1             LLLLL                                                                  M                              //////////////////////////////////////////////////////////////////////////////
// INTEL DEVELOPER'S SOFTWARE LICENSE AGREEMENT
//
// BY USING THIS SOFTWARE, YOU ARE AGREEING TO BE BOUND
// BY THE TERMS OFTHIS AGREEMENT.  DO NOT USE THE SOFTWARE
// UNTIL YOU HAVE CAREFULLY READAND AGREED TO THE FOLLOWING
// TERMS AND CONDITIONS.  IF YOU DO NOT AGREETO THE TERMS
// OF THIS AGREEMENT, PROMPTLY RETURN THE SOFTWARE PACKAGE
// ANDANY ACCOMPANYING ITEMS.
//
// IF YOU USE THIS SOFTWARE, YOU WILL BE BOUND BY THE TERMS
// OF THIS AGREEMENT
//
// LICENSE: Intel Corporation ("Intel") grants you the non-exclusive right
// to use the enclosed software program ("Software").  You will not use,
// copy, modify, rent, sell or transfer the Software or any portion
// thereof, except as provided in this Agreement.
//
// System OEM Developers may:
// 1.      Copy the Software for support, backup or archival purposes;
// 2.      Install, use, or distribute Intel owned Software in object code
//         only;
// 3.      Modify and/or use Software source code that Intel directly makes
//         available to you as an OEM Developer;
// 4.      Install, use, modify, distribute, and/or make or have made
//         derivatives ("Derivatives") of Intel owned Software under the
//         terms and conditions in this Agreement, ONLY if you are a System
//         OEM Developer and NOT an end-user.
//
// RESTRICTIONS:
//
// YOU WILL NOT:
// 1.      Copy the Software, in whole or in part, except as provided for
//         in this Agreement;
// 2.      Decompile or reverse engineer any Software provided in object
//         code format;
// 3.      Distribute any Software or Derivative code to any end-users,
//         unless approved by Intel in a prior writing.
//
// TRANSFER: You may transfer the Software to another OEM
// Developer if thereceiving party agrees to the terms of this
// Agreement at the sole risk of any receiving party.
//
// OWNERSHIP AND COPYRIGHT OF SOFTWARE:
// Title to the Software and all copies thereof remain with Intel
// or its vendors.  The Software iscopyrighted and is protected by
// United States and international copyright laws.  You will not
// remove the copyright notice from the Software.  You agree to
// prevent any unauthorized copying of the Software.
//
// DERIVATIVE WORK: OEM Developers that make or have made
// Derivatives will not be required to provide Intel with a copy of the
// source or object code.  OEM Developers shall be authorized to use,
// market, sell, and/or distribute Derivatives to other OEM Developers
// at their own risk and expense. Title to Derivatives and all copies
// thereof shall be in the particular OEM Developer creating the
// Derivative.  Such OEMs shall remove the Intel copyright notice
// from all Derivatives if such notice is contained in the Software
// source code.
//
// DUAL MEDIA SOFTWARE: If the Software package contains
// multiple media, you may only use the medium appropriate for
// your system.
//
// WARRANTY: Intel warrants that it has the right to license you to use,
// modify, or distribute the Software as provided in this Agreement. The
// Software is provided "AS IS".  Intel makes no representations to
// upgrade, maintain, or support the Software at any time. Intel warrants
// that the media on which the Software is furnished will be free from
// defects in material and workmanship for a period of one (1) year from
// the date of purchase.  Upon return of such defective media, Intel's
// entire liability and your exclusive remedy shall be the replacement of
// the Software.
//
// THE ABOVE WARRANTIES ARE THE ONLY WARRANTIES OF
// ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
// WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE.
//
// LIMITATION OF LIABILITY: NEITHER INTEL NOR ITS VENDORS
// OR AGENTS SHALL BE LIABLE FOR ANY LOSS OF PROFITS,
// LOSS OF USE, LOSS OF DATA, INTERRUPTION OF BUSINESS,
// NOR FOR INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL
// DAMAGES OF ANY KIND WHETHER UNDER THIS AGREEMENT OR
// OTHERWISE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//
// TERMINATION OF THIS LICENSE: Intel reserves the right to conduct or have
// conducted audits to verify your compliance with this Agreement.  Intel
// may terminate this Agreement at any time if you are in breach of any of
// its terms and conditions.  Upon termination, you will immediately
// destroy, and certify in writing the destruction of, the Software or
// return all copies of the Software and documentation to Intel.
//
// U.S. GOVERNMENT RESTRICTED RIGHTS: The Software and
// documentation were developed at private expense and are provided
// with "RESTRICTED RIGHTS".  Use, duplication or disclosure by
// the Government is subject to restrictions as set forth in FAR52.227-14
// and DFAR252.227-7013 et seq. or its successor.
//
// EXPORT LAWS: You agree that the distribution and export/re-export of the
// Software is in compliance with the laws, regulations, orders or other
// restrictions of the U.S. Export Administration Regulations.
//
// APPLICABLE LAW: This Agreement is governed by the laws of the State of
// California and the United States, including patent and copyright laws.
// Any claim arising out of this Agreement will be brought in Santa Clara
// County, California.
//
// Copyright 1996, Intel Corporation, All Rights Reserved
//////////////////////////////////////////////////////////////////////////////
// Copyright 1994, Intel Corporation
// Functionality and specifications based on 28F008SA datasheet
// revision 4 (order number 290429-004).
// Please contact Intel or distribution sales office for
// up-to-date specifications on Intel flash memory products.

//  
//   Revision History
//      Date        Revision    Comment
//   Nov 14, 1994    0.5beta     Initial Attempt
//   Dec  2, 1994    1.0b        Increased functionality

`timescale   1ns/1ps

`define FALSE        1'b0
`define TRUE         1'b1

//The following constants control how long it take an algorithm to run
// to scale all times together (for making simulation run faster
// change the constant later listed as TimerPeriod.

`define AC_ProgramTime        'h21
//`define   AC_EraseTime      'h299D69  // 1.2 sec takes too long
`define   AC_EraseTime        'h100   // dummy for simulation purposes.

`define BlockRowSize        'hFFFF
`define ID_DeviceCodeB      'ha2
`define ID_ManufacturerB     'h89


// These constants are the actual command codes
`define EraseCmd             'hEC
`define ClearSRCmd           'h50
`define ProgramCmd           'h10
`define Program2Cmd          'h40
`define EraseBlockCmd  'h20
`define ReadArrayCmd         'hFF
`define ReadCSRCmd           'h70
`define ReadIDCmd            'h90
`define SuspendCmd           'hB0
`define ResumeCmd            'hD0


`define TGHIL_5v                0 
`define TPHIL_5v              400 
`define TILIH_5v               40 
`define TVPIH_5v              100 
`define TAVIH_5v               40 
`define TDVIH_5v               40 
`define TIHDX_5v                5 
`define TIHAX_5v                5
`define TIHIL_5v               30
`define TWHRL_5v              100 
`define TIHGL_5v               65 
`define TAVQV_5v               70 
`define TGHQZ_5v               30 
`define TGLQX_5v                0 
`define TRLRZ_5v              220 
`define TIHRL_5v              100 
`define TimerPeriod_5v      220
//`define TimerPeriod_5v       10

// array of bits
`define   Word               15:0
`define   DoubleWord         31:0
`define   Byte                7:0
`define   Address_T          19:0

`define   ReadMode_T          2:0
`define   rdARRAY          3'b000
`define   rdCSR            3'b011
`define   rdID             3'b100

`define   WritePtr_T          1:0
`define   NewCmd            2'b01
`define   CmdField          2'b10

// type RdyBsy_T
`define   Rdy                1'b0
`define   Bsy                1'b1

// memory array defs
`define   RowRange      15:0
`define   MainArray_T   1048576:0


`define   OpType_T            1:0
`define   Program           2'b00
`define   Erase             2'b01
`define   Operation         2'b10

`define   edge_T              2:0
`define   RisingEdge       3'b000
`define   RE               3'b001
`define   FallingEdge      3'b010
`define   FE               3'b011
`define   AnyEdge          3'b100
`define   AE               3'b101


// Cmd_T record
`define   Cmd_T           150:0
`define   CmdAdd_1        150:131    // 21  
`define   CmdAdd_2        130:111    // 21  
`define   Add             110:91   // 21
`define   CmdData_1       90:83
`define   CmdData_2       82:75
`define   Cmd             75:68     //  8
`define   Count            67:36    // 32
`define   Time            35:8    // 28
`define   Confirm          7       //  1
`define   OpBlock          6:2    //  5
`define   OpType           1:0    //  2
`define   CmdData1_lo      83
`define   CmdData1Fx8      90:83
`define   CmdData2_lo      75
`define   CmdData2Fx8      82:75
`define   CmdAdd1          150 
`define   CmdAdd1_lo       131
`define   CmdAdd2_lo       111

`define   CmdAdd1RowMSB    146 
`define   CmdAdd1RowLSB    131

module Intel28F008SA (dq, addr, ceb,   rpb, oeb, web, ry_byb, vpp_b, vcc_b) ;
input   [63:0]    vpp_b, vcc_b ;   
input   [19:0]     addr ;
inout   [`Byte]    dq ;
input             ceb;
input             rpb;
input             oeb;
input             web ;
output            ry_byb ;

reg            ry_byb ;

// input generics 
parameter   LoadOnPowerUp     =   `FALSE ;
parameter   LoadFileName1     =   ""     ;
parameter   LoadFileName2     =   ""     ;
parameter   SaveOnPowerDown   =   `FALSE ;
parameter   SaveFileName      =   ""     ;

//  Flag to show the running algorithm is done.
reg       AlgDone ;
   
//  Flag to show that a Cmd has been written
//  and needs predecoding
reg       CmdValid ;
   
//  Number of addition writes necessary to 
//  supply the current command information.
//  When it hits zero it goes to Decode
integer       DataPtr ;
   
//  Represents CSR bit.
wire       DeviceOperationError ;
   
//  Internal representation of CSR bit
reg        OperationError ;
   
//  Internal representation of CSR bit
reg        EraseError ;
   
//  Flag that determines if the chip is driving
//  the outputs
reg        DriveOutputs ;
   
//  Internal value of the out data.  If DriveOutputs
//  is active this value will be placed on the
//  outputs.  -1 == Unknown or XXXX
integer    InternalOutput ;
   
//  Master internal write enable
wire       Internal_WE ;
   
//  Master internal output enable
wire       Internal_OE ;
   
//  Master internal read enable
wire       Internal_RE ;
   
reg        ProgramError ;
   
//  Internal flag to tell if an algorithm is running
wire       RdyBsy ;

reg        RunningAlgorithm ;

//  Algorithm Timer
reg        TimerClk ;

reg LV_ceb;
reg LV_ReadMode;
reg LV_ceb0;
reg LV_ceb1;
reg LV_WE;

//  Flag to represent if the chip is suspended
reg        Suspended ;
   
//  Current Vpp Range (five volt/ 12 volt)
reg        VppLevel ;
reg        VppError ;

//  Internal representation of GSR bit
reg [`ReadMode_T] ReadMode ;
   
   
//  Current value of the CSR
wire [`Byte] CSR ;

reg  [`Cmd_T] Algorithm ;


//  Startup Flag phase
reg        StartUpFlag ;

reg        ClearVppFlag ;

reg        VppFlag ;

//  Contains all current timing values

//  Global Reset Flag
reg        Reset ;

reg  [`Byte] MainArray [`MainArray_T] ;

// Number of timer cycles remaining for the 
// current algorithm
integer    AlgTime;

// This records where the algorithm is when the 
// the chip suspends or Queue slot 1 is interrupted.
integer    PauseTime ;
  
// This points to where data written to the part will
// go. By default it is to NewCmd. CmdField means the 
// chip is waiting on more data for the cmd (ie confirm)
// ToPB mean to the Page Buffer .
reg  [`WritePtr_T] WriteToPtr ;

// Contains the current executing command and all its 
// support information.
reg  [`Cmd_T]      Cmd ;

integer    ArrayOut ;

// Current output of the Compatible status register
integer    CSROut ;

// Current output of the Intelligent Identifer (tm)
integer    IDOut ;

// Generic temporary varible
integer    LoopCntr ;

// Flag for if the chip is suspended
reg        Suspend ;

// Generic temporary varible
integer    LoopCounter ;

// Pointer to a Block
integer    BlockNum ;

// Pointer to a Row
reg [`RowRange]   RowNum ;

// Another pointer to a Blcok
integer    BlockPtr ;

// Generic temporary variable
integer    Tmp1 ;

// Generic temporary variable
integer    Tmp2 ; 

// Generic temporary variable
reg   [6:0]       Index ;

// Generic 
reg        Other ;

// Generic variable
integer    LoopCount ;

// Generic variable
integer    NewData ;

// A Generic fail flag
reg        Fail ;

time       ToOut ;
time       LastWE ;

//  Contains all current timing values
time       TPHIL ;
time       TIHIL ;
time       TILIH ;
time       TAVIH ;
time       TDVIH ;
time       TIHAX ;
time       TIHDX ;
time       TGHIL ;
time       TIHGL ;
time       TAVQV ;
time       TGHQZ ;
time       TGLQX ;
time       TIHRL ;
time       TRLRZ ;
time       TimerPeriod ;

time       last_addr_time ,curr_addr_time;
time       last_dq_time ,curr_dq_time;
time       last_ReadMode_time, curr_ReadMode_time ;
time       last_Internal_RE_time, curr_Internal_RE_time ;
time       last_Internal_WE_time, curr_Internal_WE_time ;
time       last_rpb_time, curr_rpb_time ;
time       WriteRecovery ;

reg        Internal_OE_flag ;
reg        VppErrFlag ;

real       vpp, vcc ;

task      TimingInit;

begin
      TPHIL = `TPHIL_5v;
      TIHIL = `TIHIL_5v;
      TILIH = `TILIH_5v;
      TAVIH = `TAVIH_5v;
      TDVIH = `TDVIH_5v;
      TIHAX = `TIHAX_5v;
      TIHDX = `TIHDX_5v;
      TGHIL = `TGHIL_5v;
      TIHGL = `TGHIL_5v;
      TAVQV = `TAVQV_5v;
      TGHQZ = `TGHQZ_5v;
      TGLQX = `TGLQX_5v;
      TIHRL = `TIHRL_5v;
      TRLRZ = `TRLRZ_5v;
      TimerPeriod = `TimerPeriod_5v;
end
endtask

//-----------------------------------------------------------------
// LoadAll
//  This is used when the generic flag is set so that the Main Ar
//  ray contains code at startup.  Basically it loads the 
//  array from data in a file .
//----------------------------------------------------------------

task LoadAll ;
begin
   $readmemh(LoadFileName1,MainArray);
end
endtask 

//-----------------------------------------------------------------
// StoreAll
//  This is used when the generic flag is set so that the Main 
//  Array stores code at powerdown.  Basically it stores the 
//  array into a file
//-----------------------------------------------------------------

task  StoreAll;
   reg  [0:31]       BlockPtr ;
   reg  [`RowRange]  RowPtr ;
   reg  [31:0]       outfile ;
begin
   outfile = $fopen(SaveFileName) ;
   if (outfile == 0) 
      $display("Oops, cannot open output file %s",SaveFileName) ; 
   for (BlockPtr = 0 ; BlockPtr <= 15; BlockPtr = BlockPtr + 1) begin
      for (RowPtr = 0 ; RowPtr <= `BlockRowSize; RowPtr = RowPtr + 1) 
         $fdisplay(outfile,MainArray[{BlockPtr,RowPtr}]);
   end     
end 
endtask

//------------------------------------------------------
// Program  
// -- Description: Programs new values in to the array --
//------------------------------------------------------

task  Program ;
   inout  [`Byte] TheArrayValue ;
   input  [`Byte] DataIn  ;

   reg   [31:0]   OldData, NewData, LowByte, temp ;  
begin
   OldData = TheArrayValue;
    NewData = DataIn;
   TheArrayValue = NewData & OldData;
end 
endtask


assign  Internal_OE = !(ceb | oeb | !rpb) ;
assign  Internal_RE = (((RdyBsy == `Rdy) || (ReadMode != `rdARRAY)) && !ceb && !Reset) ;
assign  Internal_WE = !(ceb | web | !rpb) ;

// Determine if the algorithm engine is operating
assign  RdyBsy = (RunningAlgorithm & !Suspended) ? `Bsy : `Rdy;

// register definitions //

// Compatible Status Register
assign  CSR [7] = (RdyBsy == `Bsy) ? 1'b0 : 1'b1 ;
assign  CSR [6] = Suspended ;
assign  CSR [5] = EraseError ;
assign  CSR [4] = ProgramError ;
assign  CSR [3] = VppError ;
assign  CSR [2:0] = 3'b000;
 

// Output Drivers //

assign dq [7 : 0] = 
   (DriveOutputs && (InternalOutput > -1)) ? 
                     InternalOutput  :
   ((DriveOutputs &&  (InternalOutput < 0)) ?
                     8'hx :
                     8'hz) ;

initial begin
   AlgDone               = `FALSE ;
   CmdValid              = `FALSE ;
   DataPtr               = 0 ;   
   OperationError        = `FALSE ;
   EraseError            = `FALSE ;
   DriveOutputs          = `FALSE ;
   Suspended             = `FALSE ;
   TimerClk              = 1'b0;
   VppLevel              = `FALSE ;
   VppError              = `FALSE ;
   StartUpFlag           = `TRUE ;
   StartUpFlag          <= #2 `FALSE ;
   ClearVppFlag          = `FALSE ;
   VppFlag               = `FALSE ;
   Reset                 = 1'bx ;
   Reset                <= `TRUE ;
   PauseTime             = 0 ;
   WriteToPtr            = `NewCmd ;
   ArrayOut              = 0 ;
   CSROut                = 0 ;
   IDOut                 = 0 ;
   LoopCntr              = 0 ;
   Suspend               = `FALSE ;
   LoopCounter           = 0 ;
   BlockNum              = 0 ;
   RowNum                = 0 ;
   BlockPtr              = 0 ;
   Tmp1                  = 0 ;
   Tmp2                  = 0 ;
   Index                 = 0 ;
   Other                 = `FALSE ;
   LoopCount             = 0 ;
   NewData               = 0 ;
   Fail                  = `FALSE ;
   ToOut                 = 0 ;       
   LastWE                = 0 ;
   Internal_OE_flag      = `FALSE ;
   VppErrFlag            = `FALSE ;
   last_dq_time          = 0 ;
   curr_dq_time          = 0 ;
   last_addr_time        = 0 ;
   curr_addr_time        = 0 ;
   last_rpb_time         = 0 ;
   curr_rpb_time         = 0 ;   
   last_ReadMode_time    = 0 ;
   curr_ReadMode_time    = 0 ;
   last_Internal_RE_time = 0 ;
   curr_Internal_RE_time = 0 ;
   last_Internal_WE_time = 0 ;
   curr_Internal_WE_time = 0 ;
   TimingInit;
   InternalOutput        = -1 ;
   WriteRecovery         = 0 ;

//
// Array Init //
//
   if (LoadOnPowerUp) 
      LoadAll;
   else begin
      for (LoopCntr = 0; LoopCntr <= 15; LoopCntr = LoopCntr + 1) begin
         for(LoopCount = 0; LoopCount <= `BlockRowSize; LoopCount = LoopCount + 1) begin
            MainArray [{LoopCntr,LoopCount[15:0]}] = 'hFF ;
         end
      end
   end 
end

always @(vpp_b)
   vpp = $bitstoreal(vpp_b) ;

always @(vcc_b) 
   vcc = $bitstoreal(vcc_b) ;

// record the time for addr changes .
always @(addr) begin
   if($time > 0) begin
      curr_addr_time = $time ;
   end
end

// record the time for rpb changes .
always @(rpb) begin
   if ($time > 0) begin
      curr_rpb_time = $time ;
   end
end

// record the time for ReadMode changes .
always @(ReadMode) begin
   if ($time > 0) begin
      curr_ReadMode_time = $time ;
   end
end

// record the time for Internal_RE changes .
always @(Internal_RE) begin
   if($time > 0) begin
      curr_Internal_RE_time = $time ;
   end
end


always @(Reset) begin : Reset_process
   if (Reset) begin   
      ClearVppFlag  <= #1 `TRUE ;
      ClearVppFlag  <= #9 `FALSE;
      AlgDone        = `FALSE   ;
      CmdValid       = `FALSE   ;
      DataPtr        = 0        ;
      EraseError     = `FALSE   ;
      ProgramError   = `FALSE   ;
      RunningAlgorithm        = `FALSE   ;
      InternalOutput = -1       ;
      OperationError = `FALSE   ;
      Suspended      = `FALSE   ;  
      VppError       = `FALSE   ;
      ReadMode       = `rdARRAY ;
      AlgTime        =  0       ;
      PauseTime      =  0       ;
      WriteToPtr     = `NewCmd  ;
      CSROut         =  0       ;
      IDOut          =  0       ;
      Suspend        = `FALSE   ;
   end
end


always @(Internal_RE or ReadMode or addr) begin : array_read

//
//  array reads
//
   if (Internal_RE && ReadMode == `rdARRAY) begin
    // Get Block and RowNum, then read the array
      BlockNum = addr[19:16] ;
      RowNum = addr[15:0] ;
      ArrayOut = MainArray[{BlockNum,RowNum}] ;
   end
end

always @(Internal_RE or ReadMode or addr or Internal_OE) begin
   // output mux
   // Determine and generate the access time .
#0
   if (Internal_OE_flag == `FALSE) begin
      if (ReadMode == `rdARRAY)
         ToOut = TAVQV;
      else
         ToOut = 0.001 ;
   end
   else begin
      if (ReadMode == `rdARRAY)
         ToOut = 1 ;
      else
         ToOut = 30 ;
      if ($time > TAVQV) begin
         last_addr_time = $time - curr_addr_time;
         if ((last_addr_time < TAVQV) && ((TAVQV - last_addr_time) > ToOut))
            ToOut = TAVQV - last_addr_time ;
         last_ReadMode_time = $time - curr_ReadMode_time;
         if ((last_ReadMode_time < TAVQV) && ((TAVQV - last_ReadMode_time) > ToOut))
            ToOut = TAVQV - last_ReadMode_time ;
         last_Internal_RE_time = $time - curr_Internal_RE_time ;
         if ((last_Internal_RE_time < TAVQV) && ((TAVQV - last_Internal_RE_time) > ToOut)) begin
            ToOut = TAVQV - last_Internal_RE_time ;
         end
      end   
      Internal_OE_flag = `FALSE ;
   end   

//  Output Mux with timing
   if (!StartUpFlag) begin
      InternalOutput <= -1 ;
      #0 case (ReadMode) 
         `rdARRAY : begin
             InternalOutput <= #ToOut ArrayOut ;
         end
         `rdCSR   : begin
                InternalOutput <= #ToOut CSROut ;
         end
         `rdID    :  begin
               InternalOutput <= #ToOut IDOut ;
         end
      endcase
   end
end   

//
// other reads 
//
always @(Internal_OE) begin : other_read
   if (!Reset) begin
      Internal_OE_flag = `TRUE ;
      if (ReadMode != `rdARRAY) begin
         CSROut = CSR ;
            if (addr[0] == 1'b0) 
               IDOut = `ID_ManufacturerB ;
            else
               IDOut = `ID_DeviceCodeB ;
      end
   end
end

// Handle Write to Part

always @(negedge Internal_WE) begin : handle_write

   reg [`Word]   temp ;       // temporary variable needed for double 
                              // indexing CmdData.
   if (!Reset) begin
      case (WriteToPtr)                            // Where are we writting to ?
         `NewCmd : begin                           // This is a new command.
            Cmd[`Cmd] = dq[7:0] ;
            Cmd[`Add] = addr[19:0] ;
            CmdValid <= `TRUE ; // CmdValid sends it to the Predecode section
            DataPtr <= -1 ;
         end
         `CmdField : begin   // This is data used by another command
            if (DataPtr == 1) begin
               Cmd[`CmdData_1] = dq[`Byte];
               Cmd[`CmdAdd_1] = addr [19:0] ;
            end
            else if (DataPtr == 2) begin
               Cmd[`CmdData_2] = dq[`Byte];
               Cmd[`CmdAdd_2] = addr[19:0] ;
            end   
            else
               $display("DataPtr out of range") ;
            DataPtr <= #1 DataPtr - 1 ; // When DataPtr hits zero the command goes to the 
                                        // Decode section
         end
      endcase
   end
end

//
// Predecode Command
//
always @(posedge CmdValid) begin : predecode
   reg [`Byte] temp;       // temporary variable needed for double 
                           // indexing BSR.

   if (!Reset) begin
      // Set Defaults
      Cmd [`OpType] = `Program ;
      WriteToPtr = `NewCmd ;
      DataPtr <= 0 ;
      case (Cmd [`Cmd])          // Handle the basic read mode commands
 
     // READ ARRAY COMMAND --
 
      `ReadArrayCmd  : begin    // Read Flash Array
         CmdValid <= `FALSE ;
         if (RdyBsy == `Bsy) // Can not read array when running an algorithm
            ReadMode <= `rdCSR ;
         else
            ReadMode <= `rdARRAY ;
      end
 
        // READ INTELLIGENT IDENTIFIER COMMAND --
 
      `ReadIDCmd     :  begin   // Read Intelligent ID
         ReadMode <= `rdID ;
         CmdValid <= `FALSE ;
      end 
 
       // READ COMPATIBLE STATUS REGISTER COMMAND --
 
      `ReadCSRCmd  : begin    // Read CSR 
         ReadMode <= `rdCSR ;
         CmdValid <= `FALSE ;
      end 
      default  : begin 
         Other = `TRUE ;            // Other flag marks commands that are algorithms
         Cmd [`Confirm] = `FALSE  ; // Defaults
         case (Cmd [`Cmd]) 
 
// PROGRAM WORD/BYTE COMMAND --
 
         `ProgramCmd : begin                              // Program Word/Byte
            WriteToPtr = `CmdField  ;
            DataPtr <= 1  ;
            Cmd [`Time] = `AC_ProgramTime ;
         end 

// PROGRAM WORD/BYTE COMMAND --
 
         `Program2Cmd  : begin       // Program Word/Byte
            Cmd [`Cmd] = `ProgramCmd ;
            WriteToPtr = `CmdField ;
            DataPtr <= 1 ;
            Cmd [`Time] = `AC_ProgramTime ;
         end 

// ERASE BLOCK COMMAND --
 
         `EraseBlockCmd : begin    // Single Block Erase
            WriteToPtr = `CmdField ;
            DataPtr <= 1 ;
            Cmd [`Time] = `AC_EraseTime ;
            Cmd [`OpType] = `Erase ;
            Cmd [`Confirm] = `TRUE ;
         end 
         default : begin // The remaining commands are complex non-algorithm commands
            Other = `FALSE ;
            CmdValid = `FALSE ;

// CLEAR STATUS REGISTER COMMAND

               if (Cmd [`Cmd] == `ClearSRCmd) begin
                  if (Suspend)
                     ReadMode <= `rdARRAY ;
                  else if (RdyBsy == `Bsy) 
                     ReadMode <= `rdCSR ;
                  else begin
                     EraseError <= `FALSE ;
                     OperationError <= `FALSE;
                     ProgramError <= `FALSE ;
                     VppError <= `FALSE ;
                     ReadMode <= `rdARRAY ;
                  end 
               end 
   
// RESUME COMMAND --
 
               else if (Cmd [`Cmd] == `ResumeCmd) begin
                  if (Suspended) 
                     ReadMode <= `rdCSR ;
                  Suspend = `FALSE ;
                  Suspended <= `FALSE ;
            end
   
// SUSPEND COMMAND --
 
            else if (Cmd [`Cmd] == `SuspendCmd) begin
               if (RdyBsy == `Rdy)
                  ReadMode <= `rdARRAY ;
               else begin
                  ReadMode <= `rdCSR ;
                  Suspend = `TRUE ;
               end
               CmdValid <= `FALSE ;
            end 
            else begin
               CmdValid <= `FALSE ;
               $display("Warning:Illegal Command");
            end
         end
         endcase 
 
// HANDLE ALGORITHMS

         if (Other) begin
            if (Suspended)  begin
               $display("Attempted to issue command during suspend.  Command was Ignored");
               CmdValid <= `FALSE ;
               WriteToPtr = `NewCmd ;
               ReadMode <= `rdARRAY ;
            end
         end 
      end
      endcase
   end
end

//
// Command Decode
//

always @(DataPtr) begin : command

   if (!Reset && (DataPtr == 0) && (WriteToPtr != `NewCmd)) begin // When DataPtr hits zero it means that all the 
                                       // additional data has been given to the current command
      if (CmdValid && (WriteToPtr == `CmdField)) begin
         WriteToPtr = `NewCmd;
        // Just finish a multi-cycle command.  Determine which block the command uses
         Cmd [`OpBlock] = Cmd [`CmdAdd1 : `CmdAdd1-3] ;
       // If this command needs a confirm 
       // (flaged at predecode) then check if confirm was received
         if (Cmd [`Confirm]) begin
            if (Cmd[`CmdData1Fx8] == 8'hd0) begin
       // If the command is still valid put it in the queue and deactivate the array
               Algorithm = Cmd;
               AlgTime = Cmd [`Time] ;
               CmdValid <= `FALSE;
               if (!VppError)
               RunningAlgorithm <= #1 `TRUE ;
               ReadMode <= `rdCSR;
            end
            else begin
               OperationError <= `TRUE;
               if (Cmd [`OpType] ==  `Erase ) begin
                  ProgramError <= `TRUE;
                  EraseError <= `TRUE;
               end
               CmdValid <= `FALSE;
            end   
         end
         else begin
            Algorithm = Cmd;
            AlgTime = Cmd [`Time] ;
            CmdValid <= `FALSE;
            if (!VppError)
            RunningAlgorithm <= #1 `TRUE ;
            ReadMode <= `rdCSR;
         end
      end 
   end
end

//
// Program Timer --
//

always @(RdyBsy) begin
   if ((!Reset) && (RdyBsy  == `Bsy)) begin  // If the algorithm engine just started, start the clock
      ClearVppFlag <= #1 `TRUE ;
      ClearVppFlag <= #3 `FALSE ;
      TimerClk <= #1 1'b1 ;
      TimerClk <= #TimerPeriod 1'b0 ; 
   end 
end

always @(TimerClk) begin
   if ((!Reset) && (RdyBsy == `Bsy) && (TimerClk == 1'b0)) begin  // Reschedule clock and decrement algorithm count
      TimerClk <= #1 1'b1 ;
      TimerClk <= #TimerPeriod 1'b0 ; 
      if (Suspend) begin   // Is the chip pending suspend? If so do it
         Suspend = `FALSE;
         Suspended <= `TRUE;
      end
      if (!Suspended && RdyBsy == `Bsy && RunningAlgorithm) begin
         AlgTime = AlgTime - 1;
         if (AlgTime <= 0) begin // Check if the algorithm is done
            AlgDone <= #1 `TRUE ;
            AlgDone <= #10 `FALSE ;
         end 
      end
   end 
end 

 
//////////////
// Execution //
//////////////
always @(posedge AlgDone)  begin  : execution
   reg   [`Byte]   temp ;       // temporary variable needed for double indexing BSR.
   if (!Reset) begin
      if (AlgDone) begin   // When the algorithm finishes
                           // if chips is executing during an erase interrupt
                           // then execute out of queue slot 2
         if (Algorithm [`OpType] == `Erase) begin
            if (VppFlag) begin
               VppError <= `TRUE ;
               EraseError <= `TRUE;
            end
            else begin
// ERASE COMMAND //

      // Do ERASE to OpBlock
                  for (LoopCount = 0; LoopCount <= `BlockRowSize; LoopCount = LoopCount + 1)
                     MainArray [{Algorithm[`OpBlock],LoopCount[15:0]}] = 'hFFFF ;
            end
         end
         else begin
 
  // PROGRAM COMMAND //
 
                if (VppFlag) begin
                   ProgramError <= `TRUE;
                   VppError <= `TRUE ;
                end
                else begin
                   RowNum = Algorithm [`CmdAdd1RowMSB : `CmdAdd1RowLSB] ;
                   NewData = Algorithm [`CmdData_1] ;
                   Program (MainArray[{Algorithm [`OpBlock], RowNum}],NewData) ;
             end
            end
      end 
      RunningAlgorithm <= `FALSE ;
   end
end


//
// VccMonitor
//

always @(Reset or vcc) begin : VccMonitor
     // Save the array when chip is powered off
   if (vcc == 0.0 && SaveOnPowerDown)
      StoreAll;
   if (!((vcc > 4.5) && (vcc < 5.5)))
       $display ("Vcc is out of operating range for 5 volt mode") ;
end

//
// VppMonitor
//
always @(VppFlag or ClearVppFlag or vpp) begin : VppMonitor
   if (ClearVppFlag) begin
         VppErrFlag = `FALSE ;
   end
   else
      if ((vpp > 12.6) || (vpp < 11.4)) begin
            VppErrFlag = `TRUE ;
      end
   VppFlag <= VppErrFlag;
end

//////////////////////-
//  Reset Controller //
//////////////////////-

always @(rpb or vcc) begin : ResetPowerdownMonitor 
  // Go into reset if reset powerdown pin is active or
  // the vcc is too low
   if ((rpb != 1'b1) || (vcc < 2.5)) begin // Low Vcc protection
      Reset <= `TRUE ;
      if (!((vcc >= 2.5) || StartUpFlag))
         $display ("Low Vcc: Chip Reseting") ;
   end
   else
  // Coming out of reset takes time
      Reset <= #TPHIL  `FALSE ;
end

always @(RdyBsy) begin : ReadyBusyMonitor
         if (RdyBsy == `Bsy) 
            ry_byb <= #TIHRL 1'b0 ;
         else
            ry_byb <= #TIHRL 1'bz ; 
end 

always @(StartUpFlag or Internal_OE) begin : OEMonitor
   // This section generated DriveOutputs which is the main signal that
   // controls the state of the output drivers

   if (!StartUpFlag)  begin
      WriteRecovery = 0 ;
      last_Internal_WE_time = $time - curr_Internal_WE_time;
      if (!($time < TIHGL) && (last_Internal_WE_time < TIHGL)) 
         WriteRecovery = TIHGL - last_Internal_WE_time ;
      if (Internal_OE) begin
         WriteRecovery = WriteRecovery + TGLQX ;
         DriveOutputs <= #WriteRecovery `TRUE ;
      end
      else begin
         WriteRecovery = WriteRecovery + TGHQZ;
         DriveOutputs <= #WriteRecovery `FALSE ;
      end
   end 
   else
      DriveOutputs <= `FALSE ;
end

/////// Timing Checks /////////////

always @(Internal_WE) begin : Timing_chk

   reg [`edge_T] edges ;
   reg           e ;   

   if ($time > 0) begin

   // pulse chk
      if (Internal_WE) begin
         if ((($time - LastWE) < TIHIL) && (TIHIL > 0 )) begin
            $display("[",$time,"] Timing Violation: Internal Write Enable Insufficient High Time") ;
         end
      end
      else if ((($time - LastWE) < TILIH) && (TILIH > 0 ))
         $display("[",$time,"] Timing Violation: Internal Write Enable Insufficient Low Time") ;
      LastWE = $time ;

   // timing_chk - addr
      last_dq_time = $time - curr_dq_time;
      last_rpb_time = $time - curr_rpb_time;
      last_addr_time = $time - curr_addr_time;

      if (Internal_WE == 0)  begin
         if ((last_addr_time < TAVIH) && (last_addr_time > 0))
            $display("[",$time,"] Timing Violation: Address setup time during write, Last Event %d",last_addr_time) ;
         if ((last_rpb_time < TGHIL) && (last_rpb_time > 0))
            $display("[",$time,"] Timing Violation: Writing while coming out of powerdown,  Last Event %d",last_rpb_time) ;
         if ((last_dq_time < TAVIH) && (last_dq_time > 0))
            $display("[",$time,"] Timing Violation: Data setup time during write, Last Event %d",last_dq_time) ;
      end 
   end
end  

always @(addr) begin
   last_Internal_WE_time = $time - curr_Internal_WE_time;
   if (($time > 0) && !Internal_WE)      //timing chk
      if ((last_Internal_WE_time < TIHAX) && (last_Internal_WE_time > 0))
         $display("[",$time,"] Timing Violation:Address hold time after write, Last Event %d",last_Internal_WE_time) ;

end

always @(dq) begin
   curr_dq_time = $time ;
   last_Internal_WE_time = $time - curr_Internal_WE_time;
   if (($time > 0) && !Internal_WE) begin
      if ((last_Internal_WE_time < TIHDX) && (last_Internal_WE_time > 0))
         $display("[",$time,"] Timing Violation:Data hold time after write, Last Event %d",last_Internal_WE_time) ;
   end
end

endmodule
 array when chip is powered off
   if (vcc == 0.0 && SaveOnPowerDown)
      StoreAll;
   if (!((vcc > 4.5) &     w                                                                                                             B             >  z      .  M  Q          >          !   !  m        E          !  %  7          M             <  @  i      2	  s	  	  	  	  1
  x
  
    I                `  q  u    	
  N
  
  
  +  s          ;  p             7  r        >        c        &  g        6   6          Z          L  q        P  Q  V  l                 /  I  J          *  l                   M  o            5  W  y              )  L  o               ?  b          
      A  c                 0  1  S  u                     B   C   D   f                      !  3!  U!  w!  !  !  !  !  !  !  "  G"  p"  "  "  "  #  ,#   ,#  U#  }#  #  #  #  $  #$  C$  b$  $  $  $  $  $  %  4%  N%  f%  }%  %   %  %  %  %  %  %  %  &  6&  a&  &  &  &  &  '  ''  +'  X'  r'  '  '   '  '  '  (  #(  '(  ?(  a(  e(  (  (  (  (  (  (  )  /)  I)  M)  )  )   )  )  )  )  *  /*  3*  U*  n*  r*  *  *  *  *  *  +  +  +  5+  6+  J+   J+  `+  a+  m+  ~+  +  +  +  +  +  +  +  ,  /,  E,  F,  m,  ,  ,  ,  ,   ,  ,  ,  ,  ,  ,  ,  -  -  *-  +-  @-  A-  h-  i-  -  -  -  -  -  -   -  -  .  .  D.  y.  .  .  .   /  9/  [/  {/  |/  /  /  /  /  /  /  00   00  D0  E0  y0  0  0  0  0  0  0  0  0  1  21  31  I1  _1  `1  t1  1  1   1  1  1  1  1  1  1  2  '2  (2  F2  `2  a2  m2  2  2  2  2  2  2  2   2  2  2   3  3  3  (3  )3  P3  c3  v3  3  3  3  3  3  3  3  4  !4  44   44  G4  Z4  s4  t4  4  4  4  45  n5  5  5  5  5  5  5  6  6  6  6  6   6  86  Q6  j6  6  6  6  6  6   7  7  27  K7  d7  }7  7  7  7  7  7  7   7  @8  {8  8  8  8  8  8  9  9  (9  )9  m9  y9  9  9  
:  Q:  R:  b:  :   :  :  :  :  :  :  B;  ;  ;  	<  <  <  "<  #<  \<  i<  <  <  <  <  =   =  +=  ,=  b=  h=  =  =  =  =  =  =  =  =  T>  >  >  >  >  >  ?  ?   ?  .?  a?  ?  ?  ?  ?  ?  ?  ?  @  @  &@  T@  {@  @  @  @  @  @  A   A  9A  [A  A  A  A  A  B  0B  TB  wB  B  B  B  C  +C  JC  oC  C  C  C   C  C  D  .D  MD  lD  D  D  D  D  E  +E  JE  nE  E  E  E  E  F  9F  XF   XF  wF  F  F  F  F  G  4G  SG  rG  G  G  G  G  G  G  G  G  G  H  TH   TH  H  H  H   I  I  I  
I  I  ;I  <I  MI  kI  lI  I  I  I  I  I  I  I   I  J  "J  :J  XJ  _J  cJ  dJ  J  J  J  J  J  J  J  K  7K  NK  tK  {K  K   K  K  K  K  K  K  L  $L  FL  hL  L  L  L  L  M  ?M  aM  M  M  M  M   M  N  -N  ON  VN  ZN  [N  \N  N  N  N  N  N  N  O  2O  NO  ~O  O  O  O   O  O  O  	P  P  5P  UP  mP  xP  P  P  P  P  P  P  P  Q  MQ  Q  Q  R   R  VR  R  R  )S  ]S  jS  wS  S  S  S  S  S  S  T  +T  \T  iT  T  T  T   T  T  
U  U  (U  /U  6U  7U  :U  JU  MU  vU  U  U  U  U  V  7V  HV  qV  {V   {V  V  V  V  V  V  V  V  W  NW  cW  W  X  #X  HX  X  X  X  Y  (Y  TY   TY  Y  Y  Y  Y  Z  'Z  8Z  jZ  Z  Z  [  [  ![  %[  &[  )[  >[  A[  n[  [   [  [  [  [  
\  +\  H\  ]\  \  \  \  \  \  ]  f]  ]  ]  ]  ]  ]  ]   ]  ]  /^  L^  j^  u^  w^  ^  ^  ^  ^  _   _  8_  _  _  _  _  _  _  L`   L`  r`  `  `  `  `  `  `  %a  La  qa  a  a  a  a  a  a  b  Ab  \b  b   b  b  b  b  4c  Qc  qc  rc  c  c  c  c  d  ?d  id  d  d  d  e  9e  ee   ee  |e  e  e  e  e  e  f  /f  Tf  |f  f  f  f  f  f  g  *g  Dg  kg  g   g  g  g  g  g  h  Fh  Vh  ch  uh  wh  h  h  h  h  %i  Ii  oi  i  i  i   i  i  i  i  i  i  i  i  i  i  j  j  j  j  k  <k  k  k  k  8l  [l   [l  l  l  m  )m  Lm  jm  m  m  m  m  
n  >n  gn  n  n  n  n  n  n  o   o  9o  Yo  to  o  o  o  o  o  o  o  o  o  o  o  p  {p  p  p  p  q   q  	q  
q  q  'q  q  q  q  %r  @r  ]r  gr  r  r  s  .s  Rs  `s  js  rs  ws   ws  xs  zs  s  s  s  s  ,t  At  {t  t  u  :u  Yu  |u  u  u  u  u  u  u   u  Vv  v  v  v  v  v  v  v  w  Bw  iw  }w  w  w  x  ix  zx  x  x  x   x  x  x  x  x  x  x  x  x  y  4y  Zy  jy  y  y  y  y  y  y  y  )z   )z  Dz  cz  jz  rz  z  z  z  z  z  z  {  {  2{  3{  g{  {  {  {  |  8|   8|  g|  n|  v|  |  |  |  |  |  }  +}  9}  ^}  c}  d}  }  }  ~  ~  /~  I~   I~  ~  ~  ~    M  }                2  6  7  [  \               Ѐ  р      =          U  l  m      ݂    
   
  0  o    "    ل  J  U  \  b  c  x      2               ܆    @        	  
      c  x      2             
   Arial    .D  MD  lD  D  D  D  D  E  +E  JE  nE  E  E  E  E  F  9F  XF   