;	Copyright Intel Corporation, 1996
;	Peter Hazen, Intel Corporation, June 4, 1992, Revision 0.0
;       Collin Ong, Intel Corporation, April 3, 1996, Revision 0.1

;	Revision History
;	Revision 0.0 	Adapted from "28F008SA Software Drivers", AP-360
;       Revision 0.1    Updated to include SmartVoltage IDs and features.
			Format also cleaned up.
        
; 	The following code is divided into four sections.
;	1. Byte Program (28F00x) 
;	2. Word Program (28Fx00)
;	3. Block erase during x8 operation (28F00x)
;	4. Block erase during x16 operation (28Fx00)


;	Section 1: The following code controls byte write of data to a single 28F00x device.

;	DS:[SI] points to the data to be written 
;	ES:[DI] is the location to be written

;	In protected mode operation, DS and ES reference a descriptor
;	Register AX is modified by this procedure

PROG_SETUP	EQU	40H
READ_ID		EQU	90H
INTEL_ID	EQU	89H
DEVICE_ID	EQU	98H	;  Insert the appropriate DEVICE_ID
				;  28F008BV-T, 28F008BE-T				98H
				;  28F008BV-B, 28F008BE-B				99H
				;  28F004BV-T, 28F004BE-T, 28F004BX-T, 28F004BL-T   	78H
				;  28F004BV-B, 28F004BE-B, 28F004BX-B, 28F004BL-B	79H
				;  28F002BV-T, 28F002BE-T, 28F002BX-T, 28F002BL-T   	7CH
				;  28F002BV-B, 28F002BE-B, 28F002BX-B, 28F002BL-B	7DH

READY		EQU	80H
W_ERR_FLAG	EQU	10H
VPP_FLAG	EQU	08H
;	Insert code here to ramp Vpp and disable component RP# input.  
;	If a string of bytes is	to be written in sequence, Vpp ramp 
;	and ID check need only occur once, before the first byte is written.

;	Insert code to unlock the boot block if boot block alteration is 
;	desired.  By setting RP# to 12V	or WP# (where available) to VIH, 
; 	byte write and block erase commands can be executed on addresses in the boot location.

	MOV	AX,			"Address 0 for target flash memory-segment"	; Initialize pointer to flash memory address 0
	MOV	ES,			AX
	MOV	DI,			"Address 0 for target flash memory-offset"
	MOV	BYTE PTR ES:[DI],	READ_ID						; Write Inteligent Identifier command
	CMP	BYTE PTR ES:[DI],	INTEL_ID					; Does manufacturer ID read correctly?
	JNZ	W_BYT_ID_ERR
	MOV	DI,			"Address 1 for target flash memory-offset"	; Initialize pointer to flash memory address 1
	CMP	BYTE PTR ES:[DI],	DEVICE_ID					; Does device ID read correctly?
	JNZ	W_BYT_ID_ERR

W_BYT_ID_PASS:
	MOV	AX,			"Byte write destination address-segment"	; Initialize pointer to byte write dest. address
	MOV	ES,			AX
	MOV	DI,			"Byte write destination address-offset"
	MOV	BYTE PTR ES:[DI],	PROG_SETUP					; Write byte program setup command
	MOV	AL,			DS:[SI]						; Load AL with data to write
	MOV	ES:[DI],		AL						; Write to device

W_BYT_LOOP:
	TEST	BYTE PTR ES:[DI],	READY						; Read Status Register
	JZ	W_BYT_LOOP								; Loop until bit 7 = 1

	TEST	BYTE PTR ES:[DI],	(W_ERR_FLAG OR VPP_FLAG)
	JZ	W_BYT_CONT								; Success!

	TEST	BYTE PTR ES:[DI],	W_ERR_FLAG					; Check Status Register bit 4
	JNZ	W_BYT_ERR								; Jump if = 1, Byte Write Error

	TEST	ES:[DI],		VPP_FLAG					; Check Status Register bit 3
	JNZ	W_BYT_VPP								; Jump if = 1, Vpp Low Error

W_BYT_ID_ERR:
;	Insert code to service improper device ID read error here.
;	Is RP# input disabled?  Is Vcc applied to the flash memory?
W_BYT_ERR:
;	Insert code to service byte write error here
W_BYT_VPP:
;	Insert code to service byte write Vpp low error here
W_BYT_CONT:
;	Relock boot block if desired.
;	Code continues from this point.....


;	Section 2: The following code controls word write of data to a single 28Fx00 device.

;	DS:[SI] points to the data to be written.
;	ES:[DI] is the location to be written.
;	In protected mode operation, DS and ES reference a descriptor
;	Register AX is modified by this procedure

PROG_SETUP	EQU	0040H
READ_ID		EQU	0090H
INTEL_ID	EQU	0089H
DEVICE_ID	EQU	889CH	;  Insert the appropriate DEVICE_ID	
				;  28F800BV-T, 28F800CV-T, 28F800CE-T				889CH
				;  28F800BV-B, 28F800CV-B, 28F800CE-B				889DH
				;  28F400BV-T, 28F400CV-T, 28F400CE-T, 28F400BX-T, 28F400BL-T	4470H
				;  28F400BV-B, 28F400CV-B, 28F400CE-B, 28F400BX-B, 28F400BL-B	4471H
				;  28F200BV-T, 28F200CV-T, 28F200CE-T, 28F200BX-T, 28F200BL-T	2274H
				;  28F200BV-B, 28F200CV-B, 28F200CE-B, 28F200BX-B, 28F200BL-B	2275H

READY		EQU	0080H
W_ERR_FLAG	EQU	0020H
VPP_FLAG	EQU	0008H
;	Insert code here to ramp Vpp and disable component RP# input.  If a string of words is
;	to be written in sequence, Vpp ramp and ID check need only occur once,
;	before the first word is written

;	Insert code to unlock the boot block if boot block alteration is desired.  By setting 
;	RP# to 12V or WP# (where available) to VIH, word write and  block erase commands 
;	can be executed on addresses in the boot block.

	MOV	AX,			"Address 0 for target flash memory-segment"    	; Initialize pointer to flash memory address 0
	MOV	ES,			AX
	MOV	DI,			"Address 0 for target flash memory-offset"
	MOV	ES:[DI],		READ_ID				         	; Write Inteligent Identifier command
	CMP	ES:[DI],		INTEL_ID	   		         	; Does manufacturer ID read correctly?
	JNZ	W_WRD_ID_ERR
	MOV	DI,			"Address 1 for target flash memory-offset"      ; Initialize pointer to flash memory address 1
	CMP	ES:[DI],		DEVICE_ID			         	; Does device ID read correctly?
	JNZ	W_WRD_ID_ERR

W_WRD_ID_PASS:
	MOV	AX,			"Word write destination address-segment"	; Initialize pointer to word write dest. address
	MOV	ES,			AX
	MOV	DI,			"Word write destination address-offset"
	MOV	ES:[DI],		PROG_SETUP					; Write word program setup command
	MOV	AX,			DS:[SI]						; Load AX with data to write
	MOV	ES:[DI],		AX						; Write to devices

W_WRD_LOOP:
	TEST	ES:[DI],		READY						; Read  Status Register
	JZ	W_WRD_LOOP								; Loop until bit 7 = 1

	TEST	ES:[DI],		(W_ERR_FLAG OR VPP_FLAG)
	JZ	W_WRD_CONT								; Success!

	MOV	AX,			ES:[DI]						; Load Status Register data into AX
	TEST	AX,			W_ERR_FLAG					; Check Status Register bit 4 
	JNZ	W_WRD_ERR								; Jump if = 1
	TEST	AX,			VPP_FLAG					; Check Status Register bit 3 
	JNZ	W_WRD_VPP								; Jump if = 1

W_WRD_ID_ERR:
;	Insert code to service improper device ID read error here.
;	Is RP# input disabled?  Is Vcc applied to the flash memory?
W_WRD_ERR:
;	Insert code to service word write error here
W_WRD_VPP:
;	Insert code to service word write Vpp low error here
W_WRD_CONT:
;	Relock boot block if desired.
;	Code continues from this point.....


;	Section 3: The following code controls block erase of a single 28F00x device (x8 operation)

;	ES:[DI] points to the block to be erased.
;	In protected mode operation, ES references a descriptor.
;	Register AX is modified by this procedure.

ERASE_SETUP	EQU	20H
ERASE_CONFIRM	EQU	D0H
READ_ID		EQU	90H
INTEL_ID	EQU	89H
DEVICE_ID	EQU	98H	;  Insert the appropriate DEVICE_ID
				;  28F008BV-T, 28F008BE-T				98H
				;  28F008BV-B, 28F008BE-B				99H
				;  28F004BV-T, 28F004BE-T, 28F004BX-T, 28F004BL-T   	78H
				;  28F004BV-B, 28F004BE-B, 28F004BX-B, 28F004BL-B	79H
				;  28F002BV-T, 28F002BE-T, 28F002BX-T, 28F002BL-T   	7CH
				;  28F002BV-B, 28F002BE-B, 28F002BX-B, 28F002BL-B	7DH

READY		EQU	80H
E_ERR_FLAG	EQU	20H
E_CMD_FLAG	EQU	30H
VPP_FLAG	EQU	08H
;	Insert code here to ramp Vpp and disable component RP# input.  If a string of blocks is
;	to be erased in sequence, Vpp ramp and ID check need only occur once,
;	before the first block is erased.

;	Insert code to unlock the boot block if boot block erase is desired.  By setting RP# to 12V
;	or WP# (where available) to VIH, byte write and block erase commands can be executed on 
; 	addresses in the boot block.

	MOV	AX,			"Address 0 for target flash memory-segment"	; Initialize pointer to flash memory address 0
	MOV	ES,			AX
	MOV	DI,			"Address 0 for target flash memory-offset"
	MOV	BYTE PTR ES:[DI],	READ_ID						; Write Inteligent Identifier command
	CMP	BYTE PTR ES:[DI],	INTEL_ID					; Does manufacturer ID read correctly?
	JNZ	E_BYT_ID_ERR
	MOV	DI,			"Address 1 for target flash memory-offset"	; Initialize pointer to flash memory address 1
	CMP	BYTE PTR ES:[DI],	DEVICE_ID					; Does device ID read correctly?
	JNZ	E_BYT_ID_ERR

E_BYT_ID_PASS:
	MOV	AX,			"Block erase destination address-segment" 	; Initialize pointer to block erase dest.address
	MOV	ES,			AX
	MOV	DI,			"Block erase destination address-offset"
	MOV	BYTE PTR ES:[DI],	ERASE_SETUP					; Write block erase setup command
	MOV	BYTE PTR ES:[DI],	ERASE_CONFIRM					; Write block erase confirm command

E_BYT_LOOP:
	TEST	BYTE PTR ES:[DI],	READY						; Read Status Register
	JZ	E_BYT_LOOP								; Loop until bit 7 = 1

	TEST	BYTE PTR ES:[DI],	(E_CMD_FLAG OR VPP_FLAG)
	JZ	E_BYT_CONT								; Success!

	TEST	BYTE PTR ES:[DI],	E_CMD_FLAG					; Check Status Register bits 4 and 5
	JNZ	E_BYT_CMD_ERR								; Jump if = 1

	TEST	BYTE PTR ES:[DI],	E_ERR_FLAG					; Check Status Register bit 5
	JNZ	E_BYT_ERR								; Jump if = 1

	TEST	BYTE PTR ES:[DI],	VPP_FLAG					; Check Status Register bit 3
	JNZ	E_BYT_VPP								; Jump if = 1

E_BYT_ID_ERR:
;	Insert code to service improper device ID read error here.
;	Is RP# input disabled?  Is Vcc applied to the flash memory?
E_BYT_CMD_ERR:
;	Insert code to service block erase command sequence error here (setup followed by a command other than confirm)
E_BYT_ERR:
;	Insert code to service block erase error here
E_BYT_VPP:
;	Insert code to service block erase Vpp low error here
E_BYT_CONT:
;	Relock boot block if desired.
;	Code continues from this point.....


;	Section 4: The following code controls block erase in x16 mode for a 28Fx00 device.

;	ES:[DI] points to the blocks to be erased.
;	In protected mode operation, ES references a descriptor.
;	Register AX is modified by this procedure.

ERASE_SETUP	EQU	0020H
ERASE_CONFIRM	EQU	00D0H
READ_ID		EQU	0090H
INTEL_ID	EQU	0089H
DEVICE_ID	EQU	889CH	;  Insert the appropriate DEVICE_ID	
				;  28F800BV-T, 28F800CV-T, 28F800CE-T				889CH
				;  28F800BV-B, 28F800CV-B, 28F800CE-B				889DH
				;  28F400BV-T, 28F400CV-T, 28F400CE-T, 28F400BX-T, 28F400BL-T	4470H
				;  28F400BV-B, 28F400CV-B, 28F400CE-B, 28F400BX-B, 28F400BL-B	4471H
				;  28F200BV-T, 28F200CV-T, 28F200CE-T, 28F200BX-T, 28F200BL-T	2274H
				;  28F200BV-B, 28F200CV-B, 28F200CE-B, 28F200BX-B, 28F200BL-B	2275H

READY		EQU	0080H
E_ERR_FLAG	EQU	0020H
E_CMD_FLAG	EQU	0030H
VPP_FLAG	EQU	0008H

;	Insert code here to ramp Vpp and disable component RP# inputs.  If a string of blocks is
;	to be erased in sequence at one time, Vpp ramp and ID check need only occur once,
;	before the first block pair is erased.

;	Insert code to unlock the boot block if boot block erase is desired.  By setting RP# to 12V
;	or WP# (where available) to VIH, word write and block erase commands can be executed on 
; 	addresses in the boot block.

	MOV	AX,		"Address 0 for target flash memory-segment"		; Initialize pointer to flash memory address 0
	MOV	ES,		AX
	MOV	DI,		"Address 0 for target flash memory-offset"
	MOV	ES:[DI],	READ_ID				          		; Write Inteligent Identifier command
	CMP	ES:[DI],	INTEL_ID			          		; Does manufacturer ID read correctly?
	JNZ	E_WRD_ID_ERR
	MOV	DI,		"Address 1 for target flash memory-offset"        	; Initialize pointer to flash memory address 1
	CMP	ES:[DI],	DEVICE_ID			          		; Does device ID read correctly?
	JNZ	E_WRD_ID_ERR

E_WRD_ID_PASS:
	MOV	AX,		"Block erase destination address-segment"	        ; Initialize pointer to block erase dest. address
	MOV	ES,		AX
	MOV	DI,		"Block erase destination address-offset"
	MOV	ES:[DI],	ERASE_SETUP						; Write block erase setup cmd
	MOV	ES:[DI],	ERASE_CONFIRM						; Write block erase confirm cmd

E_WRD_LOOP:
	TEST	ES:[DI],	READY							; Read  Status Register
	JZ	E_WRD_LOOP								; Loop until bit 7 = 1

	TEST	ES:[DI],	(E_CMD_FLAG OR VPP_FLAG)
	JZ	E_WRD_CONT								; Success!

	MOV	AX,		ES:[DI]							; Load Status Register data into AX
	TEST	AX,		E_CMD_FLAG						; Check Status Register bits 4 and 5 
	JNZ	E_WRD_CMD_ERR								; Jump if = 1
	TEST	AX,		E_ERR_FLAG						; Check Status Register bit 5 
	JNZ	E_WRD_ERR								; Jump if = 1
	TEST	AX,		VPP_FLAG						; Check Status Register bit 3 
	JNZ	E_WRD_VPP								; Jump if = 1

E_WRD_ID_ERR:
;	Insert code to service improper device ID read error here.
;	Is RP# input disabled?  Is Vcc applied to the flash memory?
E_WRD_CMD_ERR:
;	Insert code to service block erase command sequence error here (setup followed by a command other than confirm)
E_WRD_ERR:
;	Insert code to service block erase error here
E_WRD_VPP:
;	Insert code to service block erase Vpp low error here
E_WRD_CONT:
;	Relock boot block if desired.
;	Code continues from this point.....
