// TimeDCTView.cpp : implementation of the CTimeDCTView class
//
/********************************************************************
*
*                    Copyright (c) 1998 Intel Corporation
*    
*    THIS SOURCE CODE IS PROVIDED "AS IS" WITH NO WARRANTIES WHATSOEVER, 
*    INCLUDING ANY WARRANTY OF MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR ANY 
*    PARTICULAR PURPOSE, OR ANY WARRANTY OTHERWISE ARISING OUT OF ANY PROPOSAL, 
*    SPECIFICATION OR SAMPLE. Intel disclaims all liability, including liability 
*    for infringement of any proprietary rights, relating to use of information 
*    in this specification. No license, express or implied, by estoppel or 
*    otherwise, to any intellectual property rights is granted herein, other 
*    than a royalty-free copyright license to use, copy, modify, distribute, and 
*    otherwise dispose of this source code and resulting object code in any 
*    format, for execution on Intel Architecture processors.
*
*    Microprocessors may contain design defects or errors known as errata which
*    may cause the product to deviate from published specifications. Current 
*    characterized errata for Intel microprocessors are available on request.
*
*********************************************************************/
#include "stdafx.h"
#include "TimeDCT.h"

#include "TimeDCTDoc.h"
#include "TimeDCTView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTView

IMPLEMENT_DYNCREATE(CTimeDCTView, CView)

BEGIN_MESSAGE_MAP(CTimeDCTView, CView)
	//{{AFX_MSG_MAP(CTimeDCTView)
	ON_COMMAND(ID_TIMING_ASM, OnTimingAsm)
	ON_COMMAND(ID_TIMING_C, OnTimingC)
	ON_COMMAND(ID_TIMING_INTRIN, OnTimingIntrin)
	ON_COMMAND(ID_TIMING_IVEC, OnTimingIvec)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTView construction/destruction

CTimeDCTView::CTimeDCTView()
{
	// TODO: add construction code here

}

CTimeDCTView::~CTimeDCTView()
{
}

BOOL CTimeDCTView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTView drawing

void CTimeDCTView::OnDraw(CDC* pDC)
{
	CTimeDCTDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTView diagnostics

#ifdef _DEBUG
void CTimeDCTView::AssertValid() const
{
	CView::AssertValid();
}

void CTimeDCTView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CTimeDCTDoc* CTimeDCTView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTimeDCTDoc)));
	return (CTimeDCTDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTView message handlers

void CTimeDCTView::OnTimingAsm() 
{
	CTimeDCTApp::DoAsmDCT();
	
}

void CTimeDCTView::OnTimingC() 
{
	CTimeDCTApp::DoCDCT();
	
}

void CTimeDCTView::OnTimingIntrin() 
{
	CTimeDCTApp::DoIntrinDCT();
	
}

void CTimeDCTView::OnTimingIvec() 
{
	CTimeDCTApp::DoIvecDCT();
	
}
