/* TimeDCT.cpp *******************************************************************
*
*                    Copyright (c) 1998 Intel Corporation
*    
*    THIS SOURCE CODE IS PROVIDED "AS IS" WITH NO WARRANTIES WHATSOEVER, 
*    INCLUDING ANY WARRANTY OF MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR ANY 
*    PARTICULAR PURPOSE, OR ANY WARRANTY OTHERWISE ARISING OUT OF ANY PROPOSAL, 
*    SPECIFICATION OR SAMPLE. Intel disclaims all liability, including liability 
*    for infringement of any proprietary rights, relating to use of information 
*    in this specification. No license, express or implied, by estoppel or 
*    otherwise, to any intellectual property rights is granted herein, other 
*    than a royalty-free copyright license to use, copy, modify, distribute, and 
*    otherwise dispose of this source code and resulting object code in any 
*    format, for execution on Intel Architecture processors.
*
*    Microprocessors may contain design defects or errors known as errata which
*    may cause the product to deviate from published specifications. Current 
*    characterized errata for Intel microprocessors are available on request.
*
***********************************************************************************/
	
#include "stdafx.h"
#include "TimeDCT.h"

#include "MainFrm.h"
#include "TimeDCTDoc.h"
#include "TimeDCTView.h"
#include "TimeDialog.h"
#include "aan_idct.h"
#include "timing.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//Global Variables:

// matrix contains the initial 64 elements of the 8X8 matrix used as input to
// DCT routines.  It's contents are copied into the input matrices for initialization.
const short matrix[64] = {
  -16384, -16384, -16069, -13622, -16384, -16384,  -9102,  -3196,
  -16384, -16384,   3196,   9102, -16384, -16384,  13622,  16069,
  -15136,  -6269, -13622,   3196,   6269,  15136,  16069,   9102,
   15136,   6269,  -9102, -16069,  -6269, -15136,  -3196,  13622,
   11585, -11585,   9102, -16069, -11585,  11585,   3196,  13622,
   11585, -11585, -13622,  -3196, -11585,  11585,  16069,  -9102,
    6269, -15136,   3196,  -9102,  15136,  -6269,  13622, -16069,
   -6269,  15136,  16069, -13622, -15136,   6269,   9102,  -3196,};

static unsigned int Ctime;
static unsigned int Atime;
static unsigned int Itime;
static unsigned int Vtime;

// Number of loop iterations (calls to the DCT routine) to time.
#define NumIter 10000

__m64 M64Const_xm1, M64Const_xm2, M64Const_xm3, M64Const_xm4, M64Const_128;

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTApp

BEGIN_MESSAGE_MAP(CTimeDCTApp, CWinApp)
	//{{AFX_MSG_MAP(CTimeDCTApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTApp construction

CTimeDCTApp::CTimeDCTApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CTimeDCTApp object

CTimeDCTApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTApp initialization

BOOL CTimeDCTApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings(1);  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CSingleDocTemplate* pDocTemplate;
	pDocTemplate = new CSingleDocTemplate(
		IDR_MAINFRAME,
		RUNTIME_CLASS(CTimeDCTDoc),
		RUNTIME_CLASS(CMainFrame),       // main SDI frame window
		RUNTIME_CLASS(CTimeDCTView));
	AddDocTemplate(pDocTemplate);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The one and only window has been initialized, so show and update it.
	m_pMainWnd->ShowWindow(SW_SHOW);
	m_pMainWnd->UpdateWindow();

	Ctime = 0;
	Atime = 0;
	Itime = 0;
	Vtime = 0;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CTimeDCTApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CTimeDCTApp commands
void CTimeDCTApp::DoAsmDCT()
{
	int i, j;
	__int64 clock;		// clock counts
	__int64 minclock = 1000000000;  // minimum clock of the 5 runs.
	__declspec(align(8)) short Amatrix[64];	// the matrix for input/output
   

	// Initialize the matrix.
	for (i=0; i<64; i++) {
		Amatrix[i] = matrix[i];
	}

	// Get the starting time stamp count.  Then run the timing loop 5 times to find the
	// best (shortest) duration.
	for (j=0; j < 4; j++) {
		cleartimer();
		starttimer();

		// Call the DCT a bunch of times.
		for (i=0; i<NumIter; i++) {
			MMX_iDCT8x8AAN(Amatrix);
		}

		// Get the ending and total count.
		clock = stoptimer();
		minclock = (clock < minclock) ? clock : minclock;
	}
	Atime = (unsigned int) (minclock);
	
	// Display the timing statistics.
	SetStatistics();

}

void CTimeDCTApp::DoIntrinDCT()
{
	int i, j;
	__int64 clock;		// clock counts
	__int64 minclock = 1000000000;  // minimum clock of the 5 runs.
	__declspec(align(8)) short Imatrix[64];	// the matrix for input/output

	// Set these globals for use in the intrinsics routine.
	M64Const_xm1 = *((__m64 *) &xm1);
    M64Const_xm2 = *((__m64 *) &xm2);
    M64Const_xm3 = *((__m64 *) &xm3);
    M64Const_xm4 = *((__m64 *) &xm4);
    M64Const_128 = *((__m64 *) &const_128);

	// Initialize the matrix.
	for (i=0; i<64; i++) {
		Imatrix[i] = matrix[i];
	}
	
	// Get the starting time stamp count.  Then run the timing loop 5 times to find the
	// best (shortest) duration.
	for (j=0; j < 4; j++) {
		cleartimer();
		starttimer();

		// Call the DCT a bunch of times.
		for (i=0; i<NumIter; i++) {
			MMXIntrin_iDCT8x8AAN(Imatrix);
		}

		// Get the ending and total count.
		clock = stoptimer();
		minclock = (clock < minclock) ? clock : minclock;
	}
	Itime = (unsigned int) (minclock);
	
	// Display the timing statistics.
	SetStatistics();
}

void CTimeDCTApp::DoCDCT()
{
	int i, j;
	__int64 clock;		// clock counts
	__int64 minclock = 1000000000;  // minimum clock of the 5 runs.
   	__declspec(align(8)) short Cmatrix[64];	// the matrix for input/output


	// Initialize the matrices.
	for (i=0; i<64; i++) {
		Cmatrix[i] = matrix[i];
	}

	// Get the starting time stamp count.  Then run the timing loop 5 times to find the
	// best (shortest) duration.
	for (j=0; j < 4; j++) {
		cleartimer();
		starttimer();

		// Call the DCT a bunch of times.
		for (i=0; i<NumIter; i++) {
			IDct_AAN(Cmatrix);
		}

		// Get the ending and total count.
		clock = stoptimer();
		minclock = (clock < minclock) ? clock : minclock;
	}
	Ctime = (unsigned int) (minclock);
	
	// Display the timing statistics.
	SetStatistics();
}

void CTimeDCTApp::DoIvecDCT()
{
	int i, j;
	__int64 clock;		// clock counts
	__int64 minclock = 1000000000;  // minimum clock of the 5 runs.
   	__declspec(align(8)) short Vmatrix[64];	// the matrix for input/output

	// Set these globals for use in the ivec routine.
	M64Const_xm1 = *((__m64 *) &xm1);
    M64Const_xm2 = *((__m64 *) &xm2);
    M64Const_xm3 = *((__m64 *) &xm3);
    M64Const_xm4 = *((__m64 *) &xm4);
    M64Const_128 = *((__m64 *) &const_128);

	// Initialize the matrices.
	for (i=0; i<64; i++) {
		Vmatrix[i] = matrix[i];
	}

	// Get the starting time stamp count.  Then run the timing loop 5 times to find the
	// best (shortest) duration.
	for (j=0; j < 4; j++) {
		cleartimer();
		starttimer();

		// Call the DCT a bunch of times.
		for (i=0; i<NumIter; i++) {
			MMXIvec_iDCT8x8AAN(Vmatrix);
		}

		// Get the ending and total count.
		clock = stoptimer();
		minclock = (clock < minclock) ? clock : minclock;
	}
	Vtime = (unsigned int) (minclock);
	
	// Display the timing statistics.
	SetStatistics();
}

void CTimeDCTApp::SetStatistics()
{
	TimeDialog td;
	char buf[12];

	// Set each of the timing percentages vs. the asm-time.
	td.m_asmpct = (Atime > 0) ? 100.0 : 0.0;
	td.m_cpct = (Ctime > 0) ? ((double) Atime / (double) Ctime) : 0.0;
	td.m_intrinpct = (Itime > 0) ? ((double) Atime / (double) Itime) : 0.0;
	td.m_ivecpct = (Vtime > 0) ? ((double) Atime / (double) Vtime) : 0.0;
	
	// Now set the times in the dialog fields.
	sprintf(buf, " %d ", Atime);
	td.m_asmtime = buf;
	sprintf(buf, " %d ", Ctime);
	td.m_ctime = buf;
	sprintf(buf, " %d ", Itime);
	td.m_intrintime = buf;
	sprintf(buf, " %d ", Vtime);
	td.m_ivectime = buf;
    td.DoModal();
}

