/* Balls64 - converted from BASIC by G Smith */

#include <Arthur.h>
#include <Signal.h>
#include <Stdlib.h>
#include <Stdio.h>
#include <Math.h>

#define TRUE 1

int main()
{
    void fn(int);                /* our own error function */
    int fnx(void);
    int fny(void);
    int fnrgb(void);
    int step=8;
    int radius=64;
    int rad2=radius>>1;
    int base,x,t;
    double l;
    mode(15);
    vduq(23,1,0,0,0,0,0,0,0);
    signal(4, *fn);              /* called when ESC pressed */
    do {
      origin(fnx(),fny());
      l=log(512/radius)/log(2);
      base=fnrgb(); 
      for (x=radius; x>=step; x-=step) {
          t=l;
          vduq(23,17,2,512-(x<<t),0,0,0,0,0);
          if (x<=rad2) 
             gcol(0,base+0x15);
          else 
             gcol(0,base);
          move(-x/3,-x/3);
          plot(0x9D,x,0); 
      }
    }while (TRUE); /* ie do forever */
} /* end main */

int fnx(void)
{
  return(rnd(640)<<1);
}

int fny(void)
{
  return(rnd(256)<<2);
}

int fnrgb(void)
{
  return( (rnd(3)-1)*1 + (rnd(3)-1)* 4 +(rnd(3)-1)*16);
}

void fn(type)
int type;
{
 int t;
 switch (type) {
        case SIGINT :  printf("Escape pressed\n");
                       printf("Bye bye\n");
                       exit(0);
                       break;
        default     :  printf("the signal type was %d\n",type);
                       t=raise(SIGILL);
        }
}



