package sorcererII;

import java.io.*;

public class ArraySorcererDisk implements SorcererDisk
{
  protected final byte _data[] = new byte[
    SorcererDiskDrive.SECTORS_PER_TRACK *
    SorcererDiskDrive.NUMBER_OF_TRACKS *
    SorcererDiskDrive.BYTES_PER_SECTOR ];

  private boolean _dirty = false;

  public ArraySorcererDisk()
  {
  }

  public ArraySorcererDisk( InputStream in ) throws IOException
  {
    in.read( _data );
  }

  private final int calcIndex( int track, int sector, int offset )
  {
    int index =
      track *
      SorcererDiskDrive.SECTORS_PER_TRACK *
      SorcererDiskDrive.BYTES_PER_SECTOR;

    index +=
      sector *
      SorcererDiskDrive.BYTES_PER_SECTOR;

    index += offset;

    return index;
  }

  public final byte read( int track, int sector, int offset )
  {
    int index = calcIndex( track, sector, offset );

    byte data = _data[ index ];

    //System.out.println( "Reading Track " + track + " sector " + sector + " index " + offset + " data " + Z80.toHexByte( data ) );

    return data;
  }

  public synchronized final void write( int track, int sector, int offset, byte data )
  {
    _dirty = true;

    int index = calcIndex( track, sector, offset );

    _data[ index ] = data;

    //System.out.println( "Writing Track " + track + " sector " + sector + " index " + offset + " data " + Z80.toHexByte( data ) );
  }

  public void activate() throws IOException {
    
  }
  
  public void deactivate() throws IOException
  {
    if( _dirty )
    {
      flush();
    }
  }

  public synchronized void flush() throws IOException
  {
  }
}