package sorcererII;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;

import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.border.AbstractBorder;
import javax.swing.filechooser.FileFilter;

class ColorBorder extends AbstractBorder {
  /**
   * 
   */
  private static final long serialVersionUID = 1045129269595712805L;
  
  protected int _thickness;
  protected Color _lineColor;

  /** 
   * Creates a line border with the specified color and a 
   * thickness = 1.
   * @param color the color for the border
   */
  public ColorBorder(Color color) {
    this(color, 1);
  }

  /**
   * Creates a line border with the specified color, thickness,
   * and corner shape.
   * @param color the color of the border
   * @param thickness the thickness of the border
   * @param roundedCorners whether or not border corners should be round
   * @since 1.3
   */
  public ColorBorder(int thickness)  {
    this(null, thickness);
  }
  
  /**
   * Creates a line border with the specified color, thickness,
   * and corner shape.
   * @param color the color of the border
   * @param thickness the thickness of the border
   * @param roundedCorners whether or not border corners should be round
   * @since 1.3
   */
  public ColorBorder(Color color, int thickness)  {
    _lineColor = color;
    this._thickness = thickness;
  }

  /**
   * Paints the border for the specified component with the 
   * specified position and size.
   * @param c the component for which this border is being painted
   * @param g the paint graphics
   * @param x the x position of the painted border
   * @param y the y position of the painted border
   * @param width the width of the painted border
   * @param height the height of the painted border
   */
  public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    if(_lineColor != null) {
      Color oldColor = g.getColor();
      int i;

      g.setColor(_lineColor);
      for(i = 0; i < _thickness; i++)  {
        g.drawRect(x+i, y+i, width-i-i-1, height-i-i-1);
      }
      g.setColor(oldColor);
    }
  }

  /**
   * Returns the insets of the border.
   * @param c the component for which this border insets value applies
   */
  public Insets getBorderInsets(Component c)       {
    return new Insets(_thickness, _thickness, _thickness, _thickness);
  }

  /** 
   * Reinitialize the insets parameter with this Border's current Insets. 
   * @param c the component for which this border insets value applies
   * @param insets the object to be reinitialized
   */
  public Insets getBorderInsets(Component c, Insets insets) {
    insets.left = insets.top = insets.right = insets.bottom = _thickness;
    return insets;
  }

  public void setColor(final Color color) {
    _lineColor = color;
  }
  
  /**
   * Returns the color of the border.
   */
  public Color getLineColor()     {
    return _lineColor;
  }

  /**
   * Returns the thickness of the border.
   */
  public int getThickness()       {
    return _thickness;
  }
}

public abstract class JFileChooserWithImage extends JBistableImageButton {
  /**
   * 
   */
  private static final long serialVersionUID = -4801660798524004594L;
  
  private File _file = null;
  private final ColorBorder _border = new ColorBorder(1);
  final JFileChooser _fileChooser = new JFileChooser();

  public JFileChooserWithImage(final Image image1, 
                               final Image image2,
                               final File home,
                               final String tooltip) {
    super(image1, image2, tooltip);
    _file = home;
    setBorder(_border);
    _fileChooser.setCurrentDirectory(_file);
  }
  
  public abstract void eject();
  
  public abstract void load(final File file) throws IOException;
  
  protected void setAccessory(final JComponent accessory) {
    _fileChooser.setAccessory(accessory);
  }
  
  protected void setFileFilter(final FileFilter filter) {
    _fileChooser.setFileFilter(filter);
  }
  
  public void setBorderColor(final Color color) {
    _border.setColor(color);
    repaint();
  }

  @Override
  public boolean gotoState1() {
    eject();
    return true;
  }

  @Override
  public boolean gotoState2() {
        
    final int returnVal = _fileChooser.showOpenDialog(JFileChooserWithImage.this);
    if (returnVal == JFileChooser.APPROVE_OPTION) {

      try {
        _file = _fileChooser.getSelectedFile();
        _file.createNewFile();  
        load(_file);
        return true;
      }
      catch (final IOException ex) {
        // TODO Handle error
      }
    }
    return false;
  }
}