package sorcererII;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

class TableCellRendererProxy implements TableCellRenderer {

  final Font _font = new Font("ariel", Font.PLAIN, 11);  
  final Font _boldFont = new Font("ariel", Font.BOLD, 11);
  
  private TableCellRenderer _delegate = null;
  
  public void setDelegate(final TableCellRenderer delegate) {
    _delegate = delegate;
  }
  
  @Override
  public Component getTableCellRendererComponent(final JTable table, 
                                                 final Object value,
                                                 final boolean isSelected, 
                                                 final boolean hasFocus, 
                                                 final int row, 
                                                 final int column) {
    final Component component = _delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    if(row == 0) {
      component.setFont(_boldFont);
    }
    else {
      component.setFont(_font);      
    }    
    return component;
  }
}

class JSorcererLoggerTable extends JTable {
  
  private static final int MAX_ROWS = 50; 

  private ImageIcon _infoIcon = new ImageIcon("images/icon_small_info.png");
  private ImageIcon _warningIcon = new ImageIcon("images/icon_small_warning.png");
  private ImageIcon _errorIcon = new ImageIcon("images/icon_small_error.png");
  
  private ImageIcon levelToIcon(final Level level) {
    if(level.equals(Level.SEVERE)) return _errorIcon;
    if(level.equals(Level.WARNING)) return _warningIcon;
    return _infoIcon;
  }
  
  private TableCellRendererProxy _tableCellRendererProxy = new TableCellRendererProxy();
  @Override
  public TableCellRenderer getDefaultRenderer(final Class<?> columnClass) {
    _tableCellRendererProxy.setDelegate(super.getDefaultRenderer(columnClass));
    return _tableCellRendererProxy;
  }
  
  public JSorcererLoggerTable() {
    super(new DefaultTableModel(new Object[] {"Level", "Message"}, 0) {
      @Override
      public boolean isCellEditable(int row, int col) {
        return false;
      }
      
      @Override
      public Class getColumnClass(int col) {
        if(col == 0) return ImageIcon.class;
        else return Object.class;
      }
    });
    
    setFillsViewportHeight(true);
    setPreferredScrollableViewportSize(getPreferredSize());
    setShowGrid(false);
    setOpaque(false);
    setTableHeader(null); // Hide table headings    
    setFocusable(false);

    final TableColumnModel cm = getColumnModel();
    cm.getColumn(0).setPreferredWidth(25);
    cm.getColumn(1).setPreferredWidth(680);

    Sorcerer.LOGGER.addHandler(new Handler() {
      
      @Override
      public void publish(final LogRecord record) {
        if(record.getLevel().intValue() > Level.FINE.intValue()) {
          final DefaultTableModel dm = (DefaultTableModel)getModel();
          dm.insertRow(0, new Object[]{levelToIcon(record.getLevel()), record.getMessage()});
          if(dm.getRowCount() > MAX_ROWS) dm.removeRow(MAX_ROWS);       
        }
      }
      
      @Override
      public void flush() {
      }
      
      @Override
      public void close() throws SecurityException {
      }
    });
  }
}

public class JSorcererLoggerPanel extends JScrollPane {
  public JSorcererLoggerPanel() {
    super(new JSorcererLoggerTable());
    setBorder(BorderFactory.createLineBorder(Color.gray));
  }
}
