package sorcererII;

import java.io.*;
import java.util.*;

// TODO This probably does not work
class SorcererCrc
{
  int _crc;

  public SorcererCrc()
  {
    _crc = 0;
  }

  int getValue()
  {
    return _crc;
  }

  void data( int data )
  {
    _crc = ( 0xff - ( data - _crc ) ) & 0xff;
  }

  boolean ok()
  {
    return _crc == 0xff;
  }

}

class SorcererCrcException extends Exception
{
}

class SorcererTapeHeader
{
  private byte[] _raw = new byte[ 16 ];
  private InputStream _input;

  private final int nextByte() throws IOException, EndOfCassetteException
  {
    int data = _input.read();
    return data;
  }

  private void ReadHeader() throws IOException, EndOfCassetteException, SorcererCrcException
  {
    SorcererCrc crc = new SorcererCrc();

    for( int i = 0; i < 16; ++i )
    {
      int data = nextByte();
      

      _raw[ i ] = (byte)data;
      crc.data( data );
    }

    crc.data( nextByte() );

    if( !crc.ok() )
    {
      throw new SorcererCrcException();
    }
  }

  public SorcererTapeHeader( InputStream input ) throws IOException, EndOfCassetteException, SorcererCrcException
  {
    _input = input;

    ReadHeader();
  }

  public int getLength()
  {
    return _raw[ 7 ] + ( _raw[ 8 ] * 256 );
  }

  public int getStart()
  {
    return _raw[ 9 ] + ( _raw[ 10 ] * 256 );
  }
}



class SorcererTapeBlock
{
  private byte[] _raw;
  private InputStream _input;
  private int _length;

  private final int nextByte() throws IOException, EndOfCassetteException
  {
    int data = _input.read();
    return data;
  }

  private void ReadBlock() throws IOException, EndOfCassetteException, SorcererCrcException
  {
    SorcererCrc crc = new SorcererCrc();

    for( int i = 0; i < _length; ++i )
    {
      int data = nextByte();
      _raw[ i ] = (byte)data;
      crc.data( data );
    }

    crc.data( nextByte() );

    if( !crc.ok() )
    {
      System.out.println( "Crc Error" );
      //throw new SorcererCrcException();
    }
  }

  public SorcererTapeBlock( InputStream input, int length ) throws IOException, EndOfCassetteException, SorcererCrcException
  {
    _input = input;
    _length = length;
    _raw = new byte[ length ];

    ReadBlock();
  }

  public void write( OutputStream output ) throws IOException
  {
    output.write( _raw );
  }
}


public class SorcererTapeReader
{
  private FileInputStream _input;
  private SorcererTapeHeader _header;
  private ArrayList _blocks = new ArrayList();

  public static void main( String[] args )
  {
    if( args.length != 2 )
    {
      System.out.println( "usage: java SorcererTapeReader <tapeFileName> <romFileName>" );
    }
    else
    {
      try
      {
        System.out.println( "Reading from " + args[ 0 ] + " and writing to " + args[ 1 ] );
        SorcererTapeReader sorcererTapeReader = new SorcererTapeReader(  args[ 0 ] );
        sorcererTapeReader.writeRom( args[ 1 ] );
      }
      catch( Exception e )
      {
        e.printStackTrace();
      }
    }
  }

  private void SeekStart() throws IOException, EndOfCassetteException
  {
    while( true )
    {
      int data;
      while( ( data = _input.read() ) == 0 );
      if( data == 1 ) return;
    }
  }

  public SorcererTapeReader( String tapeFileName ) throws IOException, SorcererCrcException, EndOfCassetteException
  {
    _input = new FileInputStream( tapeFileName );

    SeekStart();
    _header = new SorcererTapeHeader( _input );
    SeekStart();

    for( int i = _header.getLength(); i > 0; i -= 256 )
    {
      int blockLength = 256;

      if( i < 256 )
      {
        blockLength = i;
      }

      _blocks.add( new SorcererTapeBlock( _input, blockLength ) );
    }

    _input.close();
  }

  public void writeRom( String romFileName ) throws IOException
  {
    FileOutputStream romOutputStream = new FileOutputStream( romFileName );

    Iterator it = _blocks.iterator();

    while( it.hasNext() )
    {
      SorcererTapeBlock block = ( SorcererTapeBlock )it.next();
      block.write( romOutputStream );
    }

    romOutputStream.close();
  }
}