package sorcererII;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class WaveToTape
{
  public static Logger LOGGER = Logger.getLogger("WaveToTapeLogger");

  public static void convert(final double bitFrequency, 
                             final String wavFileName,
                             final String tapeFileName) throws IOException
  {
    final OutputStream os = new FileOutputStream(tapeFileName);
    try {
      final InputStream is = new SorcererAudioInputStream (new File(wavFileName), bitFrequency, LOGGER);
      try { 
        while(true) {
          final int b = is.read();
          if(b == -1) break;
          os.write(b);
        }
      }finally {
        is.close();
      }
    }
    finally {
      os.close();
    }
  }

  public static void main( String[] args ) throws IOException
  {
    if(args.length != 3) {
      System.out.println("Usage: WaveToTape <baud> <wavFile> <tapeFile>");
    }
    else {
      convert( Double.parseDouble(args[0]), args[1], args[2] );
    }
  }
}
