 4.00!FUJITSU!PrintPartner 12V HMI/VMI!l!
 00 01 02 03 04 05 06 FF 08 FF FF 0B FF FF FF FF  /* Zeichenumsetzungs- */
 10 11 FF 13 FF 15 16 17 20 20 1A FF 1C 1D 1E 1F  /* tabelle */
 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F
 30 31 32 33 34 35 36 37 38 39 3A 3B FF FF FF 3F
 40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F
 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F
 60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F
 70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E 7F
 80 81 82 83 84 85 86 87 88 89 8A 8B 8C 8D 8E 8F
 90 91 92 93 94 95 96 97 98 99 9A 9B 9C 9D 9E 9F
 A0 A1 A2 A3 A4 A5 A6 A7 A8 A9 AA AB AC AD AE AF
 B0 B1 B2 B3 B4 B5 B6 B7 B8 B9 BA BB BC BD BE BF
 C0 C1 C2 C3 C4 C5 C6 C7 C8 C9 CA CB CC CD CE CF
 D0 D1 D2 D3 D4 D5 D6 D7 D8 D9 DA DB DC DD DE DF
 E0 E1 E2 E3 E4 E5 E6 E7 E8 E9 EA EB EC ED EE EF
 F0 F1 F2 F3 F4 F5 F6 F7 F8 F9 FA FB FC FD FE FF !

/********************************************************************/
/*                                                                  */
/* Druckertabellenname: fj12vhv.asd                                 */
/* Referenzdrucker    : FUJITSU PrintPartner 12V                    */
/* Ersteller          : Armin Gntner/Softwareentwicklung           */
/* Namenskrzel       : ag                                          */
/* Erstellungsdatum   : 05.08.98                                    */
/* Version intern     : 4.0                                         */
/*------------------------------------------------------------------*/
/*                                                                  */
/* Verwendete Register:                                             */
/*                                                                  */
/* Statusregister :                                                 */
/* Arbeitsregister:                                                 */
/*------------------------------------------------------------------*/
/*                                                                  */
/* nderungen:                                                      */
/* Datum     Krzel nderung                                        */
/* 05.08.98  ag     1. Erstes Release => Kopie die HP LaserJet 5    */
/*                     HMI/VMI Druckertabelle                       */
/*                  2. Duplexdruck deaktiviert                      */
/*------------------Freigabestand V3.51-----------------------------*/
/********************************************************************/
/********************************************************************/
/*       START OF VM-SEQUENCES                                      */
/********************************************************************/

SEQUENCES
/*--------------------- SEQUENCE: Zeilenvorshub --------------------*/

nop 0a end

		prn 0a
		prn 0d
		movi 05 01
		end

/*--------------------- SEQUENCE: Blattvorshub ---------------------*/

nop 0c end

		prn 0c
		prn 0d
		movi 06 01
		movi 05 01
		end

/*--------------------- SEQUENCE: Wagenrcklauf --------------------*/

nop 0d end

		prn 0d
		movi 05 01
		end

/*--------------------- Zeichen hex. 3C ----------------------------*/

nop 3C end

		cmpi 14 01              /* OCRA EIN ? */
		beq  #3C_ocra
		prn 3C                  /* NEIN */
		bra  #3C_end

#3C_ocra        prn 5E                  /* Umsetzung 3C -> 5E (Schwartz-Font) */

#3C_end         movi 05 01
		end

/*--------------------- Zeichen hex. 3D ----------------------------*/

nop 3D end

		cmpi 14 01              /* OCRA EIN ? */
		beq  #3D_ocra
		prn 3D                  /* NEIN */
		bra  #3D_end

#3D_ocra        prn 7B                  /* Umsetzung 3D -> 7B (Schwartz-Font) */

#3D_end         movi 05 01
		end

/*--------------------- Zeichen hex. 3E ----------------------------*/

nop 3E end

		cmpi 14 01              /* OCRA EIN ? */
		beq  #3E_ocra
		prn  3E                 /* NEIN */
		bra  #3E_end

#3E_ocra        prn 7D                  /* Umsetzung 3E -> 7D (Schwartz-Font) */

#3E_end         movi 05 01
		end

/*--------------------- SEQUENCE: unterstreichen ein/aus -----------*/

nop 1b nop 2d sto 10 end

		cmpi 10 00
		beq #1b_2d_off
		seti 00 06
		prn 1b prn 26 prn 64 prn 30 prn 44
		movi 1a 01
		loab [#save_unterstr] 1a
		bra #1b_2d_end

#1b_2d_off      prn 1b prn 26 prn 64 prn 40
		clri 00 06
		movi 1a 00
		loab [#save_unterstr] 1a

#1b_2d_end      end

/*--------------------- SEQUNECE: N/216'' Zeilenabstand ------------*/

nop 1b nop 33 sto 12 end

		loab [#n_216_wert] 12   /* N/216 Anzahl N sichern */
		pushb 12
		call #N/216_ON
		end

/*--------------------- SEQUNECE: Fettdruck ein --------------------*/

nop 1b nop 45 end

		cmpi 1C 00
		bne #1b45_end
		prn 1b prn 28 prn 73 prn 33 prn 42 /* fett ein */
		movi 1a 01
		loab [#save_fett] 1a
		tsti 00 0D              /* Fettdruck und 10 CPI */
		beq  #call_PICA
		tsti 00 0E              /* Fettdruck und 12 CPI */
		beq  #call_ELITE
		tsti 00 0F              /* Fettdruck und 16,66 CPI */
		bne #1b45_end
		call #COMPRESSED_ON
		bra #1b45_end

#call_ELITE     call #ELITE_ON
		bra #1b45_end

#call_PICA      call #PICA_ON

#1b45_end       end

/*--------------------- SEQUNECE: Fettdruck aus --------------------*/

nop 1b nop 46 end

		cmpi 1C 00              /* Hochschrift ein ? */
		bne #1b46_end
		prn 1b prn 28 prn 73 prn 30 prn 42 /* fett aus */
		movi 1a 00
		loab [#save_fett] 1a
		tsti 00 0D              /* Fettdruck aus und 10 CPI */
		beq  #call_PICA
		tsti 00 0E              /* Fettdruck aus und 12 CPI */
		beq  #call_ELITE
		tsti 00 0F              /* Fettdruck aus und 16.66 CPI */
		bne #1b46_end
		call #COMPRESSED_ON
		bra #1b46_end

#call_ELITE     call #ELITE_ON
		bra #1b46_end

#call_PICA      call #PICA_ON

#1b46_end       end

/*--------------------- SEQUNECE: doppelte Breite ------------------*/

nop 1b nop 57 sto 10 end

		mov 0a 02
		end

nop 0e end      mov 0a 02
		end

nop 14 end      mov 0a 02
		end

/*--------------------- SEQUNECE: BELL -----------------------------*/

nop 07 end

		mov 0a 02
		end

/*--------------------- SEQUENCE: HORIZONTAL TAB -------------------*/

nop 09 end

		mov 1F 05
		subi 1F 01

#09_tstloop     addi 1F 01
		tst 01 1F
		beq #09_outloop
		cmp 1F 07
		bne #09_tstloop

#09_outloop     tsti 00 06
		bne #09_weiter
		prn 1B prn 26 prn 64 prn 40

#09_weiter      prn 20
		addi 05 01
		cmp 05 1F
		ble #09_outloop
		beq #09_outloop
		cmp 07 05
		bgr #09_out
		movi 05 01

#09_out         tsti 00 06
		bne #09_ende
		prn 1B prn 26 prn 64 prn 44

#09_ende        end

/*--------------------- SEQUENCE: SET HORIZONTAL TAB STOPS ---------*/

nop 1B nop 44 end

		loa 0E 00E0
		loa 0F 0000

#1B_44_loop     clr 01 0F
		addi 0F 01
		cmp 0F 0E
		ble #1B_44_loop

#1B_44_next     sto 10
		cmpi 10 00
		beq #1b_44_ende
		subi 10 01
		set 01 10
		bra #1B_44_next

#1b_44_ende     end

/*--------------------- SEQUNECE: OCRA Ein -------------------------*/

nop 1b nop 21 end

		movi 14 01        /* Schalter OCRA auf EIN */
		/* Laden OCRA-Zeichensatz fr Fontauswahl */
		prn 1b prn 28 prn 30 prn 4f
		end

/*--------------------- SEQUNECE: OCRA Aus -------------------------*/

nop 1b nop 22 end

		/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
		/* bei OCRA OFF mu der vorherige Font mit */
		/* allen Attributen wieder eingestellt werden */
		/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
		movi 14 00              /* Schalter OCRA auf AUS */
		/* Laden PC-8 Zeichensatz */
		prn 1b prn 28 prn 31 prn 30 prn 55
		end

/*--------------------- SEQUENCE: Papierendekontrolle ein/aus ------*/
nop 1b nop 38 end

		mov 0a 02
		end

nop 1b nop 39 end

		mov 0a 02
		end

/*--------------------- SEQUENCE: N/216'' einmalig vor -------------*/

nop 1b nop 4a sto 12 end

		mpyi 12 0a
		divi 12 03              /* Umrechnung in N/720''(Decipoints) */
		cmpi 12 00
		bne #N_216_einm_vor_1
		movi 12 01

#N_216_einm_vor_1
		prn 1b prn 26 prn 61 prn 2b
		call #convert
		prn 56

#N_216_einm_vor_end
		movi 12 00
		movi 13 01
		loab [#n216_einmal] 13
		end

/*--------------------- SEQUENCE: Furand setzen -------------------*/

nop 1b nop 4e sto 10 end

		mov 0a 02
		end

/*--------------------- SEQUNECE: Furand lschen ------------------*/

nop 1b nop 4f end

		mov 0a 02
		end

/*--------------------- SEQUENCE: Hochschrift ein ------------------*/

nop 1b nop 53 nop 00 end

		movi 1C 01
		prn 1b prn 2a prn 70 prn 2d prn 31 prn 35 prn 59
		prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* CPI */
		end

/*--------------------- SEQUENCE: Tiefschrift ein ------------------*/

nop 1b nop 53 nop 01 end

		movi 1C 02
		prn 1b prn 2a prn 70 prn 2b prn 31 prn 35 prn 59
		prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* CPI */
		end

/*--------------------- SEQUNECE: Hoch-/Tiefschrift aus ------------*/

nop 1b nop 54 end

		cmpi 1C 01
		bne #TIEF_OUT
		prn 1b prn 2a prn 70 prn 2b prn 31 prn 35 prn 59
		tsti 00 0F
		bne #PICA_54_1
		call #COMPRESSED_ON
		bra #END_54_1

#PICA_54_1      tsti 00 0D
		bne #ELITE_54_1
		call #PICA_ON
		bra #END_54_1

#ELITE_54_1     call #ELITE_ON

#END_54_1       movi 1C 00
		bra #H_T_END

#TIEF_OUT       cmpi 1C 02
		bne #H_T_END
		prn 1b prn 2a prn 70 prn 2d prn 31 prn 35 prn 59
		tsti 00 0F
		bne #PICA_54_2
		call #COMPRESSED_ON
		bra #END_54_2

#PICA_54_2      tsti 00 0D
		bne #ELITE_54_2
		call #PICA_ON
		bra #END_54_2

#ELITE_54_2     call #ELITE_ON

#END_54_2       movi 1C 00

#H_T_END        end

/*--------------------- SEQUNECE: Halbzeilenschaltung vor ----------*/

nop 1b nop 63 nop 02 end

		prn 1b prn 3d
		end

/*--------------------- SEQUNECE: Halbzeilenschaltung zurck--------*/

nop 1b nop 63 nop 01 end

		prn 1b prn 26 prn 61 prn 2d prn 2e prn 35 prn 52
		end

/*--------------------- SEQUNECE: N/216'' einmalig zurck ----------*/

nop 1b nop 6a sto 12 end

		mpyi 12 0a
		divi 12 03              /* Umrechnung in N/720''(Decipoints) */
		cmpi 12 00
		bne #N_216_einm_back_1
		movi 12 01

#N_216_einm_back_1
		prn 1b prn 26 prn 61 prn 2d
		call #convert
		prn 56

#N_216_einm_back_end
		movi 12 00
		movi 13 01
		loab [#n216_einmal] 13
		end

/*--------------------- SEQUNECE: Endebehandlung -------------------*/

nop 1b nop 5b nop 36 nop 7e end         /* Endebehandlung */

		loab 12 [#PAPER_TYPE]   /* Endlospapier */
		cmpi 12 00
		beq #1b_40_strt         /* if true, skip */
		loab 12 [#FINAL_EJECT]  /* Auswurf Ja/Nein */
		cmpi 12 00
		beq #1b_40_strt         /* nein, skip */
		call #SHEET_OUT
		bra #1b_40_strt
		end

/*--------------------- SEQUNECE: INIT ehemals GENERAL RESET -------*/

nop 1b nop 40 end

		movi 10 00              /* Register 10 lschen */
		movi 11 00              /* Register 11 lschen */
		movi 12 00              /* Register 12 lschen */
		movi 13 00              /* Register 13 lschen */
		movi 14 00              /* Register 14 lschen */
		movi 15 00              /* Register 15 lschen */
		movi 16 00              /* Register 16 lschen */
		movi 17 00              /* Register 17 lschen */
		movi 18 00              /* Register 18 lschen */
		movi 19 00              /* Register 19 lschen */
		movi 1a 00              /* Register 1a lschen */
		movi 1b 00              /* Register 1b lschen */
		movi 1c 00              /* Register 1c lschen */
		movi 1d 00              /* Register 1d lschen */
		movi 1e 00              /* Register 1e lschen */
		movi 1f 00              /* Register 1f lschen */
		prn 1b prn 45           /*spezielle HP-Sequenzen(HW RESET) */
		/*--- select a feeder ---*/
		call #select_a_feeder

#1b_40_strt     movi 13 00              /* setzen #HMI_ORIENT */
		loab [#hmi_orient] 13   /* bei internen INIT auf Portrait */
		/*--- internal inits ---*/
		loa 1F 00E8             /* alle internen Tabs zurcksetzen */

#1B_40_tabs     clr 01 1F
		subi 1F 01
		cmpi 1F 00
		bne #1B_40_tabs
		loa 0E 00E8             /* Tab auf jeder 8ten Position setzen */
		movi 0F 08

#1b_40_set      set 01 0F
		addi 0F 08
		cmp 0F 0E
		bne #1b_40_set
		prn 1b prn 26 prn 6C prn 30 prn 53 /* SIMPLEX ein */
		prn 1b prn 28 prn 73 prn 30 prn 42 /* fett aus */
		movi 1a 00
		loab [#save_fett] 1a
		prn 1b prn 26 prn 64 prn 40 /*Unterstreichen aus*/
		movi 1a 00
		loab [#save_unterstr] 1a
		prn 1b prn 28 prn 31 prn 30 prn 55 /* PC-8 Zeichensatz */
		prn 1b prn 28 prn 73 prn 30 prn 50 /* Fixed Spacing    */
		prn 1b prn 26 prn 6C prn 30 prn 4F /* Hochformat */
		clri 00 05
		clri 00 06
		clri 00 09
		clri 00 0D              /* Merker fr 10/12/comp. lschen */
		clri 00 0E              /*                                */
		clri 00 0F              /*                                */
		movi 05 01              /* COLCNT */
		movi 06 01              /* LINCNT */
		movi 1C 00
		loab 07 [#PAPER_WIDTH]  /* MAXCOL */
		loab 08 [#PAPER_LENGTH] /* MAXLIN */
		loab 09 [#BOTTOM_LINES] /* BOTTOM */
		mov 09 08
		loab 13 [#BOTTOM_LINES] /* Seitenlnge */
		sub 09 13
		/*--- start printer inits ---*/

#1b_40_quality  loab 12 [#QUALITY]      /* Test Quality */
		cmpi 12 00
		beq #1b_40_draft        /* 0 = draft */
		cmpi 12 01              /* 1 = nlq   */
		beq #1b_40_nlq
		call #LQ_ON             /* 2 = lq    */
		bra #1b_40_cpi

#1b_40_draft    call #DRAFT_ON
		bra #1b_40_cpi

#1b_40_nlq      call #NLQ_ON

#1b_40_cpi      loab 12 [#CHAR_SPACING] /* spacing in n/60'' */
		cmpi 12 00
		beq  #1b_40_fixed
		pushb [#CHAR_SPACING]   /* spacing in n/60'' */
		call #N/60
		bra  #1b_40_lpi

#1b_40_fixed    loab 12 [#CHARS_PER_INCH]
		cmpi 12 11              /* 17 cpi = compressed */
		beq  #1b_40_compressed
		cmpi 12 0C              /* 12 cpi = elite */
		beq  #1b_40_elite
		call #PICA_ON           /* 10 cpi = pica */
		bra  #1b_40_lpi

#1b_40_compressed
		call #COMPRESSED_ON
		bra  #1b_40_lpi

#1b_40_elite    call #ELITE_ON
					/* set lines per inch */
#1b_40_lpi      loab 12 [#LINES_PER_INCH]
		cmpi 12 08
		bne  #1b_40_1/6
		call #1/8_ON
		bra  #1b_40_length

#1b_40_1/6      movi 12 0C              /* set 12/72'' == 1/6'' */
		call #N/72
		call #1/6_ON            /* start 1/6'' linespacing */

#1b_40_length   /* set paper length*/
		pushb [#PAPER_LENGTH]
		call #LINES_PER_PAGE

#1b_40_left_margin                      /* left and right margin */
		pushb [#LEFT_MARGIN]
		pushb [#RIGHT_MARGIN]
		call #SET_MARGINS

#1b_40_head     /* set header of page */
		pushb [#HEAD_LINES]
		call #SET_HEADER

#1b_40_bottom   /* set bottom of page */
		pushb [#BOTTOM_LINES]
		call #SET_BOTTOM

#1b_40_user_init
		loaa 12 #USR_INIT
		pushw 12                /* Ausgabe Benutzerzeile aus */
		call #print_str         /* INIT_BLOCK */
		movi 13 00              /* Init Orient.-Schalter auf */
		loab [#hmi_orient] 13   /*        HMI = 0          */
		loaa 12 #USR_INIT
		loaw 1f [12]            /* Lngenfeld nach 1f */
		addi 12 02
		mov 1d 12               /* sichern Adr. BenutzerzeileBeg. */
		add 1d 1f               /* Adr. Benutzerzeile End*/

#a10            cmp 12 1d               /* Benutzerzeile Ende ? */
		bgr #1b_40_end          /* Ja */
		loab 1e [12]
		cmpi 1e 1b              /* suche ESC */
		beq #a11
		addi 12 01              /* erhhe Adr. Ben.zeile */
		bra #a10

#a11            addi 12 01
		loab 1e [12]
		loa 11 0026
		cmp 1e 11               /* suche hex. 26 */
		beq #a12
		addi 12 01              /* erhhe Adr. Ben.zeile */
		bra #a10

#a12            addi 12 01
		loab 1e [12]
		loa 11 006c
		cmp 1e 11               /* suche hex. 6c */
		beq #a13
		addi 12 01              /* erhhe Adr. Ben.zeile */
		bra #a10

#a13            addi 12 01
		loab 1e [12]
		loa 11 0031
		cmp 1e 11               /* suche hex. 31 */
		beq #a14
		addi 12 01              /* erhhe Adr. Ben.zeile */
		bra #a10

#a14            addi 12 01
		loab 1e [12]
		loa 11 004f
		cmp 1e 11               /* suche hex. 4f */
		beq #1b_40_orient       /* Landscape gefunden */
		addi 12 01              /* erhhe Adr. Ben.zeile */
		bra #a10

#1b_40_orient   movi 13 01             /* HMI Landscape */
		loab [#hmi_orient] 13  /* setzen Orient.-schalter */
		/* Landscape lscht verschiedene Ein- */
		/* stellungen !!! ; nochmalige Ausgabe */
		pushb [#PAPER_LENGTH]
		call #LINES_PER_PAGE
		pushb [#LEFT_MARGIN]
		pushb [#RIGHT_MARGIN]
		call #SET_MARGINS
		loab 12 [#CHARS_PER_INCH]
		cmpi 12 11
		beq  #ls_compressed
		cmpi 12 0c
		beq  #ls_elite
		call #PICA_ON
		bra #1b_40_end

#ls_compressed  call #COMPRESSED_ON
		bra  #1b_40_end

#ls_elite       call #ELITE_ON

#1b_40_end      end

/*--------------------- SEQUENCE: Blattauswurf oder Einzug aus Schacht n -*/

nop 1B nop 62 sto 12 end

		cmpi 12 00
		beq #1b_62_sheet_out
		pushb 12
		call #GET_SHEET
		bra #1b_62_end

#1b_62_sheet_out
		call #SHEET_OUT

#1b_62_end      end

/*--------------------- SEQUENCE: NLQ ein ---------------------------*/

nop 1B nop 47 end

		call #NLQ_ON
		end

/*--------------------- SEQUENCE: NLQ aus ---------------------------*/

nop 1B nop 48 end

		call #DRAFT_ON
		end

/*--------------------- SEQUENCE: LQ ON ----------------------------*/

/* not yet defined */

/*--------------------- SEQUENCE: Formularlnge einstellen ---------*/

nop 1B nop 43 sto 12 end

		pushb 12                /* Formularlnge */
		loab [#form_length] 12  /* sichern       */
		call #LINES_PER_PAGE
		end

/*--------------------- SEQUENCE: n/60'' Zeichenabstand ------------*/

nop 1B nop 61 sto 12 end

		pushb 12
		call #N/60
		end

/*--------------------- SEQUENCE: PICA 10 cpi ----------------------*/

nop 12 end

		call #PICA_ON
		end

/*--------------------- SEQUENCE: ELITE 12 cpi ---------------------*/

nop 1B nop 4D end

		bra #1b_3A_start
		end

nop 1B nop 3A end

#1b_3A_start    call #ELITE_ON
		end

/*--------------------- SEQUENCE: COMPRESSED 17 cpi ----------------*/

nop 0F end

		call #COMPRESSED_ON
		end

/*--------------------- SEQUENCE: 1/8'' Zeilenabstand --------------*/

nop 1B nop 30 end

		call #1/8_ON
		end

/*--------------------- SEQUENCE: 1/6'' Zeilenabstand oder ESC A ausfhren -*/

nop 1B nop 32 end

		call #1/6_ON
		end

/*--------------------- SEQUENCE: linker/rechter Rand --------------*/

nop 1B nop 58 end

		sto 12                  /* linker Rand */
		pushb 12
		sto 12                  /* rechter Rand */
		pushb 12
		call #SET_MARGINS
		end

/*--------------------- SEQUENCE: Kopfzeilen einstellen ------------*/

/* not yet available */

/*--------------------- SEQUENCE: Fuzeilen einstellen -------------*/

nop 1B nop 4E sto 12 end

		pushb 12
		call #SET_BOTTOM
		end

/*--------------------- SEQUENCE: N/72'' Zeilenabstand -------------*/

nop 1B nop 41 sto 12 end

		loab [#n_72_wert] 12    /* N/72 Anzahl N sichern */
		call #N/72
		end

/*--------------------- SEQUENCE: DUPLEX ein/aus -------------------*/

nop 1b nop 2c sto 10 end
		
		mov 0a 02
		end

/*--------------------- SEQUENCE: Orientierung ---------------------*/

nop 1b nop 26 nop 6c sto 16 nop 4f end

		call #ORIENTIERUNG
		end

/*--------------------- SEQUENCE: erweiterte CPI-Auswahl ------------*/

nop 1b nop 64 sto 10 sto 11 sto 12 sto 13 end

		mov 0a 02
		end

/*--------------------- SEQUENCE: rechter Rand > 255 ---------------*/

nop 1b nop 65 nop ff sto 10 end

		mov 0a 02
		end

/*--------------------------------------------------------------*/
/*      bypass of Bit Image Mode graphics                       */
/*                                                              */
/*      Regs used:      12      used to store input data        */
/*                      13      counter of BIM data bytes       */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* ESC K n1 n2, normal density BIM, normal speed                */
/*--------------------------------------------------------------*/

nop 1B nop 4B end

		loa 12 004B
		bra #graphics_out
		end

/*--------------------------------------------------------------*/
/* ESC L n1 n2, double density BIM, half speed                  */
/*--------------------------------------------------------------*/

nop 1B nop 4C end

		loa 12 004C
		bra #graphics_out
		end

/*--------------------------------------------------------------*/
/* ESC Y n1 n2, double density BIM, normal speed                */
/*--------------------------------------------------------------*/

nop 1B nop 59 end

		loa 12 0059
		bra #graphics_out
		end

/*--------------------------------------------------------------*/
/* ESC Z n1 n2, quadruple density BIM                           */
/*--------------------------------------------------------------*/

nop 1B nop 5A end

		loa 12 005A

#graphics_out   prn 1B
		mov 00 12
		sto 12                  /* n1 = n MOD 256 */
		mov 00 12
		mov 13 12               /* save it */
		sto 12                  /* n2 = n DIV 256 */
		mov 00 12
		/* n = n1 + 256 * n2 */
		mpyi 12 10              /* 256 = REG2 * 16 */
		mpyi 12 10              /* 256 = 16 * 16 */
		add 13 12

#graphics_loop  cmpi 13 00              /* counter == 0 ? */
		beq #graphics_end
		sto 12
		mov 00 12
		subi 13 01             /* decrement counter */
		bra #graphics_loop

#graphics_end   end

END_SEQUENCES
/************************************************************************/
/*       END OF VM-SEQUENCES                                            */
/************************************************************************/

FUNCTIONS
/************************************************************************/
/*      START OF FUNCTION BODIES                                        */
/************************************************************************/

/*----------------------------------------------------------------------*/
/*      function body ORIENTIERUNG                                      */
/*----------------------------------------------------------------------*/

#ORIENTIERUNG   loa 12 0031
		prn 1b prn 26 prn 6c
		cmp 16 12               /* Landscape-Format ? */
		bne #ORIENT_PORTRAIT
		prn 31                  /* Landscape-Format */
		movi 12 01              /* setzen #HMI_ORIENT */
		loab [#hmi_orient] 12
		bra #ORIENT_EINSTELL

#ORIENT_PORTRAIT
		movi 12 00              /* Landscape */
		loab [#hmi_orient] 12   /* setzen Orient.-schalter */
		prn 30                  /* Portrt-Format */

#ORIENT_EINSTELL
		prn 4f
		loab 12 [#save_char_spac] /* N/60 Zeichenabstand ? */
		cmpi 12 00
		beq  #ORIENT_EINSTELL_CPI
		pushb [#save_char_spac]
		call #N/60
		bra  #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_CPI
		loab 12 [#save_cpi]
		cmpi 12 10              /* 17 CPI ? */
		beq #ORIENT_EINSTELL_COMPRESS
		cmpi 12 0C              /* 12 CPI ? */
		beq #ORIENT_EINSTELL_ELITE
		call #PICA_ON           /* 10 CPI */
		bra #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_COMPRESS
		call #COMPRESSED_ON     /* 17 CPI einstellen */
		bra #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_ELITE
		call #ELITE_ON          /* 12 CPI einstellen */

#ORIENT_EINSTELL_LPI
		loab 12 [#save_lpi]
		cmpi 12 08              /* 1/8'' Zeilenabstand ? */
		bne  #ORIENT_EINSTELL_N/72
		call #1/8_ON            /* 1/8'' Zeilenabstand einstellen */
		bra  #ORIENT_EINSTELL_FORM

#ORIENT_EINSTELL_N/72
		cmpi 12 07              /* N/72'' Zeilenabstand ? */
		bne #ORIENT_EINSTELL_N/216
		loab 12 [#n_72_wert]    /* N/72'' Zeilenabstand */
		call #N/72              /* einstellen           */
		call #1/6_ON            /* N/72'' Zeilenabstand starten */
		bra #ORIENT_EINSTELL_FORM

#ORIENT_EINSTELL_N/216
		cmpi 12 16              /* N/216'' Zeilenabstand ? */
		bne #ORIENT_EINSTELL_1/6
		pushb [#n_216_wert]     /* N/216'' Zeilenabstand */
		call #N/216_ON          /* einstellen            */
		bra #ORIENT_EINSTELL_FORM

#ORIENT_EINSTELL_1/6
		call #1/6_ON            /* 1/6'' Zeilenabstand einstellen */

#ORIENT_EINSTELL_FORM
		pushb [#form_length]    /* Formularlnge */
		call #LINES_PER_PAGE    /* einstellen    */

#ORIENT_EINSTELL_MARGINS
		pushb [#save_lrd]       /* Rnder     */
		pushb [#save_rrd]       /*            */
		call #SET_MARGINS       /* einstellen */

#ORIENT_ENDE    ret 00

/*----------------------------------------------------------------------*/
/*      function body SELECT_A_FEEDER (INIT)    PARA: -                 */
/*----------------------------------------------------------------------*/

#select_a_feeder
		loab 12 [#PAPER_TYPE]   /* Endlospapier */
		cmpi 12 00
		beq #sel_a_feeder_end   /* if true, skip */
		loab 12 [#FEED_SELECT]  /* select feeder */
		cmpi 12 00
		beq #sel_a_feeder_end   /* no default get sheet */
		pushb [#FEED_SELECT]
		call #GET_SHEET

#sel_a_feeder_end
		ret 00

/*----------------------------------------------------------------------*/
/*      function body BLATTAUSWURF              PARA: -                 */
/*----------------------------------------------------------------------*/

#SHEET_OUT      loab 12 [#PAPER_TYPE]   /* Endlospapier */
		cmpi 12 00
		bne  #SHEET_OUT_001     /* if true, skip */
		prn  0C                 /* FF bei Endlospapier */
		bra  #SHEET_OUT_end

#SHEET_OUT_001  prn 1b prn 26 prn 6c prn 30 prn 48 /* Blattauswurfsequenz */

#SHEET_OUT_end  ret 00

/*----------------------------------------------------------------------*/
/*      function body BLATTEINZUG               PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#GET_SHEET      loab 12 [#PAPER_TYPE]     /* Endlospapier */
		cmpi 12 00
		beq  #GET_SHEET_end       /* if true, skip */

#GET_SHEET_EZB  loab 12 [0C+2]            /* Para from Stack */
		loab [#save_schacht] 12   /* 110595 th */
		cmpi 12 02
		beq #GET_SHEET_EZB_2
		cmpi 12 03
		beq #GET_SHEET_EZB_3
		prn 1b prn 26 prn 6c prn 31 prn 48
		bra #GET_SHEET_end

#GET_SHEET_EZB_2
                prn 1b prn 26 prn 6c prn 36 prn 48
		bra #GET_SHEET_end

#GET_SHEET_EZB_3
                prn 1b prn 26 prn 6c prn 34 prn 48

#GET_SHEET_end  ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body LQ-Modus EIN              PARA: -                 */
/*----------------------------------------------------------------------*/

#LQ_ON          mov 0A 02
		ret 00

/*----------------------------------------------------------------------*/
/*      function body DRAFT-Modus EIN           PARA: -                 */
/*----------------------------------------------------------------------*/

#DRAFT_ON       mov 0A 02
		ret 00

/*----------------------------------------------------------------------*/
/*      function body NLQ-Modus EIN             PARA: -                 */
/*----------------------------------------------------------------------*/

#NLQ_ON         mov 0A 02
		ret 00

/*----------------------------------------------------------------------*/
/*      function body SEITENLNGE               PARA:  1 Byte           */
/*----------------------------------------------------------------------*/

#LINES_PER_PAGE /*Para from stack*/
		loab 12 [0C+2]
		loab [#form_length] 12  /*sichern Formularlnge fr VMI- */
					/* Berechnung */
		loab [#vmi_switch] 00   /* lschen VMI-Schalter */
		call #vmi_pruef         /* setze Schalter, wenn VMI */
					/* erforderlich */
		loab 13 [#vmi_switch]
		cmpi 13 00              /* VMI erforderlich ? , d. h. */
					/* Forml. Portr. > 64 Zeilen bzw. */
					/*  "    Landsc. > 42 Zeilen */
		beq  #LINES_PER_PAGE_AUSG  /* Nein */
		prn 1b                  /* vor VMI-Berechnung Formular-   */
		prn 45                  /* lnge durch den HW-Reset       */
					/* zurckgesetzt                 */
		call #einstell          /* aktuelle Einstellungen nach  */
					/* HW-Reset wieder durchfhren  */
		prn 1b                  /* VMI-Berechnung und -ausgabe */
		prn 26
		prn 6c
		call #vmi_berechnung
		prn 43
		bra #LINES_PER_PAGE_END

#LINES_PER_PAGE_AUSG
					  /* zurcksetzen von VMI */
					  /* durch Zeilenabstand, fr */
		loab 12 [#LINES_PER_INCH] /* den Fall, da Anwendung vor */
		cmpi 12 08                /* neuer Formularlnge keinen */
		bne  #LPPA_1/6            /* Zeilenabstand schickt */
		prn 1b prn 26 prn 6c prn 38 prn 44
		bra #LPPA_TEXTLNGE

#LPPA_1/6       prn 1b prn 26 prn 6c prn 36 prn 44

#LPPA_TEXTLNGE prn 1b prn 26 prn 6c
		loab 12 [0C+2]
		call #convert
		prn 46

#LINES_PER_PAGE_END
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body VARIABLER ZEICHENABSTAND  PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#N/60           prn 1b prn 26 prn 6b
		loab 12 [0C+2]            /* Para from stack */
		loab [#save_char_spac] 12 /* variable von Char_spacing*/
		mpyi 12 02
		call #convert
		prn 48
		ret 01                    /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body 17 Zeichen / Zoll (VERDICHTET EIN)  PARA: -       */
/*----------------------------------------------------------------------*/

#COMPRESSED_ON
		seti 00 0F              /* setzen 16,66 CPI */
		clri 00 0E              /* lschen 12 CPI */
		clri 00 0D              /* lschen 10 CPI */
		prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* CPI */
		prn 1b prn 28 prn 73 prn 34 prn 31 prn 30 prn 32 prn 54 /* Letter Gothic */
		movi 12 00
		loab [#save_char_spac] 12
		movi 12 10              /* sichern 16 CPI */
		loab [#save_cpi] 12
		loab 11 [#hmi_orient]
		cmpi 11 01
		jne  #comp_on_portrait
		prn 1b                  /* Orientierung Landscape */
		prn 26
		prn 6b
		prn 35                  /* HMI = 11,1 * 120 : 224 = 5,946 */
		prn 2e
		prn 39
		prn 34
		prn 36
		prn 48
		bra #comp_on_end

#comp_on_portrait
		prn 1b                  /* Orientierung Portrait */
		prn 26
		prn 6b
		prn 36                  /* HMI = 7,6 * 120 : 132 = 6,909 */
		prn 2e                  /* Ausgabe 6,99 wg. anderer Drucker */
		prn 39
		prn 39
		prn 30
		prn 48

#comp_on_end    ret 00

/*----------------------------------------------------------------------*/
/*      function body 10 Zeichen / Zoll         PARA: -                 */
/*----------------------------------------------------------------------*/

#PICA_ON        seti 00 0D              /* setzen 10 CPI */
		clri 00 0E              /* lschen 12 CPI */
		clri 00 0F              /* lschen 16,66 CPI */
		prn 1b prn 28 prn 73 prn 31 prn 30 prn 48
		prn 1b prn 28 prn 73 prn 31 prn 32 prn 56
		prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		movi 12 00
		loab [#save_char_spac] 12
		movi 12 0a              /* sichern 10 CPI */
		loab [#save_cpi] 12
		loab 11 [#hmi_orient]
		cmpi 11 01
		jne  #pica_on_portrait
		prn 1b                  /* Orientierung Landscape */
		prn 26
		prn 6b
		prn 31                  /* HMI = 11,1 * 120 : 132 = 10,09 */
		prn 30
		prn 2e
		prn 30
		prn 39
		prn 48
		bra #pica_on_end

#pica_on_portrait
		prn 1b                  /* Orientierung Portrait */
		prn 26
		prn 6b
		prn 31                  /* HMI = 7,6 * 120 : 80 = 11,400 */
		prn 31                  /* Ausgabe 11,300 wegen Inkompatibilitten */
		prn 2e                  /* bei anderen Drucker, z.B: TA SDR 7705 */
		prn 33
		prn 30
		prn 30
		prn 48

#pica_on_end    ret 00

/*----------------------------------------------------------------------*/
/*      function body 12 Zeichen / Zoll         PARA: -                 */
/*----------------------------------------------------------------------*/

#ELITE_ON       seti 00 0E              /* setzen 12 CPI */
		clri 00 0D              /* lschen 10 CPI */
		clri 00 0F              /* lschen 16,66 CPI */
		prn 1b prn 28 prn 73 prn 31 prn 32 prn 48
		prn 1b prn 28 prn 73 prn 31 prn 30 prn 56
		prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		movi 12 00
		loab [#save_char_spac] 12
		movi 12 0c              /* sichern 12 CPI */
		loab [#save_cpi] 12
		loab 11 [#hmi_orient]
		cmpi 11 01
		jne  #elite_on_portrait
		prn 1b                  /* Orientierung Landscape */
		prn 26
		prn 6b
		prn 38                  /* HMI = 11,1 * 120 : 158 = 8,43 */
		prn 2e
		prn 34
		prn 33
		prn 48
		bra #elite_on_end

#elite_on_portrait
		prn 1b                  /* Orientierung Portrait */
		prn 26
		prn 6b
		prn 39                  /* HMI = 7,7 * 120 : 96 = 9,625 */
		prn 2e
		prn 36
		prn 32
		prn 35
		prn 48

#elite_on_end   ret 00

/*----------------------------------------------------------------------*/
/*      function body 1/8'' Zeilenabstand       PARA: -                 */
/*----------------------------------------------------------------------*/

#1/8_ON         loab 13 [#vmi_switch]
		cmpi 13 00              /* wird VMI bei Formularlnge */
		beq  #1/8_ON_AUSG       /* ausgegeben ?   Nein     */
		movi 0a 02              /* ignoriere Zeilenabstand, da */
		bra  #1/8_ON_END        /* diese VMI berschreibt */

#1/8_ON_AUSG    prn 1b prn 26 prn 6c prn 38 prn 44
		movi 1a 08
		loab [#save_lpi] 1a

#1/8_ON_END     ret 00

/*----------------------------------------------------------------------*/
/*      function body 1/6'' Zeilenabstand  (Startsequenz fr ESC 41 n   */
/*----------------------------------------------------------------------*/

#1/6_ON

#1b_32_start    /* Aufruf fr ESC A */
		loab 13 [#vmi_switch]
		cmpi 13 00              /* wird VMI bei Formularlnge */
		beq  #1b_32_ausg        /* ausgegeben ?   Nein     */
		movi 0a 02              /* ignoriere Zeilenabstand, da */
		bra  #1b_32_end         /* diese VMI berschreibt */

#1b_32_ausg     tsti 00 09
		beq #1b_32_var
		prn 1b prn 26 prn 6c prn 36 prn 44 /* 1/6 */
		movi 1a 06
		loab [#save_lpi] 1a
		bra #1b_32_end

#1b_32_var      loab 12 [#save_n72_var] /*n/72 */
		prn 1b prn 26 prn 6c
		call #convert
		prn 43
		clri 00 09
		movi 1a 07
		loab [#save_lpi] 1a

#1b_32_end      ret 00

/*----------------------------------------------------------------------*/
/*      function body n/72'' Zeilenabstand       PARA: 1                */
/*----------------------------------------------------------------------*/

#N/72           loab [#n_72_wert] 12
		mpyi 12 02
		divi 12 03              /* Umrechnung in n/48 */
		cmpi 12 00
		bne #N_72_AUS
		movi 12 01

#N_72_AUS       loab [#save_n72_var] 12  /* merken Wert */
		seti 00 09               /* Start nach ESC A */

#N/72_ENDE      ret 00

/*----------------------------------------------------------------------*/
/*      function body N/216'' Zeilenabstand     PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#N/216_ON       loab 12 [0C+2]          /* Para from Stack */
		loab 13 [#vmi_switch]
		cmpi 13 00              /* wird VMI bei Formularlnge */
		beq  #N/216_AUSG        /* ausgegeben ?   Nein     */
		movi 0a 02              /* ignoriere Zeilenabstand, da */
		bra  #N/216_END         /* diese VMI berschreibt */

#N/216_AUSG     mpyi 12 02
		divi 12 09
		cmpi 12 00
		bne #N_216_1
		movi 12 01

#N_216_1        prn 1b prn 26 prn 6c
		call #convert
		prn 43
		movi 12 16              /* N/216'' Zeilenabstand */
		loab [#save_lpi] 12     /* eingestellt           */

#N/216_END      ret 01

/*----------------------------------------------------------------------*/
/*      function body LINKER und RECHTER RAND   PARA: 2 Byte            */
/*----------------------------------------------------------------------*/

#SET_MARGINS    prn 1b prn 39           /* Rnder lschen */
		prn 1b prn 26 prn 61
		loab 12 [0C+3]          /* Para from stack     */
		loab [#save_lrd] 12     /* linken Rand sichern */
		call #convert
		prn 4c
		loab 12 [0C+2]          /* rechter Rand */
		cmpi 12 00              /*    = 0  ?    */
		beq  #set_right_marg_no
		prn 1b prn 26 prn 61
		loab 12 [0C+2]          /* Para from stack      */
		loab [#save_rrd] 12     /* rechten Rand sichern */
		call #convert
		prn 4d
		bra #set_right_marg_no

#set_right_marg_no
		ret 02                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body KOPFBEREICH               PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#SET_HEADER                             /* not yet available */
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body FUZEILEN                 PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#SET_BOTTOM     movi 0A 02
	    /*  loab 00 [0C+2]   */     /* Para from stack */
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      Funktion VMI-Pruefung                   PARA: -                 */
/*      Hier wird geprft, ob ein VMI erforderlich ist                  */
/*----------------------------------------------------------------------*/

#vmi_pruef      loab 12 [#form_length]  /* aktuelle Formularlnge */
		loab 13 [#hmi_orient]
		cmpi 13 01
		beq #vmi_ls             /* Orientierung ist Landscape */
		loa 11 0040             /* Portrait-Format */
		cmp 12 11               /* Formularlnge > 64 Zeilen ? */
		bgr #vmi_yes_pt
		movi 13 00
		loab [#vmi_switch] 13   /* setze VMI-Schalter auf Null */
		bra #vmi_pruef_end

#vmi_ls         loa 11 002b             /* Landscape-Format */
		cmp 12 11               /* Formularlnge > 43 Zeilen ? */
		bgr #vmi_yes_ls         /* ja; VMI erforderlich */
		movi 13 00
		loab [#vmi_switch] 13   /* setze VMI-Schalter auf Null */
		bra #vmi_pruef_end

#vmi_yes_pt     movi 13 01
		loab [#vmi_switch] 13   /* setze VMI-Schalter auf Portrait */
		bra #vmi_pruef_end

#vmi_yes_ls     movi 13 02
		loab [#vmi_switch] 13   /* setze VMI-Schalter auf Landscape */

#vmi_pruef_end  ret 00

/*----------------------------------------------------------------------*/
/*      Funktion VMI-Berechnung                 PARA: -                 */
/*      Steuerparameter #vmi_switch                                     */
/*      Formel f. Portrait:     vmi = 48 x 10,7 : Zeilen/Seite          */
/*                Landscape:    vmi = 48 x  7,3 : Zeilen/Seite          */
/*----------------------------------------------------------------------*/

#vmi_berechnung
	       loab 18 [#vmi_switch]
	       cmpi 18 01               /* Portrait ? */
	       beq #vmi_ber_1           /* Ja */
	       loa 18 88b8              /* landscape dec. 35000 */
	       bra #vmi_ber_2

#vmi_ber_1     loa 18 c8c8              /* portrait dec. 51400 */

#vmi_ber_2     loa 1a 0030
	       loa 17 0064              /* dez. 100 */
	       loab 19 [#form_length]
	       div 18 19                /* ermittle VMI als Ganzzahl */
	       mov 15 18                /* sichern Ergebnis */
	       div 18 17                /* ermittle Vorkommastelle */
	       add 18 1a
	       mov 00 18                /* Ausgabe Vorkommastelle */
	       prn 2e                   /* Ausgabe Komma */
	       mod 15 17                /* ermittle dezimalen Rest */
	       mov 18 15                /* sichern Rest */
	       divi 15 0a               /* ermitteln erste Nachkommastelle */
	       add 15 1a
	       mov 00 15                /* Ausgabe erste Nachkommastelle */
	       modi 18 0a               /* ermitteln zweite Nachkommastelle */
	       add 18 1a
	       mov 00 18                /* Ausgabe zweite Nachkommastelle */

#vmi_berechnung_end
	       ret 00

/*----------------------------------------------------------------------*/
/*      Funktion EINSTELL                       PARA: -                 */
/*      Hier werden aktuelle Einstellungen wieder aktiviert             */
/*      (nach vorherigem Hardware Reset)                                */
/*      -- bentigt vor neuer VMI-Berechnung --                         */
/*----------------------------------------------------------------------*/

#einstell       loab 1a [#save_schacht]
		cmpi 1a 00
		bne #einst_schacht
		loab 1a [#FEED_SELECT]

#einst_schacht  cmpi 1a 01
		beq #schacht_1
		cmpi 1a 02
		beq #schacht_2
		cmpi 1a 03
		bne #einst_feeder

#schacht_3      prn 1b prn 26 prn 6c prn 34 prn 48
		bra #einst_feeder

#schacht_1      prn 1b prn 26 prn 6c prn 31 prn 48
		bra #einst_feeder

#schacht_2      prn 1b prn 26 prn 6c prn 36 prn 48

#einst_feeder   prn 1b prn 28 prn 31 prn 30 prn 55 /* PC-8 Zeichensatz */

#einst_orient   loab 12 [#hmi_orient]
		cmpi 12 01
		beq #einst_orient_lands
		prn 1b prn 26 prn 6c prn 30 prn 4f
		bra #einst_fett

#einst_orient_lands
		prn 1b prn 26 prn 6c prn 31 prn 4f

#einst_fett     loab 1a [#save_fett]
		cmpi 1a 00
		beq #einst_fett_aus
		prn 1b prn 28 prn 73 prn 33 prn 42 /*fett ein*/
		bra #einst_unterstr

#einst_fett_aus prn 1b prn 28 prn 73 prn 30 prn 42 /*fett aus*/

#einst_unterstr loab 1a [#save_unterstr]
		cmpi 1a 00
		beq #einst_unterstr_aus
		prn 1b prn 26 prn 64 prn 30 prn 44 /*unterstreichen ein*/
		bra #einst_char_spac

#einst_unterstr_aus
		prn 1b prn 26 prn 64 prn 40 /*unterstreichen aus */

#einst_char_spac
		loab 1a [#save_char_spac]
		cmpi 1a 00
		beq #einst_cpi
		pushb [#save_char_spac]
		call #N/60
		jmp #einst_lpi

#einst_cpi      loab 1a [#save_cpi]
		cmpi 1a 0a
		bne #einst_cpi_12
		prn 1b prn 28 prn 73 prn 31 prn 30 prn 48 /* 10 cpi */
		prn 1b prn 28 prn 73 prn 31 prn 32 prn 56
		prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		loab 1a [#hmi_orient]
		cmpi 1a 01              /* HMI = Landscape ? */
		bne #einst_cpi_10_pt    /* Nein ==> Portrt */
		prn 1b prn 26 prn 6b    /* HMI = 10,09 */
		prn 31 prn 30 prn 2e prn 30 prn 39 prn 48
		jmp #einst_lpi

#einst_cpi_10_pt
		prn 1b prn 26 prn 6b    /* HMI = 11,300 */
		prn 31 prn 31 prn 2e prn 33 prn 30 prn 30 prn 48
		jmp #einst_lpi

#einst_cpi_12   cmpi 1a 0c
		bne #einst_cpi_16
		prn 1b prn 28 prn 73 prn 31 prn 32 prn 48   /* 12 cpi */
		prn 1b prn 28 prn 73 prn 31 prn 30 prn 56
		prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		loab 1a [#hmi_orient]
		cmpi 1a 01              /* HMI = Landscape ? */
		bne #einst_cpi_12_pt    /* Nein ==> Portrt */
		prn 1b prn 26 prn 6b    /* HMI = 8,43 */
		prn 38 prn 2e prn 34 prn 33 prn 48
		jmp #einst_lpi

#einst_cpi_12_pt
		prn 1b prn 26 prn 6b    /* HMI = 9,625 */
		prn 39 prn 2e prn 36 prn 32 prn 35 prn 48
		jmp #einst_lpi

#einst_cpi_16   prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* CPI */
		prn 1b prn 28 prn 73 prn 34 prn 31 prn 30 prn 32 prn 54 /* Letter Gothic */
		loab 1a [#hmi_orient]
		cmpi 1a 01              /* HMI = Landscape ? */
		bne #einst_cpi_16_pt    /* Nein ==> Portrt */
		prn 1b prn 26 prn 6b    /* HMI = 5,946*/
		prn 35 prn 2e prn 39 prn 34 prn 36 prn 48
		jmp #einst_lpi

#einst_cpi_16_pt
		prn 1b prn 26 prn 6b    /* HMI = 6,990 */
		prn 36 prn 2e prn 39 prn 39 prn 30 prn 48
		jmp #einst_lpi

#einst_lpi      /* Einstellung von Zeilenabstand nicht not-*/
		/*wendig, da sowieso VMI berechnet wird */

#einst_rd       pushb [#save_lrd]
		pushb [#save_rrd]       /* Rnder einstellen */
		call #SET_MARGINS

#einstell_usr_int
		loaa 12 #USR_INIT
		pushw 12
		call #print_str
		ret 00

/*----------------------------------------------------------------------*/
/*   function print_str                      PARA: 1 WORD               */
/*                                                                      */
/*   Gibt einen PASCAL string an den Drucker aus.                       */
/*   Stringformat: #name 2-Byte-Lnge Daten                             */
/*----------------------------------------------------------------------*/

#print_str      loaw 12 [0C+2]          /* Para from stack */
		loaw 13 [12]            /* first WORD is length */
		addi 12 02              /* add length + strtadr */
		add  13 12              /* first printable byte */

#print_str_loop cmp  13 12              /* are we already at the end */
		beq  #print_str_end
		loab 00 [12]            /* print data */
		addi 12 01
		bra #print_str_loop

#print_str_end  ret 02

/*----------------------------------------------------------------------*/
/*   function print_str_u                    PARA: 1 WORD               */
/*                                                                      */
/*   Gibt einen PASCAL string an den Drucker aus.                       */
/*!!! gibt erstes Byte des Strings nicht aus (--> Benutzerzeile) !!!    */
/*   Stringformat: #name 2-Byte-Lnge Daten                             */
/*----------------------------------------------------------------------*/

#print_str_u    loaw 12 [0C+2]          /* Para from stack */
		loaw 13 [12]            /* Lnge in Reg. 13 */
		addi 12 02              /* Startadr. in Reg 12  */
		add  13 12              /* Endeadr. in Reg 13 */
		addi 12 01              /* erstes Byte wird nicht gedruckt */

#print_str_loop_u
		cmp  13 12              /* are we already at the end */
		beq  #print_str_end_u
		loab 00 [12]            /* print data */
		addi 12 01
		bra #print_str_loop_u

#print_str_end_u
		ret 02

#convert        /* Konvertierung Hex --> ASCII */
		loa 18 0030
		loa 19 2710             /* Divisor: hex. 2710 = dez. 10000 */

#convert_loop   mov 13 12
		div 13 19               /* Division durch 10000, 1000, 100, 10  */
		add 13 18               /* Ergebnis + hex. 30 */
		mov 00 13
		mod 12 19               /* wiederhole Division zur Restermittlung */
		divi 19 0a              /* dividiere Divisor durch 10 */
		cmpi 19 00              /* alle Dez.stellen bereits berechnet ? */
		bne #convert_loop
		ret 00

END_FUNCTIONS
/************************************************************************/
/*      END OF FUNCTION BODIES                                          */
/************************************************************************/

/************************************************************************/
/*      INIT Segment, die ersten Eintrge mssen die INIT-Werte sein!!  */
/************************************************************************/


INIT
	#PAPER_TYPE      01             /* 0 = Endlos, 1 = Einzelblatt */
	#FEED_SELECT     00             /* 0 = kein Einzug, (!=0) = Einzug */
					/*     aus Schacht n               */
	#INITIAL_FEED    00             /* 0 = kein Einzug, 1 = Einzug, ffu */
	#FINAL_EJECT     00             /* 0 = kein Auswurf, 1 = Auswurf   */
	#QUALITY         02             /* 0 = draft, 1 = NLQ, 2 = LQ      */
	#PAPER_LENGTH    40             /* n = Anzahl Zeilen pro Seite */
	#PAPER_WIDTH     88             /* n = Breite in Zeichen bei 10 CPI */

					/* CHAR_SPACING und CHARS_PER_INCH  */
					/* schlieen sich gegenseitig aus ! */
	#CHAR_SPACING    00             /* n = n/60'' character spacing */
	#CHARS_PER_INCH  0A                 /* Pica, Elite, compressed */

	#LINES_PER_INCH  06             /* linespacing 1/6'' or 1/8'' */
	#LEFT_MARGIN     01
	#RIGHT_MARGIN    88
	#HEAD_LINES      01
	#BOTTOM_LINES    00
	#USR_INIT        00 00  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
				00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
				00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
				00 00 00 00 00
	#PAGE_SIZE_1     04             /* Papierformat Schacht 1           */
	#PAGE_SIZE_2     04             /* Papierformat Schacht 2           */
	#PAGE_SIZE_3     04             /* Papierformat Schacht 3           */

END_INIT

/************************************************************************/
/*      D A T A - Block                                                 */
/************************************************************************/


DATA

#seq_tab         08 00  00 00 00 00 00 00 00 00
#hmi_data        08 00   00 00 00 00 00 00 00 00
#hmi_orient      00                 /* 00 = HMI Portrait */
				    /* 01 = HMI Landscape */
#form_length     00                 /* Formularlnge durch Init bzw. ESC `C'*/
#vmi_switch      00                 /* Schalter fr VMI-Berechnung */
				    /* 00 = kein VMI */
				    /* 01 = VMI fr Portrait */
				    /* 02 = VMI fr Landscape */
#save_fett       00                 /* 00 = fett aus */
				    /* 01 = fett ein */
#save_unterstr   00                 /* 00 = unterstreichen aus */
				    /* 01 = unterstreichen ein */
#save_char_spac  00                 /* 00 = fixed              */
				    /* 01 = n/60               */
#save_cpi        00                 /* 0a = 10 cpi             */
				    /* 0c = 12 cpi             */
				    /* 10 = 16 cpi compressed  */
#save_lpi        00                 /* 06 = 6 lpi              */
				    /* 08 = 8 lpi              */
				    /* 07 = n/72               */
				    /* 16 = n/216              */
#save_lrd        00                 /* linker Rand             */
#save_rrd        00                 /* rechter Rand            */
#save_schacht    00                 /* 01 = Schacht 1          */
				    /* 02 = Schacht 2          */
				    /* 00 = kein Schacht       */
#save_n72_var    00                 /* Zwischenablage fr N/72 */
#n_72_wert       00                 /* N/72 Wert               */
#n216_einmal     00                 /* 01 = N/216'' einmalig ein */
#n_216_wert      00                 /* N/216 Anzahl N          */

END_DATA

STACK

	00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

END_STACK

