 4.00!FUJITSU!PRINTPARTNER 16ADV!l!
 00 01 02 03 04 05 06 FF 08 FF FF 0B FF FF FF FF     /* Zeichenumsetzungs- */
 10 11 FF 13 FF 15 16 17 20 20 1A FF 1C 1D 1E 1F     /* tabelle            */
 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F
 30 31 32 33 34 35 36 37 38 39 3A 3B FF FF FF 3F
 40 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F
 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F
 60 61 62 63 64 65 66 67 68 69 6A 6B 6C 6D 6E 6F
 70 71 72 73 74 75 76 77 78 79 7A 7B 7C 7D 7E 7F
 80 81 82 83 84 85 86 87 88 89 8A 8B 8C 8D 8E 8F
 90 91 92 93 94 95 96 97 98 99 9A 9B 9C 9D 9E 9F
 A0 A1 A2 A3 A4 A5 A6 A7 A8 A9 AA AB AC AD AE AF
 B0 B1 B2 B3 B4 B5 B6 B7 B8 B9 BA BB BC BD BE BF
 C0 C1 C2 C3 C4 C5 C6 C7 C8 C9 CA CB CC CD CE CF
 D0 D1 D2 D3 D4 D5 D6 D7 D8 D9 DA DB DC DD DE DF
 E0 E1 E2 E3 E4 E5 E6 E7 E8 E9 EA EB EC ED EE EF
 F0 F1 F2 F3 F4 F5 F6 F7 F8 F9 FA FB FC FD FE FF !

/********************************************************************/
/*                                                                  */
/* Druckertabellenname: fj16av.asd                                  */
/* Referenzdrucker    : FUJITSU PrintPartner 16ADV                  */
/* Ersteller          : Armin Gntner/Softwareentwicklung           */
/* Namenskrzel       : ag                                          */
/* Erstellungsdatum   : 05.08.98                                    */
/* Version intern     : 4.0                                         */
/*------------------------------------------------------------------*/
/*                                                                  */
/* Verwendete Register:                                             */
/*                                                                  */
/* Statusregister :                                                 */
/* Arbeitsregister:                                                 */
/*------------------------------------------------------------------*/
/*                                                                  */
/* nderungen:                                                      */
/* Datum     Krzel nderung                                        */
/* 05.08.98  ag     1. Erstes Release => Kopie der HP LaserJet 5    */
/*                     Druckertabelle                               */
/*------------------Freigabestand V3.51-----------------------------*/
/********************************************************************/
/********************************************************************/
/*      START OF VM-SEQUENCES                                       */
/********************************************************************/

SEQUENCES

/*--------------------- SEQUNECE: Zeilenvorschub -------------------*/

nop 0a end      prn 0a
		prn 0d
		movi 05 01
		end

/*--------------------- SEQUNECE: Blattvorschub --------------------*/

nop 0c end      prn 0c
		prn 0d
		movi 06 01
		movi 05 01
		end

/*--------------------- SEQUENCE: Wagenrcklauf --------------------*/

nop 0d end      prn 0d
		movi 05 01
		end

/*--------------------- Zeichen hex. 3C ----------------------------*/

nop 3C end      cmpi 13 01              /* OCRA EIN ? */
		beq  #3C_ocra
		prn 3C                  /* NEIN */
		bra  #3C_end

#3C_ocra        prn 5E                  /* Umsetzung 3C -> 5E (Schwartz-Font) */

#3C_end         movi 05 01
		end

/*--------------------- Zeichen hex. 3D ----------------------------*/

nop 3D end      cmpi 13 01              /* OCRA EIN ? */
		beq  #3D_ocra
		prn 3D                  /* NEIN */
		bra  #3D_end

#3D_ocra        prn 7B                  /* Umsetzung 3D -> 7B (Schwartz-Font) */

#3D_end         movi 05 01
		end

/*--------------------- Zeichen hex. 3E ----------------------------*/

nop 3E end      cmpi 13 01              /* OCRA EIN ? */
		beq  #3E_ocra
		prn  3E                 /* NEIN */
		bra  #3E_end

#3E_ocra        prn 7D                  /* Umsetzung 3E -> 7D (Schwartz-Font) */

#3E_end         movi 05 01
		end

/*--------------------- SEQUENCE: unterstreichen ein/aus -----------*/

nop 1b nop 2d sto 10 end

		cmpi 10 00
		beq #1b_2d_off
		seti 00 06
		prn 1b prn 26 prn 64 prn 30 prn 44
		bra #1b_2d_end

#1b_2d_off      prn 1b prn 26 prn 64 prn 40
		clri 00 06

#1b_2d_end      end

/*--------------------- SEQUENCE: N/216'' Zeilenabstand ------------*/

nop 1b nop 33 sto 12 end

		loab [#n_216_wert] 12   /* N/216 Anzahl N sichern */
		pushb 12
		call #N/216_ON
		end

/*--------------------- SEQUENCE: Fettdruck ein --------------------*/

nop 1b nop 45 end

		prn 1b prn 28 prn 73 prn 33 prn 42
		loa 16 00ff
		loab 15 [#save_cpi]      /* Andere CPI eingestellt */
		cmp 15 16
		bne #1b_45_end
		pushb [#cpi_vk]
		pushb [#cpi_nk]
		pushb [#hmi_vk]
		pushb [#hmi_nk]
		call #CPI_ANDERE         /* andere CPI Werte   */

#1b_45_end      end

/*--------------------- SEQUENCE: Fettdruck aus --------------------*/

nop 1b nop 46 end

		prn 1b prn 28 prn 73 prn 30 prn 42
		loa 16 00ff
		loab 15 [#save_cpi]      /* Andere CPI eingestellt */
		cmp 15 16
		bne #1b_46_end
		pushb [#cpi_vk]
		pushb [#cpi_nk]
		pushb [#hmi_vk]
		pushb [#hmi_nk]
		call #CPI_ANDERE         /* andere CPI Werte   */

#1b_46_end      end

/*--------------------- SEQUENCE: doppelte Breite ------------------*/

nop 1b nop 57 sto 10 end

		mov 0a 02
		end

nop 0e end      mov 0a 02
		end

nop 14 end      mov 0a 02
		end

/*--------------------- SEQUENCE: BELL -----------------------------*/

nop 07 end      mov 0a 02
		end

/*--------------------- SEQUENCE: HORIZONTAL TAB -------------------*/

nop 09 end      mov 1F 05
		subi 1F 01

#09_tstloop     addi 1F 01
		tst 01 1F
		beq #09_outloop
		cmp 1F 07
		bne #09_tstloop

#09_outloop     tsti 00 06
		bne #09_weiter
		prn 1B prn 26 prn 64 prn 40

#09_weiter      prn 20
		addi 05 01
		cmp 05 1F
		ble #09_outloop
		beq #09_outloop
		cmp 07 05
		bgr #09_out
		movi 05 01

#09_out         tsti 00 06
		bne #09_ende
		prn 1B prn 26 prn 64 prn 44

#09_ende        end

/*--------------------- SEQUENCE: SET HORIZONTAL TAB STOPS ---------*/

nop 1B nop 44 end

		loa 0E 00E0
		loa 0F 0000

#1B_44_loop     clr 01 0F
		addi 0F 01
		cmp 0F 0E
		ble #1B_44_loop

#1B_44_next     sto 10
		cmpi 10 00
		beq #1b_44_ende
		subi 10 01
		set 01 10
		bra #1B_44_next

#1b_44_ende     end

/*--------------------- SEQUENCE: OCRA ein -------------------------*/

nop 1b nop 21 end

		movi 13 01              /* Schalter OCRA auf EIN */
		/* Laden OCRA-Zeichensatz fr Fontauswahl */
		prn 1b prn 28 prn 30 prn 4f
		end

/*--------------------- SEQUENCE: OCRA aus -------------------------*/

nop 1b nop 22 end

		/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
		/* bei OCRA OFF mu der vorherige Font mit */
		/* allen Attributen wieder eingestellt werden */
		/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
		movi 13 00        /* Schalter OCRA auf AUS */
		/* Laden PC-8 Zeichensatz */
		prn 1b prn 28 prn 31 prn 30 prn 55
		end

/*--------------------- SEQUENCE: Papierendekontrolle ein/aus ------*/

nop 1b nop 38 end

		mov 0a 02
		end

nop 1b nop 39 end

		mov 0a 02
		end

/*--------------------- SEQUENCE: N/216'' einmalig vor -------------*/

nop 1b nop 4a sto 12 end

		mpyi 12 0a
		divi 12 03              /* Umrechnung in N/720''(Decipoints) */
		cmpi 12 00
		bne #N_216_einm_vor_1
		movi 12 01

#N_216_einm_vor_1
		prn 1b prn 26 prn 61 prn 2b
		call #convert
		prn 56

#N_216_einm_vor_end
		movi 12 00
		movi 13 01
		loab [#n216_einmal] 13
		end

/*--------------------- SEQUENCE: Furand setzen -------------------*/

nop 1b nop 4e sto 10 end

		mov 0a 02
		end

/*--------------------- SEQUENCE: Furand lschen ------------------*/

nop 1b nop 4f end

		mov 0a 02
		end

/*--------------------- SEQUENCE: Hochschrift ein ------------------*/

nop 1b nop 53 nop 00 end

		movi 1c 01
		prn 1b prn 2a prn 70 prn 2d prn 31 prn 35 prn 59
		prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* 16.67 CPI */
		end

/*--------------------- SEQUENCE: Tiefschrift ein ------------------*/

nop 1b nop 53 nop 01 end

		movi 1c 02
		prn 1b prn 2a prn 70 prn 2b prn 31 prn 35 prn 59
		prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* 16.67 CPI */
		end

/*--------------------- SEQUENCE: Hoch-/Tiefschrift aus ------------*/

nop 1b nop 54 end

		cmpi 1c 01
		bne #TIEF_OUT
		prn 1b prn 2a prn 70 prn 2b prn 31 prn 35 prn 59
		cmpi 15 17
		bne #PICA_54_1
		call #COMPRESSED_ON
		bra #END_54_1

#PICA_54_1      cmpi 15 10
		bne #ELITE_54_1
		call #PICA_ON
		bra #END_54_1

#ELITE_54_1     call #ELITE_ON

#END_54_1       movi 1c 00
		bra #H_T_END

#TIEF_OUT       cmpi 1c 02
		bne #H_T_END
		prn 1b prn 2a prn 70 prn 2d prn 31 prn 35 prn 59
		cmpi 15 17
		bne #PICA_54_2
		call #COMPRESSED_ON
		bra #END_54_2

#PICA_54_2      cmpi 15 10
		bne #ELITE_54_2
		call #PICA_ON
		bra #END_54_2

#ELITE_54_2     call #ELITE_ON

#END_54_2       movi 1c 00

#H_T_END        end

/*--------------------- SEQUENCE: Halbzeilenschaltung vor ----------*/

nop 1b nop 63 nop 02 end

		prn 1b prn 3d
		end

/*--------------------- SEQUENCE: Halbzeilenschaltung zurck -------*/

nop 1b nop 63 nop 01 end

		prn 1b prn 26 prn 61 prn 2d prn 2e prn 35 prn 52
		end

/*--------------------- SEQUENCE: N/216'' einmalig zurck ----------*/

nop 1b nop 6a sto 12 end

		mpyi 12 0a
		divi 12 03              /* Umrechnung in N/720''(Decipoints) */
		cmpi 12 00
		bne #N_216_einm_back_1
		movi 12 01

#N_216_einm_back_1
		prn 1b prn 26 prn 61 prn 2d
		call #convert
		prn 56

#N_216_einm_back_end
		movi 12 00
		movi 13 01
		loab [#n216_einmal] 13
		end

/*--------------------- SEQUENCE: Endebehandlung -------------------*/

nop 1b nop 5b nop 36 nop 7e end         /* Endebehandlung */

		loab 12 [#PAPER_TYPE]   /* Endlospapier */
		cmpi 12 00
		beq #1b_40_strt         /* if true, skip   */
		loab 12 [#FINAL_EJECT]  /* Auswurf Ja/Nein */
		cmpi 12 00
		beq #1b_40_strt         /* nein, skip */
		call #SHEET_OUT
		bra #1b_40_strt
		end

/*--------------------- SEQUENCE: INIT - ehemals GENERAL RESET -----*/

nop 1b nop 40 end

		movi 10 00              /* Register 10 lschen */
		movi 11 00              /* Register 11 lschen */
		movi 12 00              /* Register 12 lschen */
		movi 13 00              /* Register 13 lschen */
		movi 14 00              /* Register 14 lschen */
		movi 15 00              /* Register 15 lschen */
		movi 16 00              /* Register 16 lschen */
		movi 17 00              /* Register 17 lschen */
		movi 18 00              /* Register 18 lschen */
		movi 19 00              /* Register 19 lschen */
		movi 1a 00              /* Register 1a lschen */
		movi 1b 00              /* Register 1b lschen */
		movi 1c 00              /* Register 1c lschen */
		movi 1d 00              /* Register 1d lschen */
		movi 1e 00              /* Register 1e lschen */
		movi 1f 00              /* Register 1f lschen */
		prn 1b prn 45           /* Hardware Reset      */
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */
		loab 12 [#PAPER_TYPE]   /* Endlospapier        */
		cmpi 12 00
		beq #1b_40_strt         /* if true, skip */
		loab 12 [#FEED_SELECT]  /* select feeder */
		cmpi 12 00
		beq #1b_40_strt         /* no default get sheet */
		pushb [#FEED_SELECT]
		call #GET_SHEET

#1b_40_strt     loa 1F 00E8             /* alle internen Tabs zurcksetzen */

#1B_40_tabs     clr 01 1F
		subi 1F 01
		cmpi 1F 00
		bne #1B_40_tabs
		loa 0E 00E8             /* Tab auf jeder 8ten Position setzen */
		movi 0F 08

#1b_40_set      set 01 0F
		addi 0F 08
		cmp 0F 0E
		bne #1b_40_set
		prn 1b prn 28 prn 73 prn 30 prn 42 /* fett aus        */
		prn 1b prn 26 prn 64 prn 40 /* Unterstreichen aus     */
		prn 1b prn 28 prn 31 prn 30 prn 55 /* IBM Zeichensatz */
		prn 1b prn 28 prn 73 prn 30 prn 50 /* Fixed Spacing   */
		prn 1b prn 26 prn 6C prn 30 prn 4F /* Hochformat */
		clri 00 05
		clri 00 06
		clri 00 09
		movi 05 01              /* COLCNT */
		movi 06 01              /* LINCNT */
		loab 07 [#PAPER_WIDTH]  /* MAXCOL */
		loab 08 [#PAPER_LENGTH] /* MAXLIN */
		loab 09 [#BOTTOM_LINES] /* BOTTOM */
		mov 09 08
		loab 13 [#BOTTOM_LINES] /* Seitenlnge */
		sub 09 13

#1b_40_quality  loab 12 [#QUALITY]      /* Druckqualitt */
		cmpi 12 00
		beq #1b_40_draft        /* 0 = DRAFT     */
		cmpi 12 01              /* 1 = NLQ       */
		beq #1b_40_nlq
		call #LQ_ON             /* 2 = LQ        */
		bra #1b_40_cpi

#1b_40_draft    call #DRAFT_ON
		bra #1b_40_cpi

#1b_40_nlq      call #NLQ_ON

#1b_40_cpi      loab 12 [#CHAR_SPACING] /* spacing in n/60'' */
		loab [#n/60_ein] 12
		loab [#n/60_wert] 12
		cmpi 12 00
		beq  #1b_40_fixed
		pushb [#CHAR_SPACING]   /* spacing in n/60'' */
		call #N/60
		bra  #1b_40_lpi

#1b_40_fixed    loab 12 [#CHARS_PER_INCH]
		cmpi 12 11              /* 17 cpi = compressed */
		beq  #1b_40_compressed
		cmpi 12 0C              /* 12 cpi = elite */
		beq  #1b_40_elite
		call #PICA_ON           /* 10 cpi = pica */
		bra  #1b_40_lpi


#1b_40_compressed
		call #COMPRESSED_ON
		bra  #1b_40_lpi

#1b_40_elite    call #ELITE_ON
					/* set lines per inch */
#1b_40_lpi      loab 12 [#LINES_PER_INCH]
		cmpi 12 08
		bne  #1b_40_1/6
		call #1/8_ON
		bra  #1b_40_length

#1b_40_1/6      movi 12 0C              /* set 12/72'' == 1/6'' */
		loab [#n_72_wert] 12    /* n/72 */
		call #N/72
		call #1/6_ON            /* start 1/6'' linespacing */

#1b_40_length                           /* set paper length */
		pushb [#PAPER_LENGTH]
		loab 12 [#PAPER_LENGTH] /* Formularlnge */
		loab [#form_length] 12  /* sichern       */
		call #LINES_PER_PAGE

#1b_40_left_margin                      /* left and right margin */
		pushb [#LEFT_MARGIN]
		pushb [#RIGHT_MARGIN]
		call #SET_MARGINS

#1b_40_head                             /* set header of page */
		pushb [#HEAD_LINES]
		call #SET_HEADER

#1b_40_bottom                           /* set bottom of page */
		pushb [#BOTTOM_LINES]
		call #SET_BOTTOM

#1b_40_user_init
		loaa 12 #USR_INIT
		pushw 12
		call #print_str
		end

/*--------------------- SEQUENCE: Blattauswurf oder Einzug aus Schacht N -*/

nop 1B nop 62 sto 12 end

		cmpi 12 00
		beq #1b_62_sheet_out
		pushb 12
		call #GET_SHEET
		bra #1b_62_end

#1b_62_sheet_out
		call #SHEET_OUT

#1b_62_end      end

/*--------------------- SEQUENCE: NLQ ein --------------------------*/

nop 1B nop 47 end

		call #NLQ_ON
		end

/*--------------------- SEQUENCE: NLQ aus --------------------------*/

nop 1B nop 48 end

		call #DRAFT_ON
		end

/*--------------------- SEQUENCE: Formularlnge einstellen ---------*/

nop 1B nop 43 sto 12 end

		loab [#form_length] 12  /* Formularlnge */
		pushb 12                /* sichern       */
		call #LINES_PER_PAGE
		end

/*--------------------- SEQUENCE: N/60'' Zeichenabstand ------------*/

nop 1B nop 61 sto 12 end

		loab [#n/60_ein] 12     /* N/60 eingeschalten    */
		loab [#n/60_wert] 12    /* N/60 Anzahl N sichern */
		pushb 12
		call #N/60
		end

/*--------------------- SEQUENCE: PICA  10 cpi ---------------------*/

nop 12 end      movi 12 00              /* N/60 ausgeschaltet */
		loab [#n/60_ein] 12     /*                    */
		loab [#n/60_wert] 12    /*                    */
		call #PICA_ON
		end

/*--------------------- SEQUENCE: ELITE 12 cpi ---------------------*/

nop 1B nop 4D end

		movi 12 00              /* N/60 ausgeschaltet */
		loab [#n/60_ein] 12     /*                    */
		loab [#n/60_wert] 12    /*                    */
		bra #1b_3A_start
		end

nop 1B nop 3A end

#1b_3A_start    movi 12 00              /* N/60 ausgeschaltet */
		loab [#n/60_ein] 12     /*                    */
		loab [#n/60_wert] 12    /*                    */
		call #ELITE_ON
		end

/*--------------------- SEQUENCE: COMPRESSED 17 cpi ----------------*/

nop 0F end      movi 12 00              /* N/60 ausgeschaltet */
		loab [#n/60_ein] 12     /*                    */
		loab [#n/60_wert] 12    /*                    */
		call #COMPRESSED_ON
		end

/*--------------------- SEQUENCE: 1/8'' Zeilenabstand --------------*/

nop 1B nop 30 end

		call #1/8_ON
		end

/*--------------------- SEQUENCE: 1/6'' Zeilenabstand oder ESC A ausfhren -*/

nop 1B nop 32 end

	       call #1/6_ON
	       end

/*--------------------- SEQUENCE: linker/rechter RAND --------------*/

nop 1B nop 58 end

		movi 11 00              /* rechter Rand < 255 */
		loab [#rrand>255] 11
		sto 12                  /* left margin */
		loab [#save_lrd] 12     /* linken Rand sichern */
		pushb 12
		sto 12                  /* right margin */
		loab [#save_rrd] 12     /* rechten Rand sichern */
		pushb 12
		call #SET_MARGINS
		end

/*--------------------- SEQUENCE: Fuzeileneinstellen --------------*/

nop 1B nop 4E sto 12 end

		pushb 12
		call #SET_BOTTOM
		end

/*--------------------- SEQUENCE: N/72'' Zeilenabstand -------------*/

nop 1B nop 41 sto 12 end

		loab [#n_72_wert] 12    /* N/72 Anzahl N sichern */
		call #N/72
		end

/*--------------------- SEQUENCE: DUPLEX ein/aus -------------------*/

nop 1b nop 2c sto 10 end
		loab [#duplex] 10
		call #DUPLEX
		end

/*--------------------- SEQUENCE: Orientierung ---------------------*/

nop 1b nop 26 nop 6c sto 10 nop 4f end

		loab [#orient] 10       /* Orientrierung setzen */
		call #ORIENTIERUNG
		end

/*--------------------- SEQUENCE: variabler HMI-Wert ---------------*/

nop 1b nop 64 sto 10 sto 11 sto 12 sto 13 end
		
		cmpi 10 00
		bne #CPI_WEITER
		cmpi 11 00                
		beq #CPI_NO

#CPI_WEITER     
		loa 15 00ff
		loab [#save_cpi] 15     /* Andere CPI eingestellt */
		loab [#cpi_vk] 10
		loab [#cpi_nk] 11
		loab [#hmi_vk] 12
		loab [#hmi_nk] 13
		pushb 10
		pushb 11
		pushb 12
		pushb 13
		call #CPI_ANDERE

#CPI_NO                
		end

/*--------------------- SEQUENCE: rechter Rand > 255 ---------------*/

nop 1b nop 65 nop ff sto 10 end

		loab [#save_rrd_255] 10
		movi 11 01
		loab [#rrand>255] 11
		pushb 10
		call #SET_RIGHT_MARGIN_255
		end

/*--------------------------------------------------------------*/
/*      bypass of Bit Image Mode graphics                       */
/*                                                              */
/*      Regs used:      12      used to store input data        */
/*                      13      counter of BIM data bytes       */
/*--------------------------------------------------------------*/

/*--------------------------------------------------------------*/
/* ESC K n1 n2, normal density BIM, normal speed                */
/*--------------------------------------------------------------*/

nop 1B nop 4B end

		loa 12 004B
		bra #graphics_out
		end

/*--------------------------------------------------------------*/
/* ESC L n1 n2, double density BIM, half speed                  */
/*--------------------------------------------------------------*/

nop 1B nop 4C end

		loa 12 004C
		bra #graphics_out
		end

/*--------------------------------------------------------------*/
/* ESC Y n1 n2, double density BIM, normal speed                */
/*--------------------------------------------------------------*/

nop 1B nop 59 end

		loa 12 0059
		bra #graphics_out
		end

/*--------------------------------------------------------------*/
/* ESC Z n1 n2, quadruple density BIM                           */
/*--------------------------------------------------------------*/

nop 1B nop 5A end

		loa 12 005A

#graphics_out   prn 1B
		mov 00 12
		sto 12                  /* n1 = n MOD 256 */
		mov 00 12
		mov 13 12               /* save it */
		sto 12                  /* n2 = n DIV 256 */
		mov 00 12
		/* n = n1 + 256 * n2 */
		mpyi 12 10              /* 256 = REG2 * 16 */
		mpyi 12 10              /* 256 = 16 * 16 */
		add 13 12

#graphics_loop  cmpi 13 00              /* counter == 0 ? */
		beq #graphics_end
		sto 12
		mov 00 12
		subi 13 01              /* decrement counter */
		bra #graphics_loop

#graphics_end   end

END_SEQUENCES
/************************************************************************/
/*      END OF VM-SEQUENCES                                             */
/************************************************************************/

FUNCTIONS
/************************************************************************/
/*      START OF FUNCTION BODIES                                        */
/************************************************************************/

/*----------------------------------------------------------------------*/
/*      function body BLATTAUSWURF              PARA: -                 */
/*----------------------------------------------------------------------*/

#SHEET_OUT      loab 12 [#PAPER_TYPE]   /* Endlospapier */
		cmpi 12 00
		bne  #SHEET_OUT_001     /* if true, skip       */
		prn  0C                 /* FF bei Endlospapier */
		bra  #SHEET_OUT_end

#SHEET_OUT_001  /* Blattauswurfsequenz */
		prn 1b prn 26 prn 6c prn 30 prn 48

#SHEET_OUT_end  ret 00

/*----------------------------------------------------------------------*/
/*      function body BLATTEINZUG               PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#GET_SHEET      loab 12 [#PAPER_TYPE]   /* Endlospapier */
		cmpi 12 00
		beq  #GET_SHEET_end     /* if true, skip */

#GET_SHEET_EZB  loab 12 [0C+2]          /* Para from Stack */
		cmpi 12 02
		beq #GET_SHEET_EZB_2
		cmpi 12 03
		beq #GET_SHEET_EZB_3
		loab 13 [#PAGE_SIZE_1]
		cmpi 13 03
		beq #GET_SHEET_A3_1
		prn 1b prn 26 prn 6c prn 32 prn 36 prn 41
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */
		bra #GET_SHEET_TRAY1

#GET_SHEET_A3_1 prn 1b prn 26 prn 6c prn 32 prn 37 prn 41
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */

#GET_SHEET_TRAY1
		prn 1b prn 26 prn 6c prn 31 prn 48
		bra #GET_SHEET_end

#GET_SHEET_EZB_2
		loab 13 [#PAGE_SIZE_2]
		cmpi 13 03
		beq #GET_SHEET_A3_2
		prn 1b prn 26 prn 6c prn 32 prn 36 prn 41
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */
		bra #GET_SHEET_TRAY2

#GET_SHEET_A3_2 prn 1b prn 26 prn 6c prn 32 prn 37 prn 41
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */

#GET_SHEET_TRAY2
                prn 1b prn 26 prn 6c prn 36 prn 48
		bra #GET_SHEET_end

#GET_SHEET_EZB_3
		loab 13 [#PAGE_SIZE_3]
		cmpi 13 03
		beq #GET_SHEET_A3_3
		prn 1b prn 26 prn 6c prn 32 prn 36 prn 41
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */
		bra #GET_SHEET_TRAY3

#GET_SHEET_A3_3 prn 1b prn 26 prn 6c prn 32 prn 37 prn 41
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */

#GET_SHEET_TRAY3
                prn 1b prn 26 prn 6c prn 34 prn 48

#GET_SHEET_end  call #EINSTELL_FORMAT
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body LQ-Modus EIN              PARA: -                 */
/*----------------------------------------------------------------------*/

#LQ_ON          mov 0A 02
		ret 00

/*----------------------------------------------------------------------*/
/*      function body DRAFT-Modus EIN           PARA: -                 */
/*----------------------------------------------------------------------*/

#DRAFT_ON       mov 0A 02
		ret 00

/*----------------------------------------------------------------------*/
/*      function body NLQ-Modus EIN             PARA: -                 */
/*----------------------------------------------------------------------*/

#NLQ_ON         mov 0A 02
		ret 00

/*----------------------------------------------------------------------*/
/*      function body SEITENLNGE               PARA:  1 Byte           */
/*----------------------------------------------------------------------*/

#LINES_PER_PAGE
		loab 12 [0C+2]
		loab [#form_length] 12
		prn 1b prn 26 prn 6c prn 32 prn 45 /* oberer Rand */
		prn 1b prn 26 prn 6c
		loab 12 [0C+2]
		call #convert
		prn 46                  /* Textlnge */
		prn 1b prn 26 prn 6c prn 31 prn 4c /* Perforation aus */
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body VARIABLER ZEICHENABSTAND  PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#N/60           prn 1b prn 26 prn 6b
		loab 12 [0C+2]          /* Para from stack */
		mpyi 12 02
		call #convert
		prn 48
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body 17 Zeichen / Zoll (VERDICHTET EIN)  PARA: -       */
/*----------------------------------------------------------------------*/

#COMPRESSED_ON  movi 15 17
		loab [#save_cpi] 15     /* 17 CPI eingestellt */
		prn 1b prn 28 prn 73 prn 31 prn 36 prn 2e prn 36 prn 37 prn 48 /* 16.67 CPI */
		prn 1b prn 28 prn 73 prn 34 prn 31 prn 30 prn 32 prn 54 /* Letter Gothic */
		ret 00

/*----------------------------------------------------------------------*/
/*      function body 10 Zeichen / Zoll         PARA: -                 */
/*----------------------------------------------------------------------*/

#PICA_ON        movi 15 10
		loab [#save_cpi] 15     /* 10 CPI eingestellt */
		prn 1b prn 28 prn 73 prn 31 prn 30 prn 48 /* 10 CPI */
		prn 1b prn 28 prn 73 prn 31 prn 32 prn 56 /* 12 Points */
		prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		ret 00

/*----------------------------------------------------------------------*/
/*      function body 12 Zeichen / Zoll         PARA: -                 */
/*----------------------------------------------------------------------*/

#ELITE_ON       movi 15 12
		loab [#save_cpi] 15     /* 12 CPI eingestellt */
		prn 1b prn 28 prn 73 prn 31 prn 32 prn 48 /* 12 CPI */
		prn 1b prn 28 prn 73 prn 31 prn 30 prn 56 /* 10 Points */
		prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		ret 00

/*----------------------------------------------------------------------*/
/*      function body CPI_ANDERE                PARA: 2 Byte            */
/*----------------------------------------------------------------------*/

#CPI_ANDERE     prn 1b prn 28 prn 73 prn 34 prn 30 prn 39 prn 39 prn 54 /* Courier */
		prn 1b prn 28 prn 73
		loab 12 [0C+5]          /* Para from stack */
		loab [#cpi_vk] 12
		call #cpi_convert
		prn 2e
		loab 12 [0C+4]          /* Para from stack */
		loab [#cpi_nk] 12
		call #cpi_convert
		prn 48
		loab 12 [#hmi_vk]
		loab 13 [#hmi_nk]
		add 12 13
		cmpi 12 00
		beq #CPI_ANDERE_END
		prn 1b prn 26 prn 6b
		loab 12 [0C+3]          /* Para from stack */
		loab [#hmi_vk] 12
		call #cpi_convert
		prn 2e
		loab 12 [0C+2]          /* Para from stack */
		loab [#hmi_nk] 12
		call #cpi_convert
		prn 48
#CPI_ANDERE_END ret 04

/*----------------------------------------------------------------------*/
/*      function body 1/8'' Zeilenabstand       PARA: -                 */
/*----------------------------------------------------------------------*/

#1/8_ON         prn 1b prn 26 prn 6c prn 38 prn 44
		movi 13 08              /* 1/8'' Zeilenabstand */
		loab [#save_lpi] 13     /* eingestellt         */
		ret 00

/*----------------------------------------------------------------------*/
/*      function body 1/6'' Zeilenabstand  (Startsequenz fr ESC 41 n   */
/*----------------------------------------------------------------------*/

#1/6_ON

#1b_32_start    /*aufruf fr ESC A*/
		tsti 00 09
		beq #1b_32_var
		prn 1b prn 26 prn 6c prn 36 prn 44 /* 1/6 */
		movi 13 06              /* 1/6'' Zeilenabstand */
		loab [#save_lpi] 13     /* eingestellt         */
		bra #1b_32_end

#1b_32_var      loab 12 [#save_n72_var] /* n/72 */
		prn 1b prn 26 prn 6c
		call #convert
		prn 43
		movi 13 02              /* N/72'' Zeilenabstand */
		loab [#save_lpi] 13     /* eingestellt          */
		clri 00 09

#1b_32_end      ret 00

/*----------------------------------------------------------------------*/
/*      function body n/72'' Zeilenabstand       PARA: 1                */
/*----------------------------------------------------------------------*/

#N/72           mpyi 12 02
		divi 12 03              /* Umrechnung in n/48 */
		cmpi 12 00
		bne #N/72_AUS
		movi 12 01

#N/72_AUS       loab [#save_n72_var] 12 /* n/72 */

#N/72_ENDE      seti 00 09              /* Start nach ESC A */
		ret 00

/*----------------------------------------------------------------------*/
/*      function body N/216`` Zeilenabstand      PARA: 1                */
/*----------------------------------------------------------------------*/

#N/216_ON       loab 12 [0C+2]          /* Para from Stack        */
		loab [#n_216_wert] 12   /* N/216 Anzahl N sichern */
		mpyi 12 02
		divi 12 09
		cmpi 12 00
		bne #N/216_1
		movi 12 01

#N/216_1        prn 1b prn 26 prn 6c
		call #convert
		prn 43
		movi 13 16              /* N/216'' Zeilenabstand */
		loab [#save_lpi] 13     /* eingestellt           */

#N/216_END      ret 01

/*----------------------------------------------------------------------*/
/*      function body LINKER und RECHTER RAND   PARA: 2 Byte            */
/*----------------------------------------------------------------------*/

#SET_MARGINS    prn 1b prn 39           /* Rnder lschen */
		prn 1b prn 26 prn 61
		loab 12 [0C+3]          /* Para from stack     */
		loab [#save_lrd] 12     /* linken Rand sichern */
		call #convert
		prn 4c
		loab 12 [0C+2]          /* rechter Rand */
		cmpi 12 00              /*    = 0  ?    */
		beq  #set_right_marg_no
		loab 11 [#rrand>255]    /* rechter Rand */
		cmpi 11 01              /*     >        */
		beq #set_right_margin_2 /*   255 ?      */
		prn 1b prn 26 prn 61
		loab 12 [0C+2]          /* Para from stack      */
		loab [#save_rrd] 12     /* rechten Rand sichern */
		call #convert
		prn 4d
		bra #set_right_marg_no

#set_right_margin_2
		prn 1b prn 26 prn 61
		loab 12 [#save_rrd_255] /* rechten Rand > 255 laden */
		loa 11 00ff
		add 12 11
		call #convert
		prn 4d

#set_right_marg_no
		ret 02                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body RECHTER RAND > 255        PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#SET_RIGHT_MARGIN_255
		loab 12 [0C+2]          /* Para from stack      */
		cmpi 12 00
		beq #SET_RIGHT_MARGIN_255_END
		loab [#save_rrd_255] 12 /* rechten Rand sichern */
		loa 11 00ff
		add 12 11
		prn 1b prn 26 prn 61
		call #convert
		prn 4d

#SET_RIGHT_MARGIN_255_END
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body KOPFBEREICH               PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#SET_HEADER     /* not yet available */
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body FUZEILEN                 PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#SET_BOTTOM     movi 0A 02
		ret 01                  /* stack correction */

/*----------------------------------------------------------------------*/
/*      function body ORIENTIERUNG          PARA: 1 Byte                */
/*----------------------------------------------------------------------*/

#ORIENTIERUNG   loa 12 0031
		prn 1b prn 26 prn 6c
		cmp 10 12               /* Landscape-Format ? */
		bne #ORIENT_PORTRAIT
		prn 31                  /* Landscape-Format */
		bra #ORIENT_EINSTELL

#ORIENT_PORTRAIT
		prn 30                  /* Portrait-Format */

#ORIENT_EINSTELL
		prn 4f
		loab 12 [#n/60_ein]     /* N/60 Zeichenabstand ? */
		cmpi 12 00
		beq  #ORIENT_EINSTELL_CPI
		pushb [#n/60_wert]
		call #N/60
		bra  #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_CPI
		loab 12 [#save_cpi]
		cmpi 12 17              /* 17 CPI ? */
		beq #ORIENT_EINSTELL_COMPRESS
		cmpi 12 12              /* 12 CPI ? */
		beq #ORIENT_EINSTELL_ELITE
		cmpi 12 10              /* 10 CPI ? */
		beq #ORIENT_EINSTELL_PICA
		cmpi 12 01
		beq #ORIENT_EINSTELL_LPI
		pushb [#cpi_vk]
		pushb [#cpi_nk]
		pushb [#hmi_vk]
		pushb [#hmi_nk]
		call #CPI_ANDERE         /* andere CPI Werte   */
		bra #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_COMPRESS
		call #COMPRESSED_ON     /* 17 CPI einstellen */
		bra #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_PICA
		call #PICA_ON     /* 17 CPI einstellen */
		bra #ORIENT_EINSTELL_LPI

#ORIENT_EINSTELL_ELITE
		call #ELITE_ON          /* 12 CPI einstellen */

#ORIENT_EINSTELL_LPI
		loab 12 [#save_lpi]
		cmpi 12 08              /* 1/8'' Zeilenabstand ? */
		bne  #ORIENT_EINSTELL_N/72
		call #1/8_ON            /* 1/8'' Zeilenabstand einstellen */
		bra  #ORIENT_EINSTELL_FORM

#ORIENT_EINSTELL_N/72
		cmpi 12 02              /* N/72'' Zeilenabstand ? */
		bne #ORIENT_EINSTELL_N/216
		loab 12 [#n_72_wert]    /* N/72'' Zeilenabstand         */
		call #N/72              /* einstellen                   */
		call #1/6_ON            /* N/72'' Zeilenabstand starten */
		bra  #ORIENT_EINSTELL_FORM

#ORIENT_EINSTELL_N/216
		cmpi 12 16              /* N/216'' Zeilenabstand ? */
		bne #ORIENT_EINSTELL_1/6
		pushb [#n_216_wert]     /* N/216'' Zeilenabstand */
		call #N/216_ON          /* einstellen            */
		bra #ORIENT_EINSTELL_FORM

#ORIENT_EINSTELL_1/6
		call #1/6_ON            /* 1/6'' Zeilenabstand einstellen */

#ORIENT_EINSTELL_FORM
		pushb [#form_length]    /* Formularlnge einstellen */
		call #LINES_PER_PAGE

#ORIENT_EINSTELL_MARGINS
		pushb [#save_lrd]       /* Rnder     */
		pushb [#save_rrd]       /*            */
		call #SET_MARGINS       /* einstellen */

#ORIENT_ENDE    ret 00

/*----------------------------------------------------------------------*/
/*      function body DUPLEX                    PARA: 1 Byte            */
/*----------------------------------------------------------------------*/

#DUPLEX         loab 10 [#duplex]
		cmpi 10 00
		beq #DUPLEX_AUS
		cmpi 10 01
		beq #DUPLEX_EIN
		cmpi 10 02
		beq #DUPLEX_FRONT
		movi 11 01
		loab [#duplex_seite] 11
		prn 1b prn 26 prn 61 prn 32 prn 47 /* Rckseite */
		bra #DUPLEX_END

#DUPLEX_AUS     movi 11 00
		loab [#duplex_ein] 11
		prn 1b prn 26 prn 6C prn 30 prn 53 /* SIMPLEX ein */
		bra #DUPLEX_END

#DUPLEX_EIN     movi 11 01
		loab [#duplex_ein] 11
		prn 1b prn 26 prn 6C prn 31 prn 53 /* DUPLEX ein */
		bra #DUPLEX_END

#DUPLEX_FRONT   movi 11 00
		loab [#duplex_seite] 11
		prn 1b prn 26 prn 61 prn 31 prn 47 /* Vorderseite */

#DUPLEX_END     ret 00

/*----------------------------------------------------------------------*/
/*      function body EINSTELL_FORMAT          PARA: 0 Byte             */
/*----------------------------------------------------------------------*/
/*                                                                      */
/*    Hier werden alle Einstellungen, die durch die Angabe des Papier-  */
/*    formates auf die DEFAULT-Werte zurckgesetzt werden, wieder neu   */
/*    eingestellt.                                                      */
/*----------------------------------------------------------------------*/

#EINSTELL_FORMAT
		loab 12 [#n/60_ein]     /* N/60" Zeichenabstand ? */
		cmpi 12 00
		beq  #EINSTELL_FORMAT_CPI
		pushb [#n/60_wert]
		call #N/60
		bra  #EINSTELL_FORMAT_LPI

#EINSTELL_FORMAT_CPI
		loab 12 [#save_cpi]
		cmpi 12 17              /* 17 CPI ? */
		beq #EINSTELL_FORMAT_COMPRESS
		cmpi 12 12              /* 12 CPI ? */
		beq #EINSTELL_FORMAT_ELITE
		cmpi 12 10              /* 10 CPI ? */
		beq #EINSTELL_FORMAT_PICA
		cmpi 12 01
		beq #EINSTELL_FORMAT_LPI
		pushb [#cpi_vk]
		pushb [#cpi_nk]
		pushb [#hmi_vk]
		pushb [#hmi_nk]
		call #CPI_ANDERE         /* andere CPI Werte   */
		bra #EINSTELL_FORMAT_LPI

#EINSTELL_FORMAT_COMPRESS
		call #COMPRESSED_ON     /* Engschrift einstellen */
		bra #EINSTELL_FORMAT_LPI

#EINSTELL_FORMAT_PICA
		call #PICA_ON           /* Engschrift einstellen */
		bra #EINSTELL_FORMAT_LPI

#EINSTELL_FORMAT_ELITE
		call #ELITE_ON          /* 12 CPI einstellen */

#EINSTELL_FORMAT_LPI
		loab 12 [#save_lpi]
		cmpi 12 08              /* 1/8" Zeilenabstand ? */
		bne  #EINSTELL_FORMAT_N/72
		call #1/8_ON            /* 1/8" Zeilenabstand einstellen */
		bra  #EINSTELL_FORMAT_FORM

#EINSTELL_FORMAT_N/72
		cmpi 12 02              /* N/72" Zeilenabstand ? */
		bne #EINSTELL_FORMAT_N/216
		loab 12 [#n_72_wert]    /* N/72" Zeilenabstand */
		call #N/72              /* einstellen          */
		call #1/6_ON            /* N/72" Zeilenabstand starten */
		bra  #EINSTELL_FORMAT_FORM

#EINSTELL_FORMAT_N/216
		cmpi 12 16              /* N/216" Zeilenabstand ? */
		bne #EINSTELL_FORMAT_1/6
		pushb [#n_216_wert]     /* N/216" Zeilenabstand */
		call #N/216_ON          /* einstellen           */
		bra #EINSTELL_FORMAT_FORM

#EINSTELL_FORMAT_1/6
		call #1/6_ON            /* 1/6" Zeilenabstand einstellen */

#EINSTELL_FORMAT_FORM
		pushb [#form_length]    /* Formularlnge einstellen */
		call #LINES_PER_PAGE

#EINSTELL_FORMAT_MARGINS
		pushb [#save_lrd]       /* Rnder     */
		pushb [#save_rrd]       /*            */
		call #SET_MARGINS       /* einstellen */

#EINSTELL_FORMAT_ENDE
		ret 00


/*----------------------------------------------------------------------*/
/*   function print_str                      PARA: 1 WORD               */
/*                                                                      */
/*   Gibt einen PASCAL string an den Drucker aus.                       */
/*   Stringformat: #name 2-Byte-Lnge Daten                             */
/*----------------------------------------------------------------------*/

#print_str      loaw 12 [0C+2]          /* Para from stack */
		loaw 13 [12]            /* first WORD is length */
		addi 12 02              /* add length + strtadr */
		add  13 12              /* first printable byte */

#print_str_loop cmp  13 12              /* are we already at the end */
		beq  #print_str_end
		loab 00 [12]            /* print data */
		addi 12 01
		bra #print_str_loop

#print_str_end  ret 02

#convert        loa 18 0030
		loa 19 2710
#convert_loop   mov 13 12
		div 13 19
		add 13 18
		mov 00 13
		mod 12 19
		divi 19 0a
		cmpi 19 00
		bne #convert_loop
		ret 00

#cpi_convert    loa 18 0030
		loa 19 000A
#cpi_convert_loop
		mov 13 12
		div 13 19
		add 13 18
		mov 00 13
		mod 12 19
		divi 19 0a
		cmpi 19 00
		bne #cpi_convert_loop
		ret 00
END_FUNCTIONS
/************************************************************************/
/*      END OF FUNCTION BODIES                                          */
/************************************************************************/

/************************************************************************/
/*      INIT Segment, die ersten Eintrge mssen die INIT-Werte sein!!  */
/************************************************************************/


INIT
	#PAPER_TYPE      01             /* 0 = Endlos, 1 = Einzelblatt      */
	#FEED_SELECT     00             /* 0 = kein Einzug, (!=0) = Einzug  */
					/*     aus Schacht n                */
	#INITIAL_FEED    00             /* 0 = kein Einzug, 1 = Einzug, ffu */
	#FINAL_EJECT     00             /* 0 = kein Auswurf, 1 = Auswurf    */
	#QUALITY         02             /* 0 = draft, 1 = NLQ, 2 = LQ       */
	#PAPER_LENGTH    43             /* n = Anzahl Zeilen pro Seite      */
	#PAPER_WIDTH     4D             /* n = Breite in Zeichen bei 10 CPI */

					/* CHAR_SPACING und CHARS_PER_INCH  */
					/* schlieen sich gegenseitig aus ! */
	#CHAR_SPACING    00             /* n = n/60'' character spacing     */
	#CHARS_PER_INCH  0A             /* Pica, Elite, compressed          */


	#LINES_PER_INCH  06             /* linespacing 1/6'' or 1/8'' */
	#LEFT_MARGIN     01
	#RIGHT_MARGIN    4D
	#HEAD_LINES      01
	#BOTTOM_LINES    00
	#USR_INIT        00 00  00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
				00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
				00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
				00 00 00 00 00
	#PAGE_SIZE_1     04             /* Papierformat Schacht 1           */
	#PAGE_SIZE_2     04             /* Papierformat Schacht 2           */
	#PAGE_SIZE_3     04             /* Papierformat Schacht 3           */

END_INIT


DATA

#seq_tab                 08 00  00 00 00 00 00 00 00 00
#save_lpi                00                /* 06 = 1/6                      */
					   /* 08 = 1/8                      */
					   /* 02 = n/72                     */
					   /* 16 = n/216                    */
#save_cpi                01                /* 10 = 10 CPI                   */
					   /* 12 = 12 CPI                   */
					   /* 17 = compressed               */
					   /* ff = andere CPI-Werte         */
#orient                  00                /* 30/00 = Portrait              */
					   /* 31 = Landscape                */
#save_lrd                00                /* linker Rand                   */
#save_rrd                00                /* rechter Rand                  */
#save_rrd_255            00                /* rechter Rand > 255            */
#rrand>255               00                /* rechter Rand > 255            */
					   /* 00 = Nein                     */
					   /* 01 = Ja                       */
#form_length             00                /* Formularlnge                 */
#save_n72_var            00                /* Variable n von n/72 (bereits) */
					   /* umgerechnet in n/48           */
#n216_einmal             00                /* 01 = n/216 einmalig "ein"     */
#n_216_wert              00                /* wieviel N/216'' Zeilenabstand */
#n_72_wert               00                /* wieviel N/72'' Zeilenabstand  */
#n/60_ein                00                /* 00 = N/60 eingeschaltet       */
					   /* 01 = N/60 ausgeschaltet       */
#n/60_wert               00                /* wieviel N/60                  */
#duplex                  00                /* 00 = DUPLEX aus               */
					   /* 01 = DUPLEX ein               */
					   /* 02 = Vorderseite              */
					   /* 03 = Rckseite                */
#duplex_ein              00                /* 00 = NEIN                     */
					   /* 01 = JA                       */
#duplex_seite            00                /* 00 = Vorderseite              */
					   /* 01 = Rckseite                */
#cpi_vk                  00                /* CPI Vorkommastellen           */
#cpi_nk                  00                /* CPI Nachkommastellen          */
#hmi_vk                  00                /* HMI Vorkommastellen           */
#hmi_nk                  00                /* HMI Nachkommastellen          */
END_DATA


STACK

	00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00

END_STACK

