#!c:\perl\bin\perl
#  Usage: perl Bom_cleanp_main.pl
#  Miguel Yanez Jr
#  working for quoted ref des

################################################################################
# Purpose of Script
################################################################################
# The purpose of this script is to input a BOM file (with the Rose_template2.bom template)
# and create a new BOM file by replacing a components Quantity total
# with 0 (zero) when its Material type is classified as "Empty" 
################################################################################

#-------------------------------------------------------------------------------
# Coding Begins Here
#-------------------------------------------------------------------------------
################################################################################
# Command Line Input
################################################################################
if ( $#ARGV < 0){ die "FATAL: no BOM file speicifed, please enter: perl bom_empty_update.pl <filename>\n"} # command line looking for the following input: "perl bom_empty_update.pl <filename>

$filename=shift(@ARGV);    # saving file name entered at command line

################################################################################
# Open input BOM file $filename entered at command line\ Screen display prompt.
################################################################################
open (BOMF, "$filename") or die "\n Can't open file \"$filename\"\n";    #opening BOM file
printf ( " -------------------------------------------------------\n");  #Screen display
printf ( " Opening File \"$filename\"\n");                               #Screen display
printf ( " -------------------------------------------------------\n");  #Screen display


################################################################################
# Open Output files  BOM_Update.txt and BOM_logfile.txt.
################################################################################
open(new_BOM, "> BOM_Update.txt");                                # creating an output file
open(logfile, "> BOM_logfile.txt");                           


while (<BOMF>) {
        chomp;          					  # chomp used to remove carrage return


################################################################################
# Matching Definition
################################################################################
# (m/(ARGUMENT_1)(ARGUMENT_2)...(ARGUMENT_N)/i) -> matching syntax in perl
# (.*)------------------> . = any characer and * = 0 or more occurances
# (.*) matches any character occuring 0 or more times. 
# (\,)------------------> \ = special character indicator and , = comma character
# (\,) matches a comma
# (\d+)-----------------> \d = any digit and + = 1 or more 
# (\d+) matches any digit occuring 1 or more times
# (EMPTY) matches the word "EMPTY"
# i used to match non case sensitive
#################################################################################
# in the if statement below:
#################################################################################
# (ARGUMENT_1) = (.*) = all text just before comma of components Quantity total = perl stores (ARGUMENT_1) as $1 (default)
# (ARGUMENT_2) = (\,) = commma just before components Quantity total = perl stores (ARGUMENT_2) as $2 (default)
# (ARGUMENT_3) = (\d+) = components Quantity total = perl stores (ARGUMENT_3) as $3 (default)
# (ARGUMENT_4) = (\,) = commma just after components Quantity total = perl stores (ARGUMENT_4) as $4 (default)
# (ARGUMENT_5) = (.*) = all text just after comma of components Quantity total and before EMPTY = perl stores (ARGUMENT_5) as $5 (default)
# (ARGUMENT_6) = (EMPTY) = the text "EMPTY" = perl stores (ARGUMENT_6) as $6 (default)
# (ARGUMENT_7) = (.*) = all text just after "EMPTY" = perl stores (ARGUMENT_7) as $7 (default)
#################################################################################

	       if(m/(.*)(\,)(\d+)(\,)(.*)(EMPTY)(.*)/i)          # Searches for lines with "EMPTY"
 
	          {	                                         #open if bracket
		     $quantity = 0;                              #set quanity string to 0 (zero)
		     $EMPTY_count++;                             #counter used for "EMPTY" occurances
		     $line_count++;				 #counter used to track lines read
		     printf (new_BOM "$1$2$quantity$4$5$6$7\n"); #prints out matched text
		     printf (logfile "found EMPTY part on line $line_count\n"); #prints out matched text  
 			
                  }                                              #closing if bracket

               else

		  {
		     $NON_EMPTY_count++;			 #counter used for NON "EMPTY" occurances
		     $line_count++;				 #counter used to track lines read
		     printf (new_BOM "$_\n");			 #print entire line read
		  }


               } 						 # closing bracket for while (<BOMF>)
close BOMF;
close new_BOM;
close logfile;

printf ( " ******************************************************\n");
printf ( " -------------------------------------------------------\n");
printf ( " Found $EMPTY_count empty parts\n");            
#printf ( $EMPTY_count + $NON_EMPTY_count\n);
printf ( " Read $line_count total lines\n");
printf ( " -------------------------------------------------------\n");
printf ( " *******************************************************\n");
printf ( " -------------------------------------------------------\n");
printf ( " Refer to \"BOM_logfile.txt\" for \"EMPTY\" line numbers\n");
printf ( " -------------------------------------------------------\n");
#-------------------------------------------------------------------------------
# Coding Ends Here
#-------------------------------------------------------------------------------
__END__
