/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: afeif_memmap.h
;
;  Header file for AFE IF behavioral model.
;
*****************************************************************************/
#ifndef _AFEIF_MEMMAP_H
#define _AFEIF_MEMMAP_H

#define WORD_OR_BYTE                    4
// Register offsets
#define AI_CONFIG_OFFSET            (0x0)
#define AI_SERIAL_SEQUENCE_0_OFFSET    (0x1)
#define AI_SERIAL_SEQUENCE_1_OFFSET    (0x2)
#define AI_SERIAL_TRIGGER_OFFSET    (0x3)
#define AI_SERIAL_DATA_OFFSET       (0x4)
#define AI_MEM_CONFIG_OFFSET        (0x5)
#define AI_TXROUTE_0_OFFSET            (0x6)
#define AI_TXROUTE_1_OFFSET            (0x7)
#define AI_ECROUTE_0_OFFSET            (0x8)
#define AI_ECROUTE_1_OFFSET            (0x9)
#define AI_RXROUTE_0_OFFSET            (0xA)
#define AI_RXROUTE_1_OFFSET            (0xB)

// Define pseudo-registers (for Cocomo use only)
#define AI_CHANNEL_OFFSET           (0x10)
#define AI_CONN_CTRL_OFFSET            (0x11)
#define AI_FDCONN_TX_TRIGGER_OFFSET    (0x12)
#define AI_FDCONN_RX_TRIGGER_OFFSET    (0x13)
#define AI_AFE_TX_GAIN_OFFSET       (0x14)
#define AI_PGA_OFFSET               (0x15)

#define AI_REG_SIZE                 (AI_PGA_OFFSET+1)

// Memory sizes
#define AI_DATA_MEM_SIZE            (128)
#define AI_SERIAL_MEM_SIZE          (32)

#define AI_MEM_SIZE  (AI_DATA_MEM_SIZE + AI_SERIAL_MEM_SIZE)

#define AI_CONFIG_MASK     (0x000FFFFF)
#define AI_SERIAL_SEQUENCE_0_MASK   (0xFFFFFFFF)
#define AI_SERIAL_SEQUENCE_1_MASK   (0xFFFFFFFF)
#define AI_SERIAL_TRIGGER_MASK   (0x0)
#define AI_SERIAL_DATA_MASK   (0x0)
#define AI_MEM_CONFIG_MASK (0x01FFFFFF)
#define AI_TXROUTE_0_MASK  (0xFFFFFFFF)
#define AI_TXROUTE_1_MASK  (0xFFFFFFFF)
#define AI_ECROUTE_0_MASK  (0xFFFFFFFF)
#define AI_ECROUTE_1_MASK  (0xFFFFFFFF)
#define AI_RXROUTE_0_MASK  (0xFFFFFFFF)
#define AI_RXROUTE_1_MASK  (0xFFFFFFFF)

// Memory masks
#define AI_DATA_MEM_EVEN_MASK (0x000003FF)   // AFE interface data memory at even address.
#define AI_DATA_MEM_ODD_MASK  (0xFFFFFFFF)   // AFE interface data memory at odd address.
#define AI_SERIAL_MEM_ODD_MASK   (0xFFFFFFFF)   // AFE interface serial memory.

/**********************************************************************
 * Memory map for AFEIF
 **********************************************************************/

#define     AI_REG_BASE_ADDR     (0x9900)    // 0x9900 - (0x9900 + 0x16*4)=0x9958
#define     AI_MEM_BASE_ADDR     (0x9970)    // 0x9970 - (0x9970 + (128+32)*4)=0x9BF0

// Register addresses
#define AI_CONFIG_ADDR     (AI_REG_BASE_ADDR + AI_CONFIG_OFFSET*WORD_OR_BYTE)
#define AI_SERIAL_SEQUENCE_0_ADDR      (AI_REG_BASE_ADDR + AI_SERIAL_SEQUENCE_0_OFFSET*WORD_OR_BYTE)
#define AI_SERIAL_SEQUENCE_1_ADDR      (AI_REG_BASE_ADDR + AI_SERIAL_SEQUENCE_1_OFFSET*WORD_OR_BYTE)
#define AI_SERIAL_TRIGGER_ADDR   (AI_REG_BASE_ADDR + AI_SERIAL_TRIGGER_OFFSET*WORD_OR_BYTE)
#define AI_SERIAL_DATA_ADDR   (AI_REG_BASE_ADDR + AI_SERIAL_DATA_OFFSET*WORD_OR_BYTE)
#define AI_MEM_CONFIG_ADDR (AI_REG_BASE_ADDR + AI_MEM_CONFIG_OFFSET*WORD_OR_BYTE)
#define AI_TXROUTE_0_ADDR  (AI_REG_BASE_ADDR + AI_TXROUTE_0_OFFSET*WORD_OR_BYTE)
#define AI_TXROUTE_1_ADDR  (AI_REG_BASE_ADDR + AI_TXROUTE_1_OFFSET*WORD_OR_BYTE)
#define AI_ECROUTE_0_ADDR  (AI_REG_BASE_ADDR + AI_ECROUTE_0_OFFSET*WORD_OR_BYTE)
#define AI_ECROUTE_1_ADDR  (AI_REG_BASE_ADDR + AI_ECROUTE_1_OFFSET*WORD_OR_BYTE)
#define AI_RXROUTE_0_ADDR  (AI_REG_BASE_ADDR + AI_RXROUTE_0_OFFSET*WORD_OR_BYTE)
#define AI_RXROUTE_1_ADDR  (AI_REG_BASE_ADDR + AI_RXROUTE_1_OFFSET*WORD_OR_BYTE)
#define AI_RXROUTE_1_ADDR  (AI_REG_BASE_ADDR + AI_RXROUTE_1_OFFSET*WORD_OR_BYTE)

// Pseudo-register addresses (for Cocomo use only)
#define AI_CHANNEL_ADDR    (AI_REG_BASE_ADDR + AI_CHANNEL_OFFSET*WORD_OR_BYTE)
#define AI_CONN_CTRL_ADDR  (AI_REG_BASE_ADDR + AI_CONN_CTRL_OFFSET*WORD_OR_BYTE)
#define AI_FDCONN_TX_TRIGGER_ADDR   (AI_REG_BASE_ADDR + AI_FDCONN_TX_TRIGGER_OFFSET*WORD_OR_BYTE)
#define AI_FDCONN_RX_TRIGGER_ADDR   (AI_REG_BASE_ADDR + AI_FDCONN_RX_TRIGGER_OFFSET*WORD_OR_BYTE)
#define AI_AFE_TX_GAIN_ADDR      (AI_REG_BASE_ADDR + AI_AFE_TX_GAIN_OFFSET*WORD_OR_BYTE)
#define AI_PGA_ADDR        (AI_REG_BASE_ADDR + AI_PGA_OFFSET*WORD_OR_BYTE)

#define AI_MAX_REG_ADDR    AI_PGA_ADDR

////////////////////////////////////////////////////////////////////////////////

// Bit field definitions for AI_CONN_CTRL_ADDR

#define AI_INIT_CONN_REQUEST_SHIFT  0     // writing a 1 to Bit 0 of AI_CONN_CTRL_ADDR register
                              // initiates a call to InitDliConnectivity
#define AI_EXIT_CONN_REQUEST_SHIFT  1     // writing a 1 to Bit 1 of AI_CONN_CTRL_ADDR register
                              // initiates a call to ExitConnectivity
#define AI_FDCONN_TX_REQUEST_SHIFT  2     // writing a 1 to Bit 2 of AI_CONN_CTRL_ADDR register
                              // initiates a transfer of data from the IFFT input to
                              // the Dli2 (used for freq domain connectivity).
#define AI_FDCONN_RX_REQUEST_SHIFT  3     // writing a 1 to Bit 2 of AI_CONN_CTRL_ADDR register
                              // initiates a transfer of data from the Dli2 to
                              // the FFT output (used for freq domain connectivity).
#define AI_CONN_MODE_SHIFT       4  // 0=CO_MODEM, 1=CPE_MODEM

#define AI_EXIT_REQUEST 7           // Bit 7 of AI_CONN_CTRL_ADDR register is set by
                              // based on a Dli2 exits request

#define AI_CONN_TYPE_SHIFT 8        // Bits 15:8 of AI_CONN_CTRL_ADDR register

#define AI_CONN_DLI_BLOCKSIZE_SHIFT 16 // Bits 31:16 of AI_CONN_CTRL_ADDR register


// Bit field definitions for AI_FDCONN_TX_TRIGGER_ADDR

#define AI_FDCONN_TX_IFFTSIZE_SHIFT 0     // bits 15:0 define
#define AI_FDCONN_TX_VARGAIN_SHIFT  16    // bits 31:15

// Bit field definitions for AI_FDCONN_RX_TRIGGER_ADDR

#define AI_FDCONN_RX_FFTSIZE_SHIFT  0     // bits 15:0
#define AI_FDCONN_RX_VARGAIN_SHIFT  16    // bits 31:15


////////////////////////////////////////////////////////////////////////////////

// Memory addresses
#define AI_DATA_MEM_ADDR   (AI_MEM_BASE_ADDR)
#define AI_SERIAL_MEM_ADDR (AI_DATA_MEM_ADDR + AI_DATA_MEM_SIZE*WORD_OR_BYTE)
#define AI_MAX_MEM_ADDR    (AI_MEM_BASE_ADDR + AI_MEM_SIZE*WORD_OR_BYTE)

#endif //_AFEIF_MEMMAP_H
