/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: afeif_private.h
;
*****************************************************************************/
#ifndef _AFEIF_PRIVATE_H
#define _AFEIF_PRIVATE_H

#include "afeif_typedef.h"
#include "afeif_memmap.h"
#include "afeif_const.h"

// Prototypes
void Afeif_ResyncRegister(uint32 ul_offset, uint32 ul_word);

// Strymon core memory
extern int32 gla_AfeifMemory[AI_MEM_SIZE];
extern int32 gla_AfeifRegister[AI_REG_SIZE];

// AFEIF register structure
extern AfeifReg_t gt_AfeifReg;

// Exception (see afeif_const.h for exception definitions)
extern int16 gs_AfeifException;

// Flag for enabling connectivity
extern FlagT gft_ConnEnable;

// AFE IF loopback write/read pointers
extern int32 gl_AfeifTxLpbkWritePtr;
extern int32 gl_AfeifAecLpbkWritePtr;
extern int32 gl_AfeifLpbkReadPtr;

// Loopback latency models
extern int16 gs_TxRxLpbkDelay;
extern int16 gs_TxRxLpbkBuf[MAX_AFEIF_LATENCY];
extern int16 gs_AecRxLpbkDelay;
extern int16 gs_AecRxLpbkBuf[MAX_AFEIF_LATENCY];

#ifndef UNIX_PLATFORM
// AFE IF Echo model
extern EchoStruc_t gt_Echo;
extern int16 gsa_EchoFirCoef[ECHO_LEN];
extern int16 gsa_EchoFirStates[ECHO_LEN];
#endif // #ifndef UNIX_PLATFORM

#endif // #ifndef _AFEIF_PRIVATE_H
