/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;   Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;   Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;   File Name: afeif_typedef.h
;
;   Data types of the AFEIF behavioral model.
;
*****************************************************************************/

#ifndef _AFEIF_TYPEDEF_H
#define _AFEIF_TYPEDEF_H

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
//Variable type definitions
typedef char           int8;     // prefix c
typedef short          int16;    // prefix s
typedef int            int32;    // prefix l

typedef unsigned char  uint8;    // prefix uc
typedef unsigned short uint16;      // prefix us
typedef unsigned int   uint32;      // prefix ul

typedef unsigned char  FlagT;    // prefix ft
typedef char           string[80+1]; // prefix ca

typedef unsigned int Float32;
typedef double float64;          // prefix d
#endif // _BASIC_TYPES

#ifndef acc
// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc long long
#else
#ifdef MSVC_ONLY
#define acc __int64
#else
#define acc long
#endif
#endif
#endif //#ifndef acc

#ifndef FALSE
#define FALSE           0
#endif
#ifndef TRUE
#define TRUE            1
#endif

// structure used for registers
typedef struct {
   // AI_CONFIG
   int16 s_TX_RESAMPLING;
   int16 s_RX_RESAMPLING;
   int16 s_CODE_LENGTH;
   int16 s_TX_FMT;
   int16 s_RX_FMT;
   int16 s_TRIGGER_SEL;
   int16 s_SCLK_DIV;
   int16 s_RX_TX_LPBK;
   int16 s_TX_RX_LPBK;
   int16 s_EC_ENABLE;
   int16 s_AI_RSTN;

   // AI_SERIAL_SEQUENCE_0
   int32 l_SERIAL_SEQUENCE_0;

   // AI_SERIAL_SEQUENCE_1
   int16 s_SERIAL_SEQUENCE_1;

   // AI_SERIAL_TRIGGER
   int16 s_PROGRAM_SELECT;
   int16 s_TRIGGER_SERIAL_TRANSACTION;

   // AI_SERIAL_DATA
   int16 s_SERIAL_RDATA;

   // AI_MEM_CONFIG
   int16 s_SERIAL_DELAY;
   int16 s_SERIAL_PROGRAM_LEN_1;
   int16 s_SERIAL_PROGRAM_LEN_0;

   // AI_TXROUTE_0
   int16 s_TxRoute7;
   int16 s_TxRoute6;
   int16 s_TxRoute5;
   int16 s_TxRoute4;
   int16 s_TxRoute3;
   int16 s_TxRoute2;
   int16 s_TxRoute1;
   int16 s_TxRoute0;

   // AI_TXROUTE_1
   int16 s_TxRoute15;
   int16 s_TxRoute14;
   int16 s_TxRoute13;
   int16 s_TxRoute12;
   int16 s_TxRoute11;
   int16 s_TxRoute10;
   int16 s_TxRoute9;
   int16 s_TxRoute8;

   // AI_ECROUTE_0
   int16 s_EcRoute7;
   int16 s_EcRoute6;
   int16 s_EcRoute5;
   int16 s_EcRoute4;
   int16 s_EcRoute3;
   int16 s_EcRoute2;
   int16 s_EcRoute1;
   int16 s_EcRoute0;

   // AI_TXROUTE_1
   int16 s_EcRoute15;
   int16 s_EcRoute14;
   int16 s_EcRoute13;
   int16 s_EcRoute12;
   int16 s_EcRoute11;
   int16 s_EcRoute10;
   int16 s_EcRoute9;
   int16 s_EcRoute8;

   // AI_RXROUTE_0
   int16 s_RxRoute7;
   int16 s_RxRoute6;
   int16 s_RxRoute5;
   int16 s_RxRoute4;
   int16 s_RxRoute3;
   int16 s_RxRoute2;
   int16 s_RxRoute1;
   int16 s_RxRoute0;

   // AI_RXROUTE_1
   int16 s_RxRoute15;
   int16 s_RxRoute14;
   int16 s_RxRoute13;
   int16 s_RxRoute12;
   int16 s_RxRoute11;
   int16 s_RxRoute10;
   int16 s_RxRoute9;
   int16 s_RxRoute8;

   // AI_CHANNEL
   FlagT ft_ChannelFilter;    // bit 0: TRUE/FALSE = Enable/Disable channel filter
   FlagT ft_ChannelNoise;     // bit 1: TRUE/FALSE = Enable/Disable channel noise
   FlagT ft_EchoEnabled;      // bit 2: TRUE/FALSE = Enable/Disable echo
   FlagT ft_PGAEnabled;    // bit 3: TRUE/FALSE = Enable/Disable PGA

   // AI_AFE_TX_GAIN
   int16 s_AfeTxGain;            // AFE Tx Power Control Gain in dB, 8.8 format
   float f_AfeTxGain;            // floating point decimal equivalent of s_PocoGain;

   // AI_PGA
   int16 s_PGAGain;            // PGA gain in dB, 8.8 format
   float f_PGAGain;            // floating point decimal equivalent of s_PGAGain;

   // AI_CONN_CTRL
   FlagT ft_InitConn;         // bit 0:   TRUE = Initialize DLI connectivity
   FlagT ft_ExitConn;         // bit 1:   TRUE = Exit DLI connectivity
   FlagT ft_FdConnTxReq;      // bit 2:   TRUE = transfer data from IFFT input to Dli2
   FlagT ft_FdConnRxReq;      // bit 3:   TRUE = transfer data from Dli2 to FFT output
   FlagT ft_Mode;          // bit 4:   0 = CPE_MODEM, 1 = CO_MODEM
   FlagT ft_ExitRequest;      // bit 7:   TRUE = exit requested by other modem, FALSE = normal operation
   uint8 uc_ConnType;         // bit 15:8 connectivity type
                        //          0: Strymon Time Domain (standard default)
                        //          1: FFT Frequency Domain
                        //          2: FFT Time Domain
   int16 s_DLI_BlockSize;     // bit 31:16   DLI Block Size

   // AI_FDCONN_TX_TRIGGER    // triggers data transfer from IFFT input to Dli
   int16 s_TxIFFTSize;        // bit 15:0    Tx IFFT Size
   int16 s_TxVarGain;         // bit 31:16   TxVarGain

   // AI_FDCONN_RX_TRIGGER    // triggers data transfer from Dli to FFT output
   int16 s_RxFFTSize;         // bit 15:0    Rx FFT Size
   int16 s_RxVarGain;         // bit 31:16   RxVarGain

} AfeifReg_t;

// structure used for echo model
typedef struct {
   int16 s_input;          // input sample
   acc   acc_output;       // acc output sample
   int16 s_output;            // output sample
   int16 *psa_state;       // pointer to state buffer
   int16 s_state_write_ptr;   // write pointer to state buffer
   int16 *psa_h;           // pointer to impulse response buffer
   int16 s_h_length;       // impulse response length
   int16 s_h_exp;          // impulse response exponent
   int16 s_AccWidth;       // accumulator width in bits

} EchoStruc_t;

#endif // _AFEIF_TYPEDEF_H
