/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: alp_const.h
;
;  Fixed parameters of the Alphaeus behavioral model.
;
*****************************************************************************/

#ifndef _ALP_CONST_H
#define _ALP_CONST_H

//==============================================================================
// Alphaeus (ATM) constants - may be HW specific
//==============================================================================
//#define ATM_NUM_BC          (2)
#define ALP_BC0               (0)
#define ALP_BC1               (1)
#define DISABLED_ABC       (0xF)

// Alphaeus interface mode setting (AT_CONFIG/AR_CONFIG)
#define UTOPIA_TX_OFF         (0x0)
#define UTOPIA_TX_ON       (0x1)
#define UTOPIA_RX_OFF         (0x0)
#define UTOPIA_RX_ON       (0x1)
#define UTOPIA_8_BIT_BUS      (0x0)
#define UTOPIA_16_BIT_BUS     (0x1)

// Alphaeus interface mode setting (AT_CONFIG/AR_CONFIG)
#define UTOPIA_MODE           (0x0)
#define UTOPIA_BYPASS_MODE    (0x1)
#define DSP_INTERCEPT_MODE    (0x2)

// # cell page, cell page start address (AT_CB_CFG_BCx/AR_CB_CFG_BCx)
#define CB_START_ADDR_BC0     (0x0000)
#define CB_NUM_PAGE_BC0       (0x2F)
#define CB_START_ADDR_BC1     (0x0292)
#define CB_NUM_PAGE_BC1       (0x2E)

// byte-flip, scramble enable option (AT_PCNTL_BCx/AR_PCNTL_BCx)
#define ALP_BYTE_FLIP_DISABLE (1) // 1 = disable

// idle cell payload (AT_IDLE_BCx/AR_IDLE_BCx)
#define  TX_IDLE_CELL_PAYLOAD    (0x6A)
#define  RX_IDLE_CELL_PAYLOAD    (0x6A)

// byte pattern insertion in IMA mode (AR_IMAHEC)
#define IMA_GOOD_HEC       (0x00)
#define IMA_BAD_HEC           (0x80)

// cell delinataion parameter (AR_DELIN_BCx)
//#define CELL_DELIN_DELTA    (1) // # HEC errors needed to jump out of sync state
//#define CELL_DELIN_ALPHA    (3) // # good HEC needed to enter sync state

// starting from ALP_T_CELL_CNT_BC0_ADDR to ALP_T_IDLE_CNT_BC0_ADDR, or
// starting from ALP_T_CELL_CNT_BC1_ADDR to ALP_T_IDLE_CNT_BC1_ADDR
#define NUM_READ_TX_ATM_REGS  (2)
#define TX_CELL_CNT           (0)
#define TX_IDLE_CNT           (1)

// starting from ALP_R_ATM_STAT_BC0_ADDR to ALP_R_CD_CNT_BC0_ADDR, or
// starting from ALP_R_ATM_STAT_BC1_ADDR to ALP_R_CD_CNT_BC1_ADDR
//#define NUM_READ_RX_ATM_REGS   (7)
//#define RX_ATM_STAT            (0)
//#define RX_CELL_CNT            (1)
//#define RX_IDLE_CNT            (2)
//#define RX_AIDLE_CNT        (3)
//#define RX_BE_CNT           (4)
//#define RX_HEC_CNT          (5)
//#define RX_CD_CNT           (6)

//#define ATM_NULL            (0)
//#define NCD                 (1)
//#define SYNC             (2)
//#define OCD                 (3)
//#define LCD                 (4)

/* Core version number */
#define A_MAJOR_REVISION   (5)
#define A_MINOR_REVISION   (0)

/* Core clock speed */
#define A_CLOCK_CYCLES_PER_DMT_FRAME   (11605)  // (47.104 MHz)*(1/4 msec)*(68/69)

/* Size of ATM cells */
#define ATM_CELL_HEADER_SIZE  (5)
#define ATM_CELL_PAYLOAD_SIZE (48)
#define ATM_CELL_SIZE           (ATM_CELL_HEADER_SIZE+ATM_CELL_PAYLOAD_SIZE) // 53 bytes in a ATM cell.

/* Idle cell header bytes */
#define IDLE_CELL_HEADER1  (0)
#define IDLE_CELL_HEADER2  (0)
#define IDLE_CELL_HEADER3  (0)
#define IDLE_CELL_HEADER4  (1)
#define IDLE_CELL_HEC      (0x52)

#define TX_NUM_BYTE_IN_NEXT_TRANSFER (2)

/* Size of cell buffers */
#define NUM_TX_CBPAGE               (93) // Total num. of Tx ATM cell buffer pages for a port
#define NUM_RX_CBPAGE               (93) // Total num. of Rx ATM cell buffer pages for a port.
#define NUM_LONGWORDS_PER_ATM_CELLPAGE (14) // Num. 32-bits words per ATM cell page.
#define NUM_LONGWORDS_PER_PSTM_CELLPAGE   (16) // Num. 32-bits words per ATM cell page.

// Each 56-bytes ATM cell page has 3 unused bytes:
#define ATM_CELLPAGE_SIZE       (4*NUM_LONGWORDS_PER_ATM_CELLPAGE)
// Size of Pseudo STM cells is 64 bytes:
#define PSTM_CELLPAGE_SIZE      (4*NUM_LONGWORDS_PER_PSTM_CELLPAGE)

#define ALP_TX_CELLBUFFER_SIZE      (NUM_TX_CBPAGE*ATM_CELLPAGE_SIZE) // size of Tx CB in bytes
#define ALP_RX_CELLBUFFER_SIZE      (NUM_RX_CBPAGE*ATM_CELLPAGE_SIZE) // size of Rx CB in bytes

#define ALP_DCP_TX_CELLBUFFER_SIZE  (32)     // 32 longwords.
#define ALP_DCP_RX_CELLBUFFER_SIZE  (32)     // 32 longwords.

#define RXCB_DW_SIZE          (256) // The size of the Rx cell buffer is a little bit bigger than required
                                 // for 18 cell pages.

#define TXPG_MASK       ((1<<NUM_TX_CBPAGE)-1)
#define RXPG_MASK       ((1<<NUM_RX_CBPAGE)-1)

#define DELAY_CB_WRITE       (10)   // Num. of clock cycles to delay start
                                    // of next write to CB.
#define DELAY_CB_READ        (10)   // Num. of clock cycles to delay start
                                    // of next read from CB.

/* Size of frame buffers */
#define TXFB_SIZE (256) // Size (bytes) of Tx frame buffer
#define RXFB_SIZE (512) // Size (bytes) of Rx frame buffer

/* A_ST_CTL register delay */
#define TXSEND_DELAY          (1)
#define RXCLEAR_DELAY            (1)

/* Pipeline delay */
#define TX_TPMODE_PIPELINE_DELAY    (4)
#define TX_ATM_PIPELINE_DELAY       (4)
#define TX_MAX_PIPELINE_DELAY       (4)

#define RX_TPMODE_PIPELINE_DELAY    (3)
#define RX_ATM_PIPELINE_DELAY       (3)
#define RX_MAX_PIPELINE_DELAY       (3)

#define NUM_STUFF_AND_ROB_BITS      (2)

#define MAX_NUM_BC                  (2) // Max number of bearer channels.
#define BC0                         (0) // Bearer channel 0
#define BC1                         (1) // Bearer channel 1

#define TX_PATH                  (0)
#define RX_PATH                  (1)
#define ALP_START_PG_ATTRIB          (0)
#define ALP_END_PG_ATTRIB            (1)
#define ALP_RD_PG_ATTRIB             (2)
#define ALP_WR_PG_ATTRIB             (3)
#define ALP_INTERCEPT_PG_ATTRIB      (4)
#define ALP_INTERCEPT_DEPTH_ATTRIB   (5)
#define ALP_DEPTH_ATTRIB             (6)
#define ALP_FULL_ATTRIB              (7)
#define ALP_EMPTY_ATTRIB             (8)

#ifdef LITTLE_ENDIAN
#undef LITTLE_ENDIAN
#endif
#define LITTLE_ENDIAN            (1)

#endif //_ALP_CONST_H
