/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: cell.h
;
;  Provides an abstraction of cell buffer memory and its management
;  by the Tx and Rx ATM processes.
;
*****************************************************************************/

#ifndef _CELL_H
#define _CELL_H

#include "alp_typedef.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Cell types */
#define HECERR_CELL     (0)
#define PAYLOAD_CELL (1)
#define IDLE_CELL    (2)

extern uint16 uc_RxCellBufferFull;
extern uint8  uca_PrevTxCellIsIdle[];
extern uint8  uca_CurTxCellIsIdle[];
extern uint8  uca_NextTxCellIsIdle[];
extern BearerCh_t TxBCAttrib[], RxBCAttrib[];

/////////////////////////////////////////////////////////////////////////////
//             Function Prototypes
/////////////////////////////////////////////////////////////////////////////

// functions for TX
//
void FlagFirstTxCell(void);
Cell_t*  GetIdleCell();
Cell_t*  GetTxCell();
void     ReturnTxCell();
void  IncrTxCellCounter(void);

// functions for RX
//
Cell_t*  GetRxCell();
void     ReturnRxCell(uint8 uc_celltype);
void  SetRxCellPageHalfWordFlag(void);
void  ResetRxCellPageHalfWordFlag(void);
void  SetRxCellPageHalfWordIndex(uint16 us_ByteIdx);
uint8*   GetRxCellPageHalfWordByte(void);

// functions for register
void ReadFromTxRegIdleCell(void);
void WriteToTxRegIdleCell(void);

void ReadFromRxRegCell(void);
void WriteToRxRegCell(void);

#ifdef __cplusplus
}
#endif

#endif //_CELL_H
