/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_ram.h
*
*   Header file for Iridia-FT RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_RAM_H
#define _FT_RAM_H

#include "ft_memmap.h"

// Iridia-FT RAM block IDs
#define  IRI_FT_MIN_RAM_ID             (0)

#define  IRI_FT_RAM_TX_PAR_PVEC_ID        (IRI_FT_MIN_RAM_ID)

#define  IRI_FT_MAX_RAM_ID             (IRI_FT_RAM_TX_PAR_PVEC_ID)

// Iridia-FT Register IDs
#define  IRI_FT_MIN_REG_ID             (IRI_FT_MAX_RAM_ID + 1)


// Tx Registers
#define  IRI_FT_REG_RX_CTRL_ID            (IRI_FT_MIN_REG_ID + 0)
#define  IRI_FT_REG_RX_CTRL_A_ID          (IRI_FT_MIN_REG_ID + 1)
#define  IRI_FT_REG_TX_CTRL_ID            (IRI_FT_MIN_REG_ID + 2)
#define  IRI_FT_REG_TX_CTRL_A_ID          (IRI_FT_MIN_REG_ID + 3)
#define  IRI_FT_REG_STATUS_ID          (IRI_FT_MIN_REG_ID + 4)
#define  IRI_FT_REG_RX_SCALE_ID           (IRI_FT_MIN_REG_ID + 5)
#define  IRI_FT_REG_TX_SCALE_ID           (IRI_FT_MIN_REG_ID + 6)
#define  IRI_FT_REG_TX_PARR_PARAM_ID         (IRI_FT_MIN_REG_ID + 7)
#define  IRI_FT_REG_TX_PARR_MAX0_ID       (IRI_FT_MIN_REG_ID + 8)
#define  IRI_FT_REG_TX_PARR_MAX1_ID       (IRI_FT_MIN_REG_ID + 9)
#define  IRI_FT_REG_TX_PARR_MAX2_ID       (IRI_FT_MIN_REG_ID + 10)

#define  IRI_FT_MAX_REG_ID             (IRI_FT_REG_TX_PARR_MAX2_ID)

// Global Arrays
extern uint32 *IRI_FT_RAM_VirtualBaseAddr[IRI_FT_MAX_RAM_ID+1];
extern uint32 IRI_FT_RAM_PhysBaseAddr[IRI_FT_MAX_REG_ID+1];
extern uint32 IRI_FT_RAM_Size[IRI_FT_MAX_RAM_ID+1];
extern uint32 IRI_FT_RAM_Offset[IRI_FT_MAX_RAM_ID+1];
extern uint32 IRI_FT_RAM_Mask[IRI_FT_MAX_RAM_ID+1];

extern uint32 IRI_FT_RAM_Tx_PAR_PVEC_Unaligned [4][IRI_FT_RAM_TX_PAR_PVEC_SIZE+1];
extern uint32 *IRI_FT_RAM_Tx_PAR_PVEC;

#endif //_FT_RAM_H
