/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ft_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FT_TYPEDEF_H
#define _FT_TYPEDEF_H


#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc_ft long long
#else
#ifdef MSVC_ONLY
#define acc_ft __int64
#else
#define acc_ft long
#endif
#endif

// Structure used for Iridia-FT registers
typedef struct {



   // IRI_FT_REG_RX_CTRL
   int32 l_RxFftPostProcessEnable;
   int32 l_RxFftEnable;

   // IRI_FT_REG_RX_CTRL_A
   int32 l_RxFftSize_A;
   int32 l_RxFftPostProcessEnable_A;
   int32 l_RxFftEnable_A;

   // IRI_FT_REG_TX_CTRL
   int32 l_TxIfftSize;
   int32 l_TxParrEnable;
   int32 l_TxIfftPreProcessEnable;
   int32 l_TxIfftEnable;

   // IRI_FT_REG_TX_CTRL_A
   int32 l_TxIfftSize_A;
   int32 l_TxParrEnable_A;
   int32 l_TxIfftPreProcessEnable_A;
   int32 l_TxIfftEnable_A;

   // IRI_FT_REG_STATUS
   int32 l_TxParrOverflow;
   int32 l_TxParrOn;
   int32 l_TxIfftOverflow;
   int32 l_TxIfftOn;
   int32 l_RxFftOverflow;
   int32 l_RxFftOn;

   // IRI_FT_REG_RX_SCALE
   int32 la_RxFftScale[6+1];        //  0-5:FFT stages, 6:Postprocessing

   // IRI_FT_REG_TX_SCALE
   int32 la_TxIfftScale[6+1];       //  0:Preprocessing, 1-6:IFFT stages

   // IRI_FT_REG_TX_PARR_PARAM
   int32 l_TxParrScalarA;
   int32 l_TxSort0Early;
   int32 l_TxParrScale;
   int32 l_TxParrNIT;
   int32 l_TxParrNGR;

   // IRI_FT_REG_TX_PARR_MAX0
   int32 l_TxParrPeak1;
   int32 l_TxParrPeak0;

   // IRI_FT_REG_TX_PARR_MAX1
   int32 l_TxParrPeak3;
   int32 l_TxParrPeak2;

   // IRI_FT_REG_TX_PARR_MAX2
   int32 l_TxParrPeak4;


} IridiaFT_Register_t;
extern IridiaFT_Register_t gt_IridiaFTRegister[4];


// Structure used for Iridia-FT latencies
typedef struct {

   // IRI_FT_TX
   uint16 us_TX_IFFT;
   uint16 us_TX_PARR;
   uint16 us_TX_WINDOW;

   // IRI_FT_RX
   uint16 us_TX_FFT;

} IridiaFT_Latencies_t;

#endif // _FT_TYPEDEF_H
