/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ftb_cocomo_interface.h
*
*   This file Specifies the Cocomo to Iridia-ftb interface.  This interface
*  includes the register read/write functions, core reset functions, BM
*  intialization functions, and any other cocomo/BM only functions/variables
*  that are required to run a HW Engine simulation.  These functions are NOT
*  required by, and unavailable for, actual HW.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FTB_COCOMO_INTERFACE_H
#define _FTB_COCOMO_INTERFACE_H


#include "ftb_typedef.h"
#include "ftb_io_typedef.h"
//#include "ftb_shared_typedef.h"


//=============================================================================
// Iridia-FTB BM clocking functions
//=============================================================================
void IRI_FTB_Clock(void);

//=============================================================================
// Iridia-FTB BM initialization functions
//=============================================================================
void IRI_FTB_InitializeBM(void);

//=============================================================================
// Iridia-FTB BM reset functions
//=============================================================================
void IRI_FTB_Reset(void);
void IRI_FTB_SetPortMode(uint8 uc_port_mode);

//=============================================================================
// Iridia-FTB functions for reading/writing RAM blocks and registers
//=============================================================================
int32 IRI_FTB_WriteWord(uint32 addr, uint32 ul_data, uint8 uc_ByteEnable,uint8 uc_port);
int32 IRI_FTB_ReadWord(uint32 addr, uint32 *pul_data, uint8 uc_ByteEnable,uint8 uc_port);

// This function is a Tx interface function to the Iridia-FTB BM. It is called by
// the Strymon BM to read one data sample from the Iridia-FTB IFFT buffers
// and also to buffer arbitartion based on the last sample in the frame.

void FTB_ReadFdfIfftSample(uint8 uc_port,uint32 ul_addr,uint8 uc_Last_SampleFrame, uint8 uc_ClearSample, int32 *pl_data);

// This function is a Rx interface function to the Iridia-FTB BM. It is called by
// the Strymon BM to write one data sample into the Iridia-FTB IFFT buffers
// and also to buffer arbitartion based on the last sample in the frame.


void FTB_WriteFdfFftSample(uint8 uc_port,uint32 ul_addr,uint8 uc_Last_SampleFrame,uint8 uc_data_valid,int32 l_data);


//QT- FTB interface functions

int32 IRI_FTB_TxWriteIFFT(int32 realValue,int32 imagValue, uint16 toneValue,uint8 uc_port);
int32 IRI_FTB_RxReadFFT(int32 *pla_Rx_OutputArray, int16 s_Rx_num_tones,uint8 uc_port);
//uint8 IRI_FTB_GetBufBank(ftb_cli_t Client, uint8 uc_port);
int32 IRI_FTB_ReadTxIFFT(int32 *pla_Tx_OutputArray, uint8 bufferBank, uint8 uc_port);

int32 IRI_FTB_FTTxBufferRotation(uint8 uc_IFFTStart,uint8 uc_PARRStart,uint8 uc_port);
int32 IRI_FTB_FTRxBufferRotation(uint8 uc_port);
int32 IRI_FTB_QTTxBufferRotation(uint8 uc_port);
int32 IRI_FTB_QTRxBufferRotation(uint8 uc_port);


#endif // _FTB_COCOMO_INTERFACE_H
