/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ftb_const.h
*
*   This file contains constant definitions for the Iridia-FTB BM.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FTB_CONST_H
#define _FTB_CONST_H

#ifndef MIN
#define MIN(A,B) ((A) > (B) ? (B) : (A))
#endif // MIN

//==============================================================================
// Iridia-FTB Constants
//==============================================================================


//  Iridia-FTB Definitions

#define     IRI_FTB_MAX_NUM_PORTS      4
#define FTB_SINGLE_PORT   (0)
#define FTB_TWO_PORT_MODE  (1)

//  Iridia-FTB TX

#define MAX_FTB_TX_NUM_TONES           4096

//  Iridia-FTB RX

#define MAX_FTB_RX_NUM_TONES           4096




// Byte masks
#define FTB_BYTE0_MASK     (0x000000FF)
#define FTB_BYTE1_MASK     (0x0000FF00)
#define FTB_BYTE2_MASK     (0x00FF0000)
#define FTB_BYTE3_MASK     (0xFF000000)
#define FTB_LOWER_WORD_MASK   (FTB_BYTE1_MASK | FTB_BYTE0_MASK)
#define FTB_UPPER_WORD_MASK   (FTB_BYTE3_MASK | FTB_BYTE2_MASK)
#define FTB_LONGWORD_MASK  (FTB_UPPER_WORD_MASK | FTB_LOWER_WORD_MASK)

// Byte enable masks
#define FTB_NO_BYTE_EN     (0x0)
#define FTB_BYTE0_EN       (0x1)
#define FTB_BYTE1_EN       (0x2)
#define FTB_BYTE2_EN       (0x4)
#define FTB_BYTE3_EN       (0x8)
#define FTB_LOWER_WORD_EN  (FTB_BYTE1_EN | FTB_BYTE0_EN)
#define FTB_UPPER_WORD_EN  (FTB_BYTE3_EN | FTB_BYTE2_EN)
#define FTB_LONGWORD_EN    (FTB_UPPER_WORD_EN | FTB_LOWER_WORD_EN)

// Register bit masks
#define FTB_MASK_BIT0      (0x00000001)
#define FTB_MASK_BIT1      (0x00000002)
#define FTB_MASK_BIT2      (0x00000004)
#define FTB_MASK_BIT3      (0x00000008)
#define FTB_MASK_BIT4      (0x00000010)
#define FTB_MASK_BIT5      (0x00000020)
#define FTB_MASK_BIT6      (0x00000040)
#define FTB_MASK_BIT7      (0x00000080)
#define FTB_MASK_BIT8      (0x00000100)
#define FTB_MASK_BIT9      (0x00000200)
#define FTB_MASK_BIT10     (0x00000400)
#define FTB_MASK_BIT11     (0x00000800)
#define FTB_MASK_BIT12     (0x00001000)
#define FTB_MASK_BIT13     (0x00002000)
#define FTB_MASK_BIT14     (0x00004000)
#define FTB_MASK_BIT15     (0x00008000)
#define FTB_MASK_BIT16     (0x00010000)
#define FTB_MASK_BIT17     (0x00020000)
#define FTB_MASK_BIT18     (0x00040000)
#define FTB_MASK_BIT19     (0x00080000)
#define FTB_MASK_BIT20     (0x00100000)
#define FTB_MASK_BIT21     (0x00200000)
#define FTB_MASK_BIT22     (0x00400000)
#define FTB_MASK_BIT23     (0x00800000)
#define FTB_MASK_BIT24     (0x01000000)
#define FTB_MASK_BIT25     (0x02000000)
#define FTB_MASK_BIT26     (0x04000000)
#define FTB_MASK_BIT27     (0x08000000)
#define FTB_MASK_BIT28     (0x10000000)
#define FTB_MASK_BIT29     (0x20000000)
#define FTB_MASK_BIT30     (0x40000000)
#define FTB_MASK_BIT31     (0x80000000)
//==============================================================================
// Iridia-FTB Flags
//==============================================================================
#ifndef TRUE
#define TRUE      (1)
#endif
#ifndef FALSE
#define FALSE     (0)
#endif

#define FTB_TX_PATH  (1)
#define FTB_RX_PATH  (1 - FTB_TX_PATH)

#define Buffer_A     0
#define Buffer_B     1
#define Buffer_C     2

#endif //_FTB_CONST_H
