/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ftb_private.h
*
*   This file contains private functions and variables which are visible
*   by the Iridia-ftb BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FTB_PRIVATE_H
#define _FTB_PRIVATE_H

#include "ftb_typedef.h"
#include "ftb_io_typedef.h"
#include "ftb_const.h"
#include "ftb_shared_typedef.h"

//==============================================================================
// Iridia-FTB private variables
//==============================================================================

extern IridiaFTB_Global_Register_t gt_IridiaMultiportFTB_Global_Register[IRI_FTB_MAX_NUM_PORTS];
extern IridiaFTB_Input_t gt_IridiaFTB_Input;
extern IridiaFTB_Output_t gt_IridiaFTB_Output;

//shadow registers

extern int32 gl_RxQTBufferSwap[4];
extern int32 gl_RxFTBufferSwap[4];

extern int32 gl_TxQTBufferSwap[4];
extern int32 gl_TxFDFBufferSwap[4];

//Iridia-FTB Number of Ports

extern uint8 guc_RxNumberofPorts,guc_TxNumberofPorts;

// Iridia-FTB Input Signal variables

extern uint8 guc_IRI_FTB_TX_CRI_GO_Input_Asserted;
extern uint8 guc_IRI_FTB_RX_CRI_GO_Input_Asserted;
extern int16 gs_Log4IFFTSizeTones;


// Iridia-FTB Internal strobes
extern uint8 guc_Tx_Frame_Strobe_Present;
extern uint8 guc_Rx_Frame_Strobe_Present;

// Iridia-FT local arrays


extern uint32 gula_Tx_IFFT_RAM_A_Lsb [IRI_FTB_MAX_NUM_PORTS][MAX_FTB_TX_NUM_TONES];
extern uint32 gula_Tx_IFFT_RAM_B_Lsb [IRI_FTB_MAX_NUM_PORTS][MAX_FTB_TX_NUM_TONES];
extern uint32 gula_Tx_IFFT_RAM_C_Lsb [IRI_FTB_MAX_NUM_PORTS][MAX_FTB_TX_NUM_TONES];
extern uint32 gula_Rx_FFT_RAM_A_Lsb [IRI_FTB_MAX_NUM_PORTS][MAX_FTB_RX_NUM_TONES];
extern uint32 gula_Rx_FFT_RAM_B_Lsb [IRI_FTB_MAX_NUM_PORTS][MAX_FTB_RX_NUM_TONES];
extern uint32 gula_Rx_FFT_RAM_C_Lsb [IRI_FTB_MAX_NUM_PORTS][MAX_FTB_RX_NUM_TONES];


//==============================================================================
// Iridia-FTB private functions
//==============================================================================

// Iridia-FT BM clocking function prototypes

int32 IridiaFTB_Clock_Tx(void);
int32 IridiaFTB_Clock_Rx(void);
void IridiaFTB_Clock_Tx_Strobes(void);
void IridiaFTB_Clock_Rx_Strobes(void);

// Iridia-FTB reset functions
void IridiaFTB_ResetRegisters(void);
void IridiaFTB_ResetRAMs(void);
void IridiaFTB_ResetGlobals(void);
void IridiaFTB_ResetIOSignals(void);

// Iridia-FTB initialization functions
void IridiaFTB_SetMemoryMap(void);
void IridiaFTB_AlignRAMPointers(void);
void IridiaFTB_Initialize_RAM_Lists(void);
void IridiaFTB_SetLatencies(void);

// Iridia-FTB RAM functions
int32 IridiaFTB_WriteWordVirtualAddr(int16 s_RamName, uint32 ul_offset,  uint32 ul_data, uint8 uc_ByteEnable,uint8 guc_ch_id);
int32 IridiaFTB_ReadWordVirtualAddr(int16 s_RamName, uint32 ul_offset, uint32 *pul_data, uint8 uc_ByteEnable,uint8 guc_ch_id);
void IridiaFTB_MapRAM(uint32 ul_addr, int16 *ps_RAM_id, uint32 *pul_Offset);
void IridiaFTB_ConfigIfftBuffers(uint8 uc_port);
void IridiaFTB_ConfigFftBuffers(uint8 uc_port);
void FTB_ReadFdfIfftSample(uint8 uc_port,uint32 ul_addr,uint8 uc_Last_SampleFrame, uint8 uc_ClearSample, int32 *pl_data);
void FTB_WriteFdfFftSample(uint8 uc_port,uint32 ul_addr,uint8 uc_Last_SampleFrame,uint8 uc_data_valid,int32 l_data);
uint32 DigitRev_ftb(uint32 ul_Index, uint32 fftsize);

uint8 IRI_FTB_GetBufBank(ftb_cli_t Client, uint8 uc_port);
int32 IRI_FTB_ReadTxIFFT(int32 *pla_Tx_OutputArray, uint8 bufferBank, uint8 uc_port);
int32 IRI_FTB_ReadRxFFT(int32 *pla_Rx_OutputArray, uint8 bufferBank , uint8 uc_port);
int32 IRI_FTB_ReadRxFFT_2(int32 *pla_Rx_OutputArray,  uint8 uc_port);

//Iridia- FTB -QT interface functions

int32 IRI_FTB_TxWriteIFFT(int32 realValue, int32 imagValue, uint16 s_Tx_num_tones,uint8 uc_port);
int32 IRI_FTB_QTTxBufferRotation(uint8 uc_port);
int32 IRI_FTB_TransferShadowBufferSize (uint8 uc_port);


int32 IRI_FTB_GetIFFTInputBufferAddress(int32 **pl_BaseAddr, int32 **pl_BaseAddrLsb,uint8 uc_port);
int32 IRI_FTB_GetFFTOutputBufferAddress(int32 **pl_BaseAddr, int32 **pl_BaseAddrLsb,uint8 uc_port);

// FTB-FT interface
int32 IRI_FTB_FTTxBufferRotation(uint8 uc_IFFTStart,uint8 uc_PARRStart,uint8 uc_port);
int32 IRI_FTB_FTRxBufferRotation(uint8 uc_port);
int32 IRI_FTB_QTRxBufferRotation(uint8 uc_port);


void IridiaFTB_TxShadowBufferswapRegisters(uint8 uc_signal1, uint8 uc_signal2, uint8 uc_port);
void IridiaFTB_RxShadowBufferswapRegisters(uint8 uc_signal1, uint8 uc_signal2, uint8 uc_port);




#endif // _FTB_PRIVATE_H
