/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: ftb_ram.h
*
*   Header file for Iridia-FTB RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FTB_RAM_H
#define _FTB_RAM_H

#include "ftb_memmap.h"


// Iridia-FTB RAM block IDs
#define  IRI_FTB_MIN_RAM_ID                     (0)

#define IRI_FTB_IFFT_RAM_A_ID          (0)
#define IRI_FTB_IFFT_RAM_B_ID          (1)
#define IRI_FTB_IFFT_RAM_C_ID          (2)
#define IRI_FTB_FFT_RAM_A_ID              (3)
#define IRI_FTB_FFT_RAM_B_ID              (4)
#define IRI_FTB_FFT_RAM_C_ID           (5)



#define  IRI_FTB_MAX_RAM_ID            (IRI_FTB_FFT_RAM_C_ID)

// Iridia-FTB Register IDs
#define  IRI_FTB_MIN_REG_ID            (IRI_FTB_MAX_RAM_ID + 1)

// Global Registers
#define IRI_FTB_CTRL_ID             (IRI_FTB_MIN_REG_ID + 0x00)
#define IRI_FTB_IFFT_TSIZE_ID             (IRI_FTB_MIN_REG_ID + 0x01)

#define IRI_FTB_RX_STATUS_ID        (IRI_FTB_MIN_REG_ID+0x02)
#define IRI_FTB_TX_STATUS_ID        (IRI_FTB_MIN_REG_ID+0x03)
#define IRI_FTB_FFT_START_ID        (IRI_FTB_MIN_REG_ID+0x04)


#define  IRI_FTB_NUM_GLOBAL_REGISTERS        5


#define  IRI_FTB_MAX_REG_ID               (IRI_FTB_FFT_START_ID)

//extern IridiaFTB_Global_Register_t  gt_IridiaFTB_Global_Register;
extern IridiaFTB_Global_Register_t gt_IridiaMultiportFTB_Global_Register[4];

// Global Arrays
extern uint32 *IRI_FTB_RAM_VirtualBaseAddr[IRI_FTB_MAX_RAM_ID+1];
extern uint32 IRI_FTB_RAM_PhysBaseAddr[IRI_FTB_MAX_REG_ID+1];
extern uint32 IRI_FTB_RAM_Size[IRI_FTB_MAX_RAM_ID+1];
extern uint32 IRI_FTB_RAM_Offset[IRI_FTB_MAX_RAM_ID+1];
extern uint32 IRI_FTB_RAM_Mask[IRI_FTB_MAX_RAM_ID+1];


extern uint8 IRI_FTB_IFFT_RAM_A_Unaligned[4][IRI_FTB_IFFT_RAM_A_SIZE+4];
extern uint8 *IRI_FTB_IFFT_RAM_A;

extern uint8 IRI_FTB_IFFT_RAM_B_Unaligned[4][IRI_FTB_IFFT_RAM_B_SIZE+4];
extern uint8 *IRI_FTB_IFFT_RAM_B;

extern uint8 IRI_FTB_IFFT_RAM_C_Unaligned[4][IRI_FTB_IFFT_RAM_C_SIZE+4];
extern uint8 *IRI_FTB_IFFT_RAM_C;

extern uint8 IRI_FTB_FFT_RAM_A_Unaligned[4][IRI_FTB_FFT_RAM_A_SIZE+4];
extern uint8 *IRI_FTB_FFT_RAM_A;

extern uint8 IRI_FTB_FFT_RAM_B_Unaligned[4][IRI_FTB_FFT_RAM_B_SIZE+4];
extern uint8 *IRI_FTB_FFT_RAM_B;

extern uint8 IRI_FTB_FFT_RAM_C_Unaligned[4][IRI_FTB_FFT_RAM_C_SIZE+4];
extern uint8 *IRI_FTB_FFT_RAM_C;

#endif //_FTB_RAM_H
