/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _FTB_TYPEDEF_H
#define _FTB_TYPEDEF_H


#ifndef MULTI_TO_SINGLE
#define MULTI_TO_SINGLE

//#define Rev_2

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc_qt long long
#else
#ifdef MSVC_ONLY
#define acc_qt __int64
#else
#define acc_qt long
#endif
#endif

// Structure used for Iridia-FTB registers
typedef struct{

// IRI_FTB_CTRL_ADDR
    int32 l_TxQTDigitReverseDisable;
   int32 l_RxDualFftMode;
   int32 l_TxFDFReadClear;
   int32 l_TxFTRotate;

   int32 l_IFFTDspReorder;
   int32 l_IFFTLsbEnable;
   int32 l_IFFTBufferSwapDisable;
   int32 l_TxFDFEnable;
   int32 l_RxFDFDigitReverseDisable;
   int32 l_FFTSize;
   int32 l_FFTDspReorder;
   int32 l_FFTLsbEnable;
   int32 l_FFTBufferSwapDisable;
   int32 l_RxFDFEnable;

// IRI_FTB_IFFT_TSIZE_ADDR

   int32 l_IFFTSize;
   int32 l_IFFTSize_BufferA;
   int32 l_IFFTSize_BufferB;
   int32 l_IFFTSize_BufferC;



// IRI_FTB_RX_STATUS_ADDR

   int32 l_WriteRxFDF;
   int32 l_RxFDFBufferStatus;
   int32 l_WriteRxFT;
   int32 l_RxFTBufferStatus;
   int32 l_WriteRxQT;
   int32 l_RxQTBufferStatus;


// IRI_FTB_TX_STATUS_ADDR

   int32 l_WriteTxFDF;
   int32 l_TxFDFBufferStatus;
   int32 l_WriteTxFT;
   int32 l_TxFTBufferStatus;
   int32 l_WriteTxQT;
   int32 l_TxQTBufferStatus;

// IRI_FTB_FFT_START_ADDR

   int32 l_FFTStartIndex;


} IridiaFTB_Global_Register_t;



#endif // _MULTI_TO_SINGLE
#endif //FTB_TYPEDEF_H
