/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_const.h
*
*   This file contains constant definitions for the Iridia-QT BM.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_CONST_H
#define _QT_CONST_H

#ifndef MIN
#define MIN(A,B) ((A) > (B) ? (B) : (A))
#endif // MIN

//==============================================================================
// Iridia-QT Constants
//==============================================================================

#define     IRI_MAX_NUM_PORTS    4

#define FT_RX 2


#define QT_MAX_18 0x0001FFFF
#define QT_MIN_18 0xFFFE0000

#define QT_MAX_32 0x7fffffff
#define QT_MIN_32 0x80000000

// Iridia-QT RX
#ifdef MULTI_PORT_CO

#define MAX_QT_RX_NUM_TONES            1920
#define MAX_QT_TX_NUM_TONES            3072

#else
#define MAX_QT_RX_NUM_TONES            4096
#define MAX_QT_TX_NUM_TONES            4096
#define XY_QAM_FIFO_DEPTH           (36)
#endif //MULTI_PORT_CO

#define MAX_QT_RX_MFDQ_NUM_TONES    64

//  Iridia-QT TX

// Iridia-QT Tx PRBS Generator
#define PRBS_OUTPUT_BITS      (2)                        // Number of output bits to generate each time the PRBS generator runs
#define MAX_PRBS_OUTPUT_BITS  (15)                    // Maximum Number of output bits to generate each time the PRBS generator runs

// Iridia-QT 1-bit constellations
#define  QT_SBC_45DEG      (0)
#define  QT_SBC_0DEG       (1)
#define  QT_SBC_90DEG      (2)
#define  QT_SBC_135DEG     (3)

// Iridia-QT QAM
#define  QT_3BIT_CONSTELLATION_POINTS     (8)
#define  QT_ODDBITS_CONSTELLATION_POINTS     (32)

// Iridia-QT Encoder Gain Scale Precision
#define FRAC_BITS_ENC_FINEGAIN      (13)                 // Tx FineGain*Tssi in Q2.13 format
#define  FRAC_BITS_ENC_CONSGAIN     (13)                 // Tx Constellation gain in Q3.13 format
#define FRAC_BITS_ENC_COMBGAIN      (13)                 // Tx Combined gain in Q5.13 format
#define FRAC_BITS_ENC_QAMOUT_XY     (7)                     // Tx XY constellation values before gain scale in Q9.7 format
#define FRAC_BITS_ENC_SCALED_XY     (15)                 // Tx XY constellation values after gain scale in Q3.15 format
#define SQRT_TWO_MANTISSA        (int16)(1.414213562*(1<<7))   // represents sqrt(2) in Q9.7 format

#define  QAM2_MAX             (1)
#define  QAM3_MAX             (3)
#define  QAM3_MAX_NOTRELLIS         (4)                     // 3-bit case is special
#define  QAM4_MAX             (3)
#define  QAM5_MAXINNER           (3)
#define  QAM5_MAXOUTER           (5)
#define  QAM6_MAX             (7)
#define  QAM7_MAXINNER           (7)
#define  QAM7_MAXOUTER           (11)
#define  QAM8_MAX             (15)
#define  QAM9_MAXINNER           (15)
#define  QAM9_MAXOUTER           (23)
#define  QAM10_MAX               (31)
#define  QAM11_MAXINNER          (31)
#define  QAM11_MAXOUTER          (47)
#define  QAM12_MAX               (63)
#define  QAM13_MAXINNER          (63)
#define  QAM13_MAXOUTER          (95)
#define  QAM14_MAX               (127)
#define  QAM15_MAXINNER          (127)
#define  QAM15_MAXOUTER          (191)

// States for the Rx QAM decode state machine
#define  IRI_QT_RX_IDLE    (0)
#define  IRI_QT_RX_BUSY    (1)
#define  RX_QT_DECODE      (1)

// States for the Tx QAM encode state machine
#define  IRI_QT_TX_IDLE    (0)
#define  IRI_QT_TX_BUSY    (1)
#define  TX_QT_ENCODE      (1)

// Tx Latencies
#define  IRI_QT_TX_QAMENCODE_LATENCY         (1)
#define  IRI_QT_TX_TCM_QAMENCODE_LATENCY     (1)

// Rx Latencies
#define  IRI_QT_RX_QAMDECODE_LATENCY         (1)
#define  IRI_QT_RX_TCM_QAMDECODE_LATENCY     (1)

// Masks
#define IRI_QT_BAT_MASK          (0x000F)
#ifdef VRX518
#define IRI_QT_TONETABLE_MASK    (0x1FFF)
#else
#define IRI_QT_TONETABLE_MASK    (0x0FFF)
#endif
#define IRI_QT_EXTGAIN_BIT0         (0x01)
#define IRI_QT_EXTGAIN_BITS1_0      (0x03)
#define IRI_QT_EXTGAIN_BIT2         (0x04)

#define IRI_QT_EXTGAIN_BIT3         (0x08)
#define IRI_QT_EXTGAIN_BIT4         (0x10)

// Byte masks
#define QT_BYTE0_MASK      (0x000000FF)
#define QT_BYTE1_MASK      (0x0000FF00)
#define QT_BYTE2_MASK      (0x00FF0000)
#define QT_BYTE3_MASK      (0xFF000000)
#define QT_LOWER_WORD_MASK (QT_BYTE1_MASK | QT_BYTE0_MASK)
#define QT_UPPER_WORD_MASK (QT_BYTE3_MASK | QT_BYTE2_MASK)
#define QT_LONGWORD_MASK   (QT_UPPER_WORD_MASK | QT_LOWER_WORD_MASK)

// Byte enable masks
#define QT_NO_BYTE_EN      (0x0)
#define QT_BYTE0_EN        (0x1)
#define QT_BYTE1_EN        (0x2)
#define QT_BYTE2_EN        (0x4)
#define QT_BYTE3_EN        (0x8)
#define QT_LOWER_WORD_EN   (QT_BYTE1_EN | QT_BYTE0_EN)
#define QT_UPPER_WORD_EN   (QT_BYTE3_EN | QT_BYTE2_EN)
#define QT_LONGWORD_EN     (QT_UPPER_WORD_EN | QT_LOWER_WORD_EN)

// Port select controls
#define QT_ONE_PORT_MODE         (0x0)
#define QT_TWO_PORT_MODE         (0x1)

// Register bit masks
#define QT_MASK_BIT0    (0x00000001)
#define QT_MASK_BIT1    (0x00000002)
#define QT_MASK_BIT2    (0x00000004)
#define QT_MASK_BIT3    (0x00000008)
#define QT_MASK_BIT4    (0x00000010)
#define QT_MASK_BIT5    (0x00000020)
#define QT_MASK_BIT6    (0x00000040)
#define QT_MASK_BIT7    (0x00000080)
#define QT_MASK_BIT8    (0x00000100)
#define QT_MASK_BIT9    (0x00000200)
#define QT_MASK_BIT10      (0x00000400)
#define QT_MASK_BIT11      (0x00000800)
#define QT_MASK_BIT12      (0x00001000)
#define QT_MASK_BIT13      (0x00002000)
#define QT_MASK_BIT14      (0x00004000)
#define QT_MASK_BIT15      (0x00008000)
#define QT_MASK_BIT16      (0x00010000)
#define QT_MASK_BIT17      (0x00020000)
#define QT_MASK_BIT18      (0x00040000)
#define QT_MASK_BIT19      (0x00080000)
#define QT_MASK_BIT20      (0x00100000)
#define QT_MASK_BIT21      (0x00200000)
#define QT_MASK_BIT22      (0x00400000)
#define QT_MASK_BIT23      (0x00800000)
#define QT_MASK_BIT24      (0x01000000)
#define QT_MASK_BIT25      (0x02000000)
#define QT_MASK_BIT26      (0x04000000)
#define QT_MASK_BIT27      (0x08000000)
#define QT_MASK_BIT28      (0x10000000)
#define QT_MASK_BIT29      (0x20000000)
#define QT_MASK_BIT30      (0x40000000)
#define QT_MASK_BIT31      (0x80000000)

//RTV output definitions
#define  RTV_OUT_FFT_OUT         (0)
#define  RTV_OUT_SFDQ_OUT     (1)
#define  RTV_OUT_GS_IN        (2)
#define  RTV_OUT_GS_OUT       (3)
#define  RTV_OUT_QAM_IN       (4)
//#define   RTV_OUT_V_DIST       (5)
#define  RTV_OUT_CONST        (6)
#define  RTV_OUT_ERROR        (7)

#define RTV_BUF_NUM_TONES     (512)


//RTV data format
#define  FRAC_BITS_RTV_OUT_FFT_OUT        (13)
#define  FRAC_BITS_RTV_OUT_SFDQ_OUT       (13)
#define  FRAC_BITS_RTV_OUT_GS_IN          (13)
#define  FRAC_BITS_RTV_OUT_GS_OUT         (7)
#define  FRAC_BITS_RTV_OUT_QAM_IN         (7)
#define  FRAC_BITS_RTV_OUT_CONST          (7)
#define  FRAC_BITS_RTV_OUT_ERROR          (13)

//SFDQ/MFDQ/GS precision
#define FRAC_BITS_SFDQ_INPUT  (15)                    // SFDQ input tone (Q3.15)
#define FRAC_BITS_SFDQ_MANT      (15)                    // SFDQ coefficient mantissa (Q1.15)
#define FRAC_BITS_SFDQ_OUT    (15)                    // SFDQ output tone (Q1.15)
#define WORDLENGTH_SFDQ_OUT      (20)                    // SFDQ output wordlength
#define MAX_POSITIVE_SFDQ_OUT ((1<<(WORDLENGTH_SFDQ_OUT-1))-1) //most positive number for given word length
#define MAX_NEGATIVE_SFDQ_OUT (-MAX_POSITIVE_SFDQ_OUT-1)    //most negative number for given word length

#define FRAC_BITS_RX_GS_INPUT (13)                    // GS input fractional bits (Q5.13)
#define WORDLENGTH_RX_GS_INPUT   (18)                    // GS input word length
#define FRAC_BITS_RX_GS_OUTPUT   (16)                    // GS input fractional bits (Q5.13)
#define WORDLENGTH_RX_GS_OUTPUT  (29)                    // GS input word length
#define FRAC_BITS_RX_COMBGAIN (13)                 // Rx FineGain*ConstellationGain values in Q3.13 format

// Iridia-QT QAM Decoder input
#define FRAC_BITS_DEC_SCALE_OUTPUT  (7)                     // QAM decoder input value in Q9.7 format
#define WORDLENGTH_QAMDEC_INPUT     (16)
#define FRAC_BITS_DESCALED_XY_TCM   (FRAC_BITS_DEC_SCALE_OUTPUT)

// Trellis decoder fixed pt formats
#define INT_BITS_ERROR_1D     1     // Does not include sign bit.
#define FRAC_BITS_ERROR_1D    6     // May be less than frac bits in QAM input.
#define FRAC_BITS_ERROR_2D    6     // Should be <= frac bits for 1D error

#define QT_PLUS_ONE              (1<<FRAC_BITS_DEC_SCALE_OUTPUT)
#define QT_MINUS_ONE          ((-1)<<FRAC_BITS_DEC_SCALE_OUTPUT)
#define QT_PLUS_TWO              (2<<FRAC_BITS_DEC_SCALE_OUTPUT)
#define QT_MINUS_TWO          ((-2)<<FRAC_BITS_DEC_SCALE_OUTPUT)
#define QT_PLUS_THREE            (3<<FRAC_BITS_DEC_SCALE_OUTPUT)
#define QT_MINUS_THREE           ((-3)<<FRAC_BITS_DEC_SCALE_OUTPUT)

//MFDQ parameters
#define INVALID_FB_DEPTH      (0x3F)      //invalid feedback tone depth
#define FB_TONE_NOT_MATCH     (-1)     //indicate the current logical tone does not match to the next feedback tone index
#define FB_TONE_END           (-2)     //indicate the end of the feedback tone table (or error) is found
//==============================================================================
// Iridia-QT Flags
//==============================================================================
#ifndef TRUE
#define TRUE      (1)
#endif
#ifndef FALSE
#define FALSE     (0)
#endif

#define  QAM_ENC        (0)
#define  QAM_DEC        (1)

#define TX_TONE  (1)
#define RX_TONE  (1 - TX_TONE)

#define TX_PATH  (1)
#define RX_PATH  (1 - TX_PATH)

#define QT_TX_PATH  (0)
#define QT_RX_PATH  (1 - TX_PATH)


#define BYTE_DATA   (0)
#define WORD_DATA   (1)
#define LONGWORD_DATA   (2)

# define RX_LUT_ENABLE 1 //change to 0 for LUT disable
# define TX_LUT_ENABLE 1 //change to 0 for LUT disable

#define TX_PHY_MEMORY_SIZE_VDSL 3072 // 2-port mode 30 /17 Mkz - Tx
#define TX_PHY_MEMORY_SIZE_ADSL 1536 // 4-port mode 8.8 Mkz  -Tx

#define RX_PHY_MEMORY_SIZE_VDSL (4096+256)  // 2-port mode 30 /17 Mkz -Rx
#define RX_PHY_MEMORY_SIZE_ADSL (2048+128)  //4-port mode 8.8 Mkz  -Rx

#define BGT 1
#define EGT 0

#ifdef VRX518
#define ACT_EGT_TONE_LSB_OFFSET (3)
#endif //VRX518

#endif //_QT_CONST_H
