/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_private.h
*
*   This file contains private functions and variables which are visible
*   by the Iridia-QT BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_PRIVATE_H
#define _QT_PRIVATE_H

#include "qt_typedef.h"
#include "qt_io_typedef.h"
#include "qt_const.h"

//==============================================================================
// Iridia-QT private variables
//==============================================================================

extern uint8 guc_qt_tx_go_port;
extern uint8 guc_qt_rx_go_port;
extern uint32 gul_Offsetadd;


// Iridia QT register structure for internal use

extern IridiaQT_Global_Register_t  gt_IridiaQT_Global_Register;
extern IridiaQT_Global_Register_t gt_IridiaMultiportQT_Global_Register[IRI_MAX_NUM_PORTS];
extern IridiaQT_TxPram_Register_t  gt_IridiaQT_TxPram_Register;
extern IridiaQT_TxPram_Register_t gt_IridiaMultiportQT_TxPram_Register[IRI_MAX_NUM_PORTS];
extern IridiaQT_RxPram_Register_t  gt_IridiaQT_RxPram_Register;
extern IridiaQT_RxPram_Register_t gt_IridiaMultiportQT_RxPram_Register[IRI_MAX_NUM_PORTS];




extern IridiaQT_Latencies_t gt_IridiaQTLatencies;

// Iridia-QT QAM Tables
extern int16 gsa_TxQamXTab3[QT_3BIT_CONSTELLATION_POINTS];
extern int16 gsa_TxQamYTab3[QT_3BIT_CONSTELLATION_POINTS];
extern uint8 guca_TxQamXcYcTab[QT_ODDBITS_CONSTELLATION_POINTS];
extern uint8 guca_IRI_ByteMaskTable[9];
extern uint16 gusa_WordMaskTable[16];
extern uint32 gula_LongWordMaskTable[32];
extern uint8 guca_TxGainScaleExp[16];
extern uint16 gusa_TxGainScale[16];
extern uint16 gusa_RxGainScale[16];
extern uint8 guca_RxGainScaleExp[16];
extern int16 gsa_RxQamXYTab3[QT_3BIT_CONSTELLATION_POINTS << 1];
extern uint8 guca_RxQamXcYcTab[16];
extern int16 gsa_RxQamMaxCoordInner[16];
extern int16 gsa_RxQamMaxCoordOuter[16];
extern uint16 gusa_Reordertone_table[MAX_QT_TX_NUM_TONES];   //local Tonereorder table


// Iridia-QT Rx QAM decode state machine variables
extern uint16 gus_RxQTEngineState;
extern uint16 gus_RxQTEngineNextState;
extern uint16 gus_RxQTEngineSubState;
extern uint16 gus_RxQTEngineNextSubState;
extern uint32 gul_RxQTEngineLatency;


//Iridia-QT Port select variables

extern uint8 guc_IRI_QT_PortSelect[4];
extern uint8 gusa_QTTxlut4[16];
extern uint8 gusa_QTRxlut4[16];
extern uint8 guc_qt_tx_go_port;
extern uint8 guc_qt_rx_go_port;
extern uint16 guc_TcmTonesMismatchError;

extern uint8 gc_SpecialErrorVal;
extern uint8 gft_which_rtv;

extern uint8 gfta_RxSquareSum[IRI_MAX_NUM_PORTS];
extern uint8 gfta_RxReImAccum[IRI_MAX_NUM_PORTS];

// Iridia-QT Tx QAM Encode state machine variables
extern uint16 gus_TxQTEngineState;
extern uint16 gus_TxQTEngineNextState;
extern uint16 gus_TxQTEngineSubState;
extern uint16 gus_TxQTEngineNextSubState;
extern uint32 gul_TxQTEngineLatency;

// Iridia-QT Input Signal variables
extern uint8 guc_IRI_QT_TX_CRI_GO_Input_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_GO_Input_Asserted;

// Iridia-QT Output Signal variables
extern uint8 guc_IRI_QT_TX_CRI_DONE_Output_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_DONE_Output_Asserted;
extern uint8 guc_IRI_QT_TX_CRI_BATERR_Output_Asserted;
extern uint8 guc_IRI_QT_RX_CRI_BATERR_Output_Asserted;
extern uint16 gus_IRI_QT_TX_ILV_SIZE0_Output_Asserted;
extern uint16 gus_IRI_QT_TX_ILV_SIZE1_Output_Asserted;
extern uint16 gus_IRI_QT_RX_ILV_SIZE0_Output_Asserted;
extern uint16 gus_IRI_QT_RX_ILV_SIZE1_Output_Asserted;

// Iridia-QT to Interleave memory bit extraction interface variables
extern uint32 gul_InWordLP0;
extern uint32 gul_InWordLP1;
extern uint32 gul_InWordLP2;
extern uint16 gus_EncDummyBitsLP0;
extern uint16 gus_EncDummyBitsLP1;
extern uint32 gul_EncBitsLP0;
extern uint32 gul_EncBitsLP1;
extern uint32 gul_EncBitsLP2;
extern int16  gs_EncBitPtrLP0;
extern int16  gs_EncBitPtrLP1;
extern int16  gs_EncBitPtrLP2;
extern uint8  guca_lp_order[8][3];


extern int16 gs_NumNonZeroTrellisPairs;

// Iridia-QT to Deinterleave memory bit stuffing interface variables

extern uint32 gula_OutWordLP[3];
extern uint16 gusa_DecBitsLP[3];
extern int16  gsa_DecBitPtrLP[3];

extern uint16 gusa_DecDummyBitsLP[2];
extern int16  gsa_QtRxSize[2];
extern int8   gc_StartLPath;

extern uint8 gusa_lut4[16];
extern uint8 gs_writeMFDQTNoisebufffer;

// Iridia-QT local arrays
extern int32 gla_Tx_QAMOutput[MAX_QT_TX_NUM_TONES<<1];
extern uint8 guca_Tx_ModifiedBitAlloc[MAX_QT_TX_NUM_TONES<<1];
extern int32 gla_Rx_QtToneBuf[MAX_QT_RX_NUM_TONES<<1];
extern int32 gla_Rx_FftOutBuf[MAX_QT_RX_NUM_TONES<<1];
extern int32 gla_Rx_FftOutBuf_Dualfft[MAX_QT_RX_NUM_TONES<<1];
extern uint8 guca_BitAllocTable[MAX_QT_RX_NUM_TONES];

extern int16 gs_MaxLogToneIdxWithFbTone;
extern uint16 *gpusa_Rx_ToneReorder;
extern uint16 *gpusa_RxGainTable;
extern int16  **gpsa_RTVBuf;

// Iridia-QT overflow flag
extern FlagT gft_QTOverflow;
extern int16 gs_QTFeedbackOverflowFlag;

// Iridia-QT flag to indicate it is QAM encode or Decode
extern FlagT gft_QamEncDec;

// Iridia-QT flag indicating whether the QAM decoder constellation point was clipped
extern FlagT gft_QamDecClippedInput;

// Iridia-QT variables for RAM blocks
extern uint32 *gpula_NoisyPointScratchPad;
extern uint32 *gpula_ViterbiDecisionTable;
extern uint32 *gpula_MfdqFinalDecisionTable;
extern int16 gs_NPSP_ReadPtr;
extern int16 gs_NPSP_WritePtr;
extern int16 gs_FLT_ReadPtr;
extern int16 gs_FLT_WritePtr;
extern int16 gs_MFDT_ReadPtr;
extern int16 gs_MFDT_WritePtr;

// Iridia-QT Tx PRBS Generator
extern int16 gs_TxPRBSOutput;
extern int32 gl_TxPRBSState;

// Iridia-QT Rx PRBS State Generator
//extern int32 gl_RxPRBSState;
extern int32 gl_RxPRBSStateRTV0;
extern int32 gl_RxPRBSStateRTV1;

// Iridia-QT Rx PRBS Descrambler
extern int16 gs_RxDPRBSOutput;
extern int32 gl_RxDPRBSState;

// Nyquist tone value
extern int32 gl_OsNyqToneValue;


// Physical memory sizes for Tx / Rx BAT, EGT, SFDQ Exp tabes. GST table sizes are twice this value.
extern uint32 gul_TxPhyMemorySize;
extern uint32 gul_RxPhyMemorySize;

//// For fdqAdapt.
extern int32 gla_savedFdqIn[8192*2];

extern uint8 guc_qt_tx_go_port;
extern uint8 guc_qt_rx_go_port;
extern uint32 gul_Offsetadd;

//==============================================================================
// Iridia-QT private functions
//==============================================================================

// Iridia-QT BM clocking functions
int32 IridiaQT_Clock_Tx(uint8 uc_port);
int32 IridiaQT_Clock_Rx(uint8 uc_port);
int32 Do_TxQT(uint8 uc_port);
int32 Do_RxQT(uint8 uc_port);
void Completed_TxProcessing(void);
void Completed_RxProcessing(uint8 uc_port);

// Iridia-QT reset functions
void IridiaQT_ResetRegisters(void);
void IridiaQT_ResetRAMs(void);
void IridiaQT_ResetGlobals(void);
void IridiaQT_ResetIOSignals(void);

// Iridia-QT initialization functions
void IridiaQT_SetLatencies(void);
void IridiaQT_SetMemoryMap(void);
void IridiaQT_AlignRAMPointers(void);
void IridiaQT_Initialize_RAM_Lists(void);

// Iridia-QT RAM functions
int32 IridiaQT_WriteWordVirtualAddr(int16 s_RamName, uint32 ul_offset,  uint32 ul_data, uint8 uc_ByteEnable,uint8 uc_port);
int32 IridiaQT_ReadWordVirtualAddr(int16 s_RamName, uint32 ul_offset, uint32 *pul_data, uint8 uc_ByteEnable,uint8 uc_port);

void IridiaQT_MapRAM(uint32 ul_addr, int16 *ps_RAM_id, uint32 *pul_Offset);

// Iridia-QT Tx function prototypes
void QAMEncoder(int16* psa_OutputReal, int16* psa_OutputImag, int16 s_num_tones, uint32 *pula_ActiveBGTN, uint8 *puca_ExtGain,uint8 uc_port);

void TCMEncoder(int16* psa_OutputReal, int16* psa_OutputImag, int16 s_num_tones, uint32 *pula_ActiveBGTN,uint8 *puca_ExtGain, uint8 uc_port);


uint16 GetBits(int16 s_BitLoad, uint8 s_newsymbol, uint32 *pul_Datum, int16 *ps_extrabits, uint8 uc_port);
void ProcessTxTones(uint32 *pula_ActiveBGTN, uint8 *puca_ModifiedBitAlloc,uint8 uc_port);

//void ProcessTxTones(uint8 *puca_BitAlloc, uint8 *puca_ExtGain, uint16 *pusa_ToneReorder, uint8 *puca_ModifiedBitAlloc,uint8 uc_port);
void ApplyTxOversampling(uint8 uc_port);
void TxPRBSGenerator(int16 s_output_bits);
void PRBSPilotScrambler(int32 *pl_data_real, int32 *pl_data_imag, int16 s_PRBS_output);
int16 GetPRBS2bitData(int16 s_PRBS_data_index);
void PRBSScrambler(int16 *ps_PRBS_data, int16 s_PRBS_output);
void FindConstellation(uint32 ul_input, int16 s_BitLoad, int16 *ps_X, int16 *ps_Y);
void ApplyTxGainScale(uint32 *pula_ActiveBGTN,uint8 *puca_ExtGain, uint8 *puca_ModifiedBitAlloc, uint32 *pula_TxConstellationGains,uint8 uc_port);

void CheckTxGainScaleOverflow(void);

void IRI_QT_TxZeroToneProcessing(uint8 uc_port);
void DirectCopyIFFTbuffer(uint8 uc_port);
void WriteToneAndAliases(int32 *la_QamData, int phy_idx,int s_Tx_NumTones, int oversampleRate, uint8 uc_port);


//Iridia-QT RX functions
void QT_RPPtoOffset(int16 *ps_offset,uint8 uc_port);
int16 QT_SaveRTV(int16 s_DebugFlag, int16 s_InputDataType, int32 *pla_ToneBuf, int16 s_ToneIdx, int16 **psa_RTVBuf_BaseAddr,uint8 uc_port);
int16 QT_IsToneInRTV(int16 s_ToneIdx,uint8 uc_port);
int16 QT_AccVectorPowerinRTV0(int32 *pla_ToneBuf,uint8 uc_port);

int32 IRI_QT_GetRxConstellationGainsTable(uint32 *gula_ConstellationGain);
int32 Do_RxPRBSDeScrambling(int32 *pla_ToneBuf);

void RxPRBSGenerator(int16 s_output_bits);
int32 QT_PRBSStateFromQTP(int32 *s_QTPPrbsState,uint8 uc_port);


void PRBSDeScrambler(int16 s_PRBS_Output, int32 *psa_ToneData);
void QT_SFDQ(int32 *pla_ToneBuf, int16 *psa_SfdqCoefMant, uint8 uc_SfdqExt);
void QT_ComplexMult(int32 *pla_ToneBuf, int16 *psa_FdqMant, acc_qt *pla_64BitBuf);
void ApplyFdqExp(int16 s_exp, acc_qt *pacc_InToneBuf, int32 *pla_OutToneBuf);
void FindFeedbackTone(int16 s_LogToneIdx, uint32 ul_MfdqFbToneTable, int16 *ps_FbLogToneIdx);
void QT_FormatFeedforwardTaps(int32 *pla_ToneBuf);
void QT_RxGainScale(int32 *pla_LocalToneBuf, int16 s_PhyToneIdx, uint32 *pula_ActiveBGT, uint32 *pula_RxConstellationGains);

void CheckRxGainScaleOverflow(void);
void QT_QAMDecode(uint32 *pula_MfdqFbToneTable, uint32 *pula_ActiveBGTN, int16 **psa_RTVBuf, int16 *ps_ProcRTVToneOnlyFlag,uint8 uc_port);


void QT_TcmQAMDecode(uint16 *pusa_Rx_ToneReorder, uint8 *puca_BAT, int16 **psa_RTVBuf);


void QT_MfdqTcmQAMDecode(uint32 *pula_ActiveBGTN, int16 **psa_RTVBuf,uint8 uc_port);



void GetMFDQFeedbackvalues(uint32 *pula_ActiveBGT, int16 s_LogToneIdx,int32 *la_LocalToneBuf,int16 s_MFBTIdx,int16 *s_FeedbackLength,uint8 uc_port);

void WriteXYQAMDecisionTable(int16 *la_LocalToneBuf, int16 s_LogToneIdx);
void ReadXYQAMDecisionTable(int16 *la_LocalToneBuf, int16 s_LogToneIdx);


void QT_MfdqFeedback(uint32 ul_MfdqScratchPad, int16 *psa_MfdqFbCoefMant, uint8 uc_MfdqFbCoefExp,
               int32 *la_LocalToneBuf);

void CalcMSFBT_QamDecInput(int16 s_PhyToneIdx, int16 *psa_SfdqCoefMant, uint8 *puca_SFDQExp,
                     uint32 *pula_ActiveBGTN, int16 *psa_QamInput,uint8 uc_port);


void AddMfdqFeedback(int32 *pla_GSOutputTone, int32 *pla_FeedbackTone, int32 *pla_OutputTone);
void QT_QAMDemapper(int16* psa_QamInput, int16 *psa_FinalDecision, uint8 uc_BitAlloc, uint16 *pus_Datum);
void DecodeConstellation(int16 s_X, int16 s_Y, int16 s_BitLoad, uint16 *pus_Datum);
void InitQamDecoderClipTable(void);
void QamDecoderClipInput(int16 s_X, int16 s_Y, int16 *s_XClipped, int16 *s_YClipped, int16 s_Bits);
void QamDecoderClipInput3Bit(int16 s_X, int16 s_Y, int16 *s_XClipped, int16 *s_YClipped);
uint16 QT_BitStuffer(int16 s_BitLoad, uint8 *puc_newsymbol, uint32 ul_Datum,uint8 uc_port);
void InitReadWritePointers(uint8 uc_port);
void ReadNoisyPointScratchPad(int32 *pla_OutputBuf);
void WriteNoisyPointScratchPad(int32 *pla_InputBuf);
void SaveNoisyConstellationPoint(int32 *pla_LocalToneBuf);
void ReadFLT(int16 *ps_FB_len);
void ClearSurvivorPathRAM(void);

void WriteFLT(int16 s_FB_Len);
void CalcDecodingError(int16 *psa_FeedBackTone, int32 *pla_LocalToneBuf);
void GetQAMInputTone(int32 *pla_InputToneBuf, int16 s_PhyToneIdx, int16 *psa_OutputToneBuf,uint8 uc_port);
void QT_RxGainBypass(int32 *pla_ToneBuf);

//Iridia QT dump functions

int32 IRI_QT_RxReadSPM(int32 *pla_spm, int16 *num_stages);
int32 IRI_QT_RxReadNPSP(int32 *pla_npsp, int16 *num_stages);
int32 IRI_QT_RxReadXYD(int32 *pla_xyd, int16 *num_stages);




// Iridia-QT functions shared by Tx and Rx
void QT_CopyTable(int32 l_path,uint8 uc_port);
void IRI_QT_SetportMode(uint8 uc_port_mode);

//Iridia-QT functions for generating look-up tabels in multiport CTLM
void FormRxLookupTable(uint8 *gusa_QTRxlut4,uint8 uc_port);

void IRI_QT_Clock_Tx_Frame(uint8 uc_port);
void IRI_QT_Clock_Rx_Frame(uint8 uc_port);

int32 GenerateRxLUTAddress(uint32 ul_addr,uint32 *ul_newaddr,uint8 uc_port,uint8 uc_ByteEnable,uint32 ul_numtones );
void IRI_QT_RxTonesReset(uint8 uc_port);
//wrapper functions
void QT_ZEP_ILV_GetWordFromTxDTB(int16 s_lp, uint32 *pul_word, uint8 uc_port);
void IRI_QT_RxOutputRMetric(uint8 rmetric, uint8 uc_port);

#ifdef BM_50
extern int32 IRI_FT_RxReadFFT(int32 *pla_Rx_OutputArray, int16 s_Rx_num_tones);
extern int32 IRI_FT_TxWriteIFFT(int32 *pla_Tx_InputArray, int16 s_Tx_num_tones);
#else
void QT_IRI_FTB_TxWriteIFFT(int32 realValue,int32 imagValue, uint16 toneValue,uint8 uc_port, uint8 skip);

#endif


int32 IRI_QT_FTB_ReadRxFFT_returnSize(int32 *pla_Rx_OutputArray, int32 *s_RxFFTNumTones, uint8 uc_port);
int32 IRI_QT_FTB_ReadRxFFT(int32 *pla_Rx_OutputArray, uint8 uc_port);
void QT_ZEP_ILV_PutWordToRxDTB(int16 s_lpath, uint32 ul_OutWord, uint8 uc_port);
int32 QT_ZEP_ILV_GetPRBSByteFromTxDTB(uint32 us_rd_addr, uint8 *pul_byte, uint8 uc_port);
int32 IRI_QT_SaveActiveBufferData(uint16 l_dest_address,int32 activeData,uint8 BGTN_or_EGT,uint8 path,uint8 uc_port);
int32 IRI_QT_GetActiveBufferData(uint16 source_add,uint32 *activeBGTNTableData,uint32 *activeEGTTableData,uint8 path,uint8 uc_port);
void IRI_QT_IIBRAM_Write(uint8 uc_port, uint32 offset, uint32 data, uint32 bit_enable);

//fdq adaptation function
int32 QT_UpdateFDQ( int32 *la_LocalToneBuf, int16 s_phyToneValue, int32 *pla_FftBuf, uint32 ul_BGT, uint8 uc_port);

//warpper function prototypes
extern int32 ZEP_ILV_GetWordFromTxDTB(int16 s_lp, uint32 *pul_word, uint8 uc_port);
extern int32 IRI_FTB_TxWriteIFFT(int32 realValue, int32 imagValue,uint16 toneValue,uint8 uc_port);
extern int32 IRI_FTB_ReadRxFFT(int32 *pla_Rx_OutputArray, uint8 bufferBank, uint8 uc_port);
extern int32 IRI_FTB_ReadRxFFT_2(int32 *pla_Rx_OutputArray, uint8 uc_port);
extern ZEP_ILV_CaptureRMetric(uint8 rmetric, uint8 uc_port);  // this is a function defined in ILV BM
extern int32 ZEP_ILV_PutWordToRxDTB(int16 s_lp, uint32 ul_word,uint8 uc_port);
extern int32 ZEP_ILV_GetPRBSByteFromTxDTB(uint32 us_rd_addr, uint8 *pul_byte, uint8 uc_port);



// Iridia-QT operation function prototypes
int32 round_qt(int32 L_var, int16 s_bit_position);
acc_qt round64_qt(acc_qt acc_var, int16 s_bit_position);
int32 sature_qt(int32 l_var, int16 s_bitwidth);
acc_qt sature64_qt(acc_qt acc_var, int16 s_bitwidth);
int32 add_qt(int32 L_var1, int32 L_var2);
uint8 XLSBs_ge_YLSBs(int16 s_X, int16 s_Y);

void IRI_QT_FillActiveFBTTable(uint16 l_dest_address,int16 activeFeedbackToneAddress,uint8 gs_FBTIndex,uint8 uc_port);
int32 IRI_QT_searchRxActiveBGTTable(uint16 segmentTone,uint16 search_Start,uint16 search_End,int16 *activeFeedbackToneAddress,uint8 uc_port);
int32 IRI_QT_CopyRxPRBSRegisters(int32 l_RxPRBSStateRTV0, int32 l_RxPRBSStateRTV1, uint8 uc_port);

//Verification functions needed for ASIC. Not used in BM

void GetActiveTxBGT_Table (uint32 *us_BGTN, uint8 uc_port);
void GetActiveRxBGT_Table (uint32 *us_BGT, uint8 uc_port);
void GetActiveFBT_Table(uint32 *us_FBT, uint8 uc_port);
void GetActiveEGT_Table(uint8 *us_EGT, uint8 uc_port);


#endif // _QT_PRIVATE_H
