/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_ram.h
*
*   Header file for Iridia-QT RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_RAM_H
#define _QT_RAM_H

#include "qt_memmap.h"


// Iridia-QT RAM block IDs
#define  IRI_QT_MIN_RAM_ID                   (0)

#define IRI_QT_RAM_ACTIVE_BGTN_ID            (0)
#define IRI_QT_RAM_TX_ACTIVE_EGT_ID          (1)

#define IRI_QT_RAM_FDQ_MANT_ID               (3)
#define IRI_QT_RAM_FDQ_EXP_ID             (4)

#define IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_ID         (9)
#define IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_ID         (10)
#define IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_ID       (11)
#define IRI_QT_RAM_RX_XY_DECISION_ID            (12)
#define IRI_QT_RAM_RX_SURVIVOR_PATH_ID          (13)
#define IRI_QT_RAM_RX_NOISY_POINT_SPAD_ID       (14)
#define IRI_QT_RAM_RX_VITERBI_DECISION_ID       (15)

#define IRI_QT_RAM_RX_NOISE_ACCMR_LSW_ID           (5)
#define IRI_QT_RAM_RX_NOISE_ACCMR_MSW_ID           (6)

#define IRI_QT_RAM_RX_FEEDBACK_TONE_ID          (17)
#define IRI_QT_RAM_RX_FINAL_DECISION_ID            (18)

#define IRI_QT_RAM_RX_FDQASPH_ID (19)
#define IRI_QT_RAM_RX_FDQASPL_ID (20)

#define  IRI_QT_MAX_RAM_ID          (IRI_QT_RAM_RX_FDQASPL_ID)

// Iridia-QT Register IDs
#define  IRI_QT_MIN_REG_ID          (IRI_QT_MAX_RAM_ID + 1)

// Global Registers

#define IRI_QT_REG_TX_ENABLE_ID        (IRI_QT_MIN_REG_ID+0x00)


#define IRI_QT_REG_RX_ENABLE_ID        (IRI_QT_MIN_REG_ID+0x03)

#define IRI_QT_REG_RX_NSC_ID           (IRI_QT_MIN_REG_ID+0x06)

#define  IRI_QT_REG_RX_LUT_CTRL_ID     (IRI_QT_MIN_REG_ID+0x07)
#define  IRI_QT_REG_RX_DMULT0_ID       (IRI_QT_MIN_REG_ID+0x08)
#define  IRI_QT_REG_RX_DMULT1_ID       (IRI_QT_MIN_REG_ID+0x09)
#define  IRI_QT_REG_RX_DMULT2_ID       (IRI_QT_MIN_REG_ID+0x0A)
#define  IRI_QT_REG_RX_DMULT3_ID       (IRI_QT_MIN_REG_ID+0x0B)
#define  IRI_QT_REG_RX_PLUT6_0_ID         (IRI_QT_MIN_REG_ID+0x0C)
#define  IRI_QT_REG_RX_PLUT6_1_ID         (IRI_QT_MIN_REG_ID+0x0D)
#define  IRI_QT_REG_RX_PLUT5_0_ID         (IRI_QT_MIN_REG_ID+0x0E)
#define  IRI_QT_REG_RX_PLUT5_1_ID         (IRI_QT_MIN_REG_ID+0x0F)
#define  IRI_QT_REG_RX_LUT_ERR_ID         (IRI_QT_MIN_REG_ID+0x10)

#define  IRI_QT_REG_RX_PRBS_CTRL_ID       (IRI_QT_MIN_REG_ID+0x11)
#define  IRI_QT_REG_RX_PRBS0_ID        (IRI_QT_MIN_REG_ID+0x12)
#define  IRI_QT_REG_RX_PRBS1_ID        (IRI_QT_MIN_REG_ID+0x13)
#define  IRI_QT_REG_ABGT_OFFSET_ID        (IRI_QT_MIN_REG_ID+0x14)






#define  IRI_QT_NUM_GLOBAL_REGISTERS         16

// Tx Registers

#define  IRI_QT_TXPRAM_REGISTERS_ID       (IRI_QT_REG_ABGT_OFFSET_ID+0x01)

#define IRI_QT_REG_TX_CNFG_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x00)
#define  IRI_QT_REG_TX_TCM_CTRL_ID        (IRI_QT_TXPRAM_REGISTERS_ID+0x01)
#define  IRI_QT_REG_TX_MISC_ID            (IRI_QT_TXPRAM_REGISTERS_ID+0x02)
#define  IRI_QT_REG_TX_ACTIVE_ADDR_ID        (IRI_QT_TXPRAM_REGISTERS_ID+0x03)
#define  IRI_QT_REG_TX_LP0_BITS_ID        (IRI_QT_TXPRAM_REGISTERS_ID+0x04)
#define  IRI_QT_REG_TX_LP1_BITS_ID        (IRI_QT_TXPRAM_REGISTERS_ID+0x05)
#define  IRI_QT_REG_TX_LP2_BITS_ID        (IRI_QT_TXPRAM_REGISTERS_ID+0x06)
#define  IRI_QT_REG_TX_DUMMY_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x07)
#define  IRI_QT_REG_TX_LP0_BIT_FIFO_ID                   (IRI_QT_TXPRAM_REGISTERS_ID+0x08)
#define  IRI_QT_REG_TX_LP1_BIT_FIFO_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x09)
#define  IRI_QT_REG_TX_LP2_BIT_FIFO_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x0A)

#define  IRI_QT_REG_TX_PILOT_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x0B)
#define  IRI_QT_REG_TX_PTINDEX_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x0C)
#define  IRI_QT_REG_TX_PRBS_ID            (IRI_QT_TXPRAM_REGISTERS_ID+0x0D)
#define  IRI_QT_REG_TX_PRBS_MISC_ID       (IRI_QT_TXPRAM_REGISTERS_ID+0x0E)
#define  IRI_QT_REG_TX_PRBS_POLY_ID       (IRI_QT_TXPRAM_REGISTERS_ID+0x0F)
#define  IRI_QT_REG_TX_PRBS_DATA0_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x10)
#define  IRI_QT_REG_TX_PRBS_DATA1_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x11)
#define  IRI_QT_REG_TX_PRBS_DATA2_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x12)
#define  IRI_QT_REG_TX_PRBS_DATA3_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x13)
#define  IRI_QT_REG_TX_PRBS_DATA4_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x14)
#define  IRI_QT_REG_TX_PRBS_DATA5_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x15)
#define  IRI_QT_REG_TX_PRBS_DATA6_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x16)
#define  IRI_QT_REG_TX_PRBS_DATA7_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x17)

#define  IRI_QT_REG_TX_REF_GAIN_ID        (IRI_QT_TXPRAM_REGISTERS_ID+0x18)
#define  IRI_QT_REG_TX_NYQ_TONE_DATA_ID            (IRI_QT_TXPRAM_REGISTERS_ID+0x19)

#define IRI_QT_REG_TX_CG0_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x1A)
#define IRI_QT_REG_TX_CG1_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x1B)
#define IRI_QT_REG_TX_CG2_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x1C)
#define IRI_QT_REG_TX_CG3_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x1D)
#define IRI_QT_REG_TX_CG4_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x1E)
#define IRI_QT_REG_TX_CG5_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x1F)
#define IRI_QT_REG_TX_CG6_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x20)
#define IRI_QT_REG_TX_CG7_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x21)
#define IRI_QT_REG_TX_CG8_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x22)
#define IRI_QT_REG_TX_CG9_ID           (IRI_QT_TXPRAM_REGISTERS_ID+0x23)
#define IRI_QT_REG_TX_CG10_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x24)
#define IRI_QT_REG_TX_CG11_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x25)
#define IRI_QT_REG_TX_CG12_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x26)
#define IRI_QT_REG_TX_CG13_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x27)
#define IRI_QT_REG_TX_CG14_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x28)
#define IRI_QT_REG_TX_CG15_ID          (IRI_QT_TXPRAM_REGISTERS_ID+0x29)

#define  IRI_QT_REG_TX_IFFTZ_RNG0_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x2A)
#define  IRI_QT_REG_TX_IFFTZ_RNG1_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x2B)
#define  IRI_QT_REG_TX_IFFTZ_RNG2_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x2C)
#define  IRI_QT_REG_TX_IFFTZ_RNG3_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x2D)
#define  IRI_QT_REG_TX_IFFTZ_RNG4_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x2E)
#define  IRI_QT_REG_TX_IFFTZ_RNG5_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x2F)


#define IRI_QT_REG_TX_TONEZERO_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x30)
#define IRI_QT_REG_TX_DCI_CTRL_ID         (IRI_QT_TXPRAM_REGISTERS_ID+0x31)


//#define   IRI_QT_NUM_TXPRAM_REGISTERS         (IRI_QT_TXPRAM_REGISTERS_ID-IRI_QT_REG_TX_DRTR_RNG5_ID+1)
#define  IRI_QT_NUM_TXPRAM_REGISTERS         50

#define  IRI_QT_RXPRAM_REGISTERS_ID       (IRI_QT_REG_TX_DCI_CTRL_ID+0x01)

//RxPram registers

#define IRI_QT_REG_RX_CNFG_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x00)
#define  IRI_QT_REG_RX_TCM_CTRL_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x01)
#define  IRI_QT_REG_RX_MISC_ID            (IRI_QT_RXPRAM_REGISTERS_ID+0x02)
#define  IRI_QT_REG_RX_ACTIVE_ADDR_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x03)
#define  IRI_QT_REG_RX_LP0_BITS_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x04)
#define  IRI_QT_REG_RX_LP1_BITS_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x05)
#define  IRI_QT_REG_RX_LP2_BITS_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x06)
#define  IRI_QT_REG_RX_DUMMY_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x07)
#define  IRI_QT_REG_RX_LP0_BIT_FIFO_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x08)
#define  IRI_QT_REG_RX_LP1_BIT_FIFO_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x09)
#define  IRI_QT_REG_RX_LP2_BIT_FIFO_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x0A)


#define  IRI_QT_REG_RX_DPRBS_MISC_ID         (IRI_QT_RXPRAM_REGISTERS_ID+0x0B)
#define  IRI_QT_REG_RX_DPRBS_POLY_ID         (IRI_QT_RXPRAM_REGISTERS_ID+0x0C)
#define  IRI_QT_REG_RX_FD_RNG0_ID            (IRI_QT_RXPRAM_REGISTERS_ID+0x0D)
#define  IRI_QT_REG_RX_FD_RNG1_ID            (IRI_QT_RXPRAM_REGISTERS_ID+0x0E)
#define  IRI_QT_REG_RX_FD_RNG1_BASE_ID       (IRI_QT_RXPRAM_REGISTERS_ID+0x0F)
#define  IRI_QT_REG_RX_NPR_IIBRAM_ID            (IRI_QT_RXPRAM_REGISTERS_ID+0x10)



#define  IRI_QT_REG_RX_QUAD0_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x11)
#define  IRI_QT_REG_RX_QUAD1_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x12)

#define  IRI_QT_REG_RX_SLOWDOWN_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x13)
#define  IRI_QT_REG_RX_PTINDEX_ID         (IRI_QT_RXPRAM_REGISTERS_ID+0x14)
#define  IRI_QT_REG_RX_PILOT_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x15)

#define  IRI_QT_REG_RX_FDQADAPT_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x16)

#define  IRI_QT_REG_RX_VECPOW_L_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x17)
#define  IRI_QT_REG_RX_VECPOW_H_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x18)
#define  IRI_QT_REG_RX_RMETRIC_CTL_ID     (IRI_QT_RXPRAM_REGISTERS_ID+0x19)
#define  IRI_QT_REG_RX_RMETRIC_VAL_ID     (IRI_QT_RXPRAM_REGISTERS_ID+0x1A)


#define IRI_QT_REG_RX_CG0_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x1B)
#define IRI_QT_REG_RX_CG1_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x1C)
#define IRI_QT_REG_RX_CG2_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x1D)
#define IRI_QT_REG_RX_CG3_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x1E)
#define IRI_QT_REG_RX_CG4_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x1F)
#define IRI_QT_REG_RX_CG5_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x20)
#define IRI_QT_REG_RX_CG6_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x21)
#define IRI_QT_REG_RX_CG7_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x22)
#define IRI_QT_REG_RX_CG8_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x23)
#define IRI_QT_REG_RX_CG9_ID           (IRI_QT_RXPRAM_REGISTERS_ID+0x24)
#define IRI_QT_REG_RX_CG10_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x25)
#define IRI_QT_REG_RX_CG11_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x26)
#define IRI_QT_REG_RX_CG12_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x27)
#define IRI_QT_REG_RX_CG13_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x28)
#define IRI_QT_REG_RX_CG14_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x29)
#define IRI_QT_REG_RX_CG15_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x2A)

#define  IRI_QT_REG_RX_PTINDEX1_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x2B)
#define  IRI_QT_REG_RX_PILOT1_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x2C)
#define  IRI_QT_REG_RX_PTINDEX2_ID        (IRI_QT_RXPRAM_REGISTERS_ID+0x2D)
#define  IRI_QT_REG_RX_PILOT2_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x2E)

#define  IRI_QT_REG_RX_FD_RNG0_CNT_35B_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x2F)
#define  IRI_QT_REG_RX_FD_RNG1_CNT_35B_ID          (IRI_QT_RXPRAM_REGISTERS_ID+0x30)

//#define   IRI_QT_NUM_RXPRAM_REGISTERS         (IRI_QT_RXPRAM_REGISTERS_ID-IRI_QT_REG_RX_RMETRIC_VAL_ID+1)
#define  IRI_QT_MAX_REG_ID             (IRI_QT_REG_RX_FD_RNG1_CNT_35B_ID)
#define  IRI_QT_NUM_RXPRAM_REGISTERS         49

extern IridiaQT_Global_Register_t  gt_IridiaQT_Global_Register;
extern IridiaQT_Global_Register_t gt_IridiaMultiportQT_Global_Register[4];
extern IridiaQT_TxPram_Register_t  gt_IridiaQT_TxPram_Register;
extern IridiaQT_TxPram_Register_t gt_IridiaMultiportQT_TxPram_Register[4];
extern IridiaQT_RxPram_Register_t  gt_IridiaQT_RxPram_Register;
extern IridiaQT_RxPram_Register_t gt_IridiaMultiportQT_RxPram_Register[4];

// Global Arrays
extern uint32 *IRI_QT_RAM_VirtualBaseAddr[IRI_QT_MAX_RAM_ID+1];
extern uint32 IRI_QT_RAM_PhysBaseAddr[IRI_QT_MAX_REG_ID+1];
extern uint32 IRI_QT_RAM_Size[IRI_QT_MAX_RAM_ID+1];
extern uint32 IRI_QT_RAM_Offset[IRI_QT_MAX_RAM_ID+1];
extern uint32 IRI_QT_RAM_Mask[IRI_QT_MAX_REG_ID+1];


extern uint8 IRI_QT_RAM_ACTIVE_BGTN_Unaligned[4][IRI_QT_RAM_ACTIVE_BGTN_SIZE+4];
extern uint8 *IRI_QT_RAM_ACTIVE_BGTN;

extern uint8 IRI_QT_RAM_TX_ACTIVE_EGT_Unaligned [4][IRI_QT_RAM_TX_ACTIVE_EGT_SIZE+4];
extern uint8 *IRI_QT_RAM_TX_ACTIVE_EGT;

extern uint8 IRI_QT_RAM_FDQ_MANT_Unaligned [4][IRI_QT_RAM_FDQ_MANT_SIZE+4];
extern uint8 *IRI_QT_RAM_FDQ_MANT;

extern uint8 IRI_QT_RAM_FDQ_EXP_Unaligned [4][IRI_QT_RAM_FDQ_EXP_SIZE+4];
extern uint8 *IRI_QT_RAM_FDQ_EXP;


extern uint8 IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_Unaligned [4][IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_MFDQ_FB_COEF_MANT;

extern uint8 IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_Unaligned [4][IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_MFDQ_FF_COEF_MANT;

extern uint8 IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_Unaligned [4][IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_MFDQ_FB_COEF_EXP;


extern uint8 IRI_QT_RAM_Rx_XY_DECISION_Unaligned [IRI_QT_RAM_RX_XY_DECISION_SIZE+4];
extern uint8 *IRI_QT_RAM_Rx_XY_DECISION;

extern uint8 IRI_QT_RAM_Rx_SURVIVOR_PATH_Unaligned [IRI_QT_RAM_RX_SURVIVOR_PATH_SIZE+4];
extern uint8 *IRI_QT_RAM_Rx_SURVIVOR_PATH;

extern uint8 IRI_QT_RAM_Rx_NOISY_POINT_SPAD_Unaligned [IRI_QT_RAM_RX_NOISY_POINT_SPAD_SIZE+4];
extern uint8 *IRI_QT_RAM_Rx_NOISY_POINT_SPAD;

extern uint8 IRI_QT_RAM_Rx_VITERBI_DECISION_Unaligned [IRI_QT_RAM_RX_VITERBI_DECISION_SIZE+4];
extern uint8 *IRI_QT_RAM_Rx_VITERBI_DECISION;

extern uint8 IRI_QT_RAM_RX_NOISE_ACCMR_LSW_Unaligned [4][IRI_QT_RAM_RX_NOISE_ACCMR_LSW_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_NOISE_ACCMR_LSW;

extern uint8 IRI_QT_RAM_RX_NOISE_ACCMR_MSW_Unaligned [4][IRI_QT_RAM_RX_NOISE_ACCMR_MSW_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_NOISE_ACCMR_MSW;

extern uint8 IRI_QT_RAM_RX_FEEDBACK_TONE_Unaligned [4][IRI_QT_RAM_RX_FEEDBACK_TONE_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_FEEDBACK_TONE;


extern uint8 IRI_QT_RAM_RX_FINAL_DECISION_Unaligned [4][IRI_QT_RAM_RX_FINAL_DECISION_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_FINAL_DECISION;

extern uint8 IRI_QT_RAM_RX_FDQASPL_Unaligned [4][IRI_QT_RAM_RX_FDQASPL_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_FDQASPL;

extern uint8 IRI_QT_RAM_RX_FDQASPH_Unaligned [4][IRI_QT_RAM_RX_FDQASPH_SIZE+4];
extern uint8 *IRI_QT_RAM_RX_FDQASPH;







#endif //_QT_RAM_H
