/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  qt_tcmdec.h
;
;  Header file for doing Trellis-based QAM decoding.
;
;***************************************************************************/

//================================================================
// Constants
//================================================================
#define TRELLIS_NSTATES 16

//Mei ????? should not be that high
#define MAX_TRELLIS_STAGES    (MAX_QT_RX_NUM_TONES>>1)

// TCM_DECODER_DEPTH=L specifies that the (i+L-1)st stage of the Trellis should be updated with new path metrics
// before making a decision on the ith decoded symbol.  Valid range is [1,sNTones/2].

//Mei ??? should this be 19
#define TCM_DECODER_DEPTH     (18)
#define SURVIVOR_PATH_DEPTH      (19)
#define XY_DECODE_FIFO_DEPTH  (20)

// Large constants used to effectively rule out illegal state transitions in Add/Compare/Select.
#define MAX_CUMPATH_METRIC 0x03ff
#define MAX_CUMPATH_METRIC_FINAL_STAGE 0x07ff

#define MAX(A,B) ((A) > (B) ? (A) : (B))
#define ExtractBit(data, bitnumber) ((data>>bitnumber) & 0x1)     // Extract one bit from a number. Evaluates to 0 or 1.
#define XOR ^
#define TONE_A 0
#define TONE_B 1

#define MASK_SIGNBIT       (1 << 11)
#define MAXIMUM_CPM        0xFFF
#define MAXIMUM_POSITIVE_CPM        0x7FF

#define INVALID_STATE_METRIC  0xFFFFFFFF


// =============================================================================
// Data structures
// =============================================================================

// Allocate one TrellisBranch structure for every node (i.e. every state of every stage) in the Trellis diagram.
typedef struct{
    int16   s_PrevState;      // Most likely previous state.
   uint32   ul_InputBits;     // Input bits u_i, i>=1, corresponding to transition from s_PrevState to this state.
    uint32  ul_metric;        // Path metric for most-likely path from start state to this state.
   int16 s_XAQuantized;    // 1st tone(A): X coord for quantized point.
   int16 s_YAQuantized;    // 2nd tone(A): Y coord for quantized point.
   int16 s_XBQuantized;    // 1st tone(B): X coord for quantized point.
   int16 s_YBQuantized;    // 2nd tone(B): Y coord for quantized point.
} TrellisBranch_t;


// Structure to store result of a 2D constellation decode.
typedef struct{
   int16 s_XQuantized;  // Closest constellation point.
   int16 s_YQuantized;  // Closest constellation point.
   uint16   us_InputBits;  // v_i (for Tone A) or w_i (for Tone B), i>=2.
   uint32   ul_metric2D;   // 2D branch (error) metric
} Decoded2DInput_t;

// Structure to store result of a 4D constellation decode.
typedef struct{
   uint32   ul_InputBits;  // u_i for i>=1.
   uint32   ul_metric4D;
   int16 s_XAQuantized; // 1st tone(A): X coord for quantized point.
   int16 s_YAQuantized; // 2nd tone(A): Y coord for quantized point.
   int16 s_XBQuantized; // 1st tone(B): X coord for quantized point.
   int16 s_YBQuantized; // 2nd tone(B): Y coord for quantized point.
} Decoded4DInput_t;


