/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qt_typedef.h
*
*   This file contains type definitions used by different files.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QT_TYPEDEF_H
#define _QT_TYPEDEF_H


#ifndef MULTI_TO_SINGLE
#define MULTI_TO_SINGLE

//#define Rev_2

#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
typedef unsigned short   bool;        //prefix b
#endif // _BASIC_TYPES

// define 64-bit accumulator type
#ifdef UNIX_PLATFORM
#define acc_qt long long
#define acct_qt_const(x) (acc_qt)(x##LL)
#else
#ifdef MSVC_ONLY
#define acc_qt __int64
#define acct_qt_const(x) (acc_qt)(x)
#else
#define acc_qt long
#define acct_qt_const(x) (acc_qt)(x)
#endif
#endif

// Structure used for Iridia-QT registers
typedef struct{


// IRI_QT_REG_TX_ENABLE

   int32 l_TxEnable;

// IRI_QT_REG_RX_ENABLE

   int32 l_RxEnable;


//IRI_QT_REG_IR_NSC

   int32 l_RxNumSubCarrierTones;

// IRI_QT_REG_RX_LUT_CTRL

   int32 l_RxQTLutEnable;
   int32 l_RxDSPLutEnable;

// IRI_QT_REG_RX_DMULT0
   int32 l_RxDirectMapLUT0;
   int32 l_RxDirectMapLUT1;
   int32 l_RxDirectMapLUT2;
   int32 l_RxDirectMapLUT3;

// IRI_QT_REG_RX_DMULT1
   int32 l_RxDirectMapLUT4;
   int32 l_RxDirectMapLUT5;
   int32 l_RxDirectMapLUT6;
   int32 l_RxDirectMapLUT7;

// IRI_QT_REG_RX_DMULT2

   int32 l_RxDirectMapLUT8;
   int32 l_RxDirectMapLUT9;
   int32 l_RxDirectMapLUT10;
   int32 l_RxDirectMapLUT11;

// IRI_QT_REG_RX_DMULT3
   int32 l_RxDirectMapLUT12;
   int32 l_RxDirectMapLUT13;
   int32 l_RxDirectMapLUT14;
   int32 l_RxDirectMapLUT15;

//IRI_QT_REG_RX_PLUT6_0

   int32 l_RxPartialLUTableSixOldMSBFieldZero;
   int32 l_RxPartialLUTableSixNewMSBFieldZero;
   int32 l_RxPartialLUTableSixOldMSBFieldOne;
   int32 l_RxPartialLUTableSixNewMSBFieldOne;

//IRI_QT_REG_RX_PLUT6_1

   int32 l_RxPartialLUTableSixOldMSBFieldTwo;
   int32 l_RxPartialLUTableSixNewMSBFieldTwo;
   int32 l_RxPartialLUTableSixOldMSBFieldThree;
   int32 l_RxPartialLUTableSixNewMSBFieldThree;

//IRI_QT_REG_RX_PLUT5_0

   int32 l_RxPartialLUTableFiveOldMSBFieldZero;
   int32 l_RxPartialLUTableFiveNewMSBFieldZero;
   int32 l_RxPartialLUTableFiveOldMSBFieldOne;
   int32 l_RxPartialLUTableFiveNewMSBFieldOne;

//IRI_QT_REG_RX_PLUT5_1

   int32 l_RxPartialLUTableFiveOldMSBFieldTwo;
   int32 l_RxPartialLUTableFiveNewMSBFieldTwo;
   int32 l_RxPartialLUTableFiveOldMSBFieldThree;
   int32 l_RxPartialLUTableFiveNewMSBFieldThree;

//IRI_QT_REG_RX_LUT_ERR

   int32 l_DspInvalidAddr;
   int32 l_DspMemAccessError;
   int32 l_DspDisabledDMLUTError;
   int32 l_RxTOTTone;
   int32 l_RxMemAccessError;
   int32 l_RxDisabledDMLUTError;

// IRI_QT_REG_RX_PRBS_CTRL

   int32 l_LatchPRBS0;
   int32 l_LatchPRBS1;

// IRI_QT_REG_RX_PRBS0

   int32 l_RxRNG0PRBSState;

// IRI_QT_REG_RX_PRBS1

   int32 l_RxRNG1PRBSState;

// IRI_QT_REG_ABGT_OFFSET_ID

   int32 l_TxAbgtOffset;
   int32 l_RxAbgtOffset;


} IridiaQT_Global_Register_t;


typedef struct{


   // IRI_QT_REG_TX_CNFG
   int32 l_TxNumIfftTones;
   int32 l_TxNumSubCarrierTones;
   int32 l_TxTrellisLastTone;


   // IRI_QT_REG_TX_TCM_CTRL
   int32 l_TxTrellisEnable;
   int32 l_TxTrellisOneBitTonePairs;

   // IRI_QT_REG_TX_MISC

   int32 l_TxPrbsAlt;
   int32 l_TxLpOrder;
   int32 l_TxOversamplingType;
   int32 l_TxFIFOPushError;
   int32 l_TxFIFOPopError;
   int32 l_TxGainScaleOverflow;
   int32 l_TxDCIError;
   int32 l_Tx4QAMSenseSelect;
   int32 l_TxPRBSGENEnable;
   int32 l_TxREFGENGainEnable;
   int32 l_TxPingPongBit;



//IRI_QT_REG_TX_ACTIVE_ADDR

   int32 l_TxMinAddr;
   int32 l_TxMaxAddr;


   // IRI_QT_REG_TX_LP0_BITS
   int32 l_TxLp0Bits;

   // IRI_QT_REG_TX_LP1_BITS
   int32 l_TxLp1Bits;

   // IRI_QT_REG_TX_LP1_BITS
   int32 l_TxLp2Bits;

   // IRI_QT_REG_TX_DUMMY
   int32 l_TxLp1DummyBits;
   int32 l_TxLp0DummyBits;

   // IRI_QT_REG_TX_LP0_BIT_FIFO
   int32 l_TxLp0ValidBits;
   int32 l_TxLp0BitExtractState;

   // IRI_QT_REG_TX_LP1_BIT_FIFO
   int32 l_TxLp1ValidBits;
   int32 l_TxLp1BitExtractState;

   // IRI_QT_REG_TX_LP2_BIT_FIFO
   int32 l_TxLp2ValidBits;
   int32 l_TxLp2BitExtractState;

   // IRI_QT_REG_TX_PILOT
   int32 l_TxPilotReal;
   int32 l_TxPilotImag;

   // IRI_QT_REG_TX_PTINDEX
   int32 l_TxPilotpoint;
   int32 l_TxPilotInsertEnable;
   int32 l_TxPilotIndex;

   // IRI_QT_REG_TX_PRBS
   int32 l_TxPRBSState;

   // IRI_QT_REG_TX_PRBS_MISC
   int32 l_TxPRBSScrambling11;
   int32 l_TxPRBSScrambling10;
   int32 l_TxPRBSScrambling01;
   int32 l_TxPRBSScrambling00;
   int32 l_TxPRBSModulo;
   int32 l_TxPRBSOutput;
   int32 l_TxPRBSSkip;
   int32 l_TxPRBSReset;
   int32 l_TxPRBSInvert;
   int32 l_TxPRBSPilotRotate;
   int32 l_TxPRBSLength;
        int32 l_TxPRBSNssi1;

   // IRI_QT_REG_TX_PRBS_POLY
   int32 l_TxPRBSPolynomial;

   // IRI_QT_REG_TX_PRBS_DATA
   int32 l_TxPRBS2BitInput[128];

   // IRI_QT_REG_TX_REF_GAIN
   int32 l_TxREFGain;

   // IRI_QT_REG_TX_NYQ_TONE_DATA
   int32 l_TxNyqToneData;


// IRI_QT_REG_TX_CG0

   int32  l_TxCG0GainValue;
   int32  l_TxCG0ShiftValue ;

// IRI_QT_REG_TX_CG1

   int32  l_TxCG1GainValue;
   int32  l_TxCG1ShiftValue ;

// IRI_QT_REG_TX_CG2

   int32  l_TxCG2GainValue;
   int32  l_TxCG2ShiftValue ;

// IRI_QT_REG_TX_CG3

   int32  l_TxCG3GainValue;
   int32  l_TxCG3ShiftValue ;

// IRI_QT_REG_TX_CG4

   int32  l_TxCG4GainValue;
   int32  l_TxCG4ShiftValue ;

// IRI_QT_REG_TX_CG5

   int32  l_TxCG5GainValue;
   int32  l_TxCG5ShiftValue ;

// IRI_QT_REG_TX_CG6

   int32  l_TxCG6GainValue;
   int32  l_TxCG6ShiftValue ;

// IRI_QT_REG_TX_CG7

   int32  l_TxCG7GainValue;
   int32  l_TxCG7ShiftValue ;

// IRI_QT_REG_TX_CG8

   int32  l_TxCG8GainValue;
   int32  l_TxCG8ShiftValue ;

// IRI_QT_REG_TX_CG9

   int32  l_TxCG9GainValue;
   int32  l_TxCG9ShiftValue ;

// IRI_QT_REG_TX_CG10

   int32  l_TxCG10GainValue;
   int32  l_TxCG10ShiftValue ;

// IRI_QT_REG_TX_CG11

   int32  l_TxCG11GainValue;
   int32  l_TxCG11ShiftValue ;

// IRI_QT_REG_TX_CG12

   int32  l_TxCG12GainValue;
   int32  l_TxCG12ShiftValue ;

// IRI_QT_REG_TX_CG13

   int32  l_TxCG13GainValue;
   int32  l_TxCG13ShiftValue ;

// IRI_QT_REG_TX_CG14

   int32  l_TxCG14GainValue;
   int32  l_TxCG14ShiftValue ;

// IRI_QT_REG_TX_CG15

   int32  l_TxCG15GainValue;
   int32  l_TxCG15ShiftValue ;


// IRI_QT_REG_TX_IFFTZ_RNG0_ADDR

   int32 l_IfftEnableRangeZero;
   int32 l_IfftRangeZeroStartTones;
   int32 l_IfftRangeZeroEndTones;

// IRI_QT_REG_TX_IFFTZ_RNG1_ADDR
   int32 l_IfftEnableRangeOne;
   int32 l_IfftRangeOneStartTones;
   int32 l_IfftRangeOneEndTones;

// IRI_QT_REG_TX_IFFTZ_RNG2_ADDR
   int32 l_IfftEnableRangeTwo;
   int32 l_IfftRangeTwoStartTones;
   int32 l_IfftRangeTwoEndTones;

// IRI_QT_REG_TX_IFFTZ_RNG3_ADDR
   int32 l_IfftEnableRangeThree;
   int32 l_IfftRangeThreeStartTones;
   int32 l_IfftRangeThreeEndTones;

// IRI_QT_REG_TX_IFFTZ_RNG4_ADDR
   int32 l_IfftEnableRangeFour;
   int32 l_IfftRangeFourStartTones;
   int32 l_IfftRangeFourEndTones;

// IRI_QT_REG_TX_IFFTZ_RNG5_ADDR

   int32 l_IfftEnableRangeFive;
   int32 l_IfftRangeFiveStartTones;
   int32 l_IfftRangeFiveEndTones;

// IRI_QT_REG_TX_TONEZERO

   int32  l_TxToneZeroReal;
   int32  l_TxToneZeroImag ;

// IRI_QT_REG_TX_DCI_CTRL

   int32 l_TxDCIMinAddr;
   int32 l_TxDCIMaxAddr;
   int32 l_TxDCIEnable;



} IridiaQT_TxPram_Register_t;

typedef struct {

   // IRI_QT_REG_RX_CNFG

   int32 l_RxTraceBack_Ena;
   int32 l_RxTraceBack_Bp;

   // IRI_QT_REG_RX_TCM_CTRL
   int32 l_RxTrellisEnable;
   int32 l_RxTrellisOneBitTonePairs;
   int32 l_RxFirst1BitToneIndex;

   // IRI_QT_REG_RX_MISC

   int32 l_RxDualFft;
   int32 l_RxNPRErrFmt;
   int32 l_RxNprDecim;
   int32 l_RxNPRShift;
   int32 l_RxReImAccum;
   int32 l_RxNPRAccum;
   int32 l_RxVecpowAccmrEnable;
   int32 l_RxLpOrder;
   int32 l_RxMFDQFeedbackToneTableDisable;
   int32 l_RxBitStufferDisable;
   int32 l_RxSFDQBypass;
   int32 l_RxMFDQFeedForwardBypass;
   int32 l_RxGainScaleBypass;
   int32 l_RxMFDQFeedBackBypass;
   int32 l_RxMFDQFeedBackToneTableError;
   int32 l_RxMFDQFeedBackOverflow;
   int32 l_RxMFDQFeedForwardOverflow;
   int32 l_RxGainScaleOverflow;
   int32 l_RxTRTDisable;
   int32 l_Rx4QAMSenseSelect;


   // IRI_QT_REG_RX_ACTIVE_ADDR
   int32 l_RxMaxAddr;
   int32 l_RxMinAddr;

   // IRI_QT_REG_RX_LP0_BITS
   int32 l_RxLp0Bits;

   // IRI_QT_REG_RX_LP1_BITS
   int32 l_RxLp1Bits;

   // IRI_QT_REG_RX_LP2_BITS
   int32 l_RxLp2Bits;


   // IRI_QT_REG_RX_DUMMY
   int32 l_RxLp1DummyBits;
   int32 l_RxLp0DummyBits;

   // IRI_QT_REG_RX_LP0_BIT_FIFO
   int32 l_RxLp0ValidBits;
   int32 l_RxLp0BitExtractState;

   // IRI_QT_REG_RX_LP1_BIT_FIFO
   int32 l_RxLp1ValidBits;
   int32 l_RxLp1BitExtractState;

   // IRI_QT_REG_RX_LP2_BIT_FIFO
   int32 l_RxLp2ValidBits;
   int32 l_RxLp2BitExtractState;


   // IRI_QT_REG_RX_DPRBS_MISC
   int32 l_RxDPRBSRotation11;
   int32 l_RxDPRBSRotation10;
   int32 l_RxDPRBSRotation01;
   int32 l_RxDPRBSRotation00;
   int32 l_RxDPRBSOutput;
   int32 l_RxDPRBSInvert;
   int32 l_RxDPRBSLength;

   // IRI_QT_REG_RX_DPRBS_POLY
   int32 l_RxDPRBSPolynomial;


   // IRI_QT_REG_RX_FD_RNG0
   int32 l_RxRTVBuffer0Ena;
   int32 l_RxRTVBuffer0Unrot;
   int32 l_RxRTVBuffer0Format;
   int32 l_RxQuadCnt0;
   int32 l_RxRTVBuffer0DataType;
   int32 l_RxRTVBuffer0Count;
   int32 l_RxRTVBuffer0Offset;

// IRI_QT_REG_RX_FD_RNG1
   int32 l_RxRTVBuffer1Ena;
   int32 l_RxRTVBuffer1Unrot;
   int32 l_RxRTVBuffer1Format;
   int32 l_RxQuadCnt1;
   int32 l_RxRTVBuffer1DataType;
   int32 l_RxRTVBuffer1Count;
   int32 l_RxRTVBuffer1Offset;
   int32 l_RxRTVBuffer1Base;

   // IRI_NPR_IIBRAM
   int32 l_NprIibramEna;
   int32 l_NprIibramBase;

   // IRI_QT_REG_RX_QUAD0
   int32 l_RxRTV0Quadrant3Match;
   int32 l_RxRTV0Quadrant2Match;
   int32 l_RxRTV0Quadrant1Match;
   int32 l_RxRTV0Quadrant0Match;

   // IRI_QT_REG_RX_QUAD1
   int32 l_RxRTV1Quadrant3Match;
   int32 l_RxRTV1Quadrant2Match;
   int32 l_RxRTV1Quadrant1Match;
   int32 l_RxRTV1Quadrant0Match;

   // IRI_QT_REG_RX_SLOWDOWN
   int32 l_RxSlowdown;

// IRI_QT_REG_RX_PTINDEX
   int32 l_RxPtEna;
   int32 l_RxPtIndex;

// IRI_QT_REG_RX_PILOT
   int32 l_RxPilot;//defining all 32 bits of RX_PTINDEX


//    IRI_QT_REG_RX_FDQADAPT
   int32 l_RxAdaptRng;
   int32 l_RxMuType;
   int32 l_RxLMSSaturationStatus;
   int32 l_RxLMSNoshift;
   int32 l_RxFDQShift;
   int32 l_RxForcePositiveAdapt;
   int32 l_RxToneAdapt;
   int32 l_RxLMSSigned;
   int32 l_RxLMSAdapt;


// IRI_QT_REG_RX_VECPOW_L

   int32 l_RxLowerVectorPower;

// IRI_QT_REG_RX_VECPOW_H
   int32 l_RxUpperVectorPower;

// IRI_QT_REG_RX_RMETRIC_CTL

   int32 l_RxMetricNorm;
   int32 l_RxMetricScale;

// IRI_QT_REG_RX_RMETRIC_VAL
   int32 l_RxMetricValue;


// IRI_QT_REG_RX_CG0

   int32  l_RxCG0GainValue;
   int32  l_RxCG0ShiftValue ;

// IRI_QT_REG_RX_CG1

   int32  l_RxCG1GainValue;
   int32  l_RxCG1ShiftValue ;

// IRI_QT_REG_RX_CG2

   int32  l_RxCG2GainValue;
   int32  l_RxCG2ShiftValue ;

// IRI_QT_REG_RX_CG3

   int32  l_RxCG3GainValue;
   int32  l_RxCG3ShiftValue ;

// IRI_QT_REG_RX_CG4

   int32  l_RxCG4GainValue;
   int32  l_RxCG4ShiftValue ;

// IRI_QT_REG_RX_CG5

   int32  l_RxCG5GainValue;
   int32  l_RxCG5ShiftValue ;

// IRI_QT_REG_RX_CG6

   int32  l_RxCG6GainValue;
   int32  l_RxCG6ShiftValue ;

// IRI_QT_REG_RX_CG7

   int32  l_RxCG7GainValue;
   int32  l_RxCG7ShiftValue ;

// IRI_QT_REG_RX_CG8

   int32  l_RxCG8GainValue;
   int32  l_RxCG8ShiftValue ;

// IRI_QT_REG_RX_CG9

   int32  l_RxCG9GainValue;
   int32  l_RxCG9ShiftValue ;

// IRI_QT_REG_RX_CG10

   int32  l_RxCG10GainValue;
   int32  l_RxCG10ShiftValue ;

// IRI_QT_REG_RX_CG11

   int32  l_RxCG11GainValue;
   int32  l_RxCG11ShiftValue ;

// IRI_QT_REG_RX_CG12

   int32  l_RxCG12GainValue;
   int32  l_RxCG12ShiftValue ;

// IRI_QT_REG_RX_CG13

   int32  l_RxCG13GainValue;
   int32  l_RxCG13ShiftValue ;

// IRI_QT_REG_RX_CG14

   int32  l_RxCG14GainValue;
   int32  l_RxCG14ShiftValue ;

// IRI_QT_REG_RX_CG15

   int32  l_RxCG15GainValue;
   int32  l_RxCG15ShiftValue ;


} IridiaQT_RxPram_Register_t;


// Structure used for Iridia-QT latencies
typedef struct {

   // IRI_QT_TX
   uint16 us_QAMENC;
   uint16 us_TCM_QAMENC;

   // IRI_QT_RX
   uint16 us_QAMDEC;
   uint16 us_TCM_QAMDEC;

} IridiaQT_Latencies_t;





#endif // _MULTI_TO_SINGLE
#endif //QT_TYPEDEF_H
