/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: QTP_const.h
*
*   This file contains constant definitions for the Iridia-QTP BM.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QTP_CONST_H
#define _QTP_CONST_H

#ifndef MIN
#define MIN(A,B) ((A) > (B) ? (B) : (A))
#endif // MIN

//==============================================================================
// Iridia-QTP Constants
//==============================================================================

// PRBS Constants
#define PRBS_OUTPUT_BITS      (2)                        // Number of output bits to generate each time the PRBS generator runs
#define MAX_PRBS_OUTPUT_BITS  (15)


//  Iridia-QTP Definitions

#define     IRI_QTP_MAX_NUM_PORTS      4

//  Iridia-QTP TX

#define MAX_QTP_TX_NUM_TONES           4096

//  Iridia-QTP RX

#define MAX_QTP_RX_NUM_TONES           4096


#define TX_PATH  (1)
#define RX_PATH  (1 - TX_PATH)


#define  IRI_QTP_TX_IDLE      (0)
#define  IRI_QTP_TX_BUSY      (1)
#define  TX_QTP_ENCODE     (1)

#define  IRI_QTP_RX_IDLE      (0)
#define  IRI_QTP_RX_BUSY      (1)
#define  RX_QTP_DECODE     (1)

#define  IRI_QTP_TX_LATENCY         (1)

// Rx Latencies
#define  IRI_QTP_RX_LATENCY         (1)


// Byte masks
#define QTP_BYTE0_MASK     (0x000000FF)
#define QTP_BYTE1_MASK     (0x0000FF00)
#define QTP_BYTE2_MASK     (0x00FF0000)
#define QTP_BYTE3_MASK     (0xFF000000)
#define QTP_LOWER_WORD_MASK   (QTP_BYTE1_MASK | QTP_BYTE0_MASK)
#define QTP_UPPER_WORD_MASK   (QTP_BYTE3_MASK | QTP_BYTE2_MASK)
#define QTP_LONGWORD_MASK  (QTP_UPPER_WORD_MASK | QTP_LOWER_WORD_MASK)

// Byte enable masks
#define QTP_NO_BYTE_EN     (0x0)
#define QTP_BYTE0_EN       (0x1)
#define QTP_BYTE1_EN       (0x2)
#define QTP_BYTE2_EN       (0x4)
#define QTP_BYTE3_EN       (0x8)
#define QTP_LOWER_WORD_EN  (QTP_BYTE1_EN | QTP_BYTE0_EN)
#define QTP_UPPER_WORD_EN  (QTP_BYTE3_EN | QTP_BYTE2_EN)
#define QTP_LONGWORD_EN    (QTP_UPPER_WORD_EN | QTP_LOWER_WORD_EN)

// Register bit masks
#define QTP_MASK_BIT0      (0x00000001)
#define QTP_MASK_BIT1      (0x00000002)
#define QTP_MASK_BIT2      (0x00000004)
#define QTP_MASK_BIT3      (0x00000008)
#define QTP_MASK_BIT4      (0x00000010)
#define QTP_MASK_BIT5      (0x00000020)
#define QTP_MASK_BIT6      (0x00000040)
#define QTP_MASK_BIT7      (0x00000080)
#define QTP_MASK_BIT8      (0x00000100)
#define QTP_MASK_BIT9      (0x00000200)
#define QTP_MASK_BIT10     (0x00000400)
#define QTP_MASK_BIT11     (0x00000800)
#define QTP_MASK_BIT12     (0x00001000)
#define QTP_MASK_BIT13     (0x00002000)
#define QTP_MASK_BIT14     (0x00004000)
#define QTP_MASK_BIT15     (0x00008000)
#define QTP_MASK_BIT16     (0x00010000)
#define QTP_MASK_BIT17     (0x00020000)
#define QTP_MASK_BIT18     (0x00040000)
#define QTP_MASK_BIT19     (0x00080000)
#define QTP_MASK_BIT20     (0x00100000)
#define QTP_MASK_BIT21     (0x00200000)
#define QTP_MASK_BIT22     (0x00400000)
#define QTP_MASK_BIT23     (0x00800000)
#define QTP_MASK_BIT24     (0x01000000)
#define QTP_MASK_BIT25     (0x02000000)
#define QTP_MASK_BIT26     (0x04000000)
#define QTP_MASK_BIT27     (0x08000000)
#define QTP_MASK_BIT28     (0x10000000)
#define QTP_MASK_BIT29     (0x20000000)
#define QTP_MASK_BIT30     (0x40000000)
#define QTP_MASK_BIT31     (0x80000000)

#define QTP_MASK_BIT1_2    (QTP_MASK_BIT1 | QTP_MASK_BIT2 )

//==============================================================================
// Iridia-QTP Flags
//==============================================================================
#ifndef TRUE
#define TRUE      (1)
#endif
#ifndef FALSE
#define FALSE     (0)
#endif

#define QTP_TX_PATH  (1)
#define QTP_RX_PATH  (1 - QTP_TX_PATH)

#define IRI_QTP_MAX_NUM_PORTS 4

#ifdef VRX518
#define IRI_QTP_TONETABLE_MASK (0x1FFF)
#define ACT_EGT_TONE_LSB_OFFSET (3)
#endif
#endif //_QTP_CONST_H
