/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: QTP_private.h
*
*   This file contains private functions and variables which are visible
*   by the Iridia-QTP BM only.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QTP_PRIVATE_H
#define _QTP_PRIVATE_H

#include "qtp_typedef.h"
// #include "qtp_io_typedef.h"
#include "qtp_const.h"

//==============================================================================
// Iridia-QTP private variables
//==============================================================================


extern IridiaQTP_Global_Register_t  gt_IridiaQTP_Global_Register;
extern IridiaQTP_Global_Register_t gt_IridiaMultiportQTP_Global_Register[IRI_QTP_MAX_NUM_PORTS];
extern IridiaQTP_TxPram_Register_t  gt_IridiaQTP_TxPram_Register;
extern IridiaQTP_TxPram_Register_t gt_IridiaMultiportQTP_TxPram_Register[IRI_QTP_MAX_NUM_PORTS];
extern IridiaQTP_RxPram_Register_t  gt_IridiaQTP_RxPram_Register;
extern IridiaQTP_RxPram_Register_t gt_IridiaMultiportQTP_RxPram_Register[IRI_QTP_MAX_NUM_PORTS];



extern IridiaQTP_Latencies_t gt_IridiaQTPLatencies;
extern IridiaQTP_Input_t gt_IridiaQTP_Input;
extern IridiaQTP_Output_t gt_IridiaQTP_Output;


extern uint16 gus_RxQTPEngineState;
extern uint16 gus_RxQTPEngineNextState;
extern uint16 gus_RxQTPEngineSubState;
extern uint16 gus_RxQTPEngineNextSubState;
extern uint32 gul_RxQTPEngineLatency;


//Iridia-QTP Port select variables

extern uint8 guc_qtp_tx_go_port;
extern uint8 guc_qtp_rx_go_port;
extern uint8 gs_FBTIndex;



// Iridia-QTP Tx QAM Encode state machine variables
extern uint16 gus_TxQTPEngineState;
extern uint16 gus_TxQTPEngineNextState;
extern uint16 gus_TxQTPEngineSubState;
extern uint16 gus_TxQTPEngineNextSubState;
extern uint32 gul_TxQTPEngineLatency;



extern uint8 guc_IRI_QTP_TX_CRI_GO_Input_Asserted;
extern uint8 guc_IRI_QTP_RX_CRI_GO_Input_Asserted;
extern   uint8 guc_IRI_QTP_TX_CRI_DONE_Output_Asserted;
extern   uint8 guc_IRI_QTP_RX_CRI_DONE_Output_Asserted;



// Iridia-FT local arrays

//==============================================================================
// Iridia-QTP private functions
//==============================================================================

// Iridia-FT BM clocking function prototypes

int32 IridiaQTP_Clock_Tx(uint8 uc_port);
int32 IridiaQTP_Clock_Rx(uint8 uc_port);

extern int16 gs_QTPTxPRBSOutput;
extern int32 gl_QTPTxPRBSState;
extern int32 gl_QTPPrbsState;

extern int32 ZEP_ILV_PutPRBSByteToTxDTB(uint32 us_wr_addr , uint8 uc_byte, uint8 uc_port);
extern int32 IRI_QT_SaveActiveBufferData(uint16 l_dest_address,int32 activeData,uint8 BGTN_or_EGT,uint8 path,uint8 uc_port);
extern int32 IRI_QT_GetActiveBufferData(uint16 i,uint32 *activeBGTNTableData,uint32 *activeEGTTableData,uint8 path,uint8 uc_port);
extern void IRI_QT_FillActiveFBTTable(uint16 l_dest_address,int16 activeFeedbackToneAddress,uint8 gs_FBTIndex,uint8 uc_port);
extern int32 IRI_QT_searchRxActiveBGTTable(uint16 segmentTone,uint16 search_Start,uint16 search_End,int16 *activeFeedbackToneAddress,uint8 uc_port);
extern int32 IRI_QT_CopyRxPRBSRegisters(int32 l_RxPRBSStateRTV0, int32 l_RxPRBSStateRTV1, uint8 uc_port);

void Completed_QTPTxProcessing(void);
void Completed_QTPRxProcessing(void);
int32 CopyRxPRBSRegisters(uint8 uc_port);


// Iridia-QTP Rx PRBS State Generator
extern int32 gl_RxPRBSState;
extern int32 gl_RxPRBSStateRTV0;
extern int32 gl_RxPRBSStateRTV1;

// Iridia-QTP Tx PRBS State Generator
extern int32 gl_QTP_TxPRBSState;

// Iridia-QTP reset functions
void IridiaQTP_ResetRegisters(void);
void IridiaQTP_ResetGlobals(void);
void IridiaQTP_ResetIOSignals(void);

// Iridia-QTP initialization functions
void IridiaQTP_SetMemoryMap(void);
void IridiaQTP_Initialize_RAM_Lists(void);
void IridiaQTP_SetLatencies(void);
void IridiaQTP_AlignRAMPointers(void);


void DoTxQTP(uint8 uc_port);
void DoRxQTP(uint8 uc_port);


//QTP PRBS functions
void QTP_TxRunPRBS(uint8 uc_port);
void QTP_TxPRBSGenerator(int16 s_output_bits);
int16 QTP_GetPRBS2bitData(int16 s_PRBS_data_index);
void QTP_PRBSScrambler(uint8 *ps_PRBS_data, int16 s_PRBS_output);

//zephyr ILV wrapper function
int32 QT_ZEP_ILV_PutPRBSByteToTxDTB(uint32 us_wr_addr, uint8 uc_byte,uint8 uc_port);
int32 QT_ZEP_ILV_GetPRBSByteFromTxDTB(uint32 us_rd_addr, uint8 *pul_byte, uint8 uc_port);
int32 IRI_QTP_QT_SaveActiveBufferData(uint16 l_dest_address,int32 activeData,uint8 BGTN_or_EGT,uint8 path,uint8 uc_port);
int32 IRI_QTP_QT_GetActiveBufferData(uint16 i,uint32 *activeBGTNTableData,uint32 *activeEGTTableData,uint8 path,uint8 uc_port);
int32 IRI_QTP_QT_CopyRxPRBSRegisters(int32 l_RxPRBSStateRTV0, int32 l_RxPRBSStateRTV1, uint8 uc_port);

extern int32 ZEP_ILV_GetPRBSByteFromTxDTB(uint32 us_rd_addr, uint8 *pul_byte, uint8 uc_port);

int32 IRI_QTP_GetGainScaleTableAddress(uint16 **pus_BaseAddr, uint8 uc_port);
int32 IRI_QTP_GetBitAllocationTableAddress(uint8 **puc_BaseAddr, uint8 uc_port);
int32 IRI_QTP_GetToneReorderingTableAddress(uint16 **pus_BaseAddr,uint8 uc_port);
int32 IRI_QTP_GetBitAllocationTableAddress(uint8 **puc_BaseAddr, uint8 uc_port);
int32 IRI_QTP_GetInactiveFBTTableAddress(uint16 **puc_BaseAddr, uint8 uc_port);


int32 IRI_QTP_WriteWord(uint32 addr, uint32 ul_data, uint8 uc_ByteEnable,uint8 uc_port);
int32 IRI_QTP_ReadWord(uint32 addr, uint32 *pul_data, uint8 uc_ByteEnable,uint8 uc_port);


// Iridia-QTP RAM functions
int32 IridiaQTP_WriteWordVirtualAddr(int16 s_RamName, uint32 ul_offset,  uint32 ul_data, uint8 uc_ByteEnable,uint8 guc_ch_id);
int32 IridiaQTP_ReadWordVirtualAddr(int16 s_RamName, uint32 ul_offset, uint32 *pul_data, uint8 uc_ByteEnable,uint8 guc_ch_id);
void IridiaQTP_MapRAM(uint32 ul_addr, int16 *ps_RAM_id, uint32 *pul_Offset);


void QTP_TxCopyTable(uint8 uc_port);
void IRI_QTP_TxcopyActivetoInactiveValues(uint32 l_path,uint32 l_src_start,uint32 l_src_end,uint8 uc_port);
void IRI_QTP_TxcopyTOTDisableToneRanges(uint32 l_path,uint16 l_src_start,uint16 l_src_end,uint16 l_dest_start,uint8 uc_port);
void IRI_QTP_TxcopyTOTEnableToneRanges(uint32 l_path, uint16 l_dest_start,uint8 uc_port);
void GetEGTTxRxbit(uint8 *TxRxDirection,uint16 toneNumber,uint8 uc_port);
void IRI_QTP_QT_FillActiveFBTTable(uint16 l_dest_address,int16 activeFeedbackToneAddress,uint8 gs_FBTIndex,uint8 uc_port);
 void IRI_QTP_QT_searchRxActiveBGTTable(uint16 segmentTone,uint16 search_Start,uint16 search_End,int16 *activeFeedbackToneAddress,uint8 uc_port);



void QTP_RxCopyTable(uint8 uc_port);
void IRI_QTP_RxcopyActivetoInactiveValues(uint32 l_path,uint32 l_src_start,uint32 l_src_end,uint8 uc_port);
int32 IRI_QTP_RxcopyTOTDisableToneRanges(uint32 l_path,uint16 l_src_start,uint16 l_src_end,uint16 l_dest_start,uint8 uc_port);
int32 IRI_QTP_RxcopyTOTEnableToneRanges(uint32 l_path, uint16 l_dest_start,uint8 uc_port);

void QTP_RxRunPRBS(uint8 uc_port);
void RxPRBSStateGenerator(int16 s_output_bits);
int32 Do_RxPRBSStateGeneration(uint8 uc_port);
int32 getPRBSStateFromQTP(int32 *s_QTPPrbsState,uint8 uc_port);

//Verification functions needed for ASIC. Not used in BM

void GetInactiveFBT_Table(uint16 *us_FBT, uint8 uc_port);
void GetInactiveBAT_Table (uint8 *uc_BAT, uint8 uc_port);
void GetInactiveGST_Table (uint16 *us_GST, uint8 uc_port);
void GetInactiveTOT_Table (uint16 *us_TOT, uint8 uc_port);
void GetInactiveEGT_Table (uint8 *uc_EGT, uint8 uc_port);



void IRI_QTP_Clock(void);


#endif // _QTP_PRIVATE_H
