/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2004 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   filename: qtp_ram.h
*
*   Header file for Iridia-QTP RAM blocks.
*
*-------------------------------------------------------------------------------
*/

#ifndef _QTP_RAM_H
#define _QTP_RAM_H

#include "qtp_memmap.h"

#define  IRI_QTP_MIN_RAM_ID                     (0)


#define IRI_QTP_RAM_INACTIVE_BAT_ID          (0)
#define IRI_QTP_RAM_INACTIVE_GAIN_SCALE_ID      (1)
#define IRI_QTP_RAM_INACTIVE_EGT_ID          (2)
#define IRI_QTP_RAM_INACTIVE_TOT_ID          (3)
#define IRI_QTP_RAM_INACTIVE_FBT_ID          (4)


#define  IRI_QTP_MAX_RAM_ID            (IRI_QTP_RAM_INACTIVE_FBT_ID)

// Iridia-QTP Register IDs
#define  IRI_QTP_MIN_REG_ID            (IRI_QTP_MAX_RAM_ID+1)


// Global Registers


#define IRI_QTP_REG_CONFIG_ID       (IRI_QTP_MIN_REG_ID+0x00)
#define IRI_QTP_REG_STATUS_ID       (IRI_QTP_MIN_REG_ID+0x01)
#define IRI_QTP_REG_TX_PRBS_DATA0_ID      (IRI_QTP_MIN_REG_ID+0x02)
#define IRI_QTP_REG_TX_PRBS_DATA1_ID      (IRI_QTP_MIN_REG_ID+0x03)
#define IRI_QTP_REG_TX_PRBS_DATA2_ID      (IRI_QTP_MIN_REG_ID+0x04)
#define IRI_QTP_REG_TX_PRBS_DATA3_ID      (IRI_QTP_MIN_REG_ID+0x05)
#define IRI_QTP_REG_TX_PRBS_DATA4_ID      (IRI_QTP_MIN_REG_ID+0x06)
#define IRI_QTP_REG_TX_PRBS_DATA5_ID      (IRI_QTP_MIN_REG_ID+0x07)
#define IRI_QTP_REG_TX_PRBS_DATA6_ID      (IRI_QTP_MIN_REG_ID+0x08)
#define IRI_QTP_REG_TX_PRBS_DATA7_ID      (IRI_QTP_MIN_REG_ID+0x09)


#define  IRI_QTP_TXPRAM_REGISTERS_ID      (IRI_QTP_REG_TX_PRBS_DATA7_ID+0x01)

#define IRI_QTP_REG_TX_CTRL_ID         (IRI_QTP_TXPRAM_REGISTERS_ID+0x00)
#define IRI_QTP_REG_TXTC_CTRL_ID    (IRI_QTP_TXPRAM_REGISTERS_ID+0x01)
#define IRI_QTP_REG_TXTC_TOT_ID        (IRI_QTP_TXPRAM_REGISTERS_ID+0x02)
#define IRI_QTP_REG_TXTC_ACTIVE_ID     (IRI_QTP_TXPRAM_REGISTERS_ID+0x03)
#define  IRI_QTP_REG_TX_PRBS_ID        (IRI_QTP_TXPRAM_REGISTERS_ID+0x04)
#define  IRI_QTP_REG_TX_PRBS_MISC_ID      (IRI_QTP_TXPRAM_REGISTERS_ID+0x05)
#define  IRI_QTP_REG_TX_PRBS_POLY_ID      (IRI_QTP_TXPRAM_REGISTERS_ID+0x06)


#define  IRI_QTP_RXPRAM_REGISTERS_ID      (IRI_QTP_REG_TX_PRBS_POLY_ID+0x01)

#define IRI_QTP_REG_RX_CTRL_ID         (IRI_QTP_RXPRAM_REGISTERS_ID+0x00)
#define IRI_QTP_REG_RXTC_CTRL_ID    (IRI_QTP_RXPRAM_REGISTERS_ID+0x01)
#define IRI_QTP_REG_RXTC_TOT_ID        (IRI_QTP_RXPRAM_REGISTERS_ID+0x02)
#define IRI_QTP_REG_RXTC_ACTIVE_ID     (IRI_QTP_RXPRAM_REGISTERS_ID+0x03)


#define IRI_QTP_REG_RX_PRBS_ID         (IRI_QTP_RXPRAM_REGISTERS_ID+0x04)
#define IRI_QTP_REG_RX_PRBS_MISC_ID    (IRI_QTP_RXPRAM_REGISTERS_ID+0x05)
#define IRI_QTP_REG_RX_PRBS_POLY_ID    (IRI_QTP_RXPRAM_REGISTERS_ID+0x06)
#define IRI_QTP_REG_RX_PRBS_OFFSET_ID  (IRI_QTP_RXPRAM_REGISTERS_ID+0x07)




#define  IRI_QTP_MAX_REG_ID            (IRI_QTP_REG_RX_PRBS_OFFSET_ID)



extern IridiaQTP_Global_Register_t  gt_IridiaQTP_Global_Register;
extern IridiaQTP_Global_Register_t gt_IridiaMultiportQTP_Global_Register[IRI_QTP_MAX_NUM_PORTS];
extern IridiaQTP_TxPram_Register_t  gt_IridiaQTP_TxPram_Register;
extern IridiaQTP_TxPram_Register_t gt_IridiaMultiportQTP_TxPram_Register[IRI_QTP_MAX_NUM_PORTS];
extern IridiaQTP_RxPram_Register_t  gt_IridiaQTP_RxPram_Register;
extern IridiaQTP_RxPram_Register_t gt_IridiaMultiportQTP_RxPram_Register[IRI_QTP_MAX_NUM_PORTS];


extern uint8 IRI_QT_RAM_INACTIVE_BAT_Unaligned [4][IRI_QT_RAM_INACTIVE_BAT_SIZE+4];
extern uint8 *IRI_QT_RAM_INACTIVE_BAT;

extern uint8 IRI_QT_RAM_INACTIVE_GAIN_SCALE_Unaligned [4][IRI_QT_RAM_INACTIVE_GAIN_SCALE_SIZE+4];
extern uint8 *IRI_QT_RAM_INACTIVE_GAIN_SCALE;

extern uint8 IRI_QT_RAM_INACTIVE_EGT_Unaligned [4][IRI_QT_RAM_INACTIVE_EGT_SIZE+4];
extern uint8 *IRI_QT_RAM_INACTIVE_EGT;

extern uint8 IRI_QT_RAM_INACTIVE_TOT_Unaligned [4][IRI_QT_RAM_INACTIVE_TOT_SIZE+4];
extern uint8 *IRI_QT_RAM_INACTIVE_TOT;

extern uint8 IRI_QT_RAM_INACTIVE_FBT_Unaligned [4][IRI_QT_RAM_INACTIVE_FBT_SIZE+4];
extern uint8 *IRI_QT_RAM_INACTIVE_FBT;

// Global Arrays
extern uint32 IRI_QTP_RAM_PhysBaseAddr[IRI_QTP_MAX_REG_ID+1];
extern uint32 IRI_QTP_RAM_Mask[IRI_QTP_MAX_REG_ID+1];
extern uint32 *IRI_QTP_RAM_VirtualBaseAddr[IRI_QTP_MAX_RAM_ID+1];
extern uint32 IRI_QTP_RAM_Size[IRI_QTP_MAX_RAM_ID+1];
extern uint32 IRI_QTP_RAM_Offset[IRI_QTP_MAX_RAM_ID+1];





#endif //_QTP_RAM_H
