/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//------------------------------------------------------------
// States and other definitions for aec :: aec_afir
//------------------------------------------------------------
//------------------------------------------------------------
// All rights reserved. No part of this file shall be modified without notifying the owner.
//------------------------------------------------------------
//------------------------------------------------------------
// Author           : David Schwingshackl
// Created On       : December 2008
// Last Modified By : $Author: yangcao $
// Last Modified On : $Date: 2009/01/14 15:01:00Z $
//
// $Log: aec_afir_states.h $
// Revision 1.2  2009/01/14 15:01:00Z  yangcao
// merged source code from ifx
//
//------------------------------------------------------------


#ifndef __aec_afir_statesdef__
#define __aec_afir_statesdef__

#include <regvr9.h>

#define AFIR_N_MAX 127  //max order
#define WL_IN 16   //for all filters
#define AFIR_WL_COEF 16
#define AFIR_WL_UPDATE 21
#define AFIR_WL_ACC 36

//------------------------------------------------------------
// The states structure
//------------------------------------------------------------

typedef struct {
  int16 S[AFIR_N_MAX + 1];
  int16 U[AFIR_N_MAX + 1];
  int32 W[AFIR_N_MAX + 1];
  int16 s_idx_s;
  int16 s_idx_u;
  uint16 us_toggle;
  uint32 ul_ovl;
  uint16 us_cnt_update;
  uint16 us_cnt_leaky;
  uint32 ul_cnt_stop;
  uint16 us_cnt_stop_enable;
} aec_afir_states_t;


#endif
