/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//------------------------------------------------------------
// States and other definitions for aec :: aec_pfir
//------------------------------------------------------------
//------------------------------------------------------------
// All rights reserved. No part of this file shall be modified without notifying the owner.
//------------------------------------------------------------
//------------------------------------------------------------
// Author           : David Schwingshackl
// Created On       : December 2008
// Last Modified By : $Author: yangcao $
// Last Modified On : $Date: 2009/01/14 15:02:33Z $
//
// $Log: aec_pfir_states.h $
// Revision 1.1  2009/01/14 15:02:33Z  yangcao
// Initial revision
//
//------------------------------------------------------------


#ifndef __aec_pfir_statesdef__
#define __aec_pfir_statesdef__

#include <regvr9.h>


#define PFIR_N 15
#define PFIR_WL_ACC 26
#define PFIR_WL_COEF 8
#define PFIR_DLY_MAX 63


//------------------------------------------------------------
// The states structure
//------------------------------------------------------------

typedef struct {
  int64 S[PFIR_N];  // for FIR filter
  int16 U[PFIR_DLY_MAX+1];  // for programmable delay
  int16 coef[PFIR_N+1];  // for programmable delay
  int16 s_idx_u;
} aec_pfir_states_t;

#endif
