/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright Infineon Technologies Asia Pacific Pte Ltd
    Copyright: Infineon Technologies Asia Pacific Pte Ltd
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//------------------------------------------------------------
// Filename : common.h
// Location : utils/include
// Author   : GohChee
// Date     : Mon Apr 24 14:19:54 MPST 2006
//------------------------------------------------------------
// All rights reserved. No part of this file shall be modified without notifying the owner.
//------------------------------------------------------------
// Modification History
// Date  Owner Changes
// Mon Apr 24 14:19:54 MPST 2006 GohChee  Created
//------------------------------------------------------------

//---------------------------------------------------------------
// Fixed Point PMD Signal Processing Modules
// C implementation
// Common Types definitions
// By CKGOH
// 09-Feb-2006
//---------------------------------------------------------------
#ifndef __COMMON__
#define __COMMON__

//---------------------------------------------------------------
// Lets start with some very simple includes..
//---------------------------------------------------------------
#include <stdio.h>
#include <math.h>

//---------------------------------------------------------------
// This will be the common variables for PMD slice/channel
//---------------------------------------------------------------
#define nslice 2
#define nch    4
#define nch_slice nch/nslice

#ifndef M_PI
#define M_PI 3.14159265
#endif

#define VR9PHY_DBG_MIN_PROC_DELAY

//---------------------------------------------------------------
//These are the convenient types for our fix point implementation
//---------------------------------------------------------------
//#define __MSVC__
#ifdef MSVC_ONLY
typedef __int64           int64;
typedef unsigned __int64 uint64;
#else
typedef long long          int64;
typedef unsigned long long uint64;
#endif
typedef unsigned int       uint32;
typedef unsigned short     uint16;
typedef unsigned char      uint8;
typedef int                int32;
typedef short              int16;

//---------------------------------------------------------------
// We define a global clock counter for every one...
//---------------------------------------------------------------
extern uint32 gt_clk;

//---------------------------------------------------------------
// These are the convenient macros for Register bit field handling
//---------------------------------------------------------------
#define fieldmaskL(start,end) (((int64)1<<(start-end+1))-1)
#define fieldmask(start,end)  (fieldmaskL(start,end)<<end)
#define fieldmaskN(start,end) (0xFFFFFFFF-(fieldmask(start,end)))
#define BE2MASK(be) (((be & 0x1)?fieldmask(7,0):0) | ((be & 0x2)?fieldmask(15,8):0) | ((be & 0x4)?fieldmask(23,16):0)| ((be & 0x8)?fieldmask(31,24):0))


#endif

