/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright Infineon Technologies Asia Pacific Pte Ltd
    Copyright: Infineon Technologies Asia Pacific Pte Ltd
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//------------------------------------------------------------
// Filename : common_fp.h
// Location : utils/include
// Author   : GohChee
// Date     : Mon Apr 24 14:19:54 MPST 2006
//------------------------------------------------------------
// All rights reserved. No part of this file shall be modified without notifying the owner.
//------------------------------------------------------------
// Modification History
// Date  Owner Changes
// Mon Apr 24 14:19:54 MPST 2006 GohChee  Created
//------------------------------------------------------------

//---------------------------------------------------------------
// Fixed Point PMD Signal Processing Modules
// By CKGOH
// 10-Nov-2005
//
//---------------------------------------------------------------

#ifndef __FP__
#define __FP__

#include <common.h>
//---------------------------------------------------------------
// Lets start with some very simple includes..
//---------------------------------------------------------------
#include <math.h>

//---------------------------------------------------------------
//These are the convenient macros for our fix point implementation
//---------------------------------------------------------------
#define CPLX_INTBW 23

#undef LLRAND
#define LLRAND (((_lrand48()*((LINT)1))<<32)+_lrand48())

#define rnd(lsb)           (((int64)1)<<(lsb-1))
#define rndmask(lsb)       ((((int64)1)<<(lsb))-1)
#define rndmaskn(lsb)      (-rndmask(lsb)-1)
#define satmask(sgnb)      (rndmaskn(sgnb))
#define satpos(sgnb)       (-satmask(sgnb)-1)
#define satneg(sgnb)       (satmask(sgnb))
#define ovf(a,sgnb)        ((a&satmask(sgnb))==satmask(sgnb)||((a&satmask(sgnb))==0)?0:1)
#define sat(a,sgnb)        (ovf(a,sgnb)?((a>0)?satpos(sgnb):satneg(sgnb)):a)
#define rmr(a,lsb)         ((((a&rndmask(lsb))==0)||a>0)?(a&rndmaskn(lsb)):((a+rnd(lsb+1))&rndmaskn(lsb)))
#define satrmr(a,sgnb,lsb) (sat(rmr(a,lsb),sgnb))
#define satrnd(a,sgnb,lsb) (sat((a+rnd(lsb)),sgnb)>>(lsb))
#define max(a,b)           (a>b?a:b)
#define min(a,b)           (a>b?b:a)
#define sxt(a,sgnb)        ((a&fieldmask(sgnb,0))+(((a&fieldmask(sgnb,sgnb))>0)?rndmaskn(sgnb+1):0))
#define ovv(a,sgnb)        ((a>=0)?(a&rndmask(sgnb+1)):((a&rndmask(sgnb+1))|(rndmaskN(sgnb+1))))
#define not(a)             (a?0:1)
//----------------------------------------------------------------
// A simple structure to describe the data format
// bitwidth + fracional bit width
// e.g. 2.14 => bitwidth = 16, fractional bitwidth = 14
//----------------------------------------------------------------

typedef struct {
  short bitwidth;
  short fracwidth;
} FPF;


//---------------------------------------
// Complex data type
//---------------------------------------
typedef struct {
  int64 r;
  int64 i;
} cplx;

//---------------------------------------
// Complex processing functions
//---------------------------------------
extern void cmult(cplx *c, cplx a, cplx b);
extern void cdiv(cplx *c,cplx a,cplx b);
extern void ccadd(cplx *c, cplx a, cplx b);
extern void csub(cplx *c, cplx a, cplx b);
extern void cconj(cplx *c, cplx a);
extern int64 ccabs(cplx c);
extern void ccpy(cplx *c, cplx a);
extern void cprnL(cplx c);
extern void cprnD(cplx c,FPF bw);
extern void cprnLN(cplx c);
extern void cprnDN(cplx c,FPF bw);
extern uint8 ccmp(cplx a, cplx b);
extern void cii(cplx *c, cplx a);
extern void cneg(cplx *c, cplx a);
extern uint8 covf(cplx a, uint8 sgnb);
extern uint8 csatrnd(cplx *a,uint8 sgnb,uint8 lsb);
extern uint8 csat(cplx *a,uint8 sgnb);


#endif
