/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright Infineon Technologies Asia Pacific Pte Ltd
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//------------------------------------------------------------
// Filename : regvr9.h
// Location : utils/include
// Author   : ckgoh
// Date     : Wed 12 March 2008
//------------------------------------------------------------
// All rights reserved. No part of this file shall be modified without notifying the owner.
//------------------------------------------------------------
// Modification History
// Date  Owner Changes
// 12March2008 ckgoh Created
//------------------------------------------------------------

#ifndef __REGVR9__
#define __REGVR9__

#include <common.h>
//---------------------------------
// Field Definition Structure
// With array of pointers!
//---------------------------------
typedef struct {
  uint8   start;
  uint8   end;
  uint8   type;
  uint8   nsync;
  uint32  *ptr;
} fielddef_t;
//---------------------------------
// An array of fields forms a register
//---------------------------------
typedef struct {
  uint32 data;
  uint32 reset_val;
  fielddef_t *fields;
  uint8 nfields;
  uint32 mask;
} regdef_t;
//--------------------------------
// An of course eventually an array
// of register form a register file
// This will be part of the generated files
// For each module... not part of the generic handling
// here..
//--------------------------------

//--------------------------------
// This is for address definition
//--------------------------------
typedef struct {
  char *name;
  uint32 offset;
  uint16 reg_id;
} addrdef_t;
//--------------------------------
// This is for special processing list
// like LHMK, RWSC, QRW, TRW, DRW
//--------------------------------
typedef struct {
  uint16 reg_id;
  uint16 field_id;
  uint8  type;
} fieldlistdef_t;


extern void  reg_hwreset(regdef_t *reg, uint16 nreg, fieldlistdef_t *fieldlist, uint16 nfieldlist);
extern void  reg_swreset(regdef_t *reg, uint16 nreg);
extern uint8 reg_read(regdef_t *reg, addrdef_t *reg_map, uint16 nreg, uint32 address, uint32 *dout, uint32 rmask);
extern uint8 reg_write(regdef_t *reg, addrdef_t *reg_map, uint16 nreg, uint32 address, uint32 din  , uint32 wmask);
extern void  reg_FW_update(regdef_t *reg);
extern void  reg_HW_update(regdef_t *reg);
extern void  reg_clksync(regdef_t *reg, fieldlistdef_t *fieldlist, uint16 nfields);
extern void  reg_eventsync(regdef_t *reg, fieldlistdef_t *fieldlist, uint16 nfields, uint8 *event);
extern uint16 get_reg_id(addrdef_t *reg_map, uint16 nreg, uint32 address);
extern uint32 get_reg_addr(addrdef_t *reg_map, uint16 nreg, uint16 reg_id);
extern char* get_reg_name(addrdef_t *reg_map, uint16 nreg, uint16 reg_id);
extern char* get_acctype_name(uint8 acctype);

#define __REG_RO__     0
#define __REG_RV__     1
#define __REG_W__      2
#define __REG_RW__     3
#define __REG_RWD__    4
#define __REG_WOR__    5
#define __REG_RWN__    6
#define __REG_RWH__    7
#define __REG_RWHD__   8
#define __REG_LHSC__   9
#define __REG_LHMK__  10
#define __REG_RWSC__  11
#define __REG_RWSCD__ 12
#define __REG_RW2__   13
#define __REG_RW2D__  14
#define __REG_RW3__   15
#define __REG_RW3D__  16
#define __REG_RW4__   17
#define __REG_RW4D__  18

#define byte0mask 0x000000FF
#define byte1mask 0x0000FF00
#define byte2mask 0x00FF0000
#define byte4mask 0xFF000000
#define word0mask 0x0000FFFF
#define word1mask 0xFFFF0000
#define lwordmask 0xFFFFFFFF

#define nomatchmask 0xFFFF

#endif
