/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//

// Filename : $RCSfile: str_api.h $
// Creator  : Leiter Kang
// Created  : 09/18/2007
// Revision : $Revision: 1.9 $
// Rev Date : $Date: 2009/03/18 15:04:10Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Strymon API
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _STR_API_H
#define _STR_API_H

#include "str_const.h"
#include "str_typedef.h"
#include "str_io_typedef.h"

#define VFDF_CHECK_RX_SRC       0xF
#define VFDF_CHECK_TX_HBFILT    0xE
#define VFDF_CHECK_TX_INTERP    0xD
#define VFDF_CHECK_TX_IIR       0xC
#define VFDF_CHECK_TX_WINDOW    0xB
#define VFDF_CHECK_TX_VG        0xA
#define VFDF_CHECK_RX_VG        0x9
#define VFDF_CHECK_RX_WINDOW    0x8
#define VFDF_CHECK_RX_TDQ       0x7
#define VFDF_CHECK_RX_SJ        0x6
#define VFDF_CHECK_RX_DEC       0x5
#define VFDF_CHECK_RX_IIR       0x4
#define VFDF_CHECK_RX_DECIM2    0x3
#define VFDF_CHECK_TX_SRC       0x2
#define VFDF_CHECK_RX_ADC_SHIFT 0x1
#define VFDF_CHECK_RX_DC_OFFSET 0x0

/* TYPEDEFS */
typedef struct {
  int16  rx_sample;
  int16  aec_sample;
  int16  dualtdq_sample;
  uint16  core_triggers;
  uint16  line_triggers;
  uint8  port;
} t_StrymonIns;

typedef struct {
  int16 bypass;
  int16 resetn;
  int16 mask;
  int16 ovcl;

  int16 adc_shift;
  int16 dc_offset;
  int16 decim_phase;
  int16 tx_round;
  int16 adc_rate;
  int16 decadapt_coef_done;
  int16 decadapt_enable;
  int32 srcfr;
  int32 srcctl;
  int16 src_in_rate;
  int16 dualtdq_ena;
  int16 aec_ena;
} t_StrymonRegIns;

typedef struct {
  int16 tx_sample;

  int16 tx_vg;
  int16 tx_win;
  int16 tx_iir;
  int16 tx_src;
  int16 tx_interp;
  int16 tx_hbfilt;
  int16 rx_adc_adj;
  int16 rx_decim;
  int16 rx_src;
  acc   rx_iir;
  acc   rx_dec;
  int16 rx_sumjunc;
  int16 rx_tdq;
  int16 rx_win;
  int16 rx_vg;

  int16 ovflow;
} t_StrymonOuts;

/* INITIALIZATION FUNCTIONS */
void Str_SetupMemMap(void);

/* MEMORY ACCESS FUNCTIONS */
int32 Str_ReadWord(uint8 uc_port, uint32 ul_PhysAddr, uint32 *pul_word, uint8 uc_ByteEnable);
int32 Str_WriteWord(uint8 uc_port, uint32 ul_PhysAddr, uint32 ul_word, uint8 uc_ByteEnable);

void Str_SetPortMode(uint8 uc_port_mode);
void StrymonClock (t_StrymonIns *s_Inputs, t_StrymonRegIns *s_Regs, t_StrymonOuts *s_Outputs);

#endif // _STR_COCOMO_INTERFACE_H



//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: str_api.h $
//   Revision 1.9  2009/03/18 15:04:10Z  yangcao
//   1. Fix for AFE interpolator reset -Add clearing AFE interpolator overflow
//   2. Fix for dual-TDQ-Set 2nd TDQ input to 0 if TDQ reset is asserted in StrymonRxClock()
//   3. Support for clearing IFFT buffer--Add s_clr_ifft to data structure TxFrame_t.  Add logic generating IFFT clearing flag to Str_TxFrame().
//   4. Support for enabling dualtdq and aec mode dynamically Add dualtdq_ena and aec_ena to data structure t_StrymonRegIns.  In non-COCOMO environment, the data path will use dualtdq_ena and aec_ena copied from RTL.
//
//   Revision 1.8  2009/02/12 19:47:38Z  myong
//   Li Xin's change to the BM for the dual-TDQ mode
//   Revision 1.17  2009-02-11 16:13:17-05  lxin
//   Add dualtdq_sample into BM input structure
//
//   Revision 1.16  2009-01-29 17:26:42-05  astone
//   Move Rx and Tx SRC overflow check bit positions
//
//   Revision 1.15  2009-01-29 15:21:58-05  astone
//   Connect Tx and Rx SRC overflow bits in a manner similar to other blocks.
//
//   Revision 1.14  2009-01-22 14:30:44-05  lxin
//   Fixes for AEC mode
//
//   Revision 1.6  2009/01/22 16:50:26Z  yangcao
//   Revision 1.5  2009/01/19 22:13:44Z  yangcao
//   (1). Per spec change removed DECIM1 block. For decimation factor being 32x or 64x,
//   2-stage decimation is used with the first stage decimation having a constant factor of 4x.
//   This checkin removed stage 1 decim. Decim2 now has the largest decimation factor 64x.
//   Revision 1.4  2009/01/02 18:46:18Z  yangcao
//   Revision 1.3  2008/12/30 21:40:03Z  yangcao
//   Revision 1.2  2008/12/11 17:54:11Z  yangcao
//   Revision 1.8  2008-10-28 17:17:25-04  astone
//   SRC
//
//   Revision 1.7  2008-10-09 16:34:51-04  astone
//   t_StrymonIns now has two trigger buses, each is 16 bit data type.
//
//   Revision 1.6  2008-05-12 18:12:57-04  jgross
//   Connect SJ and DEC
//
//   Revision 1.5  2008-03-28 12:11:51-04  jgross
//   Remove bufferswaps from output struct - these come from FTB
//
//   Revision 1.4  2008-01-09 11:01:55-05  jgross
//   Make bit-wide registers into vectors for brining into the BM; add place holders for overflow bits
//
//   Revision 1.3  2007-12-13 10:49:13-05  jgross
//   Add comparison of Rx TDQ output
//
//   Revision 1.2  2007-11-19 14:45:24-05  jgross
//   Bring in dynamic register values from the VFDF RTL to the BM to avoid race conditions
//
//   Revision 1.1  2007-09-18 18:30:00-04  lkang
//   Initial Revision
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

