/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//
// Filename : $RCSfile: str_const.h $
// Creator  : Leiter Kang
// Created  : 06/19/2007
// Revision : $Revision: 1.16 $
// Rev Date : $Date: 2009/02/23 18:36:56Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Constant Definitions for the Strymon BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _STR_CONST_H
#define _STR_CONST_H

//#include "str_compiler.h"  // FIXME: add

#define MAX_FIR_LEN  (1024)  // LK FIXME

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  TOP-LEVEL CONSTANTS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#define MAX_NUM_PORTS (2)  // FIXME: does this belong here?

// FIXME: do we still we need these?
// Sampling rates (Ks/s)
#define SAMPLE_RATE_552   (552)
#define SAMPLE_RATE_1104  (1104)
#define SAMPLE_RATE_2208  (2208)
#define SAMPLE_RATE_4416  (4416)
#define SAMPLE_RATE_8832  (8832)
#define SAMPLE_RATE_17664 (17664)
#define SAMPLE_RATE_35328 (35328)
#define SAMPLE_RATE_70656 (70656)


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  FIFO and DELAY CONSTANTS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//----- datapath -----

//-- delay parameters --
// Rx ADC Adjust
#define RX_ADC_ADJ_OUTPUT_DELAY  (1)
#define RX_ADC_ADJ_FIFO_DEPTH    (2*RX_ADC_ADJ_OUTPUT_DELAY)

// Rx DECIM
#define RX_DECIM_OUTPUT_DELAY  (5)
#define RX_DECIM_FIFO_DEPTH    (2*RX_DECIM_OUTPUT_DELAY)

// Rx SRC
#define RX_SRC_OUTPUT_DELAY  (5) //one less than RTL becuase of delay in generating the core side trigger is one sample.
#define RX_SRC_FIFO_DEPTH    (2*RX_SRC_OUTPUT_DELAY)

// Rx IIR
#define RX_IIR_OUTPUT_DELAY   (6)
#define RX_IIR_FIFO_DEPTH     (2*RX_IIR_OUTPUT_DELAY)

// Rx TDQ
// FIXME: recheck after chriss spec update
#define RX_TDQ_OUTPUT_DELAY   (3)
#define RX_TDQ_FIFO_DEPTH     (2*RX_TDQ_OUTPUT_DELAY)

// Rx Window
#define RX_WINDOW_OUTPUT_DELAY   (2)
#define RX_WINDOW_FIFO_DEPTH     (2*RX_WINDOW_OUTPUT_DELAY)

// Rx Var Gain
#define RX_VARGAIN_OUTPUT_DELAY   (2)
#define RX_VARGAIN_FIFO_DEPTH     (2*RX_VARGAIN_OUTPUT_DELAY)

// Rx FFT
#define RX_FFT_OUTPUT_DELAY  (2)
#define RX_FFT_FIFO_DEPTH    (2*RX_FFT_OUTPUT_DELAY)


// Tx IFFT
#define TX_IFFT_INPUT_DELAY  (1)
#define TX_IFFT_FIFO_DEPTH   (2*TX_IFFT_INPUT_DELAY)

// Tx Var Gain
#define TX_VARGAIN_OUTPUT_DELAY   (3)
#define TX_VARGAIN_FIFO_DEPTH     (2*TX_VARGAIN_OUTPUT_DELAY)

// Tx Window
#define TX_WINDOW_OUTPUT_DELAY   (2)
#define TX_WINDOW_FIFO_DEPTH     (2*TX_WINDOW_OUTPUT_DELAY)

// Tx IIR
#define TX_IIR_OUTPUT_DELAY   (6)
#define TX_IIR_FIFO_DEPTH     (2*TX_IIR_OUTPUT_DELAY)

// Tx SRC
#define TX_SRC_OUTPUT_DELAY  (6)

#define TX_SRC_FIFO_DEPTH    (2*TX_SRC_OUTPUT_DELAY)

// Tx Interp
#define TX_INTERP_OUTPUT_DELAY  (4)
#define TX_INTERP_FIFO_DEPTH    (2*TX_INTERP_OUTPUT_DELAY)

// Tx Hbfilt
#define TX_HBFILT_OUTPUT_DELAY  (5)
#define TX_HBFILT_FIFO_DEPTH    (2*TX_HBFILT_OUTPUT_DELAY)

// DEC
// FIXME: recheck after chriss spec update
#define DEC_OUTPUT_DELAY  (3)
#define DEC_FIFO_DEPTH    (2*DEC_OUTPUT_DELAY)

//----- shadow registers -----
#define MAX_RX_SHADOW_FIFO_CNT  (2)
#define RX_SHADOW_FIFO_DEPTH    (MAX_RX_SHADOW_FIFO_CNT+1)

#define MAX_TX_SHADOW_FIFO_CNT  (1)
#define TX_SHADOW_FIFO_DEPTH    (MAX_TX_SHADOW_FIFO_CNT+1)

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  BLOCK-LEVEL CONSTANTS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//----- Accum Ops -----
#define ROUND_NONE         (0)
#define ROUND_NORMAL       (1)
#define ROUND_REDUCED_MAG  (2)

//----- IIR -----
#define NUM_TX_IIR_BIQUADS  (6)
#define NUM_RX_IIR_BIQUADS  (6)
#define MAX_NUM_BIQUADS     ((NUM_TX_IIR_BIQUADS > NUM_RX_IIR_BIQUADS) ? NUM_TX_IIR_BIQUADS : NUM_RX_IIR_BIQUADS)

#define PAST_RESULTS_PER_BQ  (2)

//-- precision parameters --
#define W_RX_IIR_ACC          (52)  // 4.48
#define W_RX_IIR_COEF         (18)  // 1.17
#define W_RX_IIR_PR           (32)  // 1.31
#define W_RX_IIR_SAMP_IN      (16)  // 1.15
#define MSB_RX_IIR_TRUNC_PR   (16)  // drop bits 16:0 from 4.48 -> 4.31
#define LSB_RX_IIR_GUARD_PR   (49)  // remove bits 49 and up from 4.48 -> 1.48
#define MSB_RX_IIR_TRUNC_OUT  (17)  // drop bits 17:0 from 11.48 -> 11.30
#define LSB_RX_IIR_GUARD_OUT  (59)  // remove bits 59 and up from 20.48 -> 11.48

#define W_TX_IIR_ACC          (56)  // 4.52
#define W_TX_IIR_COEF         (22)  // 1.21
#define W_TX_IIR_PR           (32)  // 1.31
#define W_TX_IIR_SAMP_IN      (16)  // 1.15
#define MSB_TX_IIR_TRUNC_PR   (20)  // drop bits 20:0 from 4.52 -> 4.31
#define LSB_TX_IIR_GUARD_PR   (53)  // remove bits 53 and up from 4.52 -> 1.52
#define MSB_TX_IIR_TRUNC_OUT  (36)  // drop bits 36:0 from 4.52 -> 4.15
#define LSB_TX_IIR_GUARD_OUT  (53)  // remove bits 53 and up from 4.52 -> 1.52


//----- DECIM -----
//-- rate parameters --
#define MAX_DECIM2_FACTOR  (32)

//-- filter length parameters --
#define DECIM2_LEN_MULT    (8)
#define MAX_DECIM2_LENGTH  (240)

//-- data precision --
#define DECIM2_ACC_WIDTH  (42)  // 12.30
#define DECIM2_TRUNC_MSB  (14)  // drop bits 14:0 from 12.30 -> 12.15
#define DECIM2_GUARD_LSB  (31)  // remove bits 31 and up from 12.30 -> 1.30

// SRC
#define RX_SRC_FIR_ACC_WIDTH      (37)
#define RX_SRC_FIR_LEN            (24)
#define MAX_RX_SRC_FIR_LEN        (2*RX_SRC_FIR_LEN)
#define RX_SRC_FIR                (0)

#define TX_SRC_FIR_ACC_WIDTH      (37)
#define TX_SRC_FIR_PHASE_LEN      (24)
#define TX_SRC_FIR                (3)
#define MAX_TX_SRC_FIR_LEN        (2*TX_SRC_FIR_PHASE_LEN)
#define TX_SRC_INPUT_FIFO_DEPTH   (2*TX_SRC_INPUT_DELAY)
#define TX_SRC_INPUT_DELAY        (6)

#define SRC_FIR_OUT_MAX    (0x7FFF)          // maximum FIR output
#define SRC_FIR_OUT_MIN    (0x8000)          // minimum FIR output
#define RX_SRC_FIR_ACC_WIDTH      (37)
#ifndef MSVC_ONLY
#define SRC_FIR_ACC_MIN (0xFFFFFFFF80000000LL)  // minimum value of SRC FIR accumulator
#define SRC_FIR_ACC_MAX (0x000000007FFFFFFFLL)  // maximum value of SRC FIR accumulator
#else
#define SRC_FIR_ACC_MIN (0xFFFFFFFF80000000) // minimum value of SRC FIR accumulator
#define SRC_FIR_ACC_MAX (0x000000007FFFFFFF) // maximum value of SRC FIR accumulator
#endif
#define DELAY                     (0)
#define OUTPUT                    (1)
#define NUM_SRC_FIR_PARAMS        (3072)
#define SRCFR_DELAY_17664     (1)
#define SRCFR_DELAY_35328     (2)
#define SRCFR_DELAY_70656     (3)

//----- INTERP -----
//-- filter length parameters --
#define MAX_TX_INTERP_FACTOR      (16)  // 16x
#define MAX_TX_INTERP_PHASE_LEN   (24)  // max phase length
#define MAX_TX_INTERP_FIR_LEN     (MAX_TX_INTERP_PHASE_LEN)  // FIXME: remove when possible

//----- HB Filter -----
//-- filter length parameters --
#define MAX_TX_HBFILT_FACTOR      (1)  // 2x
#define MAX_TX_HBFILT_PHASE_LEN   (24)  // max phase length
#define MAX_TX_HBFILT_FIR_LEN     (MAX_TX_HBFILTER_PHASE_LEN)  // FIXME: remove when possible


//-- data precision --
#define INTERP_ACC_WIDTH  (36)  // 6.30
#define INTERP_TRUNC_MSB  (14)  // drop bits 14:0 from 6.30 -> 6.15
#define INTERP_GUARD_LSB  (31)  // remove bits 31 and up from 6.30 -> 1.30


//----- DEC/TDQ -----
//-- filter parameters --
#define TDQ_LEN_MULT    (8)
#define DEC_LEN_MULT    (8)

//-- data precision --
// FIXME: all parameters need to be rechecked after chriss updates spec
#define SJ_ACC_WIDTH  (41)
#define SJ_TRUNC_MSB  (14)
#define SJ_GUARD_LSB  (31)

#define TDQ_ACC_WIDTH  (41)
#define TDQ_TRUNC_MSB  (14)
#define TDQ_GUARD_LSB  (31)

#define DEC_ACC_WIDTH  (41)
#define DEC_TRUNC_MSB  (-1)
#define DEC_GUARD_LSB  (40)

//-- DEC Capture --
#define DEC_ERR_WAIT  (0)
#define DEC_ERR_CNT   (1)
#define DEC_ERR_CAPT  (2)
#define DEC_ERR_IDLE  (3)


//-- DEC Adaptation Memory --
#define ADAPT_MODE_COEF_WR  (2)
#define ADAPT_MODE_COEF_RD  (3)


//----- WINDOW -----
//-- coefficient mode --
#define WIN_ADSL_MODE   (0)
#define WIN_VDSL_MODE   (1)

#define WIN_CAPT_IDX   (0)
#define WIN_COMP_IDX   (1)

//-- window states --
#define WIN_IDLE     (0)
#define WIN_CAPTURE  (1)
#define WIN_COMPUTE  (2)

//-- data precision --
// FIXME: disagrees with spec
#define WIN_TRUNC_MSB   (14)  // drop bits 14:0 from 3.30 -> 3.15
#define WIN_GUARD_LSB   (31)  // remove bits 31 and up from 3.30 -> 1.30


//----- SAMPLE / FRAME -----
//-- frame states --
#define SAMP_INIT           (0)
#define SAMP_MAIN           (1)
#define SAMP_CYCLIC_PREFIX  (2)
#define SAMP_CYCLIC_SUFFIX  (3)


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  EXCEPTIONS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#define NO_STR_EXCEPTION        (0)   // Default value
#define INVALID_ACC_VALUE       (1)   // accum value out of bounds
#define INVALID_DEC_LENGTH      (2)   // DEC length not a multiple of 4
#define INVALID_TDQ_LENGTH      (3)   // TDQ length not a multiple of 4
#define INVALID_RATE_CFG        (4)   // Tx DAC rate > Tx path sample rate
#define INVALID_MEM_ACCESS      (5)   // Invalid access to memory
#define INVALID_DEC_IN_SAMPLES  (6)   // Exceeded max number of DEC input samples
#define E_FIFO_OVERFLOW         (7)   // FIFO overflow
#define E_FIFO_UNDERFLOW        (8)   // FIFO underflow


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  MEMORY ACCESSES
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//-- memory representations --
#define MEM_32  (0)  // uint32 or int32
#define MEM_16  (1)  // uint16 or int16

//-- register bit masks --
#ifndef MASK_BIT0
#define MASK_BIT0           (0x0001)
#define MASK_BIT1           (0x0002)
#define MASK_BIT2           (0x0004)
#define MASK_BIT3           (0x0008)
#define MASK_BIT4           (0x0010)
#define MASK_BIT5           (0x0020)
#define MASK_BIT6           (0x0040)
#define MASK_BIT7           (0x0080)
#define MASK_BIT8           (0x0100)
#define MASK_BIT9           (0x0200)
#define MASK_BIT10          (0x0400)
#define MASK_BIT11          (0x0800)
#define MASK_BIT12          (0x1000)
#define MASK_BIT13          (0x2000)
#define MASK_BIT14          (0x4000)
#define MASK_BIT15          (0x8000)
#define MASK_BIT16          (0x00010000)
#define MASK_BIT17          (0x00020000)
#define MASK_BIT18          (0x00040000)
#define MASK_BIT19          (0x00080000)
#define MASK_BIT20          (0x00100000)
#define MASK_BIT21          (0x00200000)
#define MASK_BIT22          (0x00400000)
#define MASK_BIT23          (0x00800000)
#define MASK_BIT24          (0x01000000)
#define MASK_BIT25          (0x02000000)
#define MASK_BIT26          (0x04000000)
#define MASK_BIT27          (0x08000000)
#define MASK_BIT28          (0x10000000)
#define MASK_BIT29          (0x20000000)
#define MASK_BIT30          (0x40000000)
#define MASK_BIT31          (0x80000000)
#endif // MASK_BIT0

//-- byte enable masks --
#define STR_NO_BYTE_EN     (0x0)
#define STR_BYTE0_EN       (0x1)
#define STR_BYTE1_EN       (0x2)
#define STR_BYTE2_EN       (0x4)
#define STR_BYTE3_EN       (0x8)
#define STR_LOWER_WORD_EN  (STR_BYTE1_EN | STR_BYTE0_EN)
#define STR_UPPER_WORD_EN  (STR_BYTE3_EN | STR_BYTE2_EN)
#define STR_LONGWORD_EN    (STR_UPPER_WORD_EN | STR_LOWER_WORD_EN)

//-- byte masks --
#define BYTE0_MASK       (0x000000FF)
#define BYTE1_MASK       (0x0000FF00)
#define BYTE2_MASK       (0x00FF0000)
#define BYTE3_MASK       (0xFF000000)
#define LOWER_WORD_MASK  (BYTE1_MASK | BYTE0_MASK)
#define UPPER_WORD_MASK  (BYTE3_MASK | BYTE2_MASK)
#define LONGWORD_MASK    (UPPER_WORD_MASK | LOWER_WORD_MASK)

#endif // _STR_CONST_H


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: str_const.h $
//   Revision 1.16  2009/02/23 18:36:56Z  myong
//   Changed TX HBFILT output delay from 4 to 5.
//   Revision 1.67  2009-02-10 08:51:13-05  kelliher
//   Increase fifo delay for afe interp
//
//   Revision 1.66  2009-02-09 08:46:29-05  cwlee
//   increase Decim FIFO depth to 5 for support of 144 out rate
//
//   Revision 1.65  2009-02-02 11:25:45-05  astone
//   RxIIR FIFO depth reduced 8 to 6
//
//   Revision 1.64  2009-01-29 18:10:36-05  lxin
//   Update to new BM
//
//   Revision 1.12  2009/01/29 16:49:28Z  myong
//   the following have been removed the specs/RTL:
//   1) Coefficient storage for Tx IIR BQ 6,7 -- we only support BQ0 to BQ5 now at the maximum.
//   2) Register bits for the section shifts associated with BQ 6,7
//   Revision 1.11  2009/01/27 15:16:40Z  myong
//   (per the ASIC team request), change the constant MAX_DECIM2_FACTOR defined in str_const.h from 64 to 32
//   Revision 1.10  2009/01/22 18:56:05Z  yangcao
//   Revision 1.9  2009/01/21 21:27:27Z  yangcao
//   implemeted Tx input fifo for txsrc
//   Revision 1.8  2009/01/19 22:13:37Z  yangcao
//   (1). Per spec change removed DECIM1 block. For decimation factor being 32x or 64x,
//   2-stage decimation is used with the first stage decimation having a constant factor of 4x.
//   This checkin removed stage 1 decim. Decim2 now has the largest decimation factor 64x.
//   Revision 1.58  2009-01-12 08:54:09-05  kelliher
//   Adjusted fifo delays for SRC
//
//   Revision 1.57  2008-12-30 17:21:46-05  lxin
//   Remove obsolete comments
//
//   Revision 1.6  2008/12/22 19:32:41Z  yangcao
//   Revision 1.5  2008/12/22 15:20:50Z  myong
//   Rename "NO_EXCEPTION" to "NO_STR_EXCEPTION" otherwise there is conflict between
//   this BM with some of the other BMs.
//   Revision 1.4  2008/12/18 20:25:01Z  yangcao
//   Revision 1.3  2008/12/17 17:31:43Z  yangcao
//   Revision 1.2  2008/12/11 17:54:18Z  yangcao
//   Revision 1.49  2008-11-20 14:56:36-05  astone
//   Add HBFilt registers. Remove Core Decim feature.
//
//   Revision 1.48  2008-11-19 17:57:19-05  kelliher
//   .Increase Tx SRC fifo
//
//   Revision 1.47  2008-11-17 17:01:37-05  kelliher
//   backout txsrc delay inconsistency
//
//   Revision 1.46  2008-11-12 11:32:16-05  astone
//   Increase Tx IIR Coefficient Precision
//
//   Revision 1.45  2008-10-30 15:40:10-04  kelliher
//   Changed TX SRC FIFO length for bypass mode skew caused by nonideal pipeline delay going through TXINPUT FIFO in RTL
//
//   Revision 1.44  2008-10-30 13:30:11-04  astone
//   MAX_NUM_PORTS 4 --> 2
//
//   Revision 1.43  2008-10-28 17:18:13-04  astone
//   SRC
//
//   Revision 1.42  2008-10-24 16:33:07-04  kelliher
//   core decim
//
//   Revision 1.41  2008-05-05 09:13:28-04  chriss
//   update dec/tdq output fifo depth
//
//
//   Revision 1.40  2008-05-01 19:24:20-04  lkang
//   cleaned up DEC capture macros
//
//   Revision 1.39  2008-04-29 19:12:45-04  lkang
//   updated DEC output delay
//
//   Revision 1.38  2008-04-18 16:27:17-04  lkang
//   added macros for DEC adaptation mode
//
//   Revision 1.37  2008-04-17 17:18:36-04  lkang
//   defined scaling factors for DEC/TDQ lengths
//   renamed DEC capture states
//   changed TDQ pipeline delay
//   removed summing junction pipeline delay
//
//   Revision 1.36  2008-03-10 12:00:01-04  lkang
//   changed TDQ pipeline delay
//
//   Revision 1.35  2008-03-07 18:14:24-05  lkang
//   added constants for shadow register FIFOs
//
//   Revision 1.34  2008-02-13 15:07:29-05  jgross
//   Set rx fft delay to 2 samples
//
//   Revision 1.33  2008-01-31 15:11:03-05  cwlee
//   adjust decim2 output delay
//
//   Revision 1.32  2007-12-19 16:00:51-05  astone
//   Change Tx IIR output FIFO depth from 5 to 6.
//
//   Revision 1.31  2007-12-13 12:07:10-05  astone
//   Fix rx vg and win fifo depths.
//
//   Revision 1.30  2007-12-12 08:54:31-05  jgross
//   Add interp bypass/reset. Fix decim reset
//
//   Revision 1.28  2007-12-11 09:59:48-05  jgross
//   Add decim bypass and decim reset functionality
//
//   Revision 1.27  2007-10-11 14:15:16-04  astone
//   txiir output delay change from 4 to 5
//
//   Revision 1.26  2007-10-02 11:50:36-04  lkang
//   moved FIFO constants to str_typedef.h
//   deleted old constants from Herc2
//   other minor file cleanup
//
//   Revision 1.25  2007-10-02 11:19:58-04  lkang
//   added macros for DEC/TDQ FIFOs and filters
//
//   Revision 1.24  2007-10-01 13:06:04-04  jgross
//   Add the IFFT delay as part of the VG pipeline
//
//   Revision 1.23  2007-09-28 11:57:32-04  lkang
//   added delay constants for IFFT and FFT access
//
//   Revision 1.22  2007-09-21 17:01:03-04  lkang
//   added Tx win output delay
//
//   Revision 1.21  2007-09-21 15:45:04-04  lkang
//   added constants for Tx Var Gain delays
//
//   Revision 1.20  2007-09-20 17:01:58-04  lkang
//   added macros for Rx win delays
//
//   Revision 1.19  2007-09-20 13:30:32-04  lkang
//   added Rx Var Gain FIFO delay
//
//   Revision 1.18  2007-09-18 18:12:35-04  lkang
//   added constant for ADC Adjust FIFO
//
//   Revision 1.17  2007-09-10 16:46:32-04  lkang
//   updated Rx IIR precision paramters
//
//   Revision 1.16  2007-09-10 12:57:46-04  lkang
//   define enum for FIFO data type
//
//   Revision 1.15  2007-08-28 16:19:24-04  lkang
//   added DECIM2 constants
//
//   Revision 1.14  2007-08-28 15:09:17-04  astone
//   Increase interp out delay from 2 to 4
//
//   Revision 1.13  2007-08-24 09:38:38-04  jgross
//   Adjust the decim delay
//
//   Revision 1.12  2007-08-17 16:48:09-04  astone
//   modify tx iir delay
//
//   Revision 1.11  2007-08-17 14:37:57-04  lkang
//   added Tx Interp parameters
//
//   Revision 1.10  2007-08-17 11:23:59-04  lkang
//   added Tx IIR FIFO parameters
//
//   Revision 1.9  2007-08-16 14:31:07-04  lkang
//   added const for DECIM2 length
//
//   Revision 1.8  2007-08-15 16:58:31-04  lkang
//   added decim constants
//
//   Revision 1.7  2007-08-15 14:51:25-04  lkang
//   updated mems to allow 16-bit representations
//
//   Revision 1.6  2007-08-14 16:31:07-04  lkang
//   added Rx IIR output delay constants
//
//   Revision 1.5  2007-08-10 19:06:05-04  lkang
//   added constants for Window and FIFO functions
//
//   Revision 1.4  2007-08-02 13:35:09-04  lkang
//   reated 2 sets of IIR truncation parameters - for past results and output samples
//
//   Revision 1.3  2007-07-31 15:29:32-04  lkang
//   updated IIR constants
//
//   Revision 1.2  2007-07-27 18:11:14-04  lkang
//   added constants related to acc_ops and FIR
//
//   Revision 1.1  2007-06-22 14:59:24-04  lkang
//   Initial Revision
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

