/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2007 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//

// Filename : $RCSfile: str_io_typedef.h $
// Creator  : Leiter Kang
// Created  : 06/19/2007
// Revision : $Revision: 1.1 $
// Rev Date : $Date: 2008/09/23 19:08:47Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Typedefs for Interfaces in Strymon BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _STR_IO_TYPEDEF_H
#define _STR_IO_TYPEDEF_H

#include "str_basic_type.h"  // include basic types

// Strymon input strobe structures
typedef struct {
   uint8 uc_TX_BUFSWAP;       // Transmit IFFT buffer swap Strobe
   uint8 uc_TX_CSCAPTURE_START;  // Strobe starting saving of Tx frame's last-beta portion
   uint8 uc_TX_WINDOW_START;     // Strobe kicking off windowed summation of Tx frame's
                           // CP and last frame's last-beta portion of CS
   uint16 us_TX_BETA_SIZE;       // Beta length
   uint8 uc_TOFS_IN;          // Tx Offset Input Strobe
   uint8 uc_TOFS_ER;          // Tx Offset Error Strobe
   uint8 uc_RX_BUFSWAP;       // Transmit IFFT buffer swap Strobe
   uint8 uc_RX_CPCAPTURE_START;  // Strobe starting saving of Rx CP's last-Lw portion
   uint8 uc_RX_WINDOW_START;     // Strobe kicking off windowed summation of Rx frame's
                           // last-Lw portion and last-Lw portion of CP.
   uint16 us_RX_LW_SIZE;         // length of Lw.
   uint8 uc_IRSFS;               // Receive Sync Frame Strobe
   uint8 uc_RSTN;             // Asynchronous reset
} Str_Input_t;

// Strymon output strobe structures
typedef struct {
   int16 s_DECDONE;
} Str_Output_t;

// Strymon Core I/O structure
typedef struct {
   int32 l_TxIn;
   int16 s_TxOut;
   int16 s_RxIn;
   int16 s_RxOut;
} StrymonCoreIO_t;

#endif // _STR_IO_TYPEDEF_H

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: str_io_typedef.h $
//   Revision 1.1  2008/09/23 19:08:47Z  myong
//   Initial revision
//   Revision 1.1  2008/09/19 21:51:43Z  jgreszcz
//   Initial revision
//   Revision 1.2  2007-07-31 15:29:08-04  lkang
//   moved basic types to separate file
//
//   Revision 1.1  2007-06-22 14:59:24-04  lkang
//   Initial Revision
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

