/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//

// Filename : $RCSfile: str_memmap.h $
// Creator  : Leiter Kang
// Created  : 06/20/2007
// Revision : $Revision: 1.20 $
// Rev Date : $Date: 2010/01/29 21:32:14Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Memory Map Constants for Strymon BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _STR_MEMMAP_H
#define _STR_MEMMAP_H


/********** REGISTER PARAMETERS **********/

//----- addresses -----
#ifdef VRX518
#define STR_REG_BASE_ADDR      (0x30C600)
#else
#define STR_REG_BASE_ADDR      (0x20C600)
#endif

#define V_CONTROL_OFFSET          (0x00<<2)
#define V_BLOCK_RSTN_OFFSET       (0x01<<2)
#define V_OVERFLOW_OFFSET         (0x02<<2)
#define V_TXIIR1_CFG_OFFSET       (0x03<<2)
#define V_TXIIR2_CFG_OFFSET       (0x04<<2)
#define V_RXIIR1_CFG_OFFSET       (0x05<<2)
#define V_RXIIR2_CFG_OFFSET       (0x06<<2)
#define V_INTERP_CFG_OFFSET       (0x07<<2)
#define V_DECIM_CFG_OFFSET        (0x08<<2)
#define V_DEC_CFG_OFFSET          (0x09<<2)
#define V_TDQ_CFG_OFFSET          (0x0A<<2)
#define V_DEC_CAPTURE_OFFSET      (0x0B<<2)
#define V_ADAPT_CTRL_OFFSET       (0x0C<<2)
#define V_TX_VARGAIN_OFFSET       (0x0D<<2)
#define V_TX_AVARGAIN_OFFSET      (0x0E<<2)
#define V_RX_VARGAIN_OFFSET       (0x0F<<2)
#define V_RX_AVARGAIN_OFFSET      (0x10<<2)
#define V_ADC_ADJUST_OFFSET       (0x11<<2)

#ifdef VRX518
#define V_FRAME_SKEW_35B_OFFSET   (0x12<<2)
#define V_TX_EXTEN_35B_OFFSET     (0x13<<2)
#define V_TX_EXTEN_A_35B_OFFSET   (0x14<<2)
#define V_TX_BETA_35B_OFFSET      (0x15<<2)
#define V_TX_BETA_A_35B_OFFSET    (0x16<<2)
#define V_TX_FSIZE_35B_OFFSET     (0x17<<2)
#define V_TX_FSIZE_A_35B_OFFSET   (0x18<<2)
#else
#define V_FRAME_SKEW_OFFSET       (0x12<<2)
#define V_TX_EXTEN_OFFSET         (0x13<<2)
#define V_TX_EXTEN_A_OFFSET       (0x14<<2)
#define V_TX_BETA_OFFSET          (0x15<<2)
#define V_TX_BETA_A_OFFSET        (0x16<<2)
#define V_TX_FSIZE_OFFSET         (0x17<<2)
#define V_TX_FSIZE_A_OFFSET       (0x18<<2)
#endif
#define V_FSOFFSET_IN_OFFSET      (0x19<<2)
#define V_FSOFFSET_ER_OFFSET      (0x1A<<2)

#ifdef VRX518
#define V_RX_EXTEN_35B_OFFSET     (0x1B<<2)
#define V_RX_EXTEN_A_35B_OFFSET   (0x1C<<2)
#define V_RX_WSIZE_35B_OFFSET     (0x1D<<2)
#define V_RX_WSIZE_A_35B_OFFSET   (0x1E<<2)
#define V_RX_FSIZE_35B_OFFSET     (0x1F<<2)
#define V_RX_FSIZE_A_35B_OFFSET   (0x20<<2)
#else
#define V_RX_EXTEN_OFFSET         (0x1B<<2)
#define V_RX_EXTEN_A_OFFSET       (0x1C<<2)
#define V_RX_WSIZE_OFFSET         (0x1D<<2)
#define V_RX_WSIZE_A_OFFSET       (0x1E<<2)
#define V_RX_FSIZE_OFFSET         (0x1F<<2)
#define V_RX_FSIZE_A_OFFSET       (0x20<<2)
#endif

#define V_SERDES_XBAR_OFFSET      (0x21<<2)
#define V_SRCFR_OFFSET            (0x22<<2)
#define V_SRCCTL_OFFSET           (0x23<<2)
#define V_SRC_CFG_OFFSET          (0x24<<2)
#define V_HBFILT_CFG_OFFSET       (0x25<<2)
#define V_AFE_SERIAL_CFG_OFFSET   (0x26<<2)
#define V_AFE_SERIAL_ADDR_OFFSET  (0x27<<2)
#define V_AFE_SERIAL_WDATA_OFFSET (0x28<<2)
#define V_AFE_SERIAL_RDATA_OFFSET (0x29<<2)

#ifdef VRX518
#define V_SRC_MSEL_35B_OFFSET    (0x26<<2)
#endif

#ifdef VRX518
#define STR_TX_WDF_REG_BASE_ADDR       (0x30B000)
#define STR_RX_WDF_REG_BASE_ADDR       (0x30B100)

// --- New DFI Memory Map --- //
#define STR_NEW_REG_BASE_ADDR          (0x30B000)
#define STR_FCSI_C_REG_BASE_ADDR       (0x30C700)
#define STR_FCSI_D_REG_BASE_ADDR       (0x30C740)
#define STR_35B_REG_BASE_ADDR          (0x30C780)
#define STR_DFI_TX_WDF_REG_BASE_ADDR    (0x30B400)
#define STR_DFI_RX_WDF_REG_BASE_ADDR    (0x30B500)
#define STR_DFI_DEC_CIC_REG_BASE_ADDR   (0x30B600)
#define STR_DFI_NS_REG_BASE_ADDR       (0x30B700)

// FCSI-C and FCSI-D Regs
#define V_FCSI_CMD_35B_OFFSET             (0x00)
#define V_FCSI_XBUF_35B_OFFSET            (0x04)
#define V_FCSI_RBUF_35B_OFFSET            (0x08)
#define V_FCSI_IRNCR_35B_OFFSET           (0x10)
#define V_FCSI_IRNICR_35B_OFFSET             (0x14)
#define V_FCSI_IRNEN_35B_OFFSET           (0x18)
#define V_FCSI_EIRNCR_35B_OFFSET             (0x20)
#define V_FCSI_EIRNICR_35B_OFFSET         (0x24)
#define V_FCSI_EIRNEN_35B_OFFSET             (0x28)
#endif

#ifdef VRX518
#define STR_REG_MAX_OFFSET     (STR_35B_REG_BASE_ADDR+V_DFI_BLK_RSTN_35B_OFFSET-STR_REG_BASE_ADDR)
#define STR_REG_MAX_ADDR       (STR_REG_BASE_ADDR + STR_REG_MAX_OFFSET)
#else
#define STR_REG_MAX_OFFSET     (V_AFE_SERIAL_RDATA_OFFSET)
#define STR_REG_MAX_ADDR       (STR_REG_BASE_ADDR + STR_REG_MAX_OFFSET)
#endif

#ifdef VRX518
// STR_35B
#define V_LBK_35B_OFFSET               (0x00)
#define V_DFI_TX_FIFO_35B_OFFSET          (0x04)
#define V_DFI_RX_FIFO_35B_OFFSET          (0x08)
#define V_DFI_BLK_RSTN_35B_OFFSET       (0x0C)


// TX and RX
//#define V_TX_DFI_SEL_35B_OFFSET               (0x00)
#define V_TX_WDF_INT1_CTRL_35B_OFFSET           (0x00)
#define V_TX_WDF_INT1_COEF_35B_OFFSET           (0x04)

//#define V_RX_SRC_SEL_35B_OFFSET               (0x00)
#define V_RX_WDF_DEC1_CTRL_35B_OFFSET           (0x00)
#define V_RX_WDF_DEC1_COEF_35B_OFFSET           (0x04)

// DFI_TX
//#define V_DFI_TX_NS_SEL_35B_OFFSET            (0x00)
#define V_DFI_TX_WDF_INT2_CTRL_35B_OFFSET       (0x00)
#define V_DFI_TX_WDF_INT2_COEF_35B_OFFSET       (0x04)

// DFI_RX
//#define V_DFI_RX_ADCADJ_SEL_35B_OFFSET          (0x00)
#define V_DFI_RX_WDF_DEC2_CTRL_35B_OFFSET       (0x00)
#define V_DFI_RX_WDF_DEC2_COEF_35B_OFFSET       (0x04)

// CIC
//#define V_DFI_RX_CIC_SEL_35B_OFFSET             (0x00)
#define V_DFI_RX_CIC_DEC_CTRL_35B_OFFSET        (0x00)

// NS
//#define V_DFI_RX_WDF_DEC2_SEL_35B_OFFSET        (0x00)
#define V_DFI_TX_NS_CTRL_35B_OFFSET             (0x00)
#define V_DFI_TX_NS_COEF_35B_OFFSET             (0x04)

#define STR_NEW_REG_MAX_OFFSET     (STR_DFI_NS_REG_BASE_ADDR+V_DFI_TX_NS_COEF_35B_OFFSET-STR_NEW_REG_BASE_ADDR)
#define STR_NEW_REG_MAX_ADDR       (STR_NEW_REG_BASE_ADDR + STR_NEW_REG_MAX_OFFSET)

#endif //VRX518


//----- masks -----
#define V_CONTROL_MASK          (0x0FFFCFFF)
#define V_BLOCK_RSTN_MASK       (0x00000002)
#define V_OVERFLOW_MASK         (0x00003EFF)
#define V_TXIIR1_CFG_MASK       (0x01F7FFFF)
#define V_TXIIR2_CFG_MASK       (0x000F00FF)
#define V_RXIIR1_CFG_MASK       (0x01F7FFFF)
#define V_RXIIR2_CFG_MASK       (0x000F00FF)
#define V_INTERP_CFG_MASK       (0xF0F21F03)  // FIXME: mask?
#define V_DECIM_CFG_MASK        (0xFFF1EF1F)
#define V_DEC_CFG_MASK          (0xFF1F7F3F)
#define V_TDQ_CFG_MASK          (0x2FE000E0)  // FIXME: mask?
#define V_DEC_TRAIN_MASK        (0x380003FE)  // FIXME: mask?
#define V_TX_VARGAIN_MASK       (0x0007FFFF)
#define V_TX_AVARGAIN_MASK      (0x0007FFFF)
#define V_RX_VARGAIN_MASK       (0x0007FFFF)
#define V_RX_AVARGAIN_MASK      (0x0007FFFF)
#define V_ADC_ADJUST_MASK       (0x000FFFFE)
#ifdef VRX518
#define V_FRAME_SKEW_35B_MASK   (0x0001FFFF)
#define V_TX_EXTEN_35B_MASK     (0x3FFFFFFF)
#define V_TX_EXTEN_A_35B_MASK   (0x3FFFFFFF)
#define V_TX_BETA_35B_MASK      (0x000003FF)
#define V_TX_BETA_A_35B_MASK        (0x000003FF)
#define V_TX_FSIZE_35B_MASK         (0x000F7FFF)
#define V_TX_FSIZE_A_35B_MASK       (0x000F7FFF)
#else
#define V_FRAME_SKEW_MASK       (0x000003FF)
#define V_TX_EXTEN_MASK         (0x1FFFFFFF)
#define V_TX_EXTEN_A_MASK       (0x1FFFFFFF)
#define V_TX_BETA_MASK          (0x000001FF)
#define V_TX_BETA_A_MASK        (0x000001FF)
#define V_TX_FSIZE_MASK         (0x00003FFF)
#define V_TX_FSIZE_A_MASK       (0x00003FFF)
#endif

#define V_FSOFFSET_IN_MASK      (0x00003FFF)
#define V_FSOFFSET_ER_MASK      (0x00003FFF)

#ifdef VRX518
#define V_RX_EXTEN_35B_MASK         (0x7FFFFFFF)
#define V_RX_EXTEN_A_35B_MASK       (0x7FFFFFFF)
#define V_RX_WSIZE_35B_MASK         (0x000003FF)
#define V_RX_WSIZE_A_35B_MASK       (0x000003FF)
#define V_RX_FSIZE_35B_MASK         (0x000F7FFF)
#define V_RX_FSIZE_A_35B_MASK       (0x000F7FFF)
#else
#define V_RX_EXTEN_MASK         (0x0FFFFFFF)
#define V_RX_EXTEN_A_MASK       (0x0FFFFFFF)
#define V_RX_WSIZE_MASK         (0x000001FF)
#define V_RX_WSIZE_A_MASK       (0x000001FF)
#define V_RX_FSIZE_MASK         (0x00003FFF)
#define V_RX_FSIZE_A_MASK       (0x00003FFF)
#endif

#define V_SERDES_XBAR_MASK      (0x00000301)
#define V_ADAPT_RAM_IF_MASK     (0x00000007)
#define V_SRCFR_MASK            (0x000FFFFF)
#define V_SRCCTL_MASK           (0x00FFFFFF)
#define V_SRC_CFG_MASK          (0xC0F3007F)
#define V_HBFILT_CFG_MASK       (0xF0010000)
#define V_AFE_SERIAL_CFG_MASK   (0x000FFFFF)
#define V_AFE_SERIAL_ADDR_MASK  (0x00003FFF)
#define V_AFE_SERIAL_WDATA_MASK (0x0000FFFF)
#define V_AFE_SERIAL_RDATA_MASK (0x00000000)



#ifdef VRX518
#define V_SRC_MSEL_35B_MASK   (0x00000001)

// FCSI-C and FCSI-D Regs
#define V_FCSI_CMD_C_MASK     (0x0000FF7F)
#define V_FCSI_XBUF_C_MASK      (0x0000FFFF)
#define V_FCSI_RBUF_C_MASK      (0x0000FFFF)
#define V_FCSI_IRNCR_C_MASK     (0x0000000F)
#define V_FCSI_IRNICR_C_MASK    (0x0000000F)
#define V_FCSI_IRNEN_C_MASK     (0x0000000F)
#define V_FCSI_EIRNCR_C_MASK    (0x00000007)
#define V_FCSI_EIRNICR_C_MASK          (0x00000007)
#define V_FCSI_EIRNEN_C_MASK           (0x00000007)

#define V_FCSI_CMD_D_MASK           (0x0000FF7F)
#define V_FCSI_XBUF_D_MASK             (0x0000FFFF)
#define V_FCSI_RBUF_D_MASK             (0x0000FFFF)
#define V_FCSI_IRNCR_D_MASK            (0x0000000F)
#define V_FCSI_IRNICR_D_MASK           (0x0000000F)
#define V_FCSI_IRNEN_D_MASK            (0x0000000F)
#define V_FCSI_EIRNCR_D_MASK           (0x00000007)
#define V_FCSI_EIRNICR_D_MASK          (0x00000007)
#define V_FCSI_EIRNEN_D_MASK           (0x00000007)

// STR_35B
#define V_LBK_35B_MASK              (0x0001FFFF)      // VRX518_OPEN : Check VDSL
#define V_DFI_TX_FIFO_35B_MASK         (0x00030073)      // VRX518_OPEN : Check VDSL
#define V_DFI_RX_FIFO_35B_MASK         (0x00030073)      // VRX518_OPEN : Check VDSL
#define V_DFI_BLK_RSTN_35B_MASK        (0x00070007)

// TX and RX
//#define V_TX_DFI_SEL_35B_MASK           (0x00000001)
#define V_TX_WDF_INT1_CTRL_MASK           (0x00010007)
#define V_TX_WDF_INT1_COEF_MASK           (0xFFFFFFFF)

//#define V_RX_SRC_SEL_35B_MASK           (0x00000001)
#define V_RX_WDF_DEC1_CTRL_MASK           (0x00010007)
#define V_RX_WDF_DEC1_COEF_MASK           (0xFFFFFFFF)

// DFI_TX
//#define V_DFI_TX_NS_SEL_35B_MASK           (0x00000001)
#define V_DFI_TX_WDF_INT2_CTRL_35B_MASK         (0x00010007)
#define V_DFI_TX_WDF_INT2_COEF_35B_MASK         (0x00FFFFFF)

// DFI_RX
//#define V_DFI_RX_ADCADJ_SEL_35B_MASK          (0x00000001)
#define V_DFI_RX_WDF_DEC2_CTRL_35B_MASK       (0x0001000F)
#define V_DFI_RX_WDF_DEC2_COEF_35B_MASK       (0x00FFFFFF)

// CIC
//#define V_DFI_RX_CIC_SEL_35B_MASK             (0x00000001)
#define V_DFI_RX_CIC_DEC_CTRL_35B_MASK        (0x0000000F)

// NS
//#define V_DFI_RX_WDF_DEC2_SEL_35B_MASK        (0x00000001)
#define V_DFI_TX_NS_CTRL_35B_MASK             (0x0000107F)     // VRX518_OPEN: Check VDSL
#define V_DFI_TX_NS_COEF_35B_MASK             (0x000003FF)     // VRX518_OPEN: Check VDSL
#endif

/********** MEMORY PARAMETERS **********/
#define STR_NUM_MEM (23)

enum STR_MEM_ID {
  STR_MEM_DEC_TDQ_CO,
  STR_MEM_DEC_TDQ_PS,
  STR_MEM_TXWIN_CO_PS,
  STR_MEM_RXWIN_CO_PS,
  STR_MEM_TXIIR_CO,
  STR_MEM_RXIIR_CO,
  STR_MEM_INTERP_CO,
  STR_MEM_DECIM_CO,
  STR_MEM_DECIM2_CO_PS,
  STR_MEM_DECIM_PS,
  STR_MEM_DEC_ADAPT,
  STR_MEM_RXSRC_B00,
  STR_MEM_RXSRC_B01,
  STR_MEM_RXSRC_B02,
  STR_MEM_RXSRC_B12,
  STR_MEM_RXSRC_B11,
  STR_MEM_RXSRC_B10,
  STR_MEM_TXSRC_B00,
  STR_MEM_TXSRC_B01,
  STR_MEM_TXSRC_B02,
  STR_MEM_TXSRC_B12,
  STR_MEM_TXSRC_B11,
  STR_MEM_TXSRC_B10
};

//----- addresses -----
#ifdef VRX518
#define STR_MEM_BASE_ADDR     (0x300000)
#else
#define STR_MEM_BASE_ADDR     (0x200000)
#endif

#define V_DECIM_CO_OFFSET     (0x0000)
#define V_DECIM2_CO_PS_OFFSET (0x0400)
#define V_DECIM_PS_OFFSET     (0x0800)
#define V_RXWIN_CO_PS_OFFSET  (0x1000)
#ifdef VRX518
#define V_TXWIN_CO_PS_OFFSET  (0x1600)
#else
#define V_TXWIN_CO_PS_OFFSET  (0x1800)
#endif
#define V_DEC_TDQ_PS_OFFSET   (0x2000)
#define V_DEC_TDQ_CO_OFFSET   (0x2800)
#define V_TXIIR_CO_OFFSET     (0x4000)
#define V_RXIIR_CO_OFFSET     (0x4100)
#define V_INTERP_CO_OFFSET    (0x4400)
#define V_DEC_ADAPT_OFFSET    (0x4800)
#define V_RXSRC_B00_OFFSET    (0x5000)
#define V_RXSRC_B01_OFFSET    (0x5800)
#define V_RXSRC_B02_OFFSET    (0x6000)
#define V_RXSRC_B12_OFFSET    (0x6800)
#define V_RXSRC_B11_OFFSET    (0x7000)
#define V_RXSRC_B10_OFFSET    (0x7800)
#define V_TXSRC_B00_OFFSET    (0x8000)
#define V_TXSRC_B01_OFFSET    (0x8800)
#define V_TXSRC_B02_OFFSET    (0x9000)
#define V_TXSRC_B12_OFFSET    (0x9800)
#define V_TXSRC_B11_OFFSET    (0xA000)
#define V_TXSRC_B10_OFFSET    (0xA800)

//----- sizes (bytes) -----
#define V_DECIM_CO_SIZE      ( 544)
#define V_DECIM2_CO_PS_SIZE  (1024)
#define V_DECIM_PS_SIZE      ( 576)
#ifdef VRX518
#define V_RXWIN_CO_PS_SIZE   (1472)
#define V_TXWIN_CO_PS_SIZE   (2304)
#else
#define V_RXWIN_CO_PS_SIZE   ( 768)
#define V_TXWIN_CO_PS_SIZE   (1152)
#endif
#define V_DEC_TDQ_PS_SIZE    (2048)
#define V_DEC_TDQ_CO_SIZE    (1536)
#define V_TXIIR_CO_SIZE      ( 124)
#define V_RXIIR_CO_SIZE      ( 124)
#define V_INTERP_CO_SIZE     ( 768)
#define V_INTERP_PS_SIZE     (  96)
#define V_DEC_ADAPT_SIZE     (2048)
#define V_RXSRC_B00_SIZE     (2048)
#define V_RXSRC_B01_SIZE     (2048)
#define V_RXSRC_B02_SIZE     (2048)
#define V_RXSRC_B12_SIZE     (2048)
#define V_RXSRC_B11_SIZE     (2048)
#define V_RXSRC_B10_SIZE     (2048)
#define V_TXSRC_B00_SIZE     (2048)
#define V_TXSRC_B01_SIZE     (2048)
#define V_TXSRC_B02_SIZE     (2048)
#define V_TXSRC_B12_SIZE     (2048)
#define V_TXSRC_B11_SIZE     (2048)
#define V_TXSRC_B10_SIZE     (2048)


//----- masks -----
#define V_DEC_TDQ_CO_MASK    (0xFFFFFFFF)
#define V_DEC_TDQ_PS_MASK    (0xFFFFFFFF)
#define V_TXWIN_CO_PS_MASK   (0xFFFFFFFF)
#define V_RXWIN_CO_PS_MASK   (0xFFFFFFFF)
#define V_TXIIR_CO_MASK      (0x003FFFFF)
#define V_RXIIR_CO_MASK      (0x0003FFFF)
#define V_INTERP_CO_MASK     (0xFFFFFFFF)
#define V_DECIM_CO_MASK      (0xFFFFFFFF)
#define V_DECIM2_CO_PS_MASK  (0xFFFFFFFF)
#define V_DECIM_PS_MASK      (0xFFFFFFFF)
#define V_DEC_ADAPT_MASK     (0xFFFFFFFF)
#define V_RXSRC_B00_MASK     (0x01FFF0FF)
#define V_RXSRC_B01_MASK     (0x03FFF1FF)
#define V_RXSRC_B02_MASK     (0x1FFFF7FF)
#define V_RXSRC_B12_MASK     (0x1FFFF7FF)
#define V_RXSRC_B11_MASK     (0x03FFF1FF)
#define V_RXSRC_B10_MASK     (0x01FFF0FF)
#define V_TXSRC_B00_MASK     (0x01FFF0FF)
#define V_TXSRC_B01_MASK     (0x03FFF1FF)
#define V_TXSRC_B02_MASK     (0x1FFFF7FF)
#define V_TXSRC_B12_MASK     (0x1FFFF7FF)
#define V_TXSRC_B11_MASK     (0x03FFF1FF)
#define V_TXSRC_B10_MASK     (0x01FFF0FF)

/********** MEMORY-SPECIFIC PARAMETERS **********/
//----- IIR -----
#define RX_IIR_SEC_SIZE  (5)

#define RX_IIR_SEC0_IN_SC_OFFSET  (0)
#define RX_IIR_SEC0_A1_OFFSET     (1)
#define RX_IIR_SEC0_A2_OFFSET     (2)
#define RX_IIR_SEC0_B0_OFFSET     (3)
#define RX_IIR_SEC0_B1_OFFSET     (4)
#define RX_IIR_SEC0_B2_OFFSET     (5)

#define TX_IIR_SEC_SIZE  (5)

#define TX_IIR_SEC0_IN_SC_OFFSET  (0)
#define TX_IIR_SEC0_A1_OFFSET     (1)
#define TX_IIR_SEC0_A2_OFFSET     (2)
#define TX_IIR_SEC0_B0_OFFSET     (3)
#define TX_IIR_SEC0_B1_OFFSET     (4)
#define TX_IIR_SEC0_B2_OFFSET     (5)

//----- DECIM -----
#define RX_DECIM2_CO_OFFSET   (0)      // in words
#define RX_DECIM2_PS_OFFSET   (0)      // in words

//----- DEC -----
#define DEC_INTERP_PHASE_MEM_OFFSET   (512)
// Register addresses
#define V_CONTROL_ADDR          (STR_REG_BASE_ADDR + V_CONTROL_OFFSET)
#define V_BLOCK_RSTN_ADDR       (STR_REG_BASE_ADDR + V_BLOCK_RSTN_OFFSET)
#define V_OVERFLOW_ADDR         (STR_REG_BASE_ADDR + V_OVERFLOW_OFFSET)
#define V_TXIIR1_CFG_ADDR       (STR_REG_BASE_ADDR + V_TXIIR1_CFG_OFFSET)
#define V_TXIIR2_CFG_ADDR       (STR_REG_BASE_ADDR + V_TXIIR2_CFG_OFFSET)
#define V_RXIIR1_CFG_ADDR       (STR_REG_BASE_ADDR + V_RXIIR1_CFG_OFFSET)
#define V_RXIIR2_CFG_ADDR       (STR_REG_BASE_ADDR + V_RXIIR2_CFG_OFFSET)
#define V_INTERP_CFG_ADDR       (STR_REG_BASE_ADDR + V_INTERP_CFG_OFFSET)
#define V_DECIM_CFG_ADDR        (STR_REG_BASE_ADDR + V_DECIM_CFG_OFFSET)
#define V_DEC_CFG_ADDR          (STR_REG_BASE_ADDR + V_DEC_CFG_OFFSET)
#define V_TDQ_CFG_ADDR          (STR_REG_BASE_ADDR + V_TDQ_CFG_OFFSET)
#define V_DEC_CAPTURE_ADDR      (STR_REG_BASE_ADDR + V_DEC_CAPTURE_OFFSET)
#define V_ADAPT_CTRL_ADDR       (STR_REG_BASE_ADDR + V_ADAPT_CTRL_OFFSET)
#define V_TX_VARGAIN_ADDR       (STR_REG_BASE_ADDR + V_TX_VARGAIN_OFFSET)
#define V_TX_AVARGAIN_ADDR      (STR_REG_BASE_ADDR + V_TX_AVARGAIN_OFFSET)
#define V_RX_VARGAIN_ADDR       (STR_REG_BASE_ADDR + V_RX_VARGAIN_OFFSET)
#define V_RX_AVARGAIN_ADDR      (STR_REG_BASE_ADDR + V_RX_AVARGAIN_OFFSET)
#define V_ADC_ADJUST_ADDR       (STR_REG_BASE_ADDR + V_ADC_ADJUST_OFFSET)
#ifdef VRX518
#define V_FRAME_SKEW_35B_ADDR       (STR_REG_BASE_ADDR + V_FRAME_SKEW_35B_OFFSET)
#define V_TX_EXTEN_35B_ADDR         (STR_REG_BASE_ADDR + V_TX_EXTEN_35B_OFFSET)
#define V_TX_EXTEN_A_35B_ADDR       (STR_REG_BASE_ADDR + V_TX_EXTEN_A_35B_OFFSET)
#define V_TX_BETA_35B_ADDR          (STR_REG_BASE_ADDR + V_TX_BETA_35B_OFFSET)
#define V_TX_BETA_A_35B_ADDR        (STR_REG_BASE_ADDR + V_TX_BETA_A_35B_OFFSET)
#define V_TX_FSIZE_35B_ADDR         (STR_REG_BASE_ADDR + V_TX_FSIZE_35B_OFFSET)
#define V_TX_FSIZE_A_35B_ADDR       (STR_REG_BASE_ADDR + V_TX_FSIZE_A_35B_OFFSET)
#else
#define V_FRAME_SKEW_ADDR       (STR_REG_BASE_ADDR + V_FRAME_SKEW_OFFSET)
#define V_TX_EXTEN_ADDR         (STR_REG_BASE_ADDR + V_TX_EXTEN_OFFSET)
#define V_TX_EXTEN_A_ADDR       (STR_REG_BASE_ADDR + V_TX_EXTEN_A_OFFSET)
#define V_TX_BETA_ADDR          (STR_REG_BASE_ADDR + V_TX_BETA_OFFSET)
#define V_TX_BETA_A_ADDR        (STR_REG_BASE_ADDR + V_TX_BETA_A_OFFSET)
#define V_TX_FSIZE_ADDR         (STR_REG_BASE_ADDR + V_TX_FSIZE_OFFSET)
#define V_TX_FSIZE_A_ADDR       (STR_REG_BASE_ADDR + V_TX_FSIZE_A_OFFSET)
#endif
#define V_FSADDR_IN_ADDR        (STR_REG_BASE_ADDR + V_FSOFFSET_IN_OFFSET)
#define V_FSADDR_ER_ADDR        (STR_REG_BASE_ADDR + V_FSOFFSET_ER_OFFSET)
#ifdef VRX518
#define V_RX_EXTEN_35B_ADDR         (STR_REG_BASE_ADDR + V_RX_EXTEN_35B_OFFSET)
#define V_RX_EXTEN_A_35B_ADDR       (STR_REG_BASE_ADDR + V_RX_EXTEN_A_35B_OFFSET)
#define V_RX_WSIZE_35B_ADDR         (STR_REG_BASE_ADDR + V_RX_WSIZE_35B_OFFSET)
#define V_RX_WSIZE_A_35B_ADDR       (STR_REG_BASE_ADDR + V_RX_WSIZE_A_35B_OFFSET)
#define V_RX_FSIZE_35B_ADDR         (STR_REG_BASE_ADDR + V_RX_FSIZE_35B_OFFSET)
#define V_RX_FSIZE_A_35B_ADDR       (STR_REG_BASE_ADDR + V_RX_FSIZE_A_35B_OFFSET)
#else
#define V_RX_EXTEN_ADDR         (STR_REG_BASE_ADDR + V_RX_EXTEN_OFFSET)
#define V_RX_EXTEN_A_ADDR       (STR_REG_BASE_ADDR + V_RX_EXTEN_A_OFFSET)
#define V_RX_WSIZE_ADDR         (STR_REG_BASE_ADDR + V_RX_WSIZE_OFFSET)
#define V_RX_WSIZE_A_ADDR       (STR_REG_BASE_ADDR + V_RX_WSIZE_A_OFFSET)
#define V_RX_FSIZE_ADDR         (STR_REG_BASE_ADDR + V_RX_FSIZE_OFFSET)
#define V_RX_FSIZE_A_ADDR       (STR_REG_BASE_ADDR + V_RX_FSIZE_A_OFFSET)
#endif
#define V_SERDES_XBAR_ADDR      (STR_REG_BASE_ADDR + V_SERDES_XBAR_OFFSET)
#define V_SRCFR_ADDR            (STR_REG_BASE_ADDR + V_SRCFR_OFFSET)
#define V_SRCCTL_ADDR           (STR_REG_BASE_ADDR + V_SRCCTL_OFFSET)
#define V_SRC_CFG_ADDR          (STR_REG_BASE_ADDR + V_SRC_CFG_OFFSET)
#define V_HBFILT_CFG_ADDR       (STR_REG_BASE_ADDR + V_HBFILT_CFG_OFFSET)
#define V_AFE_SERIAL_CFG_ADDR   (STR_REG_BASE_ADDR + V_AFE_SERIAL_CFG_OFFSET)
#define V_AFE_SERIAL_ADDR_ADDR  (STR_REG_BASE_ADDR + V_AFE_SERIAL_ADDR_OFFSET)
#define V_AFE_SERIAL_WDATA_ADDR (STR_REG_BASE_ADDR + V_AFE_SERIAL_WDATA_OFFSET)
#define V_AFE_SERIAL_RDATA_ADDR (STR_REG_BASE_ADDR + V_AFE_SERIAL_RDATA_OFFSET)

//memory addresses
#define V_DECIM_CO_ADDR     (STR_MEM_BASE_ADDR + V_DECIM_CO_OFFSET)
#define V_DECIM2_CO_PS_ADDR (STR_MEM_BASE_ADDR + V_DECIM2_CO_PS_OFFSET)
#define V_DECIM_PS_ADDR     (STR_MEM_BASE_ADDR + V_DECIM_PS_OFFSET)
#define V_RXWIN_CO_PS_ADDR  (STR_MEM_BASE_ADDR + V_RXWIN_CO_PS_OFFSET)
#define V_TXWIN_CO_PS_ADDR  (STR_MEM_BASE_ADDR + V_TXWIN_CO_PS_OFFSET)
#define V_DEC_TDQ_PS_ADDR   (STR_MEM_BASE_ADDR + V_DEC_TDQ_PS_OFFSET)
#define V_DEC_TDQ_CO_ADDR   (STR_MEM_BASE_ADDR + V_DEC_TDQ_CO_OFFSET)
#define V_TXIIR_CO_ADDR     (STR_MEM_BASE_ADDR + V_TXIIR_CO_OFFSET)
#define V_RXIIR_CO_ADDR     (STR_MEM_BASE_ADDR + V_RXIIR_CO_OFFSET)
#define V_INTERP_CO_ADDR    (STR_MEM_BASE_ADDR + V_INTERP_CO_OFFSET)
#define V_DEC_ADAPT_ADDR    (STR_MEM_BASE_ADDR + V_DEC_ADAPT_OFFSET)
#define V_RXSRC_B00_ADDR    (STR_MEM_BASE_ADDR + V_RXSRC_B00_OFFSET)
#define V_RXSRC_B01_ADDR    (STR_MEM_BASE_ADDR + V_RXSRC_B01_OFFSET)
#define V_RXSRC_B02_ADDR    (STR_MEM_BASE_ADDR + V_RXSRC_B02_OFFSET)
#define V_RXSRC_B12_ADDR    (STR_MEM_BASE_ADDR + V_RXSRC_B12_OFFSET)
#define V_RXSRC_B11_ADDR    (STR_MEM_BASE_ADDR + V_RXSRC_B11_OFFSET)
#define V_RXSRC_B10_ADDR    (STR_MEM_BASE_ADDR + V_RXSRC_B10_OFFSET)
#define V_TXSRC_B00_ADDR    (STR_MEM_BASE_ADDR + V_TXSRC_B00_OFFSET)
#define V_TXSRC_B01_ADDR    (STR_MEM_BASE_ADDR + V_TXSRC_B01_OFFSET)
#define V_TXSRC_B02_ADDR    (STR_MEM_BASE_ADDR + V_TXSRC_B02_OFFSET)
#define V_TXSRC_B12_ADDR    (STR_MEM_BASE_ADDR + V_TXSRC_B12_OFFSET)
#define V_TXSRC_B11_ADDR    (STR_MEM_BASE_ADDR + V_TXSRC_B11_OFFSET)
#define V_TXSRC_B10_ADDR    (STR_MEM_BASE_ADDR + V_TXSRC_B10_OFFSET)

// New FCSI Registers

#ifdef VRX518
#define V_SRC_MSEL_35B_ADDR         (STR_REG_BASE_ADDR + V_SRC_MSEL_35B_OFFSET)

// FCSI-C and FCSI-D Regs
#define V_FCSI_CMD_C_35B_ADDR             (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_CMD_35B_OFFSET)
#define V_FCSI_XBUF_C_35B_ADDR            (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_XBUF_35B_OFFSET)
#define V_FCSI_RBUF_C_35B_ADDR            (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_RBUF_35B_OFFSET)
#define V_FCSI_IRNCR_C_35B_ADDR           (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_IRNCR_35B_OFFSET)
#define V_FCSI_IRNICR_C_35B_ADDR             (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_IRNICR_35B_OFFSET)
#define V_FCSI_IRNEN_C_35B_ADDR           (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_IRNEN_35B_OFFSET)
#define V_FCSI_EIRNCR_C_35B_ADDR             (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_EIRNCR_35B_OFFSET)
#define V_FCSI_EIRNICR_C_35B_ADDR         (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_EIRNICR_35B_OFFSET)
#define V_FCSI_EIRNEN_C_35B_ADDR             (STR_FCSI_C_REG_BASE_ADDR + V_FCSI_EIRNEN_35B_OFFSET)

#define V_FCSI_CMD_D_35B_ADDR             (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_CMD_35B_OFFSET)
#define V_FCSI_XBUF_D_35B_ADDR            (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_XBUF_35B_OFFSET)
#define V_FCSI_RBUF_D_35B_ADDR            (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_RBUF_35B_OFFSET)
#define V_FCSI_IRNCR_D_35B_ADDR           (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_IRNCR_35B_OFFSET)
#define V_FCSI_IRNICR_D_35B_ADDR             (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_IRNICR_35B_OFFSET)
#define V_FCSI_IRNEN_D_35B_ADDR           (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_IRNEN_35B_OFFSET)
#define V_FCSI_EIRNCR_D_35B_ADDR             (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_EIRNCR_35B_OFFSET)
#define V_FCSI_EIRNICR_D_35B_ADDR         (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_EIRNICR_35B_OFFSET)
#define V_FCSI_EIRNEN_D_35B_ADDR             (STR_FCSI_D_REG_BASE_ADDR + V_FCSI_EIRNEN_35B_OFFSET)

// STR_35B
#define V_LBK_35B_ADDR              (STR_35B_REG_BASE_ADDR + V_LBK_35B_OFFSET)
#define V_DFI_TX_FIFO_35B_ADDR         (STR_35B_REG_BASE_ADDR + V_DFI_TX_FIFO_35B_OFFSET)
#define V_DFI_RX_FIFO_35B_ADDR         (STR_35B_REG_BASE_ADDR + V_DFI_RX_FIFO_35B_OFFSET)
#define V_DFI_BLK_RSTN_35B_ADDR        (STR_35B_REG_BASE_ADDR + V_DFI_BLK_RSTN_35B_OFFSET)

// TX and RX
//#define V_TX_DFI_SEL_35B_ADDR        (STR_TX_WDF_REG_BASE_ADDR + V_TX_DFI_SEL_35B_OFFSET)
#define V_TX_WDF_INT1_CTRL_35B_ADDR          (STR_TX_WDF_REG_BASE_ADDR + V_TX_WDF_INT1_CTRL_35B_OFFSET)
#define V_TX_WDF_INT1_COEF_35B_ADDR          (STR_TX_WDF_REG_BASE_ADDR + V_TX_WDF_INT1_COEF_35B_OFFSET)

//#define V_RX_SRC_SEL_35B_ADDR        (STR_RX_WDF_REG_BASE_ADDR + V_RX_SRC_SEL_35B_OFFSET)
#define V_RX_WDF_DEC1_CTRL_35B_ADDR          (STR_RX_WDF_REG_BASE_ADDR + V_RX_WDF_DEC1_CTRL_35B_OFFSET)
#define V_RX_WDF_DEC1_COEF_35B_ADDR          (STR_RX_WDF_REG_BASE_ADDR + V_RX_WDF_DEC1_COEF_35B_OFFSET)
// DFI_TX
//#define V_DFI_TX_NS_SEL_35B_ADDR     (STR_DFI_TX_WDF_REG_BASE_ADDR + V_DFI_TX_NS_SEL_35B_OFFSET)
#define V_DFI_TX_WDF_INT2_CTRL_35B_ADDR (STR_DFI_TX_WDF_REG_BASE_ADDR + V_DFI_TX_WDF_INT2_CTRL_35B_OFFSET)
#define V_DFI_TX_WDF_INT2_COEF_35B_ADDR (STR_DFI_TX_WDF_REG_BASE_ADDR + V_DFI_TX_WDF_INT2_COEF_35B_OFFSET)
// DFI_RX
//#define V_DFI_RX_ADCADJ_SEL_35B_ADDR    (STR_DFI_RX_WDF_REG_BASE_ADDR + V_DFI_RX_ADCADJ_SEL_35B_OFFSET)
#define V_DFI_RX_WDF_DEC2_CTRL_35B_ADDR (STR_DFI_RX_WDF_REG_BASE_ADDR + V_DFI_RX_WDF_DEC2_CTRL_35B_OFFSET)
#define V_DFI_RX_WDF_DEC2_COEF_35B_ADDR (STR_DFI_RX_WDF_REG_BASE_ADDR + V_DFI_RX_WDF_DEC2_COEF_35B_OFFSET)

// CIC
//#define V_DFI_RX_CIC_SEL_35B_ADDR       (STR_DFI_DEC_CIC_REG_BASE_ADDR + V_DFI_RX_CIC_SEL_35B_OFFSET)
#define V_DFI_RX_CIC_DEC_CTRL_35B_ADDR  (STR_DFI_DEC_CIC_REG_BASE_ADDR + V_DFI_RX_CIC_DEC_CTRL_35B_OFFSET)

// NS
//#define V_DFI_RX_WDF_DEC2_SEL_35B_ADDR  (STR_DFI_NS_REG_BASE_ADDR + V_DFI_RX_WDF_DEC2_SEL_35B_OFFSET)
#define V_DFI_TX_NS_CTRL_35B_ADDR       (STR_DFI_NS_REG_BASE_ADDR + V_DFI_TX_NS_CTRL_35B_OFFSET)
#define V_DFI_TX_NS_COEF_35B_ADDR       (STR_DFI_NS_REG_BASE_ADDR + V_DFI_TX_NS_COEF_35B_OFFSET)
#endif //VRX518


//====================================================================
//Register field definitions (start)
//====================================================================

//For V_CONTROL, AFE rate is fixed at 144 MSPS
#define RX_ADC_RATE        (8<<24)     //The ADC rate = (144/(1<<(8-RX_ADC_RATE))) MSPS
#define TX_DAC_RATE        (8<<20)     //The ADC rate = (144/(1<<(8-TX_DAC_RATE))) MSPS
#define STR_LPBK_ENA    (1<<19)     //enable strymon loop back
#define FIFO_FORCE         (1<<31)
#define TX_UPD_SEL         (1<<30)
#define RX_UPD_SEL         (1<<28)
#define RESET_STATEN    (1<<9)

//For V_BLOCK_RSTN

//For V_OVERFLOW

//For V_TXIIR1_CFG
#define TXIIR_BYPASS    (1<<24)

//For V_TXIIR2_CFG

//For V_RXIIR_CFG
#define RXIIR_BYPASS    (1<<24)

//For V_INTERP_CFG
#define TX_INTERP_BYPASS   (1<<17)

//For V_DECIM_CFG
#define RX_DECIM_BYPASS    (1<<16)
#define RX_DECIM_IN_RATE   (8<<20)     //RX Decim input rate = (144/(1<<(8-RX_DECIM_IN_RATE))) MSPS
                              //AFE interface is fixed at 144 MSPS
#define RX_DECIM_IN_RATE_72   (7<<20)     //Since 1:2 interop HB filter is not used In the loopback mode,
                              //this rate is fixed at 72 MSPS
#define RX_DECIM_IN_RATE_144  (8<<20) //in normal mode

//For V_DEC_CFG
#define DEC_DISABLE        (0<<5)
#define DEC_ENABLE_MASK     (1<<5)

//For V_TDQ_CFG
#define TDQ_BYPASS         (1<<8)

//For V_DEC_CAPTURE

//For V_ADAPT_CTRL

//For V_TX_VARGAIN
//For V_TX_AVARGAIN

//For V_RX_VARGAIN
//For V_RX_AVARGAIN

//For V_ADC_ADJUST

//For V_FRAME_SKEW

//For V_TX_EXTEN and For V_TX_EXTEN_A
#ifdef VRX518
//For V_TX_EXTEN_35B and For V_TX_EXTEN_A_35B
#define TX_WIN_COEFF_MODE_VDSL   (1<<29)
#define TX_WIN_COEFF_MODE_ADSL   (0<<29)
#define WIN_EN       (1<<28)
#define CS_EN        (1<<27)
#define CP_EN        (1<<26)
#define CS_SIZE_LSB     (14)
#define CP_SIZE_LSB     (0)
#define CS_SIZE_MASK (0x3FFF<<CS_SIZE_LSB)   // VRX518_OPEN: Check VDSL
#define CP_SIZE_MASK (0x3FFF<<CP_SIZE_LSB)
#else
#define TX_WIN_COEFF_MODE_VDSL   (1<<28)
#define TX_WIN_COEFF_MODE_ADSL   (0<<28)
#define WIN_EN       (1<<26)
#define CS_EN        (1<<25)
#define CP_EN        (1<<24)
#define CS_SIZE_LSB     (13)
#define CP_SIZE_LSB     (0)
#define CS_SIZE_MASK (0x7FF<<CS_SIZE_LSB)
#define CP_SIZE_MASK (0x1FFF<<CP_SIZE_LSB)
#endif
//For V_TX_BETA and V_TX_BETA_A

//For V_TX_FSIZE and V_TX_FSIZE_A

//For V_FSOFFSET_IN

//For V_FSOFFSET_ER

//For V_RX_EXTEN and For V_RX_EXTEN_A
#ifdef VRX518
#define RX_SYNC_FRAME      (1<<29)
#define RX_NORMAL_FRAME    (0<<29)
#else
#define RX_SYNC_FRAME      (1<<27)
#define RX_NORMAL_FRAME    (0<<27)
#endif
///All the other fields are as the same as V_TX_EXTEN

//For V_RX_WSIZE and V_RX_WSIZE_A

//For V_RX_FSIZE and V_RX_FSIZE_A

//For V_SERDES_XBAR

//For V_SRCFR

//For V_SRCCTL

//For V_SRC_CFG
#define TX_SRC_BYPASS      (1<<16)
#define RX_SRC_BYPASS      (1<<17)
#define SRC_FACTOR         (1)         //SRC factor of 2 used for all the mode, but 30 profile
#define SRC_FACTOR_8KHZ    (0)         //SRC factor of 1 used for 30 profile

//For V_HBFILT_CFG
#define TX_HBFILT_BYPASS   (1<<16)
#define TX_HBFILT_IN_RATE  (7<<20)     //input rate = 144/(2<<(8-7)) = 72 fixed


//For V_AFE_SERIAL_CFG

//For V_AFE_SERIAL_ADDR

//For V_AFE_SERIAL_WDATA

//For V_AFE_SERIAL_RDATA

// Renaming of Registers
#ifdef VRX518
#define    V_FRAME_SKEW_OFFSET     V_FRAME_SKEW_35B_OFFSET
#define    V_TX_EXTEN_OFFSET       V_TX_EXTEN_35B_OFFSET
#define    V_TX_EXTEN_A_OFFSET     V_TX_EXTEN_A_35B_OFFSET
#define    V_TX_BETA_OFFSET        V_TX_BETA_35B_OFFSET
#define    V_TX_BETA_A_OFFSET      V_TX_BETA_A_35B_OFFSET
#define    V_TX_FSIZE_OFFSET       V_TX_FSIZE_35B_OFFSET
#define    V_TX_FSIZE_A_OFFSET     V_TX_FSIZE_A_35B_OFFSET
#define    V_RX_EXTEN_OFFSET       V_RX_EXTEN_35B_OFFSET
#define    V_RX_EXTEN_A_OFFSET     V_RX_EXTEN_A_35B_OFFSET
#define    V_RX_WSIZE_OFFSET       V_RX_WSIZE_35B_OFFSET
#define    V_RX_WSIZE_A_OFFSET     V_RX_WSIZE_A_35B_OFFSET
#define    V_RX_FSIZE_OFFSET       V_RX_FSIZE_35B_OFFSET
#define    V_RX_FSIZE_A_OFFSET     V_RX_FSIZE_A_35B_OFFSET
#define    V_FRAME_SKEW_MASK       V_FRAME_SKEW_35B_MASK
#define    V_TX_EXTEN_MASK         V_TX_EXTEN_35B_MASK
#define    V_TX_EXTEN_A_MASK       V_TX_EXTEN_A_35B_MASK
#define    V_TX_BETA_MASK          V_TX_BETA_35B_MASK
#define    V_TX_BETA_A_MASK        V_TX_BETA_A_35B_MASK
#define    V_TX_FSIZE_MASK         V_TX_FSIZE_35B_MASK
#define    V_TX_FSIZE_A_MASK       V_TX_FSIZE_A_35B_MASK
#define    V_RX_EXTEN_MASK         V_RX_EXTEN_35B_MASK
#define    V_RX_EXTEN_A_MASK       V_RX_EXTEN_A_35B_MASK
#define    V_RX_WSIZE_MASK         V_RX_WSIZE_35B_MASK
#define    V_RX_WSIZE_A_MASK       V_RX_WSIZE_A_35B_MASK
#define    V_RX_FSIZE_MASK         V_RX_FSIZE_35B_MASK
#define    V_RX_FSIZE_A_MASK       V_RX_FSIZE_A_35B_MASK
#define    V_FRAME_SKEW_ADDR       V_FRAME_SKEW_35B_ADDR
#define    V_TX_EXTEN_ADDR         V_TX_EXTEN_35B_ADDR
#define    V_TX_EXTEN_A_ADDR       V_TX_EXTEN_A_35B_ADDR
#define    V_TX_BETA_ADDR          V_TX_BETA_35B_ADDR
#define    V_TX_BETA_A_ADDR        V_TX_BETA_A_35B_ADDR
#define    V_TX_FSIZE_ADDR         V_TX_FSIZE_35B_ADDR
#define    V_TX_FSIZE_A_ADDR       V_TX_FSIZE_A_35B_ADDR
#define    V_RX_EXTEN_ADDR         V_RX_EXTEN_35B_ADDR
#define    V_RX_EXTEN_A_ADDR       V_RX_EXTEN_A_35B_ADDR
#define    V_RX_WSIZE_ADDR         V_RX_WSIZE_35B_ADDR
#define    V_RX_WSIZE_A_ADDR       V_RX_WSIZE_A_35B_ADDR
#define    V_RX_FSIZE_ADDR         V_RX_FSIZE_35B_ADDR
#define    V_RX_FSIZE_A_ADDR       V_RX_FSIZE_A_35B_ADDR
#endif

//====================================================================
//Register field definitions (end)
//====================================================================

#endif //_STR_MEMMAP_H



//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: str_memmap.h $
//   Revision 1.20  2010/01/29 21:32:14Z  yangcao
//   Revision 1.19  2009/03/30 23:34:36Z  yangcao
//   Revision 1.38  2009-03-26 16:40:50-04  lxin
//   Update DECIM PS memory size
//
//   Revision 1.37  2009-02-19 13:03:17-05  lxin
//   Increase CS_SIZE register field by 2 bits
//
//   Revision 1.16  2009/02/15 01:40:14Z  myong
//   Back off the following files changes by Tung Le in order to get the overnight tests pass.
//   Revision 1.14  2009/02/04 15:05:25Z  myong
//   (1) Changed the TX IIR coefficient RAM size from 164 to 124.
//   (2) Changed the RX IIR coefficient RAM size from 84 to 124.
//   Revision 1.13  2009/02/03 16:13:11Z  myong
//    Make the following changes to the RX IIR filter:
//   a) Change the maximum number of RX biquad stages from 4 to 6 and make it programable.
//   b) Replaced V_RXIII_CFG by two registers V_RXIIR1_CFG and V_RXIIR2_CFG
//   Revision 1.12  2009/01/29 16:49:28Z  myong
//   the following have been removed the specs/RTL:
//   1) Coefficient storage for Tx IIR BQ 6,7 -- we only support BQ0 to BQ5 now at the maximum.
//   2) Register bits for the section shifts associated with BQ 6,7
//   Revision 1.11  2009/01/19 22:13:33Z  yangcao
//   (1). Per spec change removed DECIM1 block. For decimation factor being 32x or 64x,
//   2-stage decimation is used with the first stage decimation having a constant factor of 4x.
//   This checkin removed stage 1 decim. Decim2 now has the largest decimation factor 64x.
//   Revision 1.10  2009/01/13 20:20:15Z  myong
//   added a bit field for v register
//   Revision 1.9  2009/01/09 15:37:41Z  myong
//   Added and modify the bit field definitions in str_memmap.h
//   Revision 1.8  2009/01/08 20:40:47Z  myong
//   Added more strymon register bit field definitions.
//   Revision 1.7  2009/01/07 20:15:28Z  myong
//   Added the bit field definitions to str_memmap.h
//   Revision 1.6  2008/12/30 21:40:07Z  yangcao
//   Revision 1.5  2008/12/24 16:54:39Z  yangcao
//   Revision 1.4  2008/12/22 19:32:46Z  yangcao
//   Revision 1.3  2008/12/22 15:42:29Z  yangcao
//   added addresses for  strymon registers and memory blocks
//   Revision 1.2  2008/12/11 17:54:20Z  yangcao
//   Revision 1.22  2008-11-20 14:56:37-05  astone
//   Add HBFilt registers. Remove Core Decim feature.
//
//   Revision 1.21  2008-11-12 11:32:17-05  astone
//   Increase Tx IIR Coefficient Precision
//
//   Revision 1.20  2008-11-06 14:44:22-05  astone
//   SRC RAMs back in, redefined
//
//   Revision 1.19  2008-11-06 10:00:28-05  astone
//   Add AFE Registers.
//
//   Revision 1.18  2008-10-24 16:29:40-04  kelliher
//   core decim
//
//   Revision 1.17  2008-10-23 16:16:29-04  astone
//   src cfg register
//
//   Revision 1.16  2008-10-23 13:52:42-04  astone
//   Modify V_SERDES_XBAR_MASK
//
//   Revision 1.15  2008-10-02 17:05:31-04  astone
//   DECIM2_CO_PS
//
//   Revision 1.14  2008-09-24 16:37:51-04  astone
//   Adding SRC Registers
//
//   Revision 1.13  2008-04-16 17:41:43-04  lkang
//   changed register names for V_DEC_TRAIN and V_ADAPT_RAM_IF
//
//   Revision 1.12  2008-02-28 12:06:59-05  lkang
//   fixed macro names for various registers
//
//   Revision 1.11  2008-01-24 11:58:11-05  chriss
//   update DEC/TDQ memory sizes and replicate DEC adaptation memory per-port.
//
//   Revision 1.10  2007-11-15 15:28:26-05  astone
//   Add V_BLOCK_RSTN register.
//
//   Revision 1.9  2007-11-01 17:57:23-04  astone
//   Add V_FRAME_SKEW register
//
//   Revision 1.8  2007-09-21 12:47:05-04  astone
//   Add V_SERDES_ERR
//
//   Revision 1.7  2007-09-13 19:10:09-04  chriss
//   update dectdq co+ps, decadapt sizes.
//
//   Revision 1.6  2007-08-15 16:58:57-04  lkang
//   added DECIM1 / DECIM2 offsets for DECIM memories
//
//   Revision 1.5  2007-08-08 15:49:01-04  lkang
//   added and updated macros for DEC Adapt memory
//
//   Revision 1.4  2007-07-31 15:31:07-04  lkang
//   added constants for IIR coefficients
//
//   Revision 1.3  2007-07-23 13:11:22-04  cwlee
//   increase number of interpolator coefficients
//
//   Revision 1.2  2007-07-12 17:18:00-04  jgross
//   Use byte addresses
//
//   Revision 1.1  2007-06-22 14:59:25-04  lkang
//   Initial Revision
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

