/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//
// Filename : $RCSfile: str_private.h $
// Creator  : Leiter Kang
// Created  : 06/19/2007
// Revision : $Revision: 1.12 $
// Rev Date : $Date: 2010/01/29 21:32:16Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Internal prototypes and variable declarations for Strymon BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#include "str_const.h"
#include "str_typedef.h"
#include "str_io_typedef.h"
#include "str_memmap.h"

#include "str_api.h"

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  VARIABLES
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//----- Memories -----
extern StrymonMemParams_t gta_StrymonMemParams[STR_NUM_MEM];

extern int16 gsa_StrymonMem_DEC_TDQ_CO[MAX_NUM_PORTS][V_DEC_TDQ_CO_SIZE>>1];
extern int16 gsa_StrymonMem_DEC_TDQ_PS[MAX_NUM_PORTS][V_DEC_TDQ_PS_SIZE>>1];
extern int16 gsa_StrymonMem_TXWIN_CO_PS[MAX_NUM_PORTS][V_TXWIN_CO_PS_SIZE>>1];
extern int16 gsa_StrymonMem_RXWIN_CO_PS[MAX_NUM_PORTS][V_RXWIN_CO_PS_SIZE>>1];
extern int32 gla_StrymonMem_TXIIR_CO[MAX_NUM_PORTS][V_TXIIR_CO_SIZE>>2];
extern int32 gla_StrymonMem_RXIIR_CO[MAX_NUM_PORTS][V_RXIIR_CO_SIZE>>2];
extern int16 gsa_StrymonMem_INTERP_CO[MAX_NUM_PORTS][V_INTERP_CO_SIZE>>1];
extern int16 gsa_StrymonMem_DECIM_CO[MAX_NUM_PORTS][V_DECIM_CO_SIZE>>1];
extern int16 gsa_StrymonMem_DECIM2_CO_PS[MAX_NUM_PORTS][V_DECIM2_CO_PS_SIZE>>1];
extern int16 gsa_StrymonMem_DECIM_PS[MAX_NUM_PORTS][V_DECIM_PS_SIZE>>1];
extern int16 gsa_StrymonMem_DEC_ADAPT[MAX_NUM_PORTS][V_DEC_ADAPT_SIZE>>1];

// The SRC RAMs are not replicated per port
int32 gla_StrymonMem_RXSRC_B00[V_RXSRC_B00_SIZE>>2];
int32 gla_StrymonMem_RXSRC_B01[V_RXSRC_B01_SIZE>>2];
int32 gla_StrymonMem_RXSRC_B02[V_RXSRC_B02_SIZE>>2];
int32 gla_StrymonMem_RXSRC_B12[V_RXSRC_B12_SIZE>>2];
int32 gla_StrymonMem_RXSRC_B11[V_RXSRC_B11_SIZE>>2];
int32 gla_StrymonMem_RXSRC_B10[V_RXSRC_B10_SIZE>>2];
int32 gla_StrymonMem_TXSRC_B00[V_TXSRC_B00_SIZE>>2];
int32 gla_StrymonMem_TXSRC_B01[V_TXSRC_B01_SIZE>>2];
int32 gla_StrymonMem_TXSRC_B02[V_TXSRC_B02_SIZE>>2];
int32 gla_StrymonMem_TXSRC_B12[V_TXSRC_B12_SIZE>>2];
int32 gla_StrymonMem_TXSRC_B11[V_TXSRC_B11_SIZE>>2];
int32 gla_StrymonMem_TXSRC_B10[V_TXSRC_B10_SIZE>>2];

//----- Registers -----
extern StrymonReg_t gta_StrymonReg[MAX_NUM_PORTS];

//-- From CRI --
extern uint8 guc_port_mode;


//----- Filters -----
//-- filter parameters --
// Rx
extern Fir_t gta_Decim2_Fir[MAX_NUM_PORTS];

extern int16 gsa_decim_next_idx[MAX_NUM_PORTS];
extern int16 gsa_decim_phase_prev[MAX_NUM_PORTS];
extern FlagT gfta_decim_special_handle[MAX_NUM_PORTS];
extern FlagT gfta_first_decim[MAX_NUM_PORTS];
extern FlagT gfta_decim_reset[MAX_NUM_PORTS];

extern Iir_t     gta_RxIir[MAX_NUM_PORTS];
extern IirCoef_t gta_RxIirCoef[MAX_NUM_PORTS];
extern IirCoef_t gt_RxIirUnity;

extern Fir_t gta_TdqFir[MAX_NUM_PORTS];

// Tx
extern Iir_t     gta_TxIir[MAX_NUM_PORTS];
extern IirCoef_t gta_TxIirCoef[MAX_NUM_PORTS];
extern IirCoef_t gt_TxIirUnity;

extern Fir_t gta_InterpFir[MAX_NUM_PORTS];
extern Fir_t gta_HBFiltFir[MAX_NUM_PORTS];

// DEC
extern Fir_t gta_DecFir[MAX_NUM_PORTS];

extern int16 gsa_DecInterp_SampIn[MAX_NUM_PORTS];
extern FlagT gft_DecInterp_Write[MAX_NUM_PORTS];


// SRC
extern acc          gaa_TxSrcOut[MAX_NUM_PORTS];
//extern int16        gsa_TxSrcIn[MAX_NUM_PORTS][TX_SRC_INPUT_FIFO_DEPTH+1];
extern int16        gsa_TxSRCInputFifo[MAX_NUM_PORTS][TX_SRC_INPUT_FIFO_DEPTH];
extern Fifo_t       gta_TxSRCInputFifo[MAX_NUM_PORTS];  // sample
extern int16        gs_TxSrcLen[MAX_NUM_PORTS];
extern int16        gsa_TxSrcStates[MAX_NUM_PORTS][MAX_TX_SRC_FIR_LEN];
extern FirStruc_t   gt_TxSrc[MAX_NUM_PORTS];
extern int32        gla_TxSrcCoef[MAX_NUM_PORTS][MAX_TX_SRC_FIR_LEN];
extern FlagT        gfta_TriggerStrymonTx[MAX_NUM_PORTS][2];


extern acc          gaa_RxSrcOut[MAX_NUM_PORTS];
extern FlagT        gft_TriggerStrymonRx[MAX_NUM_PORTS];
extern int16        gs_RxSrcLen[MAX_NUM_PORTS];
extern int16        gsa_RxSrcStates[MAX_NUM_PORTS][MAX_RX_SRC_FIR_LEN];
extern int32        gla_RxSrcCoef[MAX_NUM_PORTS][MAX_RX_SRC_FIR_LEN];
extern int32        gla_RxPhaseAccOut[MAX_NUM_PORTS][2];
extern int32        gla_RxPhaseAccOutMSB[MAX_NUM_PORTS][2];
extern FirStruc_t   gt_RxSrc[MAX_NUM_PORTS];

extern int16        gsa_SrcFirSlope[MAX_NUM_PORTS][NUM_SRC_FIR_PARAMS];
extern int32        gla_SrcFirCoef[MAX_NUM_PORTS][NUM_SRC_FIR_PARAMS];
extern int16        gs_SRCFRDelay[MAX_NUM_PORTS];
extern int32        gla_SRCFR[MAX_NUM_PORTS][SRCFR_DELAY_70656+1];
extern SrcControl_t gt_SrcControl[MAX_NUM_PORTS];

extern int16 gs_PhaseAccBit24Ref[MAX_NUM_PORTS];
extern int16 gsa_RxSrcEvent2[MAX_NUM_PORTS][2];
extern int16 gs_RxPhaseSel[MAX_NUM_PORTS];

extern int32 gl_TxPhaseAccPastSample[MAX_NUM_PORTS][3];
extern int16 gs_TxSrcPhase[MAX_NUM_PORTS];



//-- FIR unity --
extern int16 gsa_FirUnity_Coef[MAX_FIR_LEN];
extern int16 gs_FirUnity_Scale;

extern int16 gsa_InterpFirUnity_Coef[MAX_TX_INTERP_FACTOR][MAX_TX_INTERP_PHASE_LEN];
extern int16 gs_InterpFirUnity_Scale;
extern int16 gs_InterpFirUnity_Length;
extern int16 gsa_FirUnity_DecInterp_Coef[MAX_FIR_LEN];

//-- IIR unity --
extern int32 gl_RxIirUnity_InScale;
extern int32 gl_TxIirUnity_InScale;
extern int16 gs_IirUnity_OutShift;

extern int32 gla_RxIirUnity_BiquadCoef[5];
extern int32 gla_TxIirUnity_BiquadCoef[5];
extern int16 gs_IirUnity_SecShift;

extern Biquad_t gt_RxIirUnity_Biquad;
extern Biquad_t gt_TxIirUnity_Biquad;

//-- internal INTERP storage --
extern int16 gsa_TxInterp_PastSamp[MAX_NUM_PORTS][MAX_TX_INTERP_PHASE_LEN];
extern int16 gsa_TxInterp_SampIn[MAX_NUM_PORTS];
extern FlagT gft_TxInterp_Write[MAX_NUM_PORTS];

//-- internal HB Filt storage --
extern int16 gsa_TxHBFilt_PastSamp[MAX_NUM_PORTS][MAX_TX_HBFILT_PHASE_LEN];
extern int16 gsa_TxHBFilt_SampIn[MAX_NUM_PORTS];
extern FlagT gft_TxHBFilt_Write[MAX_NUM_PORTS];
extern int16 gsa_TxHBFilt_Coeff[MAX_TX_HBFILT_PHASE_LEN];

//-- synchronization variables for dynamic updates --

extern int16 gsa_RxDecim_Reset[MAX_NUM_PORTS];
extern int16 gsa_DEC_Reset[MAX_NUM_PORTS];

extern int16 gsa_TxInterp_Reset[MAX_NUM_PORTS];
extern int16 gsa_TxInterp_Bypass[MAX_NUM_PORTS];
extern int16 gsa_TxInterp_Mask[MAX_NUM_PORTS];

extern int16 gsa_TxHBFilt_Reset[MAX_NUM_PORTS];
extern int16 gsa_TxHBFilt_Bypass[MAX_NUM_PORTS];
extern int16 gsa_TxHBFilt_Mask[MAX_NUM_PORTS];

//----- State Info -----

//-- frame and sample parameters --
extern FlagT gfta_RxSampleState[MAX_NUM_PORTS];
extern int16 gsa_RxSampleIdx[MAX_NUM_PORTS];

extern FlagT gfta_TxSampleState[MAX_NUM_PORTS];
extern int16 gsa_TxSampleIdx[MAX_NUM_PORTS];
extern int16 gsa_TxSampleIdx_DEC[MAX_NUM_PORTS];

extern int16 gsa_skew_ena[MAX_NUM_PORTS];
extern int16 gsa_skew_count[MAX_NUM_PORTS];


//-- pipeline parameters --
extern t_StrymonOuts gta_StrymonOut[MAX_NUM_PORTS];

// Rx
extern RxFrame_t gta_Frame_RxFft[MAX_NUM_PORTS];
extern RxFrame_t gta_Frame_RxVg[MAX_NUM_PORTS];
extern RxFrame_t gta_Frame_RxWin[MAX_NUM_PORTS];
extern RxFrame_t gta_Frame_RxTdq[MAX_NUM_PORTS];
extern RxFrame_t gta_Frame_RxIn[MAX_NUM_PORTS];

extern int32 gla_StrClock_DecOvf[MAX_NUM_PORTS];
extern int16 gsa_StrClock_DecErr[MAX_NUM_PORTS];

// Tx
extern int32 gla_TxIfftData[MAX_NUM_PORTS];

extern TxFrame_t gta_Frame_TxSampReq[MAX_NUM_PORTS];
extern TxFrame_t gta_Frame_TxIfft[MAX_NUM_PORTS];
extern TxFrame_t gta_Frame_TxVg[MAX_NUM_PORTS];
extern TxFrame_t gta_Frame_TxWin[MAX_NUM_PORTS];
extern TxFrame_t gta_Frame_TxIir[MAX_NUM_PORTS];


//-- overflow parameters --
extern StrymonOvf_t gta_StrymonOvf[MAX_NUM_PORTS];
extern int32 gla_Strymon_Overflow_Status[MAX_NUM_PORTS];
extern int32 gla_Strymon_Overflow_Clear[MAX_NUM_PORTS];


//-- window parameters --
extern Win_t gta_RxWin[MAX_NUM_PORTS];
extern Win_t gta_TxWin[MAX_NUM_PORTS];

extern int16 gsa_rxwin_wsize[MAX_NUM_PORTS];

extern int16 gsa_tx_win_en_comp[MAX_NUM_PORTS];
extern int16 gsa_tx_beta_comp[MAX_NUM_PORTS];
extern int16 gsa_tx_win_coeff_comp[MAX_NUM_PORTS];


//-- DEC capture parameters --
extern DecCapt_t gta_DecCaptState[MAX_NUM_PORTS];
extern int16     gsa_DecCaptErrorStrobe[MAX_NUM_PORTS];

extern int16 gsa_DTAdapt_Enable_prev[MAX_NUM_PORTS][2];
extern int16 gsa_DecCaptErrState_prev[MAX_NUM_PORTS];

//-- exception --
extern int16 gs_StrymonException;


//----- Datapath FIFOs -----
//-- Rx --
// Rx ADC Sample Adjust
extern int16  gsa_RxAdcAdjFifo[MAX_NUM_PORTS][RX_ADC_ADJ_FIFO_DEPTH];
extern Fifo_t gta_RxAdcAdjFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_RxAdcAdjOvfFifo[MAX_NUM_PORTS][RX_ADC_ADJ_FIFO_DEPTH];
extern Fifo_t gta_RxAdcAdj_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

// Rx DECIM
extern int16  gsa_RxDecimFifo[MAX_NUM_PORTS][RX_DECIM_FIFO_DEPTH];
extern Fifo_t gta_RxDecimFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_RxDecimOvfFifo[MAX_NUM_PORTS][RX_DECIM_FIFO_DEPTH];
extern Fifo_t gta_RxDecim_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

// Rx SRC
extern int16  gsa_RxSRCFifo[MAX_NUM_PORTS][RX_SRC_FIFO_DEPTH];
extern Fifo_t gta_RxSRCFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_RxSRCOvfFifo[MAX_NUM_PORTS][RX_SRC_FIFO_DEPTH];
extern Fifo_t gta_RxSRC_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

// Rx IIR
extern acc    gaa_RxIirFifo[MAX_NUM_PORTS][RX_IIR_FIFO_DEPTH];
extern Fifo_t gta_RxIirFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_RxIirOvfFifo[MAX_NUM_PORTS][RX_IIR_FIFO_DEPTH];
extern Fifo_t gta_RxIir_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

// Rx TDQ
extern int16  gsa_RxTdqFifo[MAX_NUM_PORTS][RX_TDQ_FIFO_DEPTH];
extern Fifo_t gta_RxTdqFifo[MAX_NUM_PORTS];  // samples

extern int32  gla_RxTdqOvfFifo[MAX_NUM_PORTS][RX_TDQ_FIFO_DEPTH];
extern Fifo_t gta_RxTdq_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern RxFrame_t gta_RxTdqFrameData[MAX_NUM_PORTS][RX_TDQ_FIFO_DEPTH];
extern Fifo_t    gta_RxTdq_Frame_Fifo[MAX_NUM_PORTS];  // frame parameters

// Rx Window
extern int16  gsa_RxWinFifo[MAX_NUM_PORTS][RX_WINDOW_FIFO_DEPTH];
extern Fifo_t gta_RxWinFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_RxWinOvfFifo[MAX_NUM_PORTS][RX_WINDOW_FIFO_DEPTH];
extern Fifo_t gta_RxWin_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern RxFrame_t gta_RxWinFrameData[MAX_NUM_PORTS][RX_WINDOW_FIFO_DEPTH];
extern Fifo_t    gta_RxWin_Frame_Fifo[MAX_NUM_PORTS];  // frame parameters

// Rx Var Gain
extern int16  gsa_RxVarGainFifo[MAX_NUM_PORTS][RX_VARGAIN_FIFO_DEPTH];
extern Fifo_t gta_RxVarGainFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_RxVarGainOvfFifo[MAX_NUM_PORTS][RX_VARGAIN_FIFO_DEPTH];
extern Fifo_t gta_RxVarGain_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern RxFrame_t gta_RxVarGainFrameData[MAX_NUM_PORTS][RX_VARGAIN_FIFO_DEPTH];
extern Fifo_t    gta_RxVarGain_Frame_Fifo[MAX_NUM_PORTS];  // frame parameters

// Rx FFT Output
extern int16  gsa_RxFftFifo[MAX_NUM_PORTS][RX_FFT_FIFO_DEPTH];
extern Fifo_t gta_RxFftFifo[MAX_NUM_PORTS];

extern RxFrame_t gta_RxFftFrameData[MAX_NUM_PORTS][RX_FFT_FIFO_DEPTH];
extern Fifo_t    gta_RxFft_Frame_Fifo[MAX_NUM_PORTS];

//-- Tx --
// Tx IFFT Input
extern int32  gla_TxIfftFifo[MAX_NUM_PORTS][TX_IFFT_FIFO_DEPTH];
extern Fifo_t gta_TxIfftFifo[MAX_NUM_PORTS];

extern TxFrame_t gta_TxIfftFrameData[MAX_NUM_PORTS][TX_IFFT_FIFO_DEPTH];
extern Fifo_t    gta_TxIfft_Frame_Fifo[MAX_NUM_PORTS];

// Tx Var Gain
extern int16  gsa_TxVarGainFifo[MAX_NUM_PORTS][TX_VARGAIN_FIFO_DEPTH];
extern Fifo_t gta_TxVarGainFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_TxVarGainOvfFifo[MAX_NUM_PORTS][TX_VARGAIN_FIFO_DEPTH];
extern Fifo_t gta_TxVarGain_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern TxFrame_t gta_TxVarGainFrameData[MAX_NUM_PORTS][TX_VARGAIN_FIFO_DEPTH];
extern Fifo_t    gta_TxVarGain_Frame_Fifo[MAX_NUM_PORTS];  // frame parameters

// Tx Window
extern int16  gsa_TxWinFifo[MAX_NUM_PORTS][TX_WINDOW_FIFO_DEPTH];
extern Fifo_t gta_TxWinFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_TxWinOvfFifo[MAX_NUM_PORTS][TX_WINDOW_FIFO_DEPTH];
extern Fifo_t gta_TxWin_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern TxFrame_t gta_TxWinFrameData[MAX_NUM_PORTS][TX_WINDOW_FIFO_DEPTH];
extern Fifo_t    gta_TxWin_Frame_Fifo[MAX_NUM_PORTS];  // frame parameters

// Tx IIR
extern int16  gsa_TxIirFifo[MAX_NUM_PORTS][TX_IIR_FIFO_DEPTH];
extern Fifo_t gta_TxIirFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_TxIirOvfFifo[MAX_NUM_PORTS][TX_IIR_FIFO_DEPTH];
extern Fifo_t gta_TxIir_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern TxFrame_t gta_TxIirFrameData[MAX_NUM_PORTS][TX_IIR_FIFO_DEPTH];
extern Fifo_t    gta_TxIir_Frame_Fifo[MAX_NUM_PORTS];  // frane parameters

// Tx SRC
extern int16  gsa_TxSRCFifo[MAX_NUM_PORTS][TX_SRC_FIFO_DEPTH];
extern Fifo_t gta_TxSRCFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_TxSRCOvfFifo[MAX_NUM_PORTS][TX_SRC_FIFO_DEPTH];
extern Fifo_t gta_TxSRC_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

// Tx Interp
extern int16  gsa_TxInterpFifo[MAX_NUM_PORTS][TX_INTERP_FIFO_DEPTH];
extern Fifo_t gta_TxInterpFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_TxInterpOvfFifo[MAX_NUM_PORTS][TX_INTERP_FIFO_DEPTH];
extern Fifo_t gta_TxInterp_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

// Tx HB Filter
extern int16  gsa_TxHBFiltFifo[MAX_NUM_PORTS][TX_HBFILT_FIFO_DEPTH];
extern Fifo_t gta_TxHBFiltFifo[MAX_NUM_PORTS];  // sample

extern int32  gla_TxHBFiltOvfFifo[MAX_NUM_PORTS][TX_HBFILT_FIFO_DEPTH];
extern Fifo_t gta_TxHBFilt_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

//-- DEC --
extern acc    gaa_DecFifo[MAX_NUM_PORTS][DEC_FIFO_DEPTH];
extern Fifo_t gta_DecFifo[MAX_NUM_PORTS];

extern int32  gla_DecOvfFifo[MAX_NUM_PORTS][DEC_FIFO_DEPTH];
extern Fifo_t gta_Dec_Ovf_Fifo[MAX_NUM_PORTS];  // overflow

extern int16  gsa_DecStrobeFifo[MAX_NUM_PORTS][DEC_FIFO_DEPTH];
extern Fifo_t gta_Dec_Strobe_Fifo[MAX_NUM_PORTS];  // capture strobes


//----- Shadow Register FIFOs -----
//-- Rx --
// V_RX_VARGAIN
extern Reg_VarGain_t gta_ShadowFifoData_RxVarGain[MAX_NUM_PORTS][RX_SHADOW_FIFO_DEPTH];
extern Fifo_t        gta_ShadowFifo_RxVarGain[MAX_NUM_PORTS];

// V_RX_EXTEN
extern Reg_FrmExten_t gta_ShadowFifoData_RxFrmExten[MAX_NUM_PORTS][RX_SHADOW_FIFO_DEPTH];
extern Fifo_t         gta_ShadowFifo_RxFrmExten[MAX_NUM_PORTS];

// V_RX_WSIZE
extern int16  gsa_ShadowFifoData_RxWinSize[MAX_NUM_PORTS][RX_SHADOW_FIFO_DEPTH];
extern Fifo_t gta_ShadowFifo_RxWinSize[MAX_NUM_PORTS];

// V_RX_FSIZE
extern Reg_Frame_t gta_ShadowFifoData_RxFrameSize[MAX_NUM_PORTS][RX_SHADOW_FIFO_DEPTH];
extern Fifo_t      gta_ShadowFifo_RxFrameSize[MAX_NUM_PORTS];


//-- Tx --
// V_TX_VARGAIN
extern Reg_VarGain_t gta_ShadowFifoData_TxVarGain[MAX_NUM_PORTS][TX_SHADOW_FIFO_DEPTH];
extern Fifo_t        gta_ShadowFifo_TxVarGain[MAX_NUM_PORTS];

// V_TX_EXTEN
extern Reg_FrmExten_t gta_ShadowFifoData_TxFrmExten[MAX_NUM_PORTS][TX_SHADOW_FIFO_DEPTH];
extern Fifo_t         gta_ShadowFifo_TxFrmExten[MAX_NUM_PORTS];

// V_TX_BETA
extern int16  gsa_ShadowFifoData_TxBeta[MAX_NUM_PORTS][TX_SHADOW_FIFO_DEPTH];
extern Fifo_t gta_ShadowFifo_TxBeta[MAX_NUM_PORTS];

// V_TX_FSIZE
extern Reg_Frame_t gta_ShadowFifoData_TxFrameSize[MAX_NUM_PORTS][TX_SHADOW_FIFO_DEPTH];
extern Fifo_t      gta_ShadowFifo_TxFrameSize[MAX_NUM_PORTS];


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  SHADOW FIFO WRITE ALLOW SIGNALS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
extern FlagT gft_ShadowFifo_RxVarGain_WriteAllow[MAX_NUM_PORTS];
extern FlagT gft_ShadowFifo_RxFrame_WriteAllow[MAX_NUM_PORTS];

extern FlagT gft_ShadowFifo_TxVarGain_WriteAllow[MAX_NUM_PORTS];
extern FlagT gft_ShadowFifo_TxFrame_WriteAllow[MAX_NUM_PORTS];


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  FUNCTIONS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//----- Acc Ops -----
acc AccAdd(acc a_x, acc a_y, int16 s_AccWidth);
acc AccScaleRoundSatTrunc(acc a_in, int16 s_scale, int16 *ps_ovf, int16 s_TruncBit, int16 s_GuardBit, FlagT ft_round);


//----- Filter Ops -----
void Iir(Iir_t *pt_filt, int16 s_numBiquads, int16 *ps_in, acc *pa_out, int16 *ps_ovf);
void Fir(Fir_t *pt_Fir, FlagT ft_output);
void InterpFir(Fir_t *pt_Fir, FlagT ft_input);
void DecInterpFir(Fir_t *pt_Fir, FlagT ft_input);
void AFEInterpFir(Fir_t *pt_Fir, FlagT ft_input);


//----- FIFO -----
void Str_ResetFifo(Fifo_t *pt_fifo, void *p_init, int16 s_delay);
void Str_SetFifoData(Fifo_t *pt_fifo, void *p_set);
void Str_RunFifo(Fifo_t *pt_fifo, int16 s_write, void *p_wdata, int16 s_read, void *p_rdata);
void Str_ResetShadowRegFifos(uint8 uc_port);

//----- Initialization -----
// Rx
void Str_InitRxAdcAdj(uint8 uc_port);
void Str_InitRxDecim(uint8 uc_port);
void Str_InitRxIir(uint8 uc_port);
void Str_InitRxTdq(uint8 uc_port);
void Str_InitRxVarGain(uint8 uc_port);
void Str_InitRxWin(uint8 uc_port);
void Str_InitRxFftSamp(uint8 uc_port);

void Str_InitRxFrame(uint8 uc_port);

// Tx
void Str_InitTxIfftSamp(uint8 uc_port);
void Str_InitTxVarGain(uint8 uc_port);
void Str_InitTxWin(uint8 uc_port);
void Str_InitTxIir(uint8 uc_port);
void Str_InitTxInterp(uint8 uc_port);
void Str_InitTxHBFilt(uint8 uc_port);

void Str_InitTxFrame(uint8 uc_port);

// DEC
void Str_InitDec(uint8 uc_port);

// other
void Str_InitGlobalVars(void);
void Str_InitPortVars(uint8 uc_port);
void Str_Reset_Port(uint8 uc_port);


//----- Shadow Register FIFOs -----
//-- Rx --
void Str_ShadowUpd_RxVarGain(uint8 uc_port);
void Str_ShadowUpd_RxFrame(uint8 uc_port);
void Str_WriteRxShadowFifo(uint8 uc_port);

//-- Tx --
void Str_ShadowUpd_TxVarGain(uint8 uc_port);
void Str_ShadowUpd_TxFrame(uint8 uc_port);
void Str_WriteTxShadowFifo(uint8 uc_port);


//----- Datapath Blocks -----
void Str_RxFrame(uint8 uc_port, RxFrame_t *pt_frame);
void Str_TxFrame(uint8 uc_port, TxFrame_t *pt_frame);

// Rx
void Str_RxAdcAdj(uint8 uc_port, int16 s_samp_in, int16 *ps_samp_out, int32 *pl_ovf_out);
void Str_RxDecim(uint8 uc_port, int16 s_trig_in, int16 s_samp_in, int16 s_trig_out, int16 *ps_samp_out, int32 *pl_ovf_out);
void Str_RxIir(uint8 uc_port, int16 s_samp_in, acc *pa_samp_out, int32 *pl_ovf_out);
void Str_RxSumJunc(uint8 uc_port, acc a_dec, int32 l_ovf_dec, int16 s_dec_err_capt, acc a_rxiir, RxFrame_t *pt_fr_rx, int16 *ps_samp_out, int32 *pl_ovf_out);
void Str_RxTdq(uint8 uc_port, int16 s_samp_in, int32 l_ovf_in, int16 *ps_samp_out, int32 *pl_ovf_out);
void Str_RxTdqFrame(uint8 uc_port, RxFrame_t *pt_fr_in, RxFrame_t *pt_fr_out);
void Str_RxWindow(uint8 uc_port, int16 s_samp_in, RxFrame_t *pt_fr_in, int16 *ps_samp_out, int32 *pl_ovf_out, RxFrame_t *pt_fr_out);
void Str_RxVarGain(uint8 uc_port, int16 s_samp_in, int32 l_ovf_in, RxFrame_t *pt_fr_in, int16 *ps_samp_out, int32 *pl_ovf_out, RxFrame_t *pt_fr_out);
void Str_RxFftSample(uint8 uc_port, int16 s_samp_in, RxFrame_t *pt_fr_in, RxFrame_t *pt_fr_out);

// Tx
int32 Str_TxIfftSample(uint8 uc_port, TxFrame_t *pt_fr_in, TxFrame_t *pt_fr_out);
void  Str_TxVarGain(uint8 uc_port, int32 l_samp_in, TxFrame_t *pt_fr_in, int16 *ps_samp_out, int32 *pl_ovf_out, TxFrame_t *pt_fr_out);
void  Str_TxWindow(uint8 uc_port, int16 s_samp_in, int32 l_ovf_in, TxFrame_t *pt_fr_in, int16 *ps_samp_out, int32 *pl_ovf_out, TxFrame_t *pt_fr_out);
void  Str_TxIir(uint8 uc_port, int16 s_samp_in, TxFrame_t *pt_fr_in, int16 *ps_samp_out, int32 *pl_ovf_out, TxFrame_t *pt_fr_out);
void  Str_TxInterp(uint8 uc_port, int16 s_trig_in, int16 s_samp_in, int16 s_trig_out, int16 *ps_samp_out, int32 *pl_ovf_out);
void  Str_TxHBFilt(uint8 uc_port, int16 s_trig_in, int16 s_samp_in, int16 s_trig_out, int16 *ps_samp_out, int32 *pl_ovf_out);

// DEC
void Str_DEC(uint8 uc_port,int16 s_trig_in, int16 s_samp_win, TxFrame_t *pt_fr_win, int16 s_samp_iir, TxFrame_t *pt_fr_iir, int16 s_trig_out, acc *pa_samp_out, int32 *pl_ovf_out, int16 *ps_dec_err_capt);

// Frame Skew
void Str_FrameSkew(uint8 uc_port, int16 s_tr_ifft, int16 s_tr_fft, int16 s_tr_adc, int16 s_tx_frame, int16 s_rx_frame);


//----- DEC Capture -----
void Str_DECCapt_Error(uint8 uc_port, int16 s_interp, int16 s_samp, int16 s_sync, int16 s_dec_err_capt);
void Str_DECCapt_Input(uint8 uc_port, int16 s_samp, int16 s_dec_in_capt);


//----- Other -----
void Set_TDQ_Length_and_DEC_PS_Mem(uint8 uc_port, int16 s_length);
void Set_DEC_Length_and_Coef_Mem(uint8 uc_port, int16 s_interp, int16 s_length);

//----- SRC --------
void Str_TxSRC(uint8 uc_port, int16 s_tr_tx_src_in, int16 s_samp_in, int16 s_tr_tx_src_out, int16 *ps_samp_out,  int32 *pl_ovf_out);
void Str_RxSRC(uint8 uc_port, int16 s_tr_rx_src_in, int16 s_samp_in, int16 s_tr_rx_src_out, int16 *ps_samp_out, int32 *pl_ovf_out);

// Reading Port Mode
void  Str_SetPortMode(uint8 uc_port_mode);
uint8 Str_ReadPortMode();

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: str_private.h $
//   Revision 1.12  2010/01/29 21:32:16Z  yangcao
//   Revision 1.11  2009/03/30 23:35:17Z  yangcao
//   Revision 1.67  2009-03-26 16:42:21-04  lxin
//   Add port mode variable
//   Add variables for dynamically changing DECIM phase
//   Add functions for setting and reading port mode
//
//   Revision 1.66  2009-03-25 17:40:19-04  lxin
//   Shadow FIFO overflow protection
//
//   Revision 1.65  2009-02-24 12:46:23-05  astone
//   Introduce new global variable to record MSB of PhaseAccOut
//
//   Revision 1.64  2009-02-16 13:16:38-05  astone
//   SRC reset on per port sync reset
//
//   Revision 1.63  2009-02-09 10:06:27-05  astone
//   Make gs_SRCFRDelay a multiport variable
//
//   Revision 1.62  2009-01-22 13:25:31-05  lxin
//   Update to new BM
//
//   Revision 1.6  2009/01/21 21:27:30Z  yangcao
//   implemeted Tx input fifo for txsrc
//   Revision 1.5  2009/01/19 22:13:29Z  yangcao
//   (1). Per spec change removed DECIM1 block. For decimation factor being 32x or 64x,
//   2-stage decimation is used with the first stage decimation having a constant factor of 4x.
//   This checkin removed stage 1 decim. Decim2 now has the largest decimation factor 64x.
//   Revision 1.4  2008/12/22 15:23:04Z  myong
//   (1) Removed some compiler warning by:
//   1.b) Defining external functions in either header file
//   Revision 1.3  2008/12/17 17:31:55Z  yangcao
//   Revision 1.2  2008/12/11 17:54:22Z  yangcao
//   Revision 1.56  2008-11-20 14:56:38-05  astone
//   Add HBFilt registers. Remove Core Decim feature.
//
//   Revision 1.55  2008-11-13 16:42:19-05  astone
//   SRC ROM replaced with RAM
//
//   Revision 1.54  2008-11-12 11:32:18-05  astone
//   Increase Tx IIR Coefficient Precision
//
//   Revision 1.53  2008-11-06 14:44:26-05  astone
//   SRC RAMs back in, redefined
//
//   Revision 1.52  2008-10-28 17:18:46-04  astone
//   SRC
//
//   Revision 1.51  2008-10-24 16:36:26-04  kelliher
//   core decim
//
//   Revision 1.50  2008-10-02 17:05:28-04  astone
//   DECIM2_CO_PS
//
//   Revision 1.49  2008-05-12 18:12:57-04  jgross
//   Connect SJ and DEC
//
//   Revision 1.48  2008-05-01 19:27:24-04  lkang
//   added var to edge detect DEC adapt enable
//
//   Revision 1.47  2008-04-29 19:14:17-04  lkang
//   changed Set_TDQ_Length_and_Mem to Set_TDQ_Length_and_DEC_PS_Mem
//   added prototype for Set_DEC_Length_and_Coef_Mem
//
//   Revision 1.46  2008-04-28 16:32:16-04  lkang
//   updated prototype of Str_RxTdq to include overflow input
//
//   Revision 1.45  2008-04-28 10:56:53-04  jgross
//   From lkang: Fix special case in frame-skew register when Rx and Tx frame boundaries are aligned; result should be skew=0 and no error set
//
//   Revision 1.44  2008-04-24 14:18:16-04  lkang
//   added separate function for TDQ frame FIFO and changed prototype of Str_RxTdq
//
//
//   Revision 1.44  2008-04-24 14:18:16-04  lkang
//   added separate function for TDQ frame FIFO and changed prototype of Str_RxTdq
//
//   Revision 1.43  2008-04-24 12:48:28-04  lkang
//   added DEC capture variable for total offset into Tx frame
//
//   Revision 1.42  2008-04-17 17:44:38-04  lkang
//   added declarations of DEC-related variables
//   deleted declarations of summing junction FIFOs
//   added prototypes for new DEC/TDQ functions
//
//   Revision 1.41  2008-03-13 14:55:14-04  jgross
//   Frame-skew register fixes from LK
//
//   Revision 1.40  2008-03-10 17:14:22-04  lkang
//   changed underlying data structure of FSIZE shadow register FIFOs
//
//   Revision 1.39  2008-03-10 12:03:49-04  lkang
//   added new variables for TDQ
//   changed prototype for Str_RxTdq
//
//   Revision 1.38  2008-03-07 18:14:52-05  lkang
//   added shadow register FIFOs and new FIFO function
//
//   Revision 1.37  2008-02-28 12:07:25-05  lkang
//   added frame skew vars and fcns
//
//   Revision 1.36  2008-02-22 12:11:27-05  jgross
//   Add decim and interp mask functionality
//
//   Revision 1.35  2008-02-13 15:07:45-05  jgross
//   Fix bugs in port reset behavior
//
//   Revision 1.34  2008-01-24 11:58:20-05  chriss
//   update DEC/TDQ memory sizes and replicate DEC adaptation memory per-port.
//
//   Revision 1.33  2008-01-14 13:07:43-05  lkang
//   added DECIM overflow FIFO and variable, and changed prototype for Str_RxDecim
//
//   Revision 1.32  2008-01-11 15:41:51-05  lkang
//   added FIFO overflows and modified prototypes for new overflow behavior
//
//   Revision 1.31  2007-12-12 08:54:31-05  jgross
//   Add interp bypass/reset. Fix decim reset
//
//   Revision 1.30  2007-12-11 09:59:49-05  jgross
//   Add decim bypass and decim reset functionality
//
//   Revision 1.29  2007-12-06 17:11:01-05  lkang
//   added decl for unity IIR vars and prot for Str_ResetFifo
//
//   Revision 1.28  2007-12-06 13:36:54-05  lkang
//   added window params from str_window.c
//   added extra set of Tx win params for win comp
//
//   Revision 1.27  2007-10-03 11:45:04-04  lkang
//   added new vars from str_data.c
//   added new frame and var init functions
//   prefixed all Init functions with Str_
//
//   Revision 1.26  2007-10-02 11:21:10-04  lkang
//   added declarations for DEC/TDQ FIFOs and filters
//   added prototypes for new DEC/TDQ functions
//
//   Revision 1.25  2007-09-28 12:02:32-04  lkang
//   added declarations of FFT and IFFT FIFOs
//   added init functions for FFT and IFFT FIFOs
//   added prototypes for Frame and Sample functions
//
//   Revision 1.24  2007-09-27 19:30:45-04  lkang
//   made Init functions single port
//
//   Revision 1.23  2007-09-21 17:35:24-04  lkang
//   added frame FIFO for Tx IIR; adjusted Tx IIR, Interp, and DECIM FIFO widths
//
//   Revision 1.22  2007-09-21 16:59:57-04  lkang
//   added prototypes and declarations for Tx Window
//
//   Revision 1.21  2007-09-21 15:46:10-04  lkang
//   prototype and declaration updates for Tx Var Gain
//
//   Revision 1.20  2007-09-20 17:03:32-04  lkang
//   added Rx win FIFOs and Rx win init function
//
//   Revision 1.19  2007-09-20 13:32:32-04  lkang
//   added Rx VarGain FIFOs; updated and fixed Rx VarGain prototypes
//
//   Revision 1.18  2007-09-18 18:13:12-04  lkang
//   added declarations of ADC Adjust FIFO variables and prototypes of ADC Adjust init function
//
//   Revision 1.17  2007-09-14 18:00:12-04  lkang
//   added prototypes of Var Gain functions
//
//   Revision 1.16  2007-09-14 15:35:51-04  lkang
//   added prototype for Str_AdcAdj
//
//   Revision 1.15  2007-09-14 14:56:00-04  lkang
//   changed prototypes of IIR block functions
//
//   Revision 1.14  2007-09-10 16:47:11-04  lkang
//   changed various functions and variables to use the acc type
//
//   Revision 1.13  2007-09-10 13:14:33-04  lkang
//   updated Str_RunFifo prototype for generic data types
//
//   Revision 1.12  2007-08-17 14:38:48-04  lkang
//   added Tx Interp declarations and prototypes
//
//   Revision 1.11  2007-08-17 11:24:35-04  lkang
//   added Tx IIR declarations and prototypes
//
//   Revision 1.10  2007-08-16 16:57:22-04  lkang
//   changed prototype of Str_RxDecim
//
//   Revision 1.9  2007-08-15 17:00:01-04  lkang
//   added declarations of decim structures
//
//   Revision 1.8  2007-08-15 14:51:43-04  lkang
//   new 16-bit representations for some memories
//
//   Revision 1.7  2007-08-14 16:31:44-04  lkang
//   added Rx IIR FIFO variables
//
//   Revision 1.6  2007-08-10 19:06:32-04  lkang
//   added prototype for FIFO function
//
//   Revision 1.5  2007-08-09 13:37:04-04  lkang
//   use only 1 copy of DEC Adapt mem
//
//   Revision 1.4  2007-08-08 15:48:36-04  lkang
//   added array for DEC Adapt memory
//   fixed memory sizes
//
//   Revision 1.3  2007-07-31 15:30:34-04  lkang
//   added declarations for Rx IIR and Tx IIR data structures
//   updated acc ops, IIR, and FIR prototypes
//   added protoypes for IIR initialization
//
//   Revision 1.2  2007-07-27 18:09:40-04  lkang
//   added prototypes / declaration for acc_ops, iir, and fir
//
//   Revision 1.1  2007-06-22 14:59:25-04  lkang
//   Initial Revision
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

