/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright 1998-2008 (c) Aware, Inc.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//--
//
// The software is owned by Aware, Inc. and is protected by United States
// copyright laws and international treaty provisions. Therefore, you must treat
// the software like any other copyrighted material.  You may not use or copy
// the software or any accompanying written materials for any other purpose than
// what is described in the Development and License Agreement
// entered into with Aware Inc. (the "Agreement").  Except as
// expressly provided in the Agreement, Aware does not grant any express or
// implied rights to you to or under Aware or any third party patents, copyrights,
// trademarks, or trade secret information.  Additionally, you shall reproduce
// and apply any copyright or other proprietary rights notices included on or
// embedded in the software to any copies or derivative works made thereof, in
// whole or in part, in any form.  These rights are provided for information
// clarification, other restrictions of rights may apply as well.
//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//-//
//
// Filename : $RCSfile: str_typedef.h $
// Creator  : Leiter Kang
// Created  : 06/21/2007
// Revision : $Revision: 1.10 $
// Rev Date : $Date: 2010/01/29 21:32:17Z $
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Description: Data Types in Strymon BM
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#ifndef _STR_TYPEDEF_H
#define _STR_TYPEDEF_H

#include "str_basic_type.h"  // include basic types

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  MEMORY PARAMETERS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef union {
  int32 *pla_mem;
  int16 *psa_mem;
} MemPtr_t;

typedef struct {
  uint32   ul_BaseOffset;
  uint32   ul_Size;
  uint32   ul_Mask;
  FlagT    ft_PwAccess;
  FlagT    ft_MemRep;
  MemPtr_t ta_MemPtr[MAX_NUM_PORTS];
} StrymonMemParams_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  REGISTER SETTINGS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//----- actual settings -----
typedef struct {
  int16 s_coeff;
  int16 s_scale;
} Reg_VarGain_t;

typedef struct {
  int16 s_sync;            // Rx only
  int16 s_win_coeff_mode;  // Tx only
  int16 s_win_en;
  int16 s_cs_en;
  int16 s_cp_en;
  int16 s_cs_size;
  int16 s_cp_size;
  int16 s_dualtdq_ena;     // Rx only
} Reg_FrmExten_t;

typedef struct {
  int16 s_rate;
  int16 s_fsize;
} Reg_Frame_t;

typedef struct {
  int16 s_dec_x;
  int16 s_tdq_x;
  int16 s_adapt_done;
  int16 s_mode;
  int16 s_enable;
} Reg_DTAdaptCtrl_t;

typedef struct {
  // V_CONTROL
  int16 s_fifo_force;
  int16 s_tx_upd_sel;
  int16 s_rx_upd_sel;
  int16 s_rx_adc_rate;
  int16 s_tx_dac_rate;
  int16 s_lpbk_tx_rx;
  int16 s_rx_signed_format;
  int16 s_tx_signed_format;
  int16 s_tx_round;
  int16 s_win_lpbk;
  int16 s_reset_staten;
  int16 s_reset_staten_asserted;
  int16 s_mode;
  int16 s_aec_ena;

  // V_BLOCK_RSTN
  int16 s_hbfilt_rstn;
  int16 s_interp_rstn;
  int16 s_txiir_rstn;
  // int16 s_vgwin_rstn;
  int16 s_dectdq_rstn;
  int16 s_rxiir_rstn;
  int16 s_decim_rstn;

  // V_OVERFLOW
  int32 l_OVERFLOW;
  int32 l_OVERFLOW_CLEAR;

  // V_TXIIR1_CFG and V_TXIIR2_CFG
  int16 s_txiir_bypass;
  int16 s_txiir_in_rate;
  int16 s_txiir_last_sec;
  int16 sa_txiir_sec_shift[NUM_TX_IIR_BIQUADS];
  int16 s_txiir_out_shift;

  // V_RXIIR1_CFG and V_RXIIR2_CFG
  int16 s_rxiir_bypass;
  int16 s_rxiir_in_rate;
  int16 s_rxiir_last_sec;
  int16 s_rxiir_out_shift;
  int16 sa_rxiir_sec_shift[NUM_RX_IIR_BIQUADS];

  // V_INTERP_CFG
  int16 s_interp_mask;
  int16 s_interp_x;
  int16 s_interp_in_rate;
  int16 s_interp_bypass;
  int16 s_interp_len;
  int16 s_interp_factor;

  // V_DECIM_CFG
  int16 s_decim_mask;
  int16 s_decim2_x;
  int16 s_decim_factor;
  int16 s_decim_in_rate;
  int16 s_decim_bypass;
  int16 s_decim_phase;
  int16 s_decim_len;

  // V_DEC_CFG
  int16 s_dec_decim_factor;
  int16 s_dec_in_rate;
  int16 s_dec_delay;
  int16 s_dec_len;
  int16 s_dec_interp;
  int16 s_dec_bypass;
  int16 s_dec_ena;
  int16 s_dec_x;
  int16 s_dec_source;
  int16 s_dec_mask;

  // V_TDQ_CFG
  int16 s_tdq_mask;
  int16 s_tdq_len;
  int16 s_tdq_bypass;
  int16 s_tdq_x;

  // V_DEC_CAPTURE
  int16 s_e_samples;
  int16 s_deccapt_error;
  int16 s_deccapt_rx_count;
  int16 s_deccapt_state;
  int16 s_i_samples;

  // V_ADAPT_CTRL
  Reg_DTAdaptCtrl_t t_DTAdaptCtrl;

  // V_TX_VARGAIN
  Reg_VarGain_t t_TxVg_shad;

  // V_TX_AVARGAIN
  Reg_VarGain_t t_TxVg_act;

  // V_RX_VARGAIN
  Reg_VarGain_t t_RxVg_shad;

  // V_RX_AVARGAIN
  Reg_VarGain_t t_RxVg_act;

  // V_ADC_ADJUST
  int16 s_adc_shift;
  int16 s_dc_offset;

  // V_FRAME_SKEW
  int16 s_skew_err;
  int16 s_skew_cnt;

  // V_TX_EXTEN
  Reg_FrmExten_t t_TxFrmExten_shad;

  // V_TX_EXTEN_A
  Reg_FrmExten_t t_TxFrmExten_act;

  // V_TX_BETA
  int16 s_tx_beta;

  // V_TX_BETA_A
  int16 s_tx_beta_a;

  // V_TX_FSIZE
  Reg_Frame_t t_TxFrm_shad;

  // V_TX_FSIZE_A
  Reg_Frame_t t_TxFrm_act;

  // V_FSOFFSET_IN
  int16 s_fsoffset_in;

  // V_FSOFFSET_ER
  int16 s_fsoffset_er;

  // V_RX_EXTEN
  Reg_FrmExten_t t_RxFrmExten_shad;

  // V_RX_EXTEN_A
  Reg_FrmExten_t t_RxFrmExten_act;

  // V_RX_WSIZE
  int16 s_rx_wsize;

  // V_RX_WSIZE_A
  int16 s_rx_wsize_a;

  // V_RX_FSIZE
  Reg_Frame_t t_RxFrm_shad;

  // V_RX_FSIZE_A
  Reg_Frame_t t_RxFrm_act;

  // V_SERDES_XBAR
  int16 s_serdes_xbar;

  // V_SRCFR
  int32 s_SRCFR;

  // V_SRCCTL
  int32 s_SRCCTL;

  // V_SRC_CFG
  int16 s_RxSRC_mask;
  int16 s_TxSRC_mask;
  int16 s_TxSRC_in_rate;
  int16 s_RxSRC_bypass;
  int16 s_TxSRC_bypass;
  int16 s_RxSRC_x;
  int16 s_TxSRC_x;
  int16 s_SRC_factor;

  // V_HBFILT_CFG_OFFSET:
  int16 s_TxHBFilt_mask;
  int16 s_TxHBFilt_x;
  int16 s_TxHBFilt_in_rate;
  int16 s_TxHBFilt_bypass;

  // V_AFE_SERIAL_CFG_OFFSET:
  int32 l_afe_serial_cfg;

  // V_AFE_SERIAL_ADDR_OFFSET:
  int16 s_afe_serial_add;

  // V_AFE_SERIAL_WDATA_OFFSET:
  int16 s_afe_serial_wdata;

  // V_AFE_SERIAL_RDATA_OFFSET:
  // nothing

} StrymonReg_t;

//----- derived settings -----


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  INPUTS / OUTPUTS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

// FIXME: do we still use this structure?

typedef struct {
  // Tx filter IO
  int32 l_TxVarGainIn;
  int16 s_TxVarGainOut;
  int16 s_TxWinIn;
  int16 s_TxWinOut;
  int16 s_TxDecIn;
  int16 s_TxIirIn;
  int16 s_TxIirOut;
  int16 s_TxInterpIn;
  acc acc_TxInterpOut;
  int16 s_TxInterpOut;

  // Rx filter IO
  int16 s_RxDecimIn;
  acc acc_RxDecimOut;
  int16 s_RxDecimOut;
  int16 s_RxIirIn;
  acc acc_RxIirOut;
  acc acc_SumJuncIn;
  acc acc_RxDecOut;
  acc acc_RxTdqIn;
  int16 s_RxTdqIn;
  acc acc_RxTdqOut;
  int16 s_RxTdqOut;
  int16 s_RxWinIn;
  int16 s_RxWinOut;
  int16 s_RxVarGainIn;
  int16 s_RxVarGainOut;
  // FIXME: add ADC Adjust
} StrymonFilterIO_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  FIFOs
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#define FIFO_NORMAL  (0)
#define FIFO_FULL    (1)
#define FIFO_EMPTY   (2)

enum STR_FIFO_DATA_TYPE {
  STR_FIFO_INT32,
  STR_FIFO_INT16,
  STR_FIFO_ACC,
  STR_FIFO_RXFRAME,
  STR_FIFO_TXFRAME,
  STR_FIFO_REG_VG,
  STR_FIFO_REG_FRMEXT,
  STR_FIFO_REG_FRAME
};

typedef struct {
  void  *pxa_data;
  FlagT ft_type;
  int16 s_wr_ptr;
  int16 s_rd_ptr;
  int16 s_max_ptr;
  FlagT ft_state;
} Fifo_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  FIR
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef struct {

  int16 s_samp_in;     // input sample
  acc   a_accum;       // accumulator output

  // past samples
  int16 *psa_samp;     // past samples buffer
  int16 s_samp_size;   // size of past samples buffer
  int16 s_samp_idx;    // next location in psa_samp to be written to
  int16 s_delay;       // offset between current input sample (x[n]) and first sample used in FIR computation (x[n-D])

  // filter parameters
  int16 *psa_coef;          // coefficients
  int16 *ps_exp;            // filter exponent
  int16 s_length;           // filter length
  FlagT ft_symmetry;        // TRUE, if filter is symmetric
  int16 s_resamp_rate;      // filter resampling rate (for decim and interp)
  int16 s_phase;            // phase (for resamp blocks)

  // bit parameters
  int16 s_AccWidth;    // accumulator width in bits
  int16 s_TruncMsb;    // accumulator bits s_TruncMsb:0 are truncated
  int16 s_GuardLsb;    // accumulator bits s_GuardLsb and up are checked for saturation

} Fir_t;


// structure used for FIR filter routine
typedef struct {
   int16 s_FirType;
   int16 *ps_inbuf;           // pointer to input buffer
   acc *pacc_outbuf;          // pointer to output buffer
   int16 *psa_state;          // pointer to state buffer
   int16 s_state_write_ptr;      // write pointer to state buffer
   int16 *psa_h;              // int16 pointer to impulse response buffer
   int32 *pla_h;              // int32 pointer to impulse response buffer (used by Rx and Tx SRC only)
   int16 *ps_h_length;           // pointer to impulse response length
   int16 *ps_h_exp;           // pointer to impulse response exponent
   int16 *ps_interp_rate;        // pointer to interpolation rate
   int16 s_AccWidth;          // accumulator width in bits
} FirStruc_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  IIR
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

//-- IIR biquad section --
typedef struct {
  int32 *a[2];           // a1, a2
  int32 *b[3];           // b0, b1, b2
  int16 *ps_SecShift;    // actual value - 1
} Biquad_t;

//-- IIR coefficients and shifts --
typedef struct {
  Biquad_t ta_biquad[MAX_NUM_BIQUADS];

  int32 *pl_InScale;     // input scale (mantissa)
  int16 *ps_OutShift;    // output shift (exponent); actual value - 1
} IirCoef_t;

//-- top-level IIR structure --
typedef struct {

  // filter scales and coefficients
  IirCoef_t *pt_coef;

  // past results
  int32 la_PastResults[MAX_NUM_BIQUADS][PAST_RESULTS_PER_BQ];

  // bit widths
  int16 s_AccWidth;           // accumulator width before shift
  int16 s_CoefWidth;          // coef width
  int16 s_PastResultWidth;    // past results width
  int16 s_SampInWidth;        // input sample width

  // truncation parameters
  // past results
  int16 s_TruncMsb_PastRes;    // accumulator bits s_TruncMsb:0 are truncated
  int16 s_GuardLsb_PastRes;    // accumulator bits s_GuardLsb and up are checked for saturation

  // output sample
  int16 s_TruncMsb_Output;    // accumulator bits s_TruncMsb:0 are truncated
  int16 s_GuardLsb_Output;    // accumulator bits s_GuardLsb and up are checked for saturation

} Iir_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  WINDOWS
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef struct {
  FlagT ft_state;    // window state: WIN_IDLE, WIN_CAPTURE, WIN_COMPUTE
  int16 s_samp_idx;  // sample index; used for window capture and computation
} Win_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  FRAME
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef struct {
  int16 s_addr;          // current sample address
  int16 s_clr_ifft;      // Clear the IFFT location just read

  int16 s_frame;         // frame strobe - last sample in frame
  int16 s_win_capt;      // window capture strobe
  int16 s_win_comp;      // window computation strobe
  int16 s_dec_in_capt;   // DEC capture strobe - input samples
  int16 s_dec_err_capt;  // DEC capture strobe - error samples
} TxFrame_t;

typedef struct {
  int16 s_addr;      // current sample address
  int16 s_write;     // 1=write to FFT buffer

  int16 s_frame;     // frame strobe - last sample in frame
  int16 s_win_capt;  // window capture strobe
  int16 s_win_comp;  // window computation strobe
  int16 s_sync;      // Rx sync frame strobe - 1st sample in Rx sync frame
} RxFrame_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  DEC CAPTURE
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef struct {
  // error sample capture
  int16 *ps_err_state;  // error sample capture state:
                        //   DEC_ERR_WAIT, DEC_ERR_CNT, DEC_ERR_CAPT, DEC_ERR_IDLE
                        //   DEC_ERR_DONE

  int16 *ps_rx_count;   // no. of Rx samp. from sync strobe to 1st captured error samp.
  int16 s_err_idx;      // error sample index

  // input sample capture
  int16 s_in_ena;       // 1 = DEC input ample capture is enabled
  int16 s_in_capt;      // 1 = DEC input sample capture is active
  int16 s_in_idx;       // input sample index
  int16 *ps_in_err;     // 1 = full input capture not completed

} DecCapt_t;


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//  OVERFLOW
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

typedef struct {
  int32 l_tx_vg;
  int32 l_tx_win;
  int32 l_tx_iir;
  int32 l_tx_src;
  int32 l_tx_dec;
  int32 l_tx_interp;
  int32 l_tx_hbfilt;
  int32 l_rx_adc_adj;
  int32 l_rx_decim;
  int32 l_rx_src;
  int32 l_rx_iir;
  int32 l_rx_sumjunc;
  int32 l_rx_tdq;
  int32 l_rx_win;
  int32 l_rx_vg;
} StrymonOvf_t;

typedef struct {
   int32 l_RxPhaseAcc;
   int32 l_RxPhaseAccOut;
   int16 s_RxSrcAddr;
   int16 s_RxSrcOffset;
   int16 s_GenOutput;

   int32 l_TxPhaseAcc;
   int16 s_TxSrcAddr;
   int16 s_TxSrcOffset;
} SrcControl_t;

#endif // _STR_TYPEDEF_H

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
// Modification History:
//
//   $Log: str_typedef.h $
//   Revision 1.10  2010/01/29 21:32:17Z  yangcao
//   Revision 1.9  2009/03/29 15:25:40Z  myong
//   Moved the dual TDQ enable bit from V_CONTROL register to V_RX_EXTEN register.
//   Revision 1.60  2009-03-20 15:34:02-04  lxin
//   Implement dualtdq_ena as shadow,active register pair
//
//   Revision 1.59  2009-03-13 16:25:04-04  lxin
//   Support for VFDF clearing IFFT buffer
//
//   Revision 1.58  2009-02-16 12:09:51-05  lxin
//   Remove obsolete variables
//
//   Revision 1.7  2009/02/16 16:11:39Z  myong
//   Removed unused variable s_rx_fft_rate and s_tx_ifft_rate in V_CONTROL register.
//   Revision 1.6  2009/02/03 16:13:11Z  myong
//    Make the following changes to the RX IIR filter:
//   a) Change the maximum number of RX biquad stages from 4 to 6 and make it programable.
//   b) Replaced V_RXIII_CFG by two registers V_RXIIR1_CFG and V_RXIIR2_CFG
//   Revision 1.5  2009/01/29 16:07:41Z  myong
//   add support for a data loopback from the output of the Tx window to the input of the Rx window.
//   V_CONTROL[11] is a new window loopback enable bit which turns on the window loopback feature
//   Revision 1.4  2009/01/19 22:13:25Z  yangcao
//   (1). Per spec change removed DECIM1 block. For decimation factor being 32x or 64x,
//   2-stage decimation is used with the first stage decimation having a constant factor of 4x.
//   This checkin removed stage 1 decim. Decim2 now has the largest decimation factor 64x.
//   Revision 1.3  2009/01/02 18:46:22Z  yangcao
//   Revision 1.2  2008/12/11 17:54:25Z  yangcao
//   Revision 1.48  2008-11-20 15:05:46-05  astone
//   hbfilt reset
//
//   Revision 1.47  2008-11-20 14:56:40-05  astone
//   Add HBFilt registers. Remove Core Decim feature.
//
//   Revision 1.46  2008-11-13 15:49:19-05  kelliher
//   aec/dualtdq bits
//
//   Revision 1.45  2008-11-06 10:00:31-05  astone
//   Add AFE registers.
//
//   Revision 1.44  2008-10-28 17:19:28-04  astone
//   SRC
//
//   Revision 1.43  2008-10-24 16:29:47-04  kelliher
//   core decim
//
//   Revision 1.42  2008-10-23 16:16:57-04  astone
//   Add src cfg reg.
//
//   Revision 1.41  2008-09-24 16:37:53-04  astone
//   Adding SRC Registers
//
//   Revision 1.40  2008-05-30 11:33:25-04  lkang
//   corrected names of register fields
//
//   Revision 1.39  2008-05-01 19:27:44-04  lkang
//   revised fields for DEC capture types
//
//   Revision 1.38  2008-04-18 16:25:55-04  lkang
//   added new type and field for V_ADAPT_CTRL
//
//   Revision 1.37  2008-04-17 17:19:04-04  lkang
//   added DEC capture structure
//
//   Revision 1.36  2008-03-27 16:37:34-04  lkang
//   added DEC/TDQ reset and bypasses to register structure
//
//   Revision 1.35  2008-03-26 17:55:43-04  lkang
//   changed upd_force bits to a single fifo_force bit
//
//   Revision 1.34  2008-03-10 17:13:51-04  lkang
//   create type for FSIZE registers
//
//   Revision 1.33  2008-03-07 18:14:04-05  lkang
//   defined structures for shadow register settings
//
//   Revision 1.32  2008-02-28 12:07:43-05  lkang
//   added frame skew register fields
//
//   Revision 1.31  2008-02-14 10:59:45-05  astone
//   Add UPD_SEL and UPD_FORCE bits to the V_CONTROL register
//
//   Revision 1.30  2008-02-13 15:07:46-05  jgross
//   Fix bugs in port reset behavior
//
//   Revision 1.29  2008-01-17 16:46:44-05  lkang
//   changed fields for V_OVERFLOW register
//
//   Revision 1.28  2008-01-11 15:41:24-05  lkang
//   added overflow structure
//
//   Revision 1.27  2007-12-06 17:11:36-05  lkang
//   reorganized IIR_t
//   changed some RSTN fields to lowercase
//
//   Revision 1.26  2007-12-06 13:43:09-05  lkang
//   removed CS capture enable fields
//   removed ps_coef_mode from Win_t
//
//   Revision 1.25  2007-11-27 12:08:47-05  cwlee
//   add Rx Decimator block reset
//
//   Revision 1.24  2007-11-19 17:10:04-05  cwlee
//   add Tx Interpolator block reset
//
//   Revision 1.23  2007-11-19 13:50:28-05  astone
//   Populate Tx IIR reset in the V_BLOCK_RSTN register.
//
//   Revision 1.22  2007-11-16 10:50:37-05  astone
//   Eliminate the Rx bypass bit.
//
//   Revision 1.21  2007-11-15 15:28:27-05  astone
//   Add V_BLOCK_RSTN register.
//
//
//   Revision 1.20  2007-11-13 15:19:13-05  astone
//   Add Tx IIR bypass bit.
//
//   Revision 1.19  2007-11-06 15:45:05-05  astone
//   Add Rx IIR bypass bit.
//
//   Revision 1.18  2007-10-04 15:43:03-04  astone
//   The window loopback register bit was removed, as this is
//   redundant capability when a DEC is available.
//
//   Revision 1.17  2007-10-02 11:49:52-04  lkang
//   moved FIFO constants here from str_const.h
//   minor file cleanup
//
//   Revision 1.16  2007-09-21 14:03:00-04  lkang
//   updated TxFrame_t
//
//   Revision 1.15  2007-09-19 17:09:21-04  lkang
//   changed RxFrame_t fields
//
//   Revision 1.14  2007-09-10 13:13:40-04  lkang
//   updated Fifo_t to support generic data types
//
//   Revision 1.13  2007-08-28 16:20:12-04  lkang
//   added fields to Fir_t to support DECIM phase
//
//   Revision 1.12  2007-08-16 14:28:12-04  lkang
//   changed filter length field in Fir_t from pointer to actual value
//
//   Revision 1.11  2007-08-15 16:59:34-04  lkang
//   added symmetry flag to Fir_t; change some Fir_t fields from pointers to actual data
//
//   Revision 1.10  2007-08-15 14:51:12-04  lkang
//   updated mems to allow 16-bit representations
//
//   Revision 1.9  2007-08-14 16:30:22-04  lkang
//   changed FIFO structure
//
//   Revision 1.8  2007-08-10 19:06:20-04  lkang
//   defined new types for windowing, FIFOs, and frame parameters
//
//   Revision 1.7  2007-08-10 18:15:08-04  lkang
//   added partial word access
//
//   Revision 1.6  2007-08-02 13:34:27-04  lkang
//   created 2 sets of IIR truncation parameters - for past results and output samples
//
//   Revision 1.5  2007-08-01 15:07:44-04  astone
//   Add missing bit txwin_coeff_mode
//
//   Revision 1.4  2007-07-31 15:27:22-04  lkang
//   moved basic types to separate file
//   renamed some structure types
//   updated IIR structures
//
//   Revision 1.3  2007-07-27 18:10:35-04  lkang
//   changed FIR and IIR structs
//   removed code related to non-existent filters
//
//   Revision 1.2  2007-07-20 16:18:41-04  jgross
//   Add int64
//
//   Revision 1.1  2007-06-22 14:59:26-04  lkang
//   Initial Revision
//
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
