/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File wb.h
;
;  This file contains declarations for subroutines used in Welch-Berlekamp
;   decoding
;
;***************************************************************************/

#ifndef _WB_H
#define _WB_H

#include "galois.h"


#ifndef _BASIC_TYPES
#define _BASIC_TYPES
// variable type definitions
typedef double           float64;     //prefix d in hungarian notation
typedef int              int32;       //prefix l
typedef char             int8;        //prefix c
typedef short            int16;       //prefix s
typedef unsigned char    uint8;       //prefix uc
typedef unsigned int     uint32;      //prefix ul
typedef unsigned short   uint16;      //prefix us
typedef unsigned int     Float32;     //prefix f
typedef unsigned char    FlagT;       //prefix ft
#endif // _BASIC_TYPES

#define T_ERROR   1
#define T_ERASURE 0

void calc_syndromes (uint8 *, uint8 *, polynomial *, galois *);
void score_sort(uint8 *, uint8 *);
uint8 welch_berlekamp( uint8 *, galois *, uint8 *, galois *, polynomial *, polynomial *);
int32 wb_score(uint8, uint8 *, uint8 *, galois *, polynomial *, polynomial *, polynomial *,
    uint8 *, uint8 *, uint8 *);
int32 CorrectRS(uint8 *puca_ErrMessage, uint8 *NumErrors, uint8 *NumIterations, uint8 *puca_Scores,
            uint8 * puca_Ocheck, galois *s, uint8 *puca_CorrMessage);
void ReedSolomonDetect1();


#endif
