/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_DATA_H
#define _ZEP_DATA_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_data.h
 * DESCRIPTION:      Header file for Zephyr BM's data (not directly visible to outside)
 *
 **********************************************************************/

#include "zep_const.h"
#include "zep_typedef.h"

// CW Buffer
extern uint16  ZEP_RAM_Rx_CW[ZEP_RAM_RX_CW_SIZE];
extern uint16    DeFramer_Buffer[MAX_CW_SIZE];

// Force Cell decision flag in bcr_rx.c
extern FlagT ft_AAIRxForceCellDecision;

/**********************************************************************
 * Main PRAM and global registers
 **********************************************************************/

extern t_ZepGlobalRegisters Zep_Global_Registers[ZEP_MAX_NUM_PORTS];
extern t_ZepTxRegisters Zep_Tx_Registers, Zep_Tx_RAMRegisters[ZEP_MAX_NUM_PORTS];
extern t_ZepRxRegisters Zep_Rx_Registers, Zep_Rx_RAMRegisters[ZEP_MAX_NUM_PORTS];

extern ZEP_FC_TxPath_t ZEP_TxSM_Var[ZEP_MAX_NUM_PORTS];
extern ZEP_FC_RxPath_t ZEP_RxSM_Var[ZEP_MAX_NUM_PORTS];

// Zephyr IO signals
extern Zephyr_Input_t  gt_ZEP_Input;
extern Zephyr_Output_t gt_ZEP_Output;

extern uint16 us_Rx_PIdx[NUM_LP];

extern uint16 us_Tx_PIdx[NUM_LP];


/**********************************************************************
 * global variables used internally by Zephyr
 **********************************************************************/



extern uint16 *gpusa_RxCWBuffer[NUM_CW_BUFFER_BLOCKS];

extern uint8 guc_TxFrameMode, guc_RxFrameMode;

extern uint8 guc_TxBC0Path, guc_TxBC1Path;
extern uint8 guc_RxBC0Path, guc_RxBC1Path;

//S=1/2 processing
extern uint16 gus_ProcessSecondCW;
extern uint16 gus_Tx_InterleaveCW2Size;

// frame variables
// number of payload bytes transferred to/from the frame buffer per frame
extern uint16 gus_TxPayloadBytes[NUM_BC];
extern uint16 gus_RxPayloadBytes[NUM_BC];

extern uint16 gus_TxMuxFrameSize[NUM_LP];
extern uint16 gus_RxMuxFrameSize[NUM_LP];

extern uint16 gus_VDSLTxPathOverhead[NUM_LP];
extern uint16 gus_VDSLRxPathOverhead[NUM_LP];

extern uint8   Tx_Fifo0[BYTES_IN_TX_FIFO0];
extern uint8   Tx_Fifo1[BYTES_IN_TX_FIFO1];
extern uint8   Tx_Fifo2[BYTES_IN_TX_FIFO2];

extern uint8   Rx_Fifo0[BYTES_IN_RX_FIFO0];
extern uint8   Rx_Fifo1[BYTES_IN_RX_FIFO1];
extern uint8   Rx_Fifo2[BYTES_IN_RX_FIFO2];

// Frame numbers being processed by Zephyr.
extern uint16 gus_TxFrameNumber[NUM_LP];
extern uint16 gus_RxFrameNumber[NUM_LP];  // Frame number of fast mux frame written into Rx frame buffer.

extern uint8 gus_MuxFrameCntr[NUM_LP];

extern uint8 gpuca_TxFastCheckBytes[16];
extern uint8 guc_Tx_NumCheckBytes[NUM_LP];
extern uint8 guc_Rx_NumCheckBytes[NUM_LP];
extern uint8 gus_RxCWSize[NUM_LP];
extern uint8 guc_CWBuffer_Block[NUM_LP];

extern uint16 gus_TxMuxFrameSize[NUM_LP];
extern uint16 gus_RxMuxFrameSize[NUM_LP];

extern uint8 guc_Tx_Enable[NUM_LP];
extern uint8 guc_Rx_Enable[NUM_LP];

extern uint16 gus_TxPathOverhead[NUM_LP];

extern uint8 guc_Rx_EnableDeframer[NUM_LP]; // Enable Interleave RS correction/descrambler/deframer.
extern uint8 guc_Rx_ProcessNewCodeword[NUM_LP];

// Intermediate storage for CRC errors
extern uint8 guc_Rx_FarEndBlockErr[ZEP_MAX_NUM_PORTS][NUM_LP];

extern Zephyr_Latencies Zep_Latencies;
// Flags for latching a pending request
extern uint8 guc_LatchedTxRequest; // flag to indicate a request is latched
extern uint8 guc_LatchedTxPort; // which port is latched.

extern int16 gft_SkipCrcCalculation[NUM_LP];

extern uint16 gus_TxFramerByteCnt[NUM_LP];

extern uint16 us_TxStateLP0;

extern uint16 us_TxStateLP1;

extern uint16 gus_CurrentKIndex[NUM_LP];

extern uint16 gus_RxFramerByteCnt[NUM_LP];

extern uint16 us_RxStateLP0;

extern uint16 us_RxStateLP1;

extern uint16 gus_WritePointer[NUM_BC];

extern uint16 gus_ReadPointer[NUM_BC];

extern uint8 guc_VdslDummyByte, guc_VdslNtrByte, guc_VdslSyncByte;

extern uint8 guc_DzByte, guc_DrsByte;

extern uint8 guca_RxMuxFrameCount[NUM_LP];

extern uint8 us_RxIlvState;

extern uint8  us_RxIlvNextState;

extern uint8 uc_DmtTxFastPathState;

extern uint8 uc_DmtTxIlvPathState;

extern uint16 gus_firstCodewordSize;

extern uint16 gus_secondCodewordSize;

extern uint16 gus_ProcessSecondCW;

extern int16 gft_shalfEnabled;

extern uint8 uc_DmtRxFastPathState;

extern uint8 uc_DmtRxIlvPathState;

extern uint8 guc_RxFastAexLexBytes;

extern uint8 guc_RxIlvAexLexBytes;

extern uint16 gus_RxfirstCodewordSize, gus_RxsecondCodewordSize;

extern uint16 gus_RxProcessSecondCW;

extern uint8 gft_RxshalfEnabled;

extern uint16 gus_RxCurrentCodewordSize[NUM_LP];

extern uint8 guca_AexLexData[4];
extern uint8 guc_AexLexDataCnt;
extern uint8 guc_AexLexIndex;

extern uint8 guca_IlvAexLexData[4];
extern uint8 guc_IlvAexLexDataCnt;
extern uint8 guc_IlvAexLexIndex;

extern int16 gft_SkipCrcAccumulation[NUM_LP];

extern uint8 guc_VdslTxState[NUM_LP];

extern uint8 guc_VdslRxState[NUM_LP];

extern FlagT gft_TxFirstIdxInc[NUM_LP];

extern uint16 gus_TxVBCSize[NUM_BC];

extern uint16 gus_TxCurrentCodewordSize[NUM_LP];

extern uint16 gus_RxVBCSize[NUM_BC];

extern uint16 gus_Tx_Bis_OHCnt[NUM_LP];

extern uint16 gus_Rx_Bis_OHCnt[NUM_LP];

extern uint16 gus_Tx_Bis_TotalOHCnt[NUM_LP];

extern uint16 gus_Rx_Bis_TotalOHCnt[NUM_LP];

extern FlagT gft_RxFirstIdxInc[NUM_LP];

extern uint8 guc_MaxCWs[NUM_LP];

#endif // _ZEP_DATA_H      Do not add anything below this line.
