/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_TYPEDEF_H
#define _ZEP_TYPEDEF_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             register.h
 * DESCRIPTION:      Header file for register.c
 *
 **********************************************************************/

#include "zep_const.h"
#include "zep_memmap.h"

#ifndef _BASIC_TYPES
#define _BASIC_TYPES

typedef void  (*PtrToFunc)(void);
/* Variable type definitions */
typedef double float64;          /* prefix d in hungarian notation */
typedef long  int32;             /* prefix l */
typedef char  int8;              /* prefix c */
typedef short int16;          /* prefix s */
typedef unsigned char uint8;     /* prefix uc */
typedef unsigned long uint32;    /* prefix ul */
typedef unsigned short uint16;      /* prefix us */
typedef unsigned long Float32;      /* prefix f */
typedef unsigned char FlagT;     /* prefix ft */

#endif // _BASIC_TYPES


/**********************************************************************
 * Global Registers                                                   *
 **********************************************************************/

typedef struct {

// Version
   uint8 MajorVersion;
   uint8 MinorVersion;

// WB_Dbg
    uint8 Num_Iter;
   uint8 Num_Err;

// WB_Rchk
   uint8 Rcheck[16];


// WB_Rsynd
   uint8 Rsynd[16];

// FIFO_Ctrl
    uint8 Tx_FIFO_First_Byte[NUM_FIFOS];
   uint8 Tx_FIFO_Last_Byte[NUM_FIFOS];
   uint8 Tx_FIFO_Empty[NUM_FIFOS];
   uint8 Tx_IdleByte[NUM_FIFOS];

// Tx_FIFO_Byte
   uint8 Tx_FIFO_Byte[3];
   uint8 Tx_Valid_Bytes[3];

// FIFO_Ctrl
    uint8 Rx_FIFO_First_Byte[NUM_FIFOS];
   uint8 Rx_FIFO_Last_Byte[NUM_FIFOS];
   uint8 Rx_FIFO_Full[NUM_FIFOS];
   uint8 Rx_FIFO_Ovrflow[NUM_FIFOS];

// Rx_FIFO_Byte
   uint8 Rx_FIFO_Byte[3];
   uint8 Rx_Valid_Bytes[3];

// Tx_PI
    uint8 Tx_Px_Latch_Ena[NUM_LP];
   uint16 Tx_P[NUM_LP];

// WB_AJ
    uint8 R_AJ[16];

// NTR_Ibits
    uint8 Tx_NtrIbits;
   uint8 Tx_NtrRaw;
   uint8 Tx_NtrAccum;
    uint8 Tx_NtrDs;

// NTR_Clk
    uint8 Tx_NtrClk;
   uint16 Tx_Ltr_Ntr_Ratio;
   uint16 Tx_Pll_Ltr_Ratio;


} t_ZepGlobalRegisters;


/**********************************************************************
 * Transmit Registers                                                 *
 **********************************************************************/

typedef struct {

// Line
    uint8 Tx_FrameMode;
   uint8 Tx_BC_BufferSelect[NUM_BC];
   uint8 Tx_BC_Enable[NUM_BC];
   uint8 Tx_IbitsLP;
    uint8 Tx_NtrEnable;
   uint8 Tx_LS0IsAS1;


// LP_Cfg
   uint8 Tx_LP_Enable[NUM_LP];
   uint8 Tx_InternalData[NUM_LP];
   uint8 Tx_ScramblerEnable[NUM_LP];
   uint8 Tx_Bitrev_CRC[NUM_LP];
   uint8 Tx_NoScram_CRC[NUM_LP];
   uint8 Tx_CRC_Enable[NUM_LP];
   uint8 Tx_Clear_CRC[NUM_LP];
   uint8 Tx_Bad_CRC[NUM_LP];
   uint8 Tx_SEQpDone[NUM_LP];
   uint8 Tx_Shalf;

// VBC_size
      uint16 Tx_VBC_Size[NUM_BC];
   uint16 Tx_VBC_Idx[NUM_BC];

// Frame_Idx
   uint16 Tx_NextFrameIndex[NUM_LP];
   uint16 Tx_MaxFrameIndex[NUM_LP];

// Codeword
   uint8 Tx_CWSize[NUM_LP];
   uint8 Tx_CurrentCWIndex[NUM_LP];

// MP
   uint8 Tx_CurSymbolCnt[NUM_LP];
   uint8 Tx_SymbolsPerCW[NUM_LP];

// TP
   uint16 Tx_TpVal_SRA[NUM_LP];
   uint16 Tx_TpCount[NUM_LP];
   uint16 Tx_Max_OH[NUM_LP];
   uint16 Tx_Tp[NUM_LP];

// DZ_Max
    uint8 Tx_Dz_Max[NUM_LP];
   uint8 Tx_Dz_Idx[NUM_LP];

// DZ_Val
   uint8 Tx_Dz_Val[NUM_LP];

// DRS_Val
   uint8 Tx_DRVal[NUM_LP];
    uint8 Tx_DRIdx[NUM_LP];

// OHRate
   uint8  Tx_OH1Rate[NUM_LP];
   uint8  Tx_OH2Rate[NUM_LP];
   uint8  Tx_OHSwitch[NUM_LP];
    uint8  Tx_OHSwitch_SRA[NUM_LP];

// EOC
   uint8 Tx_EOC_Idx;
   uint8 Tx_EOC_Size;
   uint8 Tx_EOC_Lp;

// VOC
   uint8 Tx_VOC_Idx;
   uint8 Tx_VOC_Size;

// AOC
   uint8 Tx_AOC_Data;
   uint8 Tx_AOC_Sent;
   uint8 Tx_Sync_Data;
   uint8 Tx_Sync_Sent;


// FIFO_Byte
   uint8 Tx_FIFO_Byte[3][32];

// Scr_Crc
   uint32 Tx_Scrambler_Lo[NUM_LP];
   uint8  Tx_CRC[NUM_LP];

// Num_CheckByte
   uint8 Tx_CheckByteIdx[NUM_LP];
   uint8 Tx_CheckByteSize[NUM_LP];

// CByte
   uint8 Tx_CheckByte[NUM_LP][16];

// OHRate_SRA
   uint8 Tx_OH1Rate_SRA[NUM_LP];
   uint8 Tx_OH2Rate_SRA[NUM_LP];
   uint8 Tx_OHRate_SRA[NUM_LP];

} t_ZepTxRegisters;


/**********************************************************************
 * Receive Registers                                                  *
 **********************************************************************/

typedef struct {

// Line
    uint8  Rx_FrameMode;
   uint8  Rx_BC_BufferSelect[NUM_BC];
   uint8  Rx_BC_Enable[NUM_BC];
   uint8  Rx_IbitsLP;
    uint8  Rx_KeepSync;
    uint8  Rx_LS0IsAS1;
   uint8  Rx_FifoOv;
   uint8  Rx_MaxCWs[NUM_LP];

// LP_Cfg
   uint8 Rx_LP_Enable[NUM_LP];
   uint8 Rx_ScramblerEnable[NUM_LP];
   uint8 Rx_Bitrev_CRC[NUM_LP];
   uint8 Rx_NoScram_CRC[NUM_LP];
   uint8 Rx_CRC_Enable[NUM_LP];
   uint8 Rx_Clear_CRC[NUM_LP];
   uint8 Rx_SEQpDone[NUM_LP];
   uint8 Rx_CWSize[NUM_LP];
   uint8 Rx_CheckByteSize[NUM_LP];

// VBC_size
      uint16 Rx_VBC_Size[NUM_BC];
   uint16 Rx_VBC_Idx[NUM_BC];

// Frame_Idx
   uint16 Rx_NextFrameIndex[NUM_LP];
   uint16 Rx_MaxFrameIndex[NUM_LP];


// MP
   uint8 Rx_CurSymbolCnt[NUM_LP];
   uint8 Rx_SymbolsPerCW[NUM_LP];

// TP
   uint16 Rx_TpVal_SRA[NUM_LP];
   uint16 Rx_TpCount[NUM_LP];
   uint16 Rx_Max_OH[NUM_LP];
   uint16 Rx_Tp[NUM_LP];

// DZ_Max
    uint8 Rx_Dz_Max[NUM_LP];
   uint8 Rx_Dz_Idx[NUM_LP];

// DZ_Val
   uint8 Rx_Dz_Val[NUM_LP];

// DRS_Val
   uint8 Rx_DRVal[NUM_LP];
    uint8 Rx_DRIdx[NUM_LP];

// OHRate
   uint8  Rx_OH1Rate[NUM_LP];
   uint8  Rx_OH2Rate[NUM_LP];
   uint8  Rx_OHSwitch[NUM_LP];
    uint8  Rx_OHSwitch_SRA[NUM_LP];

// EOC
   uint8 Rx_EOC_Idx;
   uint8 Rx_EOC_Size;
   uint8 Rx_EOC_Lp;

// VOC
   uint8 Rx_VOC_Idx;
   uint8 Rx_VOC_Size;

// AOC
   uint8 Rx_AOC_Data;
   uint8 Rx_AOC_Valid;


// FIFO_Byte
   uint8 Rx_FIFO_Byte[3][32];

// Scr_Crc
   uint32 Rx_Descrambler_Lo[NUM_LP];
   uint8  Rx_CRC[NUM_LP];

// Crc_Cnt
   uint8 Rx_CRC_Count[NUM_LP];

// CW_Count
    uint16 Rx_CW_Count[NUM_LP];

// FEC_Cnt
   uint16 Rx_FEC_Corr[NUM_LP];
   uint16 Rx_FEC_UnCorr[NUM_LP];

// RXIB
   uint8  Rx_FarEndCorrCnt[NUM_LP];
   uint8  Rx_FarEndBlockErr[NUM_LP];
   uint8  Rx_FECC_Act[NUM_LP];

// WB_Score_Ctl
   uint16 Rx_Score1;
   uint8  Rx_Bypass_Metric[NUM_LP];
   uint8  Rx_No_WB_Score[NUM_LP];
   uint8  Rx_Eras_METa;
   uint8  Rx_Use_Eras_METa;
   uint8  Rx_Eras_METb;
   uint8  Rx_Use_Eras_METb;
   uint8  Rx_Err_METa;
   uint8  Rx_Use_Err_METa;
   uint8  Rx_Err_METb;
   uint8  Rx_Use_Err_METb;
   uint8  Rx_Use_Max_Soln;

// WB_Score2
   uint16 Rx_Score2[NUM_LP];

// OHRate_SRA
   uint8 Rx_OH1Rate_SRA[NUM_LP];
   uint8 Rx_OH2Rate_SRA[NUM_LP];
   uint8 Rx_OHRate_SRA[NUM_LP];

} t_ZepRxRegisters;

// Transmit path attributes.
typedef struct {
  uint16 TxFramerByteCnt[NUM_LP];
  uint16 TxSMState[NUM_LP];
  uint8 DmtTxPathState[NUM_LP];
  uint8 VdslTxState[NUM_LP];
  uint16 Tx_Bis_TotalOHCnt[NUM_LP];
  uint16 Tx_Bis_OHCnt[NUM_LP];
  uint16 TxVBCSize[NUM_BC];
  uint16 TxCurrentCodewordSize[NUM_LP];
  FlagT TxFirstIdxInc[NUM_LP];
  uint8 TxAexLexIndex[NUM_LP];
  uint16 TxFrameNumber[NUM_LP];
} ZEP_FC_TxPath_t;


// Receive path attributes.
typedef struct {
  uint16 RxFramerByteCnt[NUM_LP];
  uint16 RxSMState[NUM_LP];
  uint8 DmtRxPathState[NUM_LP];

  uint8 VdslRxState[NUM_LP];
  uint16 Rx_Bis_TotalOHCnt[NUM_LP];
  uint16 Rx_Bis_OHCnt[NUM_LP];
  uint16 RxVBCSize[NUM_BC];
  uint16 RxCurrentCodewordSize[NUM_LP];
  FlagT RxFirstIdxInc[NUM_LP];
  int16 RxSkipCrcAccumulation[NUM_LP];
  uint16 RxCurrentKIndex[NUM_LP];
  uint16 RxFrameNumber[NUM_LP];

} ZEP_FC_RxPath_t;


#endif //_ZEP_TYPEDEF_H    Do not add anything below this line.


