/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEPHYRBM_H
#define _ZEPHYRBM_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zephyrbm.h
 * DESCRIPTION:      Header file for Zephyr Bit-True Behavioral Model (BTBM).
 *
 **********************************************************************/



// these are needed by the cocomo hwenginelib functions
// Byte enable masks
#ifndef BYTE0_EN
#define NO_BYTE_EN      (0x0)
#define BYTE0_EN     (0x1)
#define BYTE1_EN     (0x2)
#define BYTE2_EN     (0x4)
#define BYTE3_EN     (0x8)
#define LOWER_WORD_EN   (BYTE1_EN | BYTE0_EN)
#define UPPER_WORD_EN   (BYTE3_EN | BYTE2_EN)
#define LONGWORD_EN     (UPPER_WORD_EN | LOWER_WORD_EN)
#endif // BYTE0_EN

// =============================================================================
// Functions for reading/writing RAM blocks
// =============================================================================

/* Writes a 16-bit word at given offset in specified RAM.*/
 int32 ZEP_WriteWord(uint32 us_address, uint32 ul_data, uint8 uc_ByteEnable, uint8 uc_port);

/* Reads a 16-bit word from given offset in specified RAM. */
 int32 ZEP_ReadWord(uint32 us_address, uint32 *ul_data, uint8 uc_ByteEnable, uint8 uc_port);

 void ZEP_GetTxPortLP(uint8* port, uint8* lp);
 void ZEP_GetRxPortLP(uint8* port, uint8* lp);

// =============================================================================
// Functions for initializing Zephry BM
// =============================================================================

int32 ZEP_InitializeBM();
//  Function for performing Asynchronous Reset
void ZEP_Reset(void);

// =============================================================================
// Functions for clocking core
// =============================================================================
int32 ZEP_Clock();
int32 ZEP_Clock_Tx_Frame(uint8 uc_port);
int32 ZEP_Clock_Rx_Frame(uint8 uc_port);

int32 ZEP_ResetTxState_Port(uint8 port);
int32 ZEP_ResetRxState_Port(uint8 port);

// These functions are put here temporally for HWTest purpose.
   // We should move them to zep_private.h when all testings are finished.
   int32 ZEP_ClockCodeBlock(uint8 uc_direction, uint8 engine_id);
   int32 ZEP_ClockCodeBlockInit();
   int32 ZEP_SetBase(uint8 uc_direction, uint8 engine_id, uint16 base_addr);
   //zep_clock_tx.c
   void ZEP_AllEngine_Clock_Tx();
   uint8 ZEP_HWEngineClock_Tx(uint8 engine_id);
   //zep_clock_rx.c
   void ZEP_AllEngine_Clock_Rx();
   uint8 ZEP_HWEngineClock_Rx(uint8 engine_id);

   // End of temporal functions.

//==============================================================================
// ZEP_ILV interface functions used by Iridia-QT block
//==============================================================================
int32 ZEP_ILV_PutWordToRxDTB(int16 s_lp, uint32 ul_word,uint8 uc_port);
int32 ZEP_ILV_GetWordFromTxDTB(int16 s_lp, uint32 *pul_word, uint8 uc_port);

void ZEP_Write_IIBRAM  (uint8 uc_port, uint32 ul_address, uint32 ul_data, uint32 ul_bit_enable);

//==============================================================================
// ZEP_ILV interface functions used by Iridia-QTP block
//==============================================================================
int32 ZEP_ILV_PutPRBSByteToTxDTB(uint32 us_wr_addr , uint8 uc_byte, uint8 uc_port);
int32 ZEP_ILV_GetPRBSByteFromTxDTB(uint32 us_rd_addr, uint32 *pul_byte, uint8 uc_port);

void ZEP_ILV_DumpRxDTB(int32 *output_data);
void ZEP_ILV_DumpTxDTB(int32 *output_data);

// Interface functions
void ZEP_ILV_ClearTxDtbRdAddr(uint8 uc_port);
void ZEP_ILV_ClearRxDtbWrAddr(uint8 uc_port);
void ZEP_ILV_CaptureRMetric(uint8 uc_rmetric, uint8 uc_port);
void ZEP_ILV_SetTxDTSize(uint8 uc_port, uint16 *pusa_DTSize);
void ZEP_ILV_SetRxDTSize(uint8 uc_port, uint16 *pusa_DTSize);
void ZEP_SetTxXferSize(uint8 uc_port, uint16 *pusa_bytes);
void ZEP_SetRxXferSize(uint8 uc_port, uint16 *pusa_bytes);

// =============================================================================
// Functions for clocking ILV core, externed from the ILV BM
// =============================================================================
extern void ZEP_FC_ILV_Clock_Tx(uint8 uc_port, uint8 uc_fc_tx_on);
extern void ZEP_FC_ILV_Clock_Rx(uint8 uc_port, uint8 uc_fc_rx_on);
extern void ZEP_FC_ILV_Tx_Signals(uint8 uc_signal_1, uint8 uc_signal_2, uint8 uc_signal_3);
extern void ZEP_ILV_FC_Tx_Signals(uint8 *uc_signal_1);
extern void ZEP_FC_ILV_Rx_Signals(uint8 uc_signal_1, uint8 uc_signal_2, uint8 uc_signal_3, uint8 uc_signal_4);
extern void ZEP_ILV_FC_Rx_Signals(uint8 *uc_signal_1, uint8 *uc_signal_2, uint8 *uc_signal_3);


#endif //_ZEPHYRBM_H    Do not add anything below this line.


