/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_CONST_H
#define _ZEP_CONST_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_const.h
 * DESCRIPTION:      Constants for Zephyr Bit-True Behavioral Model (BTBM).
 *
 **********************************************************************/
// Useful Masks
#ifndef  MASK_BIT0
#define  MASK_BIT0   0x1
#define  MASK_BIT1   0x2
#define  MASK_BIT2   0x4
#define  MASK_BIT3   0x8
#define  MASK_BIT4   0x10
#define  MASK_BIT5   0x20
#define  MASK_BIT6   0x40
#define  MASK_BIT7   0x80
#define  MASK_BIT8   0x100
#define  MASK_BIT9   0x200
#define  MASK_BIT10  0x400
#define  MASK_BIT11  0x800
#define  MASK_BIT12  0x1000
#define  MASK_BIT13  0x2000
#define  MASK_BIT14  0x4000
#define  MASK_BIT15  0x8000
#endif   // MASK_BIT0

// Masks for Z_STATUS
#define MASK_TX_DONE MASK_BIT0
#define MASK_RX_DONE MASK_BIT4

// Masks for ZT_ENABLE and ZR_ENABLE
#define MASK_ENABLE_FAST   MASK_BIT4
#define MASK_ENABLE_INLV   MASK_BIT0

// Masks for Z_SYNC
#define MASK_TX_SYNC MASK_BIT0
#define MASK_RX_SYNC MASK_BIT4



// RS constants
#define  RS_CHECKBYTES     (16)
#define LOG2_RS_CHECKBYTES (4)
#define MAX_CW_SIZE        (256)
#define NUM_CW_BUFFER_BLOCKS  (2)


#define     ZEP_MAX_NUM_PORTS    4

#ifndef NUM_DSP
#define NUM_DSP      4 // number of DSP cores
#endif



#ifndef FALSE
   #define FALSE  0
#endif

#ifndef TRUE
   #define TRUE   1
#endif


#ifndef NUM_LP
#define NUM_LP    2
#endif

#ifndef NUM_BC
#define NUM_BC    2
#endif

#ifndef LP0
#define LP0       0
#define LP1       1
#endif

#ifndef BC0
#define BC0       0
#define BC1       1
#endif


// Estimated TX/RX  Latencies in clock cycles
#define  LATENCY_ZT_TOTAL        4
#define  LATENCY_ZR_TOTAL        4

// framing mode definitions
#define FULL_ASYNC         0
#define FULL_SYNC       1
#define REDUCED_SEPARATE   2
#define REDUCED_MERGED     3
#define ADSL2           4
#define SIMPLIFIED         7
#define VDSL1               5

// Sizes needed in framing/deframing
#define     TX_MUX_DATA_NBYTES               (512)
#define     RX_MUX_DATA_NBYTES               (256)



/**********************************************************************
 *
 * RAM Sizes
 *
 **********************************************************************/



#define DZ_BYTE     (0x3A)

#define DRS_BYTE    (0xD3)

#define VDSL_SYNC_BYTE   (0x3C)

#define  IB_FIFO         (0x2)

#define  HDLC_FIFO        (0x0)

#define  VDSL_DUMMY_BYTE  (0xFF)

#define  EOC_FIFO         (0x0)

#define  VOC_FIFO         (0x1)

#define  TXSTATE_WAIT_FOR_START (0x0)

#define  RXSTATE_WAIT_FOR_START (0x0)

#define  PRE_PROCESSING   (0x1)

#define  PROCESS_CUR_LP   (0x2)

#define  WAIT_FOR_TXDTBUSY_LOW_FOR_LP0  (0x3)

#define  WAIT_FOR_TXDTBUSY_LOW_FOR_LP1  (0x4)

#define  WAIT_FOR_TXDTBUSY_LOW_FOR_DCID (0x5)

#define  WAIT_FOR_RXDTBUSY_LOW_FOR_LP1  (0x6)

#define  WAIT_FOR_RXDTBUSY_LOW_FOR_LP0  (0x7)

#define  WAIT_FOR_TXDTBUSY_LOW_FOR_LP0_DCID  (0x8)

#define  RX_RS_DATA_BYTES  (0x1)

#define  RX_FRAMER         (0x2)

#define  WAIT_FOR_CODEWORD_AVAIL  (0x3)

#define  RS_DATA_BYTES     (0x1)

#define  RS_CHECK_BYTES    (0x2)

#define  FIFO0              (0)

#define  FIFO1              (1)

#define  FIFO2              (2)

#define  WAIT_FOR_ILV_RX_ON    (1)

#define   WAIT_FOR_ILV_RX_OFF  (2)

#define  WAIT_FOR_ILV_NEXT_FRAME  (3)

#define  FAST_BYTE_STATE      (0)

#define  BC0_MUX_DATA_STATE      (1)

#define  BC1_MUX_DATA_STATE      (2)

#define  AEX_LEX_STATE        (3)

#define  SYNC_BYTE_STATE      (0)

#define  ILV_BC0_MUX_DATA_STATE     (1)

#define  ILV_BC1_MUX_DATA_STATE     (2)

#define  ILV_AEX_LEX_STATE       (3)

#define  RX_FAST_BYTE_STATE        (1)

#define  RX_BC0_MUX_DATA_STATE     (2)

#define  RX_BC1_MUX_DATA_STATE     (3)

#define  RX_AEX_LEX_STATE          (4)

#define  RX_LEX_STATE              (5)

#define  RX_SYNC_BYTE_STATE         (1)

#define  RX_ILV_BC0_MUX_DATA_STATE     (2)

#define  RX_ILV_BC1_MUX_DATA_STATE     (3)

#define  RX_ILV_AEX_LEX_STATE          (4)

#define  RX_ILV_LEX_STATE              (5)


// VDSL states

#define  VDSL_TX_OVERHEAD_STATE         (1)

#define  VDSL_TX_PAYLOAD_STATE          (2)

#define  VDSL_TX_DRS_STATE              (3)


#define  VDSL_RX_OVERHEAD_STATE         (1)

#define  VDSL_RX_PAYLOAD_STATE          (2)

#define  VDSL_RX_DRS_STATE              (3)


#define  AEX_LEX_ZERO_BYTE              (0x0)
#define  AEX_LEX_AOC_BYTE               (0xC)   // to indicate it is AOC byte

// ILV Const

#define ZEP_ILV_NUM_LP           (2)

// Others
#define CRC0 (0)
#define CRC1 (1)

///////////////////////////////////////////
// Code Engine Constants
///////////////////////////////////////////
#define CODE_ENGINE0    0
#define CODE_ENGINE1    1
#define CODE_ENGINE2    2
#define CODE_ENGINE3    3
#define CODE_ENGINE4    4
#define CODE_ENGINE5    5
#define CODE_ENGINE6    6
#define CODE_ENGINE7    7
#define CODE_ENGINE8    8
#define CODE_ENGINE9    9
#define CRC0_DATA    10
#define CRC0_FLAG    11 // not used
#define CRC1_DATA    12
#define CRC1_FLAG    13 // not used
#define SCRAMBLER_DATA  14
#define SCRAMBLER_FLAG  15
#define RS_CODEC_DATA   16
#define RS_CODEC_METRIC 17
#define ALU_DATA     18
//#define NTR_FLAG      0 // not used
#define ILV0_DATA    20
#define ILV1_DATA    21
#define TC_LAYER_DATA   22
#define TC_LAYER_FLAG   23 // Used only for Fifo
#define MAILBOX         23
#define ILV_BUF_DATA 24
//#define ILV_BUF_WR_FLAG  0 // not used
#define ILV_BUF_RD_FLAG 25
#define DTB_INTERFACE   26
#define DTB_RD_FLAG     27
#define FIFO0_DATA      28
#define FIFO1_DATA      29
#define FIFO2_DATA      30
#define FIFO3_DATA      31


#define INST_SET_IO     0x6 //0110
#define INST_MOV     0x8 //1???
#define INST_FLAG    0x1 //0001
#define INST_JUMP    0x4 //0100
#define INST_WAIT_EVENT 0x0 //0000
#define INST_WR_REG     0x2 //001?
#define INST_NOP     0xF //1111

#define INST_MOV_PROCESSING   0x9
#define INST_WAITING    0XA
#define INST_ERROR         0XE

#define WITH_DATA    1
#define WITHOUT_DATA 0

#define NUM_CODE_ENGINE 10
#define FIRST_HW_ENGINE 10
#define NUM_HW_ENGINE   22
#define NUM_ENGINE      32

#define ZEPHYR_TX    1
#define ZEPHYR_RX    0

#define NUM_PORTS 2
#define NUM_DIRECTIONS 2

#define ZEP_TX 1
#define ZEP_RX 0

#define ZEP_ILV_SHALF_DISABLED      (0)
#define ZEP_ILV_SHALF_FIRST_CW      (1)
#define ZEP_ILV_SHALF_SECOND_CW     (2)

//used in mailbox interface (zep_tx, zep_rx.c)
#define INPUT_REQ 1
#define OUTPUT_REQ 2

#define IDLE  0
#define READ1  1
#define READ2  2
#define WAIT_READ 3
#define MBOX_WRITE   4


#define GARBFLAG_INC 1
#define GARBFLAG_DEC 2

#define ALU_STORE 0
#define ALU_ADD   1
#define ALU_SUB   2
#define ALU_AND   3
#define ALU_OR    4
#define ALU_XOR   5
#define ALU_EPAR  6
#define ALU_OPAR  7
#define ALU_LSHF  8
#define ALU_RSHF  9
#define ALU_LROT  10
#define ALU_RROT  11
#define ALU_DIV   12
#define ALU_MOD   13
#define ALU_MSB   15

#endif //_ZEP_CONST_H   Do not add anything below this line.


