/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1999 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ZEP_DATA_H
#define _ZEP_DATA_H

/**********************************************************************
 *
 * Aware DMT Technology. Proprietary and Confidential.
 *
 * ADDRESS:          40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
 * TELEPHONE:        781.276.4000
 * FAX:              781.276.4001
 * WEB:              http://www.aware.com
 *
 * FILE:             zep_data.h
 * DESCRIPTION:      Header file for Zephyr BM's data (not directly visible to outside)
 *
 **********************************************************************/

#include "zep_const.h"
#include "zep_typedef.h"

// CW Buffer
extern uint16  gusa_ZEP_RAM_Rx_CW[ZEP_RAM_RX_CW_SIZE];
extern uint8  guca_ZEP_RAM_IIBRAM_Buffer[2*ZEP_RAM_IIBRAM_SIZE];

extern uint16    DeFramer_Buffer[MAX_CW_SIZE];

// Force Cell decision flag in bcr_rx.c
extern FlagT ft_AAIRxForceCellDecision;

/**********************************************************************
 * Main PRAM and global registers
 **********************************************************************/

extern t_ZepGlobalRegisters Zep_Global_Registers[ZEP_MAX_NUM_PORTS];
extern t_ZepTxRegisters Zep_Tx_Registers, Zep_Tx_RAMRegisters[ZEP_MAX_NUM_PORTS];
extern t_ZepRxRegisters Zep_Rx_Registers, Zep_Rx_RAMRegisters[ZEP_MAX_NUM_PORTS];
extern t_ZEP_ILV_BM_Registers ZEP_ILV_BM_Registers[ZEP_MAX_NUM_PORTS];

extern ZEP_FC_TxPath_t ZEP_TxSM_Var[ZEP_MAX_NUM_PORTS];
extern ZEP_FC_RxPath_t ZEP_RxSM_Var[ZEP_MAX_NUM_PORTS];

// Zephyr IO signals
extern Zephyr_Input_t  gt_ZEP_Input;
extern Zephyr_Output_t gt_ZEP_Output;

extern uint16 us_Rx_PIdx[NUM_LP];

extern uint16 us_Tx_PIdx[NUM_LP];


/**********************************************************************
 * global variables used internally by Zephyr
 **********************************************************************/
extern t_code_engine *gt_TxCodeEngine;
extern t_code_engine *gt_RxCodeEngine;
extern t_interface gt_Tx_InputInterface[NUM_ENGINE];
extern t_interface gt_Rx_InputInterface[NUM_ENGINE];
extern t_interface gt_Tx_OutputInterface[NUM_ENGINE];
extern t_interface gt_Rx_OutputInterface[NUM_ENGINE];
extern t_fifo *gt_Tx_FIFO;
extern t_fifo *gt_Rx_FIFO;

extern uint8 guca_WAIT_FOR_START[NUM_DIRECTIONS]; //Flag to show if waiting for next frame's GO signal.
extern uint8 guca_Num_LP[NUM_PORTS][NUM_DIRECTIONS]; //Number of LP for each port.
extern uint8 guca_ENGINE_BUSY[NUM_DIRECTIONS][NUM_ENGINE];  //Flag to show if any code/HW engine is busy.

extern uint8 guc_cur_lp; //Current latency path
extern uint8 guc_tx_cur_lp; //Current Tx latency path
extern uint8 guc_rx_cur_lp; //Current Rx latency path

extern uint8 guc_cur_direction; //Current direction
extern uint8 guc_port_mode; //Port mode: 0: 1 port mode    1: 2 port mode

extern uint8 guc_tx_go_port;
extern uint8 guc_rx_go_port;

extern uint8 guc_qt_tx_port;
extern uint8 guc_qt_rx_port;

extern uint8 guc_RSDecoding_Done;

/////////////////////////////////////
extern uint16 *gpusa_RxCWBuffer[NUM_CW_BUFFER_BLOCKS];

extern uint8 guc_TxFrameMode, guc_RxFrameMode;

extern uint8 guc_TxBC0Path, guc_TxBC1Path;
extern uint8 guc_RxBC0Path, guc_RxBC1Path;

//S=1/2 processing
extern uint16 gus_ProcessSecondCW;
extern uint16 gus_Tx_InterleaveCW2Size;

// frame variables
// number of payload bytes transferred to/from the frame buffer per frame
extern uint16 gus_TxPayloadBytes[NUM_BC];
extern uint16 gus_RxPayloadBytes[NUM_BC];

extern uint16 gus_TxMuxFrameSize[NUM_LP];
extern uint16 gus_RxMuxFrameSize[NUM_LP];

extern uint16 gus_VDSLTxPathOverhead[NUM_LP];
extern uint16 gus_VDSLRxPathOverhead[NUM_LP];

extern uint8   Tx_Fifo0[BYTES_IN_TX_FIFO0];
extern uint8   Tx_Fifo1[BYTES_IN_TX_FIFO1];
extern uint8   Tx_Fifo2[BYTES_IN_TX_FIFO2];

extern uint8   Rx_Fifo0[BYTES_IN_RX_FIFO0];
extern uint8   Rx_Fifo1[BYTES_IN_RX_FIFO1];
extern uint8   Rx_Fifo2[BYTES_IN_RX_FIFO2];

// Frame numbers being processed by Zephyr.
extern uint16 gus_TxFrameNumber[NUM_LP];
extern uint16 gus_RxFrameNumber[NUM_LP];  // Frame number of fast mux frame written into Rx frame buffer.

extern uint8 gus_MuxFrameCntr[NUM_LP];

extern uint8 gpuca_TxFastCheckBytes;
extern uint8 guc_Tx_NumCheckBytes;
extern uint8 guc_Rx_NumCheckBytes;
extern uint8 gus_RxCWSize;
extern uint8 guc_CWBuffer_Block;

extern uint16 gus_TxMuxFrameSize[NUM_LP];
extern uint16 gus_RxMuxFrameSize[NUM_LP];

extern uint8 guc_Tx_Enable[NUM_LP];
extern uint8 guc_Rx_Enable[NUM_LP];

extern uint16 gus_TxPathOverhead[NUM_LP];

extern uint8 guc_Rx_EnableDeframer[NUM_LP]; // Enable Interleave RS correction/descrambler/deframer.
extern uint8 guc_Rx_ProcessNewCodeword[NUM_LP];

// Intermediate storage for CRC errors
extern uint8 guc_Rx_FarEndBlockErr[ZEP_MAX_NUM_PORTS][NUM_LP];

// Flags for latching a pending request
extern uint8 guc_LatchedTxRequest; // flag to indicate a request is latched
extern uint8 guc_LatchedTxPort; // which port is latched.

extern int16 gft_SkipCrcCalculation[NUM_LP];

extern uint16 gus_TxFramerByteCnt[NUM_LP];

extern uint16 us_TxStateLP0;

extern uint16 us_TxStateLP1;

extern uint16 gus_CurrentKIndex;

extern uint16 gus_RxFramerByteCnt[NUM_LP];

extern uint16 us_RxStateLP0;

extern uint16 us_RxStateLP1;

extern uint16 gus_WritePointer[NUM_BC];

extern uint16 gus_ReadPointer[NUM_BC];

extern uint8 guc_VdslDummyByte, guc_VdslNtrByte, guc_VdslSyncByte;

extern uint8 guc_DzByte, guc_DrsByte;

extern uint8 guca_RxMuxFrameCount[NUM_LP];

extern uint8 us_RxIlvState;

extern uint8  us_RxIlvNextState;

extern uint8 uc_DmtTxFastPathState;

extern uint8 uc_DmtTxIlvPathState;

extern uint16 gus_firstCodewordSize;

extern uint16 gus_secondCodewordSize;

extern uint16 gus_ProcessSecondCW;

extern int16 gft_shalfEnabled;

extern uint8 uc_DmtRxFastPathState;

extern uint8 uc_DmtRxIlvPathState;

extern uint8 guc_RxFastAexLexBytes;

extern uint8 guc_RxIlvAexLexBytes;

extern uint16 gus_RxfirstCodewordSize, gus_RxsecondCodewordSize;

extern uint16 gus_RxProcessSecondCW;

extern uint8 gft_RxshalfEnabled;

extern uint16 gus_RxCurrentCodewordSize;

extern uint8 guca_AexLexData[4];
extern uint8 guc_AexLexDataCnt;
extern uint8 guc_AexLexIndex;

extern uint8 guca_IlvAexLexData[4];
extern uint8 guc_IlvAexLexDataCnt;
extern uint8 guc_IlvAexLexIndex;

extern int16 gft_SkipCrcAccumulation[NUM_LP];

extern uint8 guc_VdslTxState[NUM_LP];

extern uint8 guc_VdslRxState[NUM_LP];

extern FlagT gft_TxFirstIdxInc[NUM_LP];

extern uint16 gus_TxVBCSize[NUM_BC];

extern uint16 gus_TxCurrentCodewordSize[NUM_LP];

extern uint16 gus_RxVBCSize[NUM_BC];

extern uint16 gus_Tx_Bis_OHCnt[NUM_LP];

extern uint16 gus_Rx_Bis_OHCnt[NUM_LP];

extern uint16 gus_Tx_Bis_TotalOHCnt[NUM_LP];

extern uint16 gus_Rx_Bis_TotalOHCnt[NUM_LP];

extern FlagT gft_RxFirstIdxInc[NUM_LP];

extern uint8 guc_MaxCWs[NUM_LP];

extern t_mailbox gt_mailbox[NUM_DIRECTIONS];

// The following data are ported from Zephyr-ILV

// buffers represent each memory block
// BM allocates memory required for a single port in 2 port-mode for each of the 4 ports
extern uint8 *gpuc_ILVB_Buffer;
extern uint8 guca_DTB_Buffer[2*ZEP_ILV_RAM_DTB_SIZE], *gpuc_DTB_Buffer;
extern uint8 *gpuc_TxDTB_Buffer;
extern uint8 *gpuc_RxDTB_Buffer;
extern uint8 guca_DMETRIC_Buffer[2*ZEP_ILV_RAM_DMET_SIZE], *gpuc_DMETRIC_Buffer;

// size of dmetric ram for a give port mode
extern uint16 gus_Dmetric_Ram_Size;

// DTB Read and Write Pointers
extern uint16 gus_Rx_DtbWr_Lw[NUM_PORTS];
extern uint16 gus_Tx_DtbRd_Lw[NUM_PORTS];

// Internal counter for Dilv Level
extern int16 gsa_Rx_Dilv_Level[NUM_PORTS][ZEP_ILV_NUM_LP];

#endif // _ZEP_DATA_H      Do not add anything below this line.
